/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.builder.tags;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import macromedia.graphics.g2d.GraphicContext;
import macromedia.swf.builder.tags.TagBuilder;
import macromedia.swf.builder.types.MatrixBuilder;
import macromedia.swf.builder.types.Point;
import macromedia.swf.builder.types.ShapeWithStyleBuilder;
import macromedia.swf.tags.DefineBits;
import macromedia.swf.tags.DefineShape;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.types.CurvedEdgeRecord;
import macromedia.swf.types.FillStyle;
import macromedia.swf.types.LineStyle;
import macromedia.swf.types.Matrix;
import macromedia.swf.types.Rect;
import macromedia.swf.types.ShapeRecord;
import macromedia.swf.types.StraightEdgeRecord;
import macromedia.swf.types.StyleChangeRecord;

public final class DefineShapeBuilder
implements TagBuilder {
    private DefineShape tag = new DefineShape(32);
    private ShapeWithStyleBuilder sws;

    private DefineShapeBuilder() {
    }

    public DefineShapeBuilder(Shape shape, GraphicContext graphicContext, boolean outline, boolean fill) {
        this();
        this.sws = new ShapeWithStyleBuilder(shape, graphicContext, outline, fill);
    }

    public DefineShapeBuilder(Shape shape, Point origin, FillStyle fs, LineStyle ls, boolean fill) {
        this();
        this.sws = new ShapeWithStyleBuilder(shape, origin, fs, ls, fill);
    }

    public void join(Shape shape) {
        this.sws.join(shape);
    }

    public DefineTag build() {
        this.tag.shapeWithStyle = this.sws.build();
        this.tag.bounds = DefineShapeBuilder.getBounds(this.tag.shapeWithStyle.shapeRecords, this.tag.shapeWithStyle.linestyles);
        return this.tag;
    }

    public static Rect getBounds(List records, List lineStyles) {
        if (records == null || records.size() == 0) {
            return new Rect();
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int x = 0;
        int y = 0;
        boolean firstMove = true;
        Iterator it = records.iterator();
        while (it.hasNext()) {
            ShapeRecord r = (ShapeRecord)it.next();
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)r;
                x = scr.moveDeltaX;
                y = scr.moveDeltaY;
                if (firstMove) {
                    x1 = x;
                    y1 = y;
                    x2 = x;
                    y2 = y;
                    firstMove = false;
                }
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                x += ser.deltaX;
                y += ser.deltaY;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                x = x + cer.controlDeltaX + cer.anchorDeltaX;
                y = y + cer.controlDeltaY + cer.anchorDeltaY;
            }
            if (x < x1) {
                x1 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y <= y2) continue;
            y2 = y;
        }
        if (lineStyles != null && lineStyles.size() > 0) {
            it = lineStyles.iterator();
            int width = 20;
            while (it.hasNext()) {
                LineStyle ls = (LineStyle)it.next();
                if (ls == null || width >= ls.width) continue;
                width = ls.width;
            }
            double stroke = (int)Math.rint((double)width * 0.5);
            x1 = (int)Math.rint((double)x1 - stroke);
            y1 = (int)Math.rint((double)y1 - stroke);
            x2 = (int)Math.rint((double)x2 + stroke);
            y2 = (int)Math.rint((double)y2 + stroke);
        }
        return new Rect(x1, x2, y1, y2);
    }

    public static DefineShape buildImage(DefineBits tag, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
        AffineTransform at = new AffineTransform();
        at.setToScale(20.0, 20.0);
        Matrix matrix = MatrixBuilder.build(at);
        FillStyle fs = new FillStyle(65, matrix, tag);
        DefineShapeBuilder builder = new DefineShapeBuilder(rect, new Point(0.0, 0.0), fs, null, true);
        return (DefineShape)builder.build();
    }
}

