/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.builder.tags;

import macromedia.graphics.images.LosslessImage;
import macromedia.swf.builder.tags.DefineShapeBuilder;
import macromedia.swf.tags.DefineBitsLossless;
import macromedia.swf.tags.DefineShape;
import macromedia.swf.tags.DefineSprite;
import macromedia.swf.tags.PlaceObject;
import macromedia.swf.types.Matrix;
import macromedia.swf.types.TagList;

public class DefineBitsLosslessBuilder {
    private DefineBitsLosslessBuilder() {
    }

    public static DefineBitsLossless build(LosslessImage image) {
        DefineBitsLossless defineBitsLossless = new DefineBitsLossless(36);
        defineBitsLossless.format = 5;
        defineBitsLossless.width = image.getWidth();
        defineBitsLossless.height = image.getHeight();
        int[] pixels = image.getPixels();
        defineBitsLossless.data = new byte[pixels.length * 4];
        int i = 0;
        while (i < pixels.length) {
            int offset = i * 4;
            int alpha = pixels[i] >> 24 & 0xFF;
            defineBitsLossless.data[offset] = (byte)alpha;
            if (defineBitsLossless.data[offset] != 0) {
                int red = pixels[i] >> 16 & 0xFF;
                defineBitsLossless.data[offset + 1] = (byte)(red * alpha / 255);
                int green = pixels[i] >> 8 & 0xFF;
                defineBitsLossless.data[offset + 2] = (byte)(green * alpha / 255);
                int blue = pixels[i] & 0xFF;
                defineBitsLossless.data[offset + 3] = (byte)(blue * alpha / 255);
            }
            ++i;
        }
        return defineBitsLossless;
    }

    public static DefineSprite buildSprite(String name, LosslessImage image) {
        TagList taglist = new TagList();
        DefineBitsLossless defineBits = DefineBitsLosslessBuilder.build(image);
        taglist.defineBitsLossless2(defineBits);
        DefineShape ds3 = DefineShapeBuilder.buildImage(defineBits, defineBits.width, defineBits.height);
        taglist.defineShape3(ds3);
        PlaceObject po2 = new PlaceObject(ds3, 1);
        po2.setMatrix(new Matrix());
        po2.setName(name);
        taglist.placeObject2(po2);
        return DefineBitsLosslessBuilder.defineSprite(name, taglist);
    }

    private static DefineSprite defineSprite(String name, TagList taglist) {
        DefineSprite defineSprite = new DefineSprite();
        defineSprite.framecount = 1;
        defineSprite.tagList = taglist;
        defineSprite.name = name;
        return defineSprite;
    }
}

