/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import macromedia.swf.ActionDecoder;
import macromedia.swf.DebugDecoder;
import macromedia.swf.Dictionary;
import macromedia.swf.Header;
import macromedia.swf.SwfDecoder;
import macromedia.swf.SwfFormatException;
import macromedia.swf.Tag;
import macromedia.swf.TagHandler;
import macromedia.swf.TagValues;
import macromedia.swf.debug.DebugTable;
import macromedia.swf.tags.DebugID;
import macromedia.swf.tags.DefineBits;
import macromedia.swf.tags.DefineBitsJPEG3;
import macromedia.swf.tags.DefineBitsLossless;
import macromedia.swf.tags.DefineButton;
import macromedia.swf.tags.DefineButtonCxform;
import macromedia.swf.tags.DefineButtonSound;
import macromedia.swf.tags.DefineEditText;
import macromedia.swf.tags.DefineFont;
import macromedia.swf.tags.DefineFontInfo;
import macromedia.swf.tags.DefineMorphShape;
import macromedia.swf.tags.DefineShape;
import macromedia.swf.tags.DefineSound;
import macromedia.swf.tags.DefineSprite;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.tags.DefineText;
import macromedia.swf.tags.DefineVideoStream;
import macromedia.swf.tags.DoAction;
import macromedia.swf.tags.DoInitAction;
import macromedia.swf.tags.EnableDebugger;
import macromedia.swf.tags.ExportAssets;
import macromedia.swf.tags.FrameLabel;
import macromedia.swf.tags.GenericTag;
import macromedia.swf.tags.ImportAssets;
import macromedia.swf.tags.PlaceObject;
import macromedia.swf.tags.ProductInfo;
import macromedia.swf.tags.RemoveObject;
import macromedia.swf.tags.ScriptLimits;
import macromedia.swf.tags.SetBackgroundColor;
import macromedia.swf.tags.SetTabIndex;
import macromedia.swf.tags.ShowFrame;
import macromedia.swf.tags.SoundStreamHead;
import macromedia.swf.tags.StartSound;
import macromedia.swf.tags.VideoFrame;
import macromedia.swf.types.ButtonCondAction;
import macromedia.swf.types.ButtonRecord;
import macromedia.swf.types.CXForm;
import macromedia.swf.types.CXFormWithAlpha;
import macromedia.swf.types.CurvedEdgeRecord;
import macromedia.swf.types.FillStyle;
import macromedia.swf.types.FlashUUID;
import macromedia.swf.types.GlyphEntry;
import macromedia.swf.types.GradRecord;
import macromedia.swf.types.ImportRecord;
import macromedia.swf.types.KerningRecord;
import macromedia.swf.types.LineStyle;
import macromedia.swf.types.Matrix;
import macromedia.swf.types.MorphFillStyle;
import macromedia.swf.types.MorphGradRecord;
import macromedia.swf.types.MorphLineStyle;
import macromedia.swf.types.Rect;
import macromedia.swf.types.Shape;
import macromedia.swf.types.ShapeRecord;
import macromedia.swf.types.ShapeWithStyle;
import macromedia.swf.types.SoundInfo;
import macromedia.swf.types.StraightEdgeRecord;
import macromedia.swf.types.StyleChangeRecord;
import macromedia.swf.types.TextRecord;
import macromedia.util.Assert;

public final class TagDecoder
implements TagValues {
    private Header header;
    private InputStream swfIn;
    private InputStream swdIn;
    private URL swfUrl;
    private DebugTable swd;
    private SwfDecoder r;
    private GenericTag jpegTables;
    private TagHandler handler;
    private boolean keepOffsets;
    private Dictionary dict = new Dictionary();

    public TagDecoder(InputStream swfIn) {
        this.swfIn = swfIn;
        this.swdIn = null;
    }

    public TagDecoder(InputStream swfIn, InputStream swdIn) {
        this.swfIn = swfIn;
        this.swdIn = swdIn;
    }

    public TagDecoder(InputStream in, URL swfUrl) {
        this.swfIn = in;
        this.swfUrl = swfUrl;
    }

    public void setKeepOffsets(boolean b) {
        this.keepOffsets = b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(TagHandler handler) throws IOException {
        this.handler = handler;
        try {
            block7: {
                try {
                    try {
                        handler.setDecoderDictionary(this.dict);
                        this.header = this.decodeHeader();
                        handler.header(this.header);
                        this.decodeTags(handler);
                        handler.finish();
                    }
                    catch (FatalParseException e) {
                        Object var4_3 = null;
                        if (this.swfIn != null) {
                            this.swfIn.close();
                        }
                        break block7;
                    }
                    Object var4_2 = null;
                    if (this.swfIn == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.swfIn == null) throw throwable;
                    this.swfIn.close();
                    throw throwable;
                }
                this.swfIn.close();
            }
            Object var6_7 = null;
            if (this.swdIn == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (this.swdIn == null) throw throwable;
            this.swdIn.close();
            throw throwable;
        }
        this.swdIn.close();
    }

    public int getSwfVersion() {
        return this.header.version;
    }

    private void decodeTags(TagHandler handler) throws IOException {
        int type;
        do {
            int currentOffset = this.r.getOffset();
            int h = this.r.readUI16();
            type = h >> 6;
            int length = h & 0x3F;
            if (length == 63 && (length = this.r.readSI32()) < 0) {
                handler.error("negative tag length: " + length + " at offset " + currentOffset);
            }
            if (type == 0) continue;
            Tag t = this.decodeTag(type, length);
            handler.setOffsetAndSize(currentOffset, this.r.getOffset() - currentOffset);
            handler.any(t);
            t.visit(handler);
        } while (type != 0);
    }

    private Tag decodeTag(int type, int length) throws IOException {
        Tag t;
        int pos = this.r.getOffset();
        switch (type) {
            case 41: {
                t = this.decodeSerialNumber();
                break;
            }
            case 1: {
                t = new ShowFrame();
                break;
            }
            case 2: 
            case 22: 
            case 32: {
                t = this.decodeDefineShape(type);
                break;
            }
            case 4: {
                t = this.decodePlaceObject(length);
                break;
            }
            case 5: 
            case 28: {
                t = this.decodeRemoveObject(type);
                break;
            }
            case 6: {
                t = this.decodeDefineBits(length);
                break;
            }
            case 7: {
                t = this.decodeDefineButton(length);
                break;
            }
            case 8: {
                this.jpegTables = this.decodeJPEGTables(length);
                t = this.jpegTables;
                break;
            }
            case 9: {
                t = this.decodeSetBackgroundColor();
                break;
            }
            case 10: {
                t = this.decodeDefineFont();
                break;
            }
            case 11: 
            case 33: {
                t = this.decodeDefineText(type);
                break;
            }
            case 12: {
                t = this.decodeDoAction(length);
                break;
            }
            case 13: 
            case 62: {
                t = this.decodeDefineFontInfo(type, length);
                break;
            }
            case 14: {
                t = this.decodeDefineSound(length);
                break;
            }
            case 15: {
                t = this.decodeStartSound();
                break;
            }
            case 17: {
                t = this.decodeDefineButtonSound();
                break;
            }
            case 18: 
            case 45: {
                t = this.decodeSoundStreamHead(type);
                break;
            }
            case 19: {
                t = this.decodeSoundStreamBlock(length);
                break;
            }
            case 20: {
                t = this.decodeDefineBitsLossless(length);
                break;
            }
            case 21: {
                t = this.decodeDefineJPEG2(length);
                break;
            }
            case 23: {
                t = this.decodeDefineButtonCxform();
                break;
            }
            case 24: {
                t = this.decodeProtect(length);
                break;
            }
            case 26: {
                t = this.decodePlaceObject2(length);
                break;
            }
            case 34: {
                t = this.decodeDefineButton2(length);
                break;
            }
            case 35: {
                t = this.decodeDefineJPEG3(length);
                break;
            }
            case 36: {
                t = this.decodeDefineBitsLossless2(length);
                break;
            }
            case 37: {
                t = this.decodeDefineEditText();
                break;
            }
            case 39: {
                t = this.decodeDefineSprite(pos + length);
                break;
            }
            case 43: {
                t = this.decodeFrameLabel(length);
                break;
            }
            case 46: {
                t = this.decodeDefineMorphShape();
                break;
            }
            case 48: {
                t = this.decodeDefineFont2();
                break;
            }
            case 56: {
                t = this.decodeExportAssets();
                break;
            }
            case 57: {
                t = this.decodeImportAssets();
                break;
            }
            case 58: 
            case 64: {
                t = this.decodeEnableDebugger(type);
                break;
            }
            case 59: {
                t = this.decodeDoInitAction(length);
                break;
            }
            case 60: {
                t = this.decodeDefineVideoStream();
                break;
            }
            case 61: {
                t = this.decodeVideoFrame(length);
                break;
            }
            case 63: {
                t = this.decodeDebugID(type, length);
                break;
            }
            case 65: {
                t = this.decodeScriptLimits();
                break;
            }
            case 66: {
                t = this.decodeSetTabIndex();
                break;
            }
            default: {
                t = this.decodeUnknown(length, type);
            }
        }
        int consumed = this.r.getOffset() - pos;
        if (consumed != length && type == 18 && consumed != length + 2) {
            throw new SwfFormatException(TagValues.names[type] + " at pos " + pos + ": " + consumed + " bytes were read. " + length + " byte were required.");
        }
        return t;
    }

    private Tag decodeSetTabIndex() throws IOException {
        int depth = this.r.readUI16();
        int index = this.r.readUI16();
        return new SetTabIndex(depth, index);
    }

    private Tag decodeUnknown(int length, int code) throws IOException {
        GenericTag t = new GenericTag(code);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private ScriptLimits decodeScriptLimits() throws IOException {
        ScriptLimits scriptLimits = new ScriptLimits(this.r.readUI16(), this.r.readUI16());
        return scriptLimits;
    }

    private Tag decodeDebugID(int type, int length) throws IOException {
        DebugID t = new DebugID(type);
        t.uuid = this.decodeFlashUUID(length);
        if (this.swdIn != null) {
            InputStream in = this.swdIn;
            DebugTable swd = new DebugTable();
            new DebugDecoder(in).readSwd(swd);
            if (!t.uuid.equals(swd.uuid)) {
                this.handler.error("SWD uuid " + swd.uuid + " doesn't match " + t.uuid);
            } else if (swd.version != this.getSwfVersion()) {
                this.handler.error("SWD version number " + swd.version + " doesn't match SWF version number " + this.getSwfVersion());
            } else {
                this.swd = swd;
            }
        } else if (this.swfUrl != null) {
            String path = this.swfUrl.toString();
            int q = path.indexOf("?");
            String query = null;
            if (q != -1) {
                query = path.substring(q);
                path = path.substring(0, q);
            }
            path = path.endsWith(".swf") ? path.substring(0, path.length() - 4) + ".swd" : path + ".swd";
            if (query != null) {
                path = path + query;
            }
            URL swdUrl = new URL(path);
            try {
                InputStream in = swdUrl.openStream();
                DebugTable swd = new DebugTable();
                new DebugDecoder(in).readSwd(swd);
                if (!t.uuid.equals(swd.uuid)) {
                    this.handler.error("SWD uuid " + swd.uuid + " doesn't match " + t.uuid);
                } else if (swd.version != this.getSwfVersion()) {
                    this.handler.error("SWD version number " + swd.version + " doesn't match SWF version number " + this.getSwfVersion());
                } else {
                    this.swd = swd;
                }
            }
            catch (FileNotFoundException ex) {
                this.handler.error("SWD not found at url " + swdUrl);
            }
        }
        return t;
    }

    private FlashUUID decodeFlashUUID(int length) throws IOException {
        byte[] uuid = new byte[length];
        this.r.readFully(uuid);
        return new FlashUUID(uuid);
    }

    private Tag decodeVideoFrame(int length) throws IOException {
        VideoFrame t = new VideoFrame();
        int pos = this.r.getOffset();
        int idref = this.r.readUI16();
        t.stream = (DefineVideoStream)this.dict.getTag(idref);
        t.frameNum = this.r.readUI16();
        t.videoData = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.videoData);
        return t;
    }

    private Tag decodeDefineVideoStream() throws IOException {
        DefineVideoStream t = new DefineVideoStream();
        int id = this.r.readUI16();
        t.numFrames = this.r.readUI16();
        t.width = this.r.readUI16();
        t.height = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(5);
        t.deblocking = this.r.readUBits(2);
        t.smoothing = this.r.readBit();
        t.codecID = this.r.readUI8();
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDoInitAction(int length) throws IOException {
        DoInitAction t = new DoInitAction();
        int idref = this.r.readUI16();
        try {
            t.sprite = (DefineSprite)this.dict.getTag(idref);
            if (t.sprite.initAction != null) {
                this.handler.error("Sprite " + idref + " initaction redefined");
            } else {
                t.sprite.initAction = t;
            }
        }
        catch (IllegalArgumentException e) {
            this.handler.error(e.getMessage());
        }
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        t.actionList = actionDecoder.decode(length - 2);
        return t;
    }

    private Tag decodeEnableDebugger(int code) throws IOException {
        EnableDebugger t = new EnableDebugger(code);
        if (code == 64) {
            if (this.getSwfVersion() < 6) {
                this.handler.error("EnableDebugger2 not valid before SWF 6");
            }
            t.reserved = this.r.readUI16();
        }
        t.password = this.r.readString();
        return t;
    }

    private Tag decodeImportAssets() throws IOException {
        ImportAssets t = new ImportAssets();
        t.url = this.r.readString();
        int count = this.r.readUI16();
        t.importRecords = new ArrayList();
        int i = 0;
        while (i < count) {
            ImportRecord ir = new ImportRecord();
            int id = this.r.readUI16();
            ir.name = this.r.readString();
            t.importRecords.add(ir);
            this.dict.add(id, ir);
            this.dict.addName(ir, ir.name);
            ++i;
        }
        return t;
    }

    private Tag decodeExportAssets() throws IOException {
        ExportAssets t = new ExportAssets();
        int count = this.r.readUI16();
        t.exports = new ArrayList(count);
        int i = 0;
        while (i < count) {
            int idref = this.r.readUI16();
            String name = this.r.readString();
            DefineTag ref = this.dict.getTag(idref);
            t.exports.add(ref);
            if (ref.name != null) {
                if (!ref.name.equals(name)) {
                    this.handler.error("symbol " + idref + " already exported as " + ref.name);
                } else {
                    this.handler.error("redundant export of " + ref.name);
                }
            } else {
                DefineTag other = this.dict.getTag(name);
                if (other != null) {
                    int id = this.dict.getId(other);
                    this.handler.error("Symbol " + name + " already refers to ID " + id);
                }
                ref.name = name;
                this.dict.addName(ref, name);
            }
            ++i;
        }
        return t;
    }

    private Tag decodeDefineFont2() throws IOException {
        int i;
        DefineFont t = new DefineFont(48);
        int id = this.r.readUI16();
        this.r.syncBits();
        t.hasLayout = this.r.readBit();
        t.shiftJIS = this.r.readBit();
        this.r.readBit();
        t.ansi = this.r.readBit();
        boolean wideOffsets = this.r.readBit();
        boolean wideCodes = this.r.readBit();
        t.italic = this.r.readBit();
        t.bold = this.r.readBit();
        t.langCode = this.r.readUI8();
        t.fontName = this.r.readLengthString();
        int numGlyphs = this.r.readUI16();
        int i2 = 0;
        while (i2 < numGlyphs) {
            if (wideOffsets) {
                this.r.readUI32();
            } else {
                this.r.readUI16();
            }
            ++i2;
        }
        if (wideOffsets) {
            this.r.readUI32();
        } else {
            this.r.readUI16();
        }
        t.glyphShapeTable = new Shape[numGlyphs];
        int i3 = 0;
        while (i3 < numGlyphs) {
            t.glyphShapeTable[i3] = this.decodeShape(32);
            ++i3;
        }
        t.codeTable = new char[numGlyphs];
        if (wideCodes) {
            i = 0;
            while (i < numGlyphs) {
                t.codeTable[i] = (char)this.r.readUI16();
                ++i;
            }
        } else {
            i = 0;
            while (i < numGlyphs) {
                t.codeTable[i] = (char)this.r.readUI8();
                ++i;
            }
        }
        if (t.hasLayout) {
            t.ascent = this.r.readSI16();
            t.descent = this.r.readSI16();
            t.leading = this.r.readSI16();
            t.advanceTable = new short[numGlyphs];
            i = 0;
            while (i < numGlyphs) {
                t.advanceTable[i] = (short)this.r.readSI16();
                ++i;
            }
            t.boundsTable = new Rect[numGlyphs];
            int i4 = 0;
            while (i4 < numGlyphs) {
                t.boundsTable[i4] = this.decodeRect();
                ++i4;
            }
            t.kerningCount = this.r.readUI16();
            t.kerningTable = new KerningRecord[t.kerningCount];
            int i5 = 0;
            while (i5 < t.kerningCount) {
                t.kerningTable[i5] = this.decodeKerningRecord(wideCodes);
                ++i5;
            }
        }
        this.dict.add(id, t);
        return t;
    }

    private KerningRecord decodeKerningRecord(boolean wideCodes) throws IOException {
        KerningRecord kr = new KerningRecord();
        kr.code1 = wideCodes ? this.r.readUI16() : this.r.readUI8();
        kr.code2 = wideCodes ? this.r.readUI16() : this.r.readUI8();
        kr.adjustment = this.r.readUI16();
        return kr;
    }

    private Tag decodeDefineMorphShape() throws IOException {
        DefineMorphShape t = new DefineMorphShape();
        int id = this.r.readUI16();
        t.startBounds = this.decodeRect();
        t.endBounds = this.decodeRect();
        int offset = (int)this.r.readUI32();
        t.fillStyles = this.decodeMorphFillstyles();
        t.lineStyles = this.decodeMorphLinestyles();
        t.startEdges = this.decodeShape(32);
        if (offset != 0) {
            t.endEdges = this.decodeShape(32);
        }
        this.dict.add(id, t);
        return t;
    }

    private MorphLineStyle[] decodeMorphLinestyles() throws IOException {
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        MorphLineStyle[] styles = new MorphLineStyle[count];
        int i = 0;
        while (i < count) {
            MorphLineStyle s = new MorphLineStyle();
            s.startWidth = this.r.readUI16();
            s.endWidth = this.r.readUI16();
            s.startColor = this.decodeRGBA(this.r);
            s.endColor = this.decodeRGBA(this.r);
            styles[i] = s;
            ++i;
        }
        return styles;
    }

    private MorphFillStyle[] decodeMorphFillstyles() throws IOException {
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        MorphFillStyle[] styles = new MorphFillStyle[count];
        int i = 0;
        while (i < count) {
            styles[i] = this.decodeMorphFillStyle();
            ++i;
        }
        return styles;
    }

    private MorphFillStyle decodeMorphFillStyle() throws IOException {
        MorphFillStyle s = new MorphFillStyle();
        s.type = this.r.readUI8();
        switch (s.type) {
            case 0: {
                s.startColor = this.decodeRGBA(this.r);
                s.endColor = this.decodeRGBA(this.r);
                break;
            }
            case 16: 
            case 18: {
                s.startGradientMatrix = this.decodeMatrix();
                s.endGradientMatrix = this.decodeMatrix();
                s.gradRecords = this.decodeMorphGradient();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int idref = this.r.readUI16();
                try {
                    s.bitmap = this.dict.getTag(idref);
                }
                catch (IllegalArgumentException ex) {
                    this.handler.error(ex.getMessage());
                    s.bitmap = null;
                }
                s.startBitmapMatrix = this.decodeMatrix();
                s.endBitmapMatrix = this.decodeMatrix();
                break;
            }
            default: {
                throw new SwfFormatException("unrecognized fill style type: " + s.type);
            }
        }
        return s;
    }

    private MorphGradRecord[] decodeMorphGradient() throws IOException {
        int num = this.r.readUI8();
        MorphGradRecord[] gradRecords = new MorphGradRecord[num];
        int i = 0;
        while (i < num) {
            MorphGradRecord g = new MorphGradRecord();
            g.startRatio = this.r.readUI8();
            g.startColor = this.decodeRGBA(this.r);
            g.endRatio = this.r.readUI8();
            g.endColor = this.decodeRGBA(this.r);
            gradRecords[i] = g;
            ++i;
        }
        return gradRecords;
    }

    private Tag decodeFrameLabel(int length) throws IOException {
        FrameLabel t = new FrameLabel();
        int pos = this.r.getOffset();
        t.label = this.r.readString();
        if (this.getSwfVersion() >= 6 && length - this.r.getOffset() + pos == 1) {
            int anchor = this.r.readUI8();
            if (anchor != 0 && anchor != 1) {
                this.handler.error("illegal anchor value: " + anchor + ".  Must be 0 or 1");
            }
            t.anchor = anchor != 0;
        }
        return t;
    }

    private Tag decodeDefineEditText() throws IOException {
        DefineEditText t = new DefineEditText();
        int id = this.r.readUI16();
        t.bounds = this.decodeRect();
        this.r.syncBits();
        t.hasText = this.r.readBit();
        t.wordWrap = this.r.readBit();
        t.multiline = this.r.readBit();
        t.password = this.r.readBit();
        t.readOnly = this.r.readBit();
        t.hasTextColor = this.r.readBit();
        t.hasMaxLength = this.r.readBit();
        t.hasFont = this.r.readBit();
        this.r.readBit();
        t.autoSize = this.r.readBit();
        t.hasLayout = this.r.readBit();
        t.noSelect = this.r.readBit();
        t.border = this.r.readBit();
        this.r.readBit();
        t.html = this.r.readBit();
        t.useOutlines = this.r.readBit();
        if (t.hasFont) {
            int idref = this.r.readUI16();
            t.font = (DefineFont)this.dict.getTag(idref);
            t.height = this.r.readUI16();
        }
        if (t.hasTextColor) {
            t.color = this.decodeRGBA(this.r);
        }
        if (t.hasMaxLength) {
            t.maxLength = this.r.readUI16();
        }
        if (t.hasLayout) {
            t.align = this.r.readUI8();
            t.leftMargin = this.r.readUI16();
            t.rightMargin = this.r.readUI16();
            t.ident = this.r.readUI16();
            t.leading = this.r.readSI16();
        }
        t.varName = this.r.readString();
        if (t.hasText) {
            t.initialText = this.r.readString();
        }
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineBitsLossless2(int length) throws IOException {
        DefineBitsLossless t = new DefineBitsLossless(36);
        SwfDecoder r1 = this.r;
        int pos = r1.getOffset();
        int id = r1.readUI16();
        t.format = r1.readUI8();
        t.width = r1.readUI16();
        t.height = r1.readUI16();
        switch (t.format) {
            case 3: {
                int colorTableSize = r1.readUI8() + 1;
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                this.decodeAlphaColorMapData(r1, t, colorTableSize);
                break;
            }
            case 4: 
            case 5: {
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                t.data = new byte[t.width * t.height * 4];
                r1.readFully(t.data);
                break;
            }
            default: {
                throw new SwfFormatException("Illegal bitmap format " + t.format);
            }
        }
        this.dict.add(id, t);
        return t;
    }

    private void decodeAlphaColorMapData(SwfDecoder r1, DefineBitsLossless tag, int tableSize) throws IOException {
        int width = tag.width;
        int height = tag.height;
        tag.colorData = new int[tableSize];
        int i = 0;
        while (i < tableSize) {
            tag.colorData[i] = this.decodeRGBA(r1);
            ++i;
        }
        if (width % 4 != 0) {
            width = (width / 4 + 1) * 4;
        }
        int data_size = width * height;
        tag.data = new byte[data_size];
        int i2 = 0;
        while (i2 < data_size) {
            int b = r1.readUI8();
            if (b == -1) break;
            tag.data[i2] = (byte)b;
            ++i2;
        }
        int extra = 0;
        while (r1.readUI8() != -1) {
            ++extra;
        }
        if (extra > 0) {
            throw new SwfFormatException(extra + " bytes of bitmap data (" + width + "x" + height + ") not read!");
        }
        if (i2 != data_size) {
            throw new SwfFormatException("(" + width + "x" + height + ") data buffer " + (data_size - i2) + " bytes too big...");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tag decodeDefineJPEG3(int length) throws IOException {
        int alpha;
        DefineBitsJPEG3 t = new DefineBitsJPEG3();
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.alphaDataOffset = this.r.readUI32();
        t.data = new byte[(int)t.alphaDataOffset];
        this.r.readFully(t.data);
        byte[] temp = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(temp);
        SwfDecoder r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(temp)), this.getSwfVersion());
        int i = 0;
        byte[] alphaData = new byte[length];
        while ((alpha = r1.readUI8()) != -1) {
            void var7_9;
            if (i == alphaData.length) {
                byte[] b = new byte[i + length];
                System.arraycopy(alphaData, 0, b, 0, alphaData.length);
                alphaData = b;
            }
            alphaData[i] = (byte)var7_9;
            ++i;
        }
        t.alphaData = new byte[i];
        System.arraycopy(alphaData, 0, t.alphaData, 0, i);
        this.dict.add(id, t);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private Tag decodeDefineButton2(int length) throws IOException {
        ButtonRecord record;
        int endpos = this.r.getOffset() + length;
        DefineButton t = new DefineButton(34);
        int id = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(7);
        t.trackAsMenu = this.r.readBit();
        int actionOffset = this.r.readUI16();
        ArrayList<Object> list = new ArrayList<Object>(5);
        while ((record = this.decodeButtonRecord(t.code)) != null) {
            void var7_7;
            list.add(var7_7);
        }
        t.buttonRecords = new ButtonRecord[list.size()];
        list.toArray(t.buttonRecords);
        list.clear();
        if (actionOffset > 0) {
            list = new ArrayList();
            int pos = this.r.getOffset();
            while ((actionOffset = this.r.readUI16()) > 0) {
                list.add(this.decodeButtonCondAction(actionOffset - 2));
                if (this.r.getOffset() != pos + actionOffset) {
                    throw new SwfFormatException("incorrect offset read in ButtonCondAction. read " + actionOffset + "");
                }
                pos = this.r.getOffset();
            }
            list.add(this.decodeButtonCondAction(endpos - this.r.getOffset()));
            t.condActions = new ButtonCondAction[list.size()];
            list.toArray(t.condActions);
        } else {
            t.condActions = new ButtonCondAction[0];
        }
        while (this.r.getOffset() < endpos) {
            int b = this.r.readUI8();
            if (b == 0) continue;
            throw new SwfFormatException("nonzero data past end of DefineButton2");
        }
        this.dict.add(id, t);
        return t;
    }

    private ButtonCondAction decodeButtonCondAction(int length) throws IOException {
        ButtonCondAction a = new ButtonCondAction();
        this.r.syncBits();
        a.keyPress = this.r.readUBits(7);
        a.overDownToIdle = this.r.readBit();
        a.idleToOverDown = this.r.readBit();
        a.outDownToIdle = this.r.readBit();
        a.outDownToOverDown = this.r.readBit();
        a.overDownToOutDown = this.r.readBit();
        a.overDownToOverUp = this.r.readBit();
        a.overUpToOverDown = this.r.readBit();
        a.overUpToIdle = this.r.readBit();
        a.idleToOverUp = this.r.readBit();
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        a.actionList = actionDecoder.decode(length - 2);
        return a;
    }

    private Tag decodePlaceObject2(int length) throws IOException {
        PlaceObject t = new PlaceObject(26);
        this.r.syncBits();
        int pos = this.r.getOffset();
        t.flags = this.r.readUI8();
        t.depth = this.r.readUI16();
        if (t.hasCharID()) {
            int idref = this.r.readUI16();
            t.ref = this.dict.getTag(idref);
        }
        if (t.hasMatrix()) {
            t.matrix = this.decodeMatrix();
        }
        if (t.hasCxform()) {
            t.colorTransform = this.decodeCxforma();
        }
        if (t.hasRatio()) {
            t.ratio = this.r.readUI16();
        }
        if (t.hasName()) {
            t.name = this.r.readString();
        }
        if (t.hasClipDepth()) {
            t.clipDepth = this.r.readUI16();
        }
        if (t.hasClipAction()) {
            ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
            actionDecoder.setKeepOffsets(this.keepOffsets);
            t.clipActions = actionDecoder.decodeClipActions(length - (this.r.getOffset() - pos));
        }
        return t;
    }

    private CXFormWithAlpha decodeCxforma() throws IOException {
        CXFormWithAlpha c = new CXFormWithAlpha();
        this.r.syncBits();
        c.hasAdd = this.r.readBit();
        c.hasMult = this.r.readBit();
        int nbits = this.r.readUBits(4);
        if (c.hasMult) {
            c.redMultTerm = this.r.readSBits(nbits);
            c.greenMultTerm = this.r.readSBits(nbits);
            c.blueMultTerm = this.r.readSBits(nbits);
            c.alphaMultTerm = this.r.readSBits(nbits);
        }
        if (c.hasAdd) {
            c.redAddTerm = this.r.readSBits(nbits);
            c.greenAddTerm = this.r.readSBits(nbits);
            c.blueAddTerm = this.r.readSBits(nbits);
            c.alphaAddTerm = this.r.readSBits(nbits);
        }
        return c;
    }

    private Tag decodeProtect(int length) throws IOException {
        GenericTag t = new GenericTag(24);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeDefineButtonCxform() throws IOException {
        DefineButtonCxform t = new DefineButtonCxform();
        int idref = this.r.readUI16();
        t.button = (DefineButton)this.dict.getTag(idref);
        if (t.button.cxform != null) {
            this.handler.error("button " + this.dict.getId(t.button) + " cxform redefined");
        }
        t.button.cxform = t;
        t.colorTransform = this.decodeCxform();
        return t;
    }

    private Tag decodeDefineJPEG2(int length) throws IOException {
        DefineBits t = new DefineBits(21);
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineBitsLossless(int length) throws IOException {
        DefineBitsLossless t = new DefineBitsLossless(20);
        SwfDecoder r1 = this.r;
        int pos = r1.getOffset();
        int id = r1.readUI16();
        t.format = r1.readUI8();
        t.width = r1.readUI16();
        t.height = r1.readUI16();
        switch (t.format) {
            case 3: {
                int tableSize = r1.readUI8() + 1;
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                this.decodeColorMapData(r1, t, tableSize);
                break;
            }
            case 4: 
            case 5: {
                byte[] data = new byte[length -= r1.getOffset() - pos];
                r1.readFully(data);
                r1 = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(data)), this.getSwfVersion());
                t.data = new byte[t.width * t.height * 4];
                r1.readFully(t.data);
                break;
            }
            default: {
                throw new SwfFormatException("Illegal bitmap format " + t.format);
            }
        }
        this.dict.add(id, t);
        return t;
    }

    private void decodeColorMapData(SwfDecoder r1, DefineBitsLossless tag, int tableSize) throws IOException {
        tag.colorData = new int[tableSize];
        int i = 0;
        while (i < tableSize) {
            tag.colorData[i] = this.decodeRGB(r1);
            ++i;
        }
        int width = tag.width;
        int height = tag.height;
        if (width % 4 != 0) {
            width = (width / 4 + 1) * 4;
        }
        tag.data = new byte[width * height];
        r1.readFully(tag.data);
    }

    private Tag decodeSoundStreamBlock(int length) throws IOException {
        GenericTag t = new GenericTag(19);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeSoundStreamHead(int code) throws IOException {
        SoundStreamHead t = new SoundStreamHead(code);
        this.r.syncBits();
        this.r.readUBits(4);
        t.playbackRate = this.r.readUBits(2);
        t.playbackSize = this.r.readUBits(1);
        t.playbackType = this.r.readUBits(1);
        t.compression = this.r.readUBits(4);
        t.streamRate = this.r.readUBits(2);
        t.streamSize = this.r.readUBits(1);
        t.streamType = this.r.readUBits(1);
        t.streamSampleCount = this.r.readUI16();
        if (t.compression == 2) {
            t.latencySeek = this.r.readSI16();
        }
        return t;
    }

    private Tag decodeDefineButtonSound() throws IOException {
        DefineButtonSound t = new DefineButtonSound();
        int idref = this.r.readUI16();
        t.button = (DefineButton)this.dict.getTag(idref);
        if (t.button.sounds != null) {
            this.handler.error("button " + idref + " sound redefined");
        }
        t.button.sounds = t;
        idref = this.r.readUI16();
        if (idref != 0) {
            t.sound0 = this.dict.getTag(idref);
            t.info0 = this.decodeSoundInfo();
        }
        if ((idref = this.r.readUI16()) != 0) {
            t.sound1 = this.dict.getTag(idref);
            t.info1 = this.decodeSoundInfo();
        }
        if ((idref = this.r.readUI16()) != 0) {
            t.sound2 = this.dict.getTag(idref);
            t.info2 = this.decodeSoundInfo();
        }
        if ((idref = this.r.readUI16()) != 0) {
            t.sound3 = this.dict.getTag(idref);
            t.info3 = this.decodeSoundInfo();
        }
        return t;
    }

    private Tag decodeStartSound() throws IOException {
        StartSound t = new StartSound();
        int idref = this.r.readUI16();
        t.sound = (DefineSound)this.dict.getTag(idref);
        t.soundInfo = this.decodeSoundInfo();
        return t;
    }

    private SoundInfo decodeSoundInfo() throws IOException {
        SoundInfo i = new SoundInfo();
        this.r.syncBits();
        this.r.readUBits(2);
        i.syncStop = this.r.readBit();
        i.syncNoMultiple = this.r.readBit();
        boolean hasEnvelope = this.r.readBit();
        boolean hasLoops = this.r.readBit();
        boolean hasOutPoint = this.r.readBit();
        boolean hasInPoint = this.r.readBit();
        if (hasInPoint) {
            i.inPoint = this.r.readUI32();
        }
        if (hasOutPoint) {
            i.outPoint = this.r.readUI32();
        }
        if (hasLoops) {
            i.loopCount = this.r.readUI16();
        }
        if (hasEnvelope) {
            int points = this.r.readUI8();
            i.records = new long[points];
            int k = 0;
            while (k < points) {
                i.records[k] = this.r.read64();
                ++k;
            }
        }
        return i;
    }

    private Tag decodeDefineSound(int length) throws IOException {
        DefineSound t = new DefineSound();
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        this.r.syncBits();
        t.format = this.r.readUBits(4);
        t.rate = this.r.readUBits(2);
        t.size = this.r.readUBits(1);
        t.type = this.r.readUBits(1);
        t.sampleCount = this.r.readUI32();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeDefineFontInfo(int code, int length) throws IOException {
        DefineFontInfo t = new DefineFontInfo(code);
        int pos = this.r.getOffset();
        int idref = this.r.readUI16();
        t.font = (DefineFont)this.dict.getTag(idref);
        if (t.font.fontInfo != null) {
            this.handler.error("font " + idref + " info redefined");
        }
        t.font.fontInfo = t;
        t.name = this.r.readLengthString();
        this.r.syncBits();
        this.r.readUBits(3);
        t.shiftJIS = this.r.readBit();
        t.ansi = this.r.readBit();
        t.italic = this.r.readBit();
        t.bold = this.r.readBit();
        boolean widecodes = this.r.readBit();
        if (code == 62) {
            if (!widecodes) {
                this.handler.error("widecodes must be true in DefineFontInfo2");
            }
            if (this.getSwfVersion() < 6) {
                this.handler.error("DefineFont2 not valid before SWF6");
            }
            t.langCode = this.r.readUI8();
        }
        length -= this.r.getOffset() - pos;
        if (widecodes) {
            t.codeTable = new char[length /= 2];
            int i = 0;
            while (i < length) {
                t.codeTable[i] = (char)this.r.readUI16();
                ++i;
            }
        } else {
            t.codeTable = new char[length];
            int i = 0;
            while (i < length) {
                t.codeTable[i] = (char)this.r.readUI8();
                ++i;
            }
        }
        return t;
    }

    private Tag decodeDoAction(int length) throws IOException {
        DoAction t = new DoAction();
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        t.actionList = actionDecoder.decode(length);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private Tag decodeDefineText(int type) throws IOException {
        int code;
        DefineText t = new DefineText(type);
        int id = this.r.readUI16();
        t.bounds = this.decodeRect();
        t.matrix = this.decodeMatrix();
        int glyphBits = this.r.readUI8();
        int advanceBits = this.r.readUI8();
        ArrayList<TextRecord> list = new ArrayList<TextRecord>(2);
        while ((code = this.r.readUI8()) != 0) {
            void var7_7;
            list.add(this.decodeTextRecord(type, (int)var7_7, glyphBits, advanceBits));
        }
        t.records = list;
        this.dict.add(id, t);
        return t;
    }

    private GlyphEntry[] decodeGlyphEntries(int glyphBits, int advanceBits, int count) throws IOException {
        GlyphEntry[] e = new GlyphEntry[count];
        this.r.syncBits();
        int i = 0;
        while (i < count) {
            GlyphEntry ge = new GlyphEntry();
            ge.setIndex(this.r.readUBits(glyphBits));
            ge.advance = this.r.readSBits(advanceBits);
            e[i] = ge;
            ++i;
        }
        return e;
    }

    private TextRecord decodeTextRecord(int defineText, int flags, int glyphBits, int advanceBits) throws IOException {
        TextRecord t = new TextRecord();
        t.flags = flags;
        if (t.hasFont()) {
            int idref = this.r.readUI16();
            t.font = (DefineFont)this.dict.getTag(idref);
        }
        if (t.hasColor()) {
            switch (defineText) {
                case 11: {
                    t.color = this.decodeRGB(this.r);
                    break;
                }
                case 33: {
                    t.color = this.decodeRGBA(this.r);
                    break;
                }
                default: {
                    Assert.testAssertion((boolean)false);
                }
            }
        }
        if (t.hasX()) {
            t.xOffset = this.r.readSI16();
        }
        if (t.hasY()) {
            t.yOffset = this.r.readSI16();
        }
        if (t.hasHeight()) {
            t.height = this.r.readUI16();
        }
        int count = this.r.readUI8();
        t.entries = this.decodeGlyphEntries(glyphBits, advanceBits, count);
        return t;
    }

    private Tag decodeDefineFont() throws IOException {
        DefineFont t = new DefineFont(10);
        int id = this.r.readUI16();
        int offset = this.r.readUI16();
        int numGlyphs = offset / 2;
        t.glyphShapeTable = new Shape[numGlyphs];
        int i = 1;
        while (i < numGlyphs) {
            this.r.readUI16();
            ++i;
        }
        int i2 = 0;
        while (i2 < numGlyphs) {
            t.glyphShapeTable[i2] = this.decodeShape(32);
            ++i2;
        }
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeSetBackgroundColor() throws IOException {
        SetBackgroundColor t = new SetBackgroundColor(this.decodeRGB(this.r));
        return t;
    }

    private GenericTag decodeJPEGTables(int length) throws IOException {
        GenericTag t = new GenericTag(8);
        t.data = new byte[length];
        this.r.readFully(t.data);
        return t;
    }

    private Tag decodeDefineButton(int length) throws IOException {
        ButtonRecord record;
        int startPos = this.r.getOffset();
        DefineButton t = new DefineButton(7);
        int id = this.r.readUI16();
        ArrayList<ButtonRecord> list = new ArrayList<ButtonRecord>();
        do {
            if ((record = this.decodeButtonRecord(t.code)) == null) continue;
            list.add(record);
        } while (record != null);
        t.buttonRecords = new ButtonRecord[list.size()];
        list.toArray(t.buttonRecords);
        int consumed = this.r.getOffset() - startPos;
        t.condActions = new ButtonCondAction[1];
        t.condActions[0].overDownToOverUp = true;
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        t.condActions[0].actionList = actionDecoder.decode(length - consumed);
        t.trackAsMenu = false;
        this.dict.add(id, t);
        return t;
    }

    private ButtonRecord decodeButtonRecord(int type) throws IOException {
        ButtonRecord b = new ButtonRecord();
        this.r.syncBits();
        int reserved = this.r.readUBits(4);
        b.hitTest = this.r.readBit();
        b.down = this.r.readBit();
        b.over = this.r.readBit();
        b.up = this.r.readBit();
        if (!(reserved != 0 || b.hitTest || b.down || b.over || b.up)) {
            return null;
        }
        int idref = this.r.readUI16();
        b.characterRef = this.dict.getTag(idref);
        b.placeDepth = this.r.readUI16();
        b.placeMatrix = this.decodeMatrix();
        if (type == 34) {
            b.colorTransform = this.decodeCxforma();
        }
        return b;
    }

    private Tag decodeDefineBits(int length) throws IOException {
        DefineBits t = new DefineBits(6);
        int pos = this.r.getOffset();
        int id = this.r.readUI16();
        t.data = new byte[length -= this.r.getOffset() - pos];
        this.r.readFully(t.data);
        t.jpegTables = this.jpegTables;
        this.dict.add(id, t);
        return t;
    }

    private Tag decodeRemoveObject(int code) throws IOException {
        RemoveObject t = new RemoveObject(code);
        if (code == 5) {
            int idref = this.r.readUI16();
            t.ref = this.dict.getTag(idref);
        }
        t.depth = this.r.readUI16();
        return t;
    }

    private Tag decodePlaceObject(int length) throws IOException {
        PlaceObject t = new PlaceObject(4);
        int pos = this.r.getOffset();
        int idref = this.r.readUI16();
        t.depth = this.r.readUI16();
        t.setMatrix(this.decodeMatrix());
        if (length - this.r.getOffset() + pos != 0) {
            t.setCxform(this.decodeCxform());
        }
        t.setRef(this.dict.getTag(idref));
        return t;
    }

    private CXForm decodeCxform() throws IOException {
        CXForm c = new CXForm();
        this.r.syncBits();
        c.hasAdd = this.r.readBit();
        c.hasMult = this.r.readBit();
        int nbits = this.r.readUBits(4);
        if (c.hasMult) {
            c.redMultTerm = this.r.readSBits(nbits);
            c.greenMultTerm = this.r.readSBits(nbits);
            c.blueMultTerm = this.r.readSBits(nbits);
        }
        if (c.hasAdd) {
            c.redAddTerm = this.r.readSBits(nbits);
            c.greenAddTerm = this.r.readSBits(nbits);
            c.blueAddTerm = this.r.readSBits(nbits);
        }
        return c;
    }

    private Tag decodeDefineShape(int shape) throws IOException {
        DefineShape t = new DefineShape(shape);
        int id = this.r.readUI16();
        t.bounds = this.decodeRect();
        t.shapeWithStyle = this.decodeShapeWithStyle(shape);
        this.dict.add(id, t);
        return t;
    }

    private ShapeWithStyle decodeShapeWithStyle(int shape) throws IOException {
        ShapeWithStyle sw = new ShapeWithStyle();
        this.r.syncBits();
        sw.fillstyles = this.decodeFillstyles(shape);
        sw.linestyles = this.decodeLinestyles(shape);
        Shape s = this.decodeShape(shape);
        sw.shapeRecords = s.shapeRecords;
        return sw;
    }

    private ArrayList decodeLinestyles(int shape) throws IOException {
        ArrayList<LineStyle> a = new ArrayList<LineStyle>();
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        int i = 0;
        while (i < count) {
            a.add(this.decodeLineStyle(shape));
            ++i;
        }
        return a;
    }

    private LineStyle decodeLineStyle(int shape) throws IOException {
        LineStyle s = new LineStyle();
        s.width = this.r.readUI16();
        switch (shape) {
            case 2: 
            case 22: {
                s.color = this.decodeRGB(this.r);
                break;
            }
            case 32: {
                s.color = this.decodeRGBA(this.r);
            }
        }
        return s;
    }

    private ArrayList decodeFillstyles(int shape) throws IOException {
        ArrayList<FillStyle> a = new ArrayList<FillStyle>();
        int count = this.r.readUI8();
        if (count == 255) {
            count = this.r.readUI16();
        }
        int i = 0;
        while (i < count) {
            a.add(this.decodeFillStyle(shape));
            ++i;
        }
        return a;
    }

    private FillStyle decodeFillStyle(int shape) throws IOException {
        FillStyle s = new FillStyle();
        s.type = this.r.readUI8();
        switch (s.type) {
            case 0: {
                if (shape == 32) {
                    s.color = this.decodeRGBA(this.r);
                    break;
                }
                if (shape == 22 || shape == 2) {
                    s.color = this.decodeRGB(this.r);
                    break;
                }
                throw new SwfFormatException("bad shape code");
            }
            case 16: 
            case 18: {
                s.matrix = this.decodeMatrix();
                s.gradient = this.decodeGradient(shape);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int idref = this.r.readUI16();
                try {
                    s.bitmap = this.dict.getTag(idref);
                }
                catch (IllegalArgumentException e) {
                    s.bitmap = null;
                    this.handler.error(e.getMessage());
                }
                s.matrix = this.decodeMatrix();
                break;
            }
            default: {
                throw new SwfFormatException("unrecognized fill style type: " + s.type);
            }
        }
        return s;
    }

    private GradRecord[] decodeGradient(int shape) throws IOException {
        int count = this.r.readUI8();
        GradRecord[] records = new GradRecord[count];
        int i = 0;
        while (i < count) {
            records[i] = this.decodeGradRecord(shape);
            ++i;
        }
        return records;
    }

    private GradRecord decodeGradRecord(int shape) throws IOException {
        GradRecord g = new GradRecord();
        g.ratio = this.r.readUI8();
        switch (shape) {
            case 2: 
            case 22: {
                g.color = this.decodeRGB(this.r);
                break;
            }
            case 32: {
                g.color = this.decodeRGBA(this.r);
            }
        }
        return g;
    }

    private Matrix decodeMatrix() throws IOException {
        Matrix m = new Matrix();
        this.r.syncBits();
        m.hasScale = this.r.readBit();
        if (m.hasScale) {
            int nScaleBits = this.r.readUBits(5);
            m.scaleX = this.r.readSBits(nScaleBits);
            m.scaleY = this.r.readSBits(nScaleBits);
        }
        m.hasRotate = this.r.readBit();
        if (m.hasRotate) {
            int nRotateBits = this.r.readUBits(5);
            m.rotateSkew0 = this.r.readSBits(nRotateBits);
            m.rotateSkew1 = this.r.readSBits(nRotateBits);
        }
        int nTranslateBits = this.r.readUBits(5);
        m.translateX = this.r.readSBits(nTranslateBits);
        m.translateY = this.r.readSBits(nTranslateBits);
        return m;
    }

    private int decodeRGBA(SwfDecoder r) throws IOException {
        int color = r.readUI8() << 16;
        color |= r.readUI8() << 8;
        color |= r.readUI8();
        return color |= r.readUI8() << 24;
    }

    private int decodeRGB(SwfDecoder r) throws IOException {
        int color = r.readUI8() << 16;
        color |= r.readUI8() << 8;
        return color |= r.readUI8();
    }

    private Shape decodeShape(int shape) throws IOException {
        Shape s1 = new Shape();
        this.r.syncBits();
        int[] numFillBits = new int[]{this.r.readUBits(4)};
        int[] numLineBits = new int[]{this.r.readUBits(4)};
        s1.shapeRecords = this.decodeShapeRecords(shape, numFillBits, numLineBits);
        return s1;
    }

    private List decodeShapeRecords(int shape, int[] numFillBits, int[] numLineBits) throws IOException {
        ArrayList<ShapeRecord> list = new ArrayList<ShapeRecord>();
        boolean endShapeRecord = false;
        do {
            if (this.r.readBit()) {
                if (this.r.readBit()) {
                    list.add(this.decodeStraightEdgeRecord());
                    continue;
                }
                list.add(this.decodeCurvedEdgeRecord());
                continue;
            }
            boolean stateNewStyles = this.r.readBit();
            boolean stateLineStyle = this.r.readBit();
            boolean stateFillStyle1 = this.r.readBit();
            boolean stateFillStyle0 = this.r.readBit();
            boolean stateMoveTo = this.r.readBit();
            if (stateNewStyles || stateLineStyle || stateFillStyle1 || stateFillStyle0 || stateMoveTo) {
                StyleChangeRecord s = this.decodeStyleChangeRecord(stateNewStyles, stateLineStyle, stateFillStyle1, stateFillStyle0, stateMoveTo, shape, numFillBits, numLineBits);
                list.add(s);
                continue;
            }
            endShapeRecord = true;
        } while (!endShapeRecord);
        return list;
    }

    private CurvedEdgeRecord decodeCurvedEdgeRecord() throws IOException {
        CurvedEdgeRecord s = new CurvedEdgeRecord();
        int nbits = 2 + this.r.readUBits(4);
        s.controlDeltaX = this.r.readSBits(nbits);
        s.controlDeltaY = this.r.readSBits(nbits);
        s.anchorDeltaX = this.r.readSBits(nbits);
        s.anchorDeltaY = this.r.readSBits(nbits);
        return s;
    }

    private StraightEdgeRecord decodeStraightEdgeRecord() throws IOException {
        int nbits = 2 + this.r.readUBits(4);
        if (this.r.readBit()) {
            int dx = this.r.readSBits(nbits);
            int dy = this.r.readSBits(nbits);
            return new StraightEdgeRecord(dx, dy);
        }
        if (this.r.readBit()) {
            int dy = this.r.readSBits(nbits);
            return new StraightEdgeRecord(0, dy);
        }
        int dx = this.r.readSBits(nbits);
        return new StraightEdgeRecord(dx, 0);
    }

    private StyleChangeRecord decodeStyleChangeRecord(boolean stateNewStyles, boolean stateLineStyle, boolean stateFillStyle1, boolean stateFillStyle0, boolean stateMoveTo, int shape, int[] numFillBits, int[] numLineBits) throws IOException {
        StyleChangeRecord s = new StyleChangeRecord();
        s.stateNewStyles = stateNewStyles;
        s.stateLineStyle = stateLineStyle;
        s.stateFillStyle1 = stateFillStyle1;
        s.stateFillStyle0 = stateFillStyle0;
        s.stateMoveTo = stateMoveTo;
        if (s.stateMoveTo) {
            int moveBits = this.r.readUBits(5);
            s.moveDeltaX = this.r.readSBits(moveBits);
            s.moveDeltaY = this.r.readSBits(moveBits);
        }
        if (s.stateFillStyle0) {
            s.fillstyle0 = this.r.readUBits(numFillBits[0]);
        }
        if (s.stateFillStyle1) {
            s.fillstyle1 = this.r.readUBits(numFillBits[0]);
        }
        if (s.stateLineStyle) {
            s.linestyle = this.r.readUBits(numLineBits[0]);
        }
        if (s.stateNewStyles) {
            s.fillstyles = this.decodeFillstyles(shape);
            s.linestyles = this.decodeLinestyles(shape);
            this.r.syncBits();
            numFillBits[0] = this.r.readUBits(4);
            numLineBits[0] = this.r.readUBits(4);
        }
        return s;
    }

    private Tag decodeDefineSprite(int endpos) throws IOException {
        DefineSprite t = new DefineSprite();
        t.header = this.header;
        int id = this.r.readUI16();
        t.framecount = this.r.readUI16();
        this.decodeTags(t.tagList);
        while (this.r.getOffset() < endpos) {
            int b = this.r.readUI8();
            if (b == 0) continue;
            throw new SwfFormatException("nonzero data past end of sprite");
        }
        this.dict.add(id, t);
        return t;
    }

    public Tag decodeSerialNumber() throws IOException {
        int product = this.r.readSI32();
        int edition = this.r.readSI32();
        byte[] version = new byte[2];
        this.r.read(version);
        byte majorVersion = version[0];
        byte minorVersion = version[1];
        long build = this.r.read64();
        long compileDate = this.r.read64();
        return new ProductInfo(product, edition, majorVersion, minorVersion, build, compileDate);
    }

    public Header decodeHeader() throws IOException, FatalParseException {
        Header header = new Header();
        byte[] sig = new byte[8];
        new DataInputStream(this.swfIn).readFully(sig);
        header.version = sig[3];
        header.length = sig[4] & 0xFF | (sig[5] & 0xFF) << 8 | (sig[6] & 0xFF) << 16 | sig[7] << 24;
        if (sig[0] == 67 && sig[1] == 87 && sig[2] == 83) {
            header.compressed = true;
            this.r = new SwfDecoder(new InflaterInputStream(this.swfIn), header.version, 8);
        } else if (sig[0] == 70 || sig[1] == 87 || sig[2] == 83) {
            this.r = new SwfDecoder(this.swfIn, header.version, 8);
        } else {
            this.handler.error("Invalid signature found.  Not a SWF file");
            throw new FatalParseException();
        }
        header.size = this.decodeRect();
        header.rate = this.r.readUI8() << 8 | this.r.readUI8();
        header.framecount = this.r.readUI16();
        return header;
    }

    private Rect decodeRect() throws IOException {
        this.r.syncBits();
        Rect rect = new Rect();
        int nBits = this.r.readUBits(5);
        rect.xMin = this.r.readSBits(nBits);
        rect.xMax = this.r.readSBits(nBits);
        rect.yMin = this.r.readSBits(nBits);
        rect.yMax = this.r.readSBits(nBits);
        return rect;
    }

    public static class FatalParseException
    extends Exception {
    }
}

