/*
 * Decompiled with CFR 0.152.
 */
package macromedia.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import macromedia.fonts.CachedFontFace;
import macromedia.fonts.CachedFontManager;
import macromedia.fonts.FontFace;
import macromedia.fonts.FontSet;
import macromedia.swf.builder.types.PathIteratorWrapper;
import macromedia.swf.builder.types.ShapeBuilder;
import macromedia.swf.types.GlyphEntry;
import macromedia.swf.types.Rect;
import macromedia.util.Trace;

public class JREFontManager
extends CachedFontManager {
    private static List systemFontNames = null;

    protected FontSet createSetForSystemFont(String family) {
        FontSet fontSet = null;
        if (family != null) {
            if (systemFontNames == null) {
                JREFontManager.initializeSystemFonts();
            }
            if (systemFontNames != null && !systemFontNames.contains(family.trim().toLowerCase())) {
                if (Trace.font) {
                    Trace.trace((String)("Font family '" + family + "' not known to JRE."));
                }
                return null;
            }
            Font font = Font.decode(family + "-PLAIN-240");
            fontSet = new FontSet(this.maxFacesPerFont);
            fontSet.put(font.getStyle(), new JREFontFace(font, (int)this.maxGlyphsPerFace));
        }
        return fontSet;
    }

    /*
     * Loose catch block
     */
    protected String createFontFromLocation(Object location) {
        String family;
        block18: {
            InputStream is;
            block14: {
                family = null;
                is = null;
                if (location == null || !(location instanceof URL)) break block14;
                URL url = (URL)location;
                if (url.getProtocol().toLowerCase().indexOf("file") > -1) {
                    File f = new File(url.getFile());
                    is = new FileInputStream(f);
                } else {
                    is = url.openStream();
                }
                Font font = Font.createFont(0, is);
                font = font.deriveFont(240.0f);
                FontSet fontSet = new FontSet(this.maxFacesPerFont);
                fontSet.put(font.getStyle(), new JREFontFace(font, (int)this.maxGlyphsPerFace));
                family = font.getFamily();
                this.getFontCache().put(family, fontSet);
            }
            Object var9_12 = null;
            try {
                is.close();
            }
            catch (Throwable t) {}
            break block18;
            {
                catch (FileNotFoundException ex) {
                    String font = null;
                    Object var9_13 = null;
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return font;
                }
                catch (FontFormatException ex) {
                    String fontSet = null;
                    Object var9_14 = null;
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return fontSet;
                }
                catch (IOException ex) {
                    String string = null;
                    Object var9_15 = null;
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                try {
                    is.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return family;
    }

    public FontFace getEntryFromLocation(URL location, int style) {
        FontFace entry = null;
        Object value = this.getFontFileCache().get(location);
        if (value != null) {
            String family = value.toString();
            FontSet fontSet = (FontSet)this.getFontCache().get(family);
            if (fontSet != null && (entry = fontSet.get(style)) == null && (entry = fontSet.getAny()) instanceof JREFontFace) {
                Font font = ((JREFontFace)entry).getFont().deriveFont(style, 240.0f);
                entry = fontSet.put(style, new JREFontFace(font, (int)this.maxGlyphsPerFace));
            }
        }
        return entry;
    }

    public FontFace getEntryFromSystem(String familyName, int style) {
        FontFace entry = null;
        FontSet fontSet = (FontSet)this.getFontCache().get(familyName);
        if (fontSet != null && (entry = fontSet.get(style)) == null && (entry = fontSet.getAny()) instanceof JREFontFace) {
            Font font = ((JREFontFace)entry).getFont().deriveFont(style, 240.0f);
            entry = fontSet.put(style, new JREFontFace(font, (int)this.maxGlyphsPerFace));
        }
        return entry;
    }

    public void addFont(Font face) {
        if (face != null) {
            String family = face.getFamily();
            int style = face.getStyle();
            FontSet fontSet = (FontSet)this.getFontCache().get(family);
            if (fontSet == null) {
                fontSet = new FontSet(this.maxFacesPerFont);
                JREFontFace fontFace = new JREFontFace(face, (int)this.maxGlyphsPerFace);
                fontSet.put(style, fontFace);
                this.getFontCache().put(family, fontSet);
            } else {
                FontFace fontFace = fontSet.get(style);
                if (fontFace == null) {
                    fontFace = new JREFontFace(face, (int)this.maxGlyphsPerFace);
                    fontSet.put(style, fontFace);
                }
            }
        }
    }

    private static void initializeSystemFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fnts = ge.getAvailableFontFamilyNames();
        if (fnts != null) {
            systemFontNames = new ArrayList(fnts.length);
            int i = 0;
            while (i < fnts.length) {
                systemFontNames.add(fnts[i].trim().toLowerCase());
                ++i;
            }
        }
    }

    public static class JREFontFace
    extends CachedFontFace {
        private Font font;
        private static Graphics2D graphics;
        private FontRenderContext frc;
        private FontMetrics fontMetrics;
        private int ascent;
        private int descent;
        private int lineGap;
        private double emScale;
        private AffineTransform scaleTransform;

        public JREFontFace(Font font, int maxGlyph) {
            super(maxGlyph, font.getStyle());
            this.font = font;
            this.init();
        }

        private void init() {
            this.emScale = 1024.0 / this.getPointSize();
            this.scaleTransform = new AffineTransform();
            this.scaleTransform.setToScale(this.emScale, this.emScale);
            if (graphics == null) {
                BufferedImage bi = new BufferedImage(50, 50, 1);
                graphics = bi.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.fontMetrics = graphics.getFontMetrics(this.font);
            this.frc = new FontRenderContext(null, true, false);
            this.ascent = (int)Math.rint((double)this.fontMetrics.getAscent() * this.emScale);
            this.descent = (int)Math.rint((double)this.fontMetrics.getDescent() * this.emScale);
            this.lineGap = (int)Math.rint(Math.abs(this.getPointSize() - (double)this.ascent - (double)this.descent));
        }

        public boolean canDisplay(char c) {
            return this.font.canDisplay(c);
        }

        public String getFamily() {
            return this.font.getName();
        }

        public int getFirstChar() {
            return 0;
        }

        public GlyphEntry getGlyphEntry(char c) {
            return (GlyphEntry)this.glyphCache.get(c);
        }

        protected GlyphEntry createGlyphEntry(char c) {
            return this.createGlyphEntry(c, c);
        }

        public GlyphEntry createGlyphEntry(char c, char referenceChar) {
            macromedia.swf.types.Shape swfShape = null;
            Rect bounds = null;
            int advance = 0;
            GlyphVector gv = this.font.createGlyphVector(this.frc, new char[]{referenceChar});
            Shape glyphOutline = gv.getGlyphOutline(0);
            GlyphMetrics metrics = gv.getGlyphMetrics(0);
            advance = (int)Math.rint(metrics.getAdvance());
            Shape scaledShape = this.scaleTransform.createTransformedShape(glyphOutline);
            swfShape = this.createGlyphShape(scaledShape);
            bounds = new Rect();
            GlyphEntry ge = new GlyphEntry();
            ge = new GlyphEntry();
            ge.advance = (int)((double)advance * this.emScale);
            ge.setShape(swfShape);
            ge.bounds = bounds;
            ge.character = c;
            return ge;
        }

        private macromedia.swf.types.Shape createGlyphShape(Shape outline) {
            ShapeBuilder shape = new ShapeBuilder(false);
            shape.setCurrentLineStyle(0);
            shape.setCurrentFillStyle1(1);
            shape.setUseFillStyle1(true);
            shape.processShape(new PathIteratorWrapper(outline.getPathIterator(null)));
            return shape.build();
        }

        public int getAdvance(char c) {
            return 0;
        }

        public Font getFont() {
            return this.font;
        }

        public int getMissingGlyphCode() {
            return this.font.getMissingGlyphCode();
        }

        public double getPointSize() {
            return this.font.getSize2D();
        }

        public FontRenderContext getFontRenderContext() {
            return this.frc;
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return this.descent;
        }

        public int getLineGap() {
            return this.lineGap;
        }

        public int getNumGlyphs() {
            return this.font.getNumGlyphs();
        }

        public boolean isBold() {
            return this.font.isBold();
        }

        public boolean isItalic() {
            return this.font.isItalic();
        }

        public double getEmScale() {
            return this.emScale;
        }
    }
}

