/*
 * Decompiled with CFR 0.152.
 */
package macromedia.fonts;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import macromedia.fonts.CachedFontFace;
import macromedia.fonts.CachedFontManager;
import macromedia.fonts.FontFace;
import macromedia.fonts.FontSet;
import macromedia.swf.builder.types.ShapeBuilder;
import macromedia.swf.builder.types.ShapeIterator;
import macromedia.swf.types.GlyphEntry;
import macromedia.swf.types.Rect;
import macromedia.swf.types.Shape;
import macromedia.util.Trace;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.Glyph;
import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapTable;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;
import org.apache.batik.svggen.font.table.GlyphDescription;
import org.apache.batik.svggen.font.table.HeadTable;
import org.apache.batik.svggen.font.table.HheaTable;
import org.apache.batik.svggen.font.table.HmtxTable;
import org.apache.batik.svggen.font.table.NameTable;
import org.apache.batik.svggen.font.table.Os2Table;

public class BatikFontManager
extends CachedFontManager {
    private String processLocation(Object location) {
        String path = null;
        if (location != null) {
            if (location instanceof URL) {
                URL url = (URL)location;
                if (url.getProtocol().toLowerCase().indexOf("file") > -1) {
                    path = url.getFile();
                }
            } else {
                File f = new File(location.toString());
                if (f.exists()) {
                    path = f.getAbsolutePath();
                }
            }
        }
        return path;
    }

    protected FontSet createSetForSystemFont(String family) {
        if (this.parent != null && this.parent instanceof CachedFontManager) {
            return ((CachedFontManager)this.parent).createSetForSystemFont(family);
        }
        return null;
    }

    public FontFace getEntryFromLocation(URL location, int style) {
        FontFace entry = null;
        Object value = this.getFontFileCache().get(location);
        if (value != null) {
            String family = value.toString();
            FontSet fontSet = (FontSet)this.getFontCache().get(family);
            if (fontSet != null && (entry = fontSet.get(style)) == null) {
                entry = fontSet.getAny();
            }
        }
        return entry;
    }

    protected String createFontFromLocation(Object location) {
        Font font;
        String family = null;
        String path = this.processLocation(location);
        if (path != null && (font = Font.create((String)path)) != null) {
            BatikFontFace fontFace = new BatikFontFace(font, 0, this.maxEntries);
            family = fontFace.getFamily();
            FontSet fontSet = new FontSet(this.maxFacesPerFont);
            fontSet.put(fontFace.style, fontFace);
            this.getFontCache().put(family, fontSet);
        }
        return family;
    }

    public FontFace getEntryFromSystem(String familyName, int style) {
        if (this.parent != null) {
            return this.parent.getEntryFromSystem(familyName, style);
        }
        return null;
    }

    public static class GlyphIterator
    implements ShapeIterator {
        private final double emScale;
        private double[][] segments;
        private int index;

        public GlyphIterator(Glyph glyph, double emScale) {
            this.emScale = emScale;
            if (glyph != null) {
                this.readPoints(glyph);
            } else {
                this.segments = new double[0][];
            }
        }

        private void readPoints(Glyph glyph) {
            int count = glyph.getPointCount();
            int offset = 0;
            boolean newContour = true;
            ArrayList<double[]> aSegments = new ArrayList<double[]>(count);
            Point lastMove = null;
            while (offset < count - 1) {
                double[] segment;
                Point point = glyph.getPoint(offset);
                if (point.endOfContour) {
                    newContour = true;
                    ++offset;
                    continue;
                }
                Point point_plus1 = glyph.getPoint(offset + 1);
                Point point_plus2 = point_plus1.endOfContour ? lastMove : (offset <= count - 3 ? glyph.getPoint(offset + 2) : null);
                if (newContour) {
                    segment = new double[5];
                    segment[0] = (double)point.x * this.emScale;
                    segment[1] = (double)(-point.y) * this.emScale;
                    segment[4] = 0.0;
                    aSegments.add(segment);
                    newContour = false;
                    lastMove = point;
                    continue;
                }
                if (point.onCurve && point_plus1 != null && point_plus1.onCurve) {
                    segment = new double[5];
                    segment[0] = (double)point_plus1.x * this.emScale;
                    segment[1] = (double)(-point_plus1.y) * this.emScale;
                    segment[4] = 1.0;
                    aSegments.add(segment);
                    ++offset;
                    continue;
                }
                if (point.onCurve && !point_plus1.onCurve && point_plus2.onCurve) {
                    segment = new double[]{(double)point_plus1.x * this.emScale, (double)(-point_plus1.y) * this.emScale, (double)point_plus2.x * this.emScale, (double)(-point_plus2.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    if (point_plus1.endOfContour) {
                        ++offset;
                        newContour = true;
                        continue;
                    }
                    offset += 2;
                    continue;
                }
                if (point.onCurve && !point_plus1.onCurve && !point_plus2.onCurve) {
                    segment = new double[]{(double)point_plus1.x * this.emScale, (double)(-point_plus1.y) * this.emScale, GlyphIterator.midPoint(point_plus1.x, point_plus2.x) * this.emScale, -GlyphIterator.midPoint(point_plus1.y, point_plus2.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    if (point_plus1.endOfContour) {
                        ++offset;
                        newContour = true;
                        continue;
                    }
                    offset += 2;
                    continue;
                }
                if (!point.onCurve && !point_plus1.onCurve) {
                    segment = new double[]{(double)point.x * this.emScale, (double)(-point.y) * this.emScale, GlyphIterator.midPoint(point.x, point_plus1.x) * this.emScale, -GlyphIterator.midPoint(point.y, point_plus1.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    ++offset;
                    continue;
                }
                if (!point.onCurve && point_plus1.onCurve) {
                    segment = new double[]{(double)point.x * this.emScale, (double)(-point.y) * this.emScale, (double)point_plus1.x * this.emScale, (double)(-point_plus1.y) * this.emScale, 2.0};
                    aSegments.add(segment);
                    ++offset;
                    continue;
                }
                ++offset;
            }
            this.segments = new double[aSegments.size()][];
            this.segments = (double[][])aSegments.toArray((T[])this.segments);
        }

        private static double midPoint(int a, int b) {
            return (double)a + (double)(b - a) / 2.0;
        }

        public short currentSegment(double[] coords) {
            coords[0] = this.segments[this.index][0];
            coords[1] = this.segments[this.index][1];
            coords[2] = this.segments[this.index][2];
            coords[3] = this.segments[this.index][3];
            return (short)this.segments[this.index][4];
        }

        public boolean isDone() {
            return this.segments == null || this.index >= this.segments.length;
        }

        public void next() {
            ++this.index;
        }
    }

    public static class BatikFontFace
    extends CachedFontFace {
        static final short PLATFORM_APPLE_UNICODE = 0;
        static final short PLATFORM_MACINTOSH = 1;
        static final short PLATFORM_ISO = 2;
        static final short PLATFORM_MICROSOFT = 3;
        static final short ENCODING_UNDEFINED = 0;
        static final short ENCODING_UGL = 1;
        static final short ENCODING_ROMAN = 0;
        private CmapFormat cmapFmt = null;
        private GlyfTable glyf;
        private HmtxTable hmtx;
        private int horizAdvanceX;
        private String fontFamily;
        private short unitsPerEm;
        private String panose;
        private short ascent;
        private short descent;
        private short lineGap;
        private int baseline;
        private boolean forceAscii;
        private double emScale;
        private int numGlyphs;
        private short platformID;
        private short encodingID;
        private int usFirstCharIndex;
        private int usLastCharIndex;
        private int missingGlyphCode = 0;

        public BatikFontFace(Font font, int style, int maxGlyphs) {
            super(maxGlyphs, style);
            this.init(font);
        }

        private void init(Font font) {
            this.numGlyphs = font.getNumGlyphs();
            this.processCmapTable(font);
            this.processNameTable(font);
            this.processHeadTable(font);
            this.processHheaTable(font);
            this.processOS2Table(font);
            this.hmtx = (HmtxTable)font.getTable(1752003704);
            this.glyf = (GlyfTable)font.getTable(1735162214);
            this.emScale = 1024.0 / (double)this.unitsPerEm;
        }

        private void processCmapTable(Font font) {
            CmapTable cmap = font.getCmapTable();
            if (cmap != null) {
                if (this.forceAscii) {
                    this.cmapFmt = cmap.getCmapFormat((short)1, (short)0);
                    this.platformID = 1;
                    this.encodingID = 0;
                } else {
                    this.cmapFmt = cmap.getCmapFormat((short)3, (short)1);
                    if (this.cmapFmt == null) {
                        this.cmapFmt = cmap.getCmapFormat((short)3, (short)0);
                        this.platformID = (short)3;
                        this.encodingID = 0;
                    } else {
                        this.platformID = (short)3;
                        this.encodingID = 1;
                    }
                }
            }
            if (this.cmapFmt == null) {
                throw new RuntimeException("Cannot find a suitable cmap table");
            }
        }

        private void processNameTable(Font font) {
            NameTable name = font.getNameTable();
            if (name != null) {
                this.fontFamily = name.getRecord((short)1);
            } else if (Trace.font) {
                Trace.trace((String)("Font " + this.fontFamily + " did not have a NAME Table."));
            }
        }

        private void processHeadTable(Font font) {
            HeadTable head = font.getHeadTable();
            this.baseline = 0;
            if (head != null) {
                this.unitsPerEm = head.getUnitsPerEm();
                short flags = head.getFlags();
                if ((flags & 1) == 0) {
                    this.baseline = 0;
                }
            } else if (Trace.font) {
                Trace.trace((String)("Font " + this.fontFamily + " did not have an HEAD Table."));
            }
        }

        private void processHheaTable(Font font) {
            HheaTable hhea = font.getHheaTable();
            if (hhea != null) {
                this.ascent = hhea.getAscender();
                this.descent = hhea.getDescender();
                this.lineGap = hhea.getLineGap();
            } else if (Trace.font) {
                Trace.trace((String)("Font " + this.fontFamily + " did not have an HHEA Table."));
            }
        }

        private void processOS2Table(Font font) {
            Os2Table os2 = font.getOS2Table();
            if (os2 != null) {
                if (!this.forceAscii) {
                    int winAscent = os2.getWinAscent();
                    this.ascent = (short)winAscent;
                    int winDescent = os2.getWinDescent();
                    this.descent = (short)winDescent;
                    short winLeading = os2.getTypoLineGap();
                    this.lineGap = winLeading;
                }
                this.horizAdvanceX = os2.getAvgCharWidth();
                this.panose = os2.getPanose().toString();
                this.usFirstCharIndex = os2.getFirstCharIndex();
                this.usLastCharIndex = os2.getLastCharIndex();
            } else if (Trace.font) {
                Trace.trace((String)("Font " + this.fontFamily + " did not have an OS2 Table."));
            }
        }

        public boolean canDisplay(char c) {
            return this.cmapFmt.mapCharCode(this.getCharIndex(c)) > 0;
        }

        public GlyphEntry getGlyphEntry(char c) {
            return (GlyphEntry)this.glyphCache.get(c);
        }

        protected GlyphEntry createGlyphEntry(char c) {
            return this.createGlyphEntry(c, c);
        }

        public GlyphEntry createGlyphEntry(char c, char referenceChar) {
            int index = this.getCharIndex(referenceChar);
            index = this.cmapFmt.mapCharCode(index);
            Glyph glyph = this.getGlyph(index);
            Shape s = this.getShapeFromGlyph(glyph);
            GlyphEntry ge = new GlyphEntry();
            ge.advance = (int)((double)this.getAdvance(referenceChar) * this.emScale);
            ge.character = c;
            ge.setShape(s);
            ge.bounds = new Rect();
            return ge;
        }

        public int getFirstChar() {
            if (this.platformID == 3 && this.encodingID == 0) {
                return this.usFirstCharIndex - 61440;
            }
            return this.usFirstCharIndex;
        }

        private int getCharIndex(char index) {
            if (this.platformID == 3 && this.encodingID == 0) {
                index = (char)(index + (this.usFirstCharIndex - (this.usFirstCharIndex - 61440)));
            }
            return index;
        }

        private Glyph getGlyph(int index) {
            Glyph glyph = null;
            GlyfDescript desc = this.glyf.getDescription(index);
            if (desc != null) {
                glyph = new Glyph((GlyphDescription)this.glyf.getDescription(index), this.hmtx.getLeftSideBearing(index), this.hmtx.getAdvanceWidth(index));
            }
            return glyph;
        }

        private Shape getShapeFromGlyph(Glyph glyph) {
            ShapeBuilder shape = new ShapeBuilder(false);
            shape.setCurrentLineStyle(0);
            shape.setCurrentFillStyle1(1);
            shape.setUseFillStyle1(true);
            shape.processShape(new GlyphIterator(glyph, this.emScale));
            return shape.build();
        }

        public int getAdvance(char c) {
            if (this.hmtx != null) {
                int index = this.getCharIndex(c);
                index = this.cmapFmt.mapCharCode(index);
                return this.hmtx.getAdvanceWidth(index);
            }
            return this.horizAdvanceX;
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return this.descent;
        }

        public String getFamily() {
            return this.fontFamily;
        }

        public int getLineGap() {
            return this.lineGap;
        }

        public int getMissingGlyphCode() {
            return this.missingGlyphCode;
        }

        public int getNumGlyphs() {
            return this.numGlyphs;
        }

        public double getPointSize() {
            return 1.0;
        }

        public boolean isBold() {
            return this.style == 1 || this.style == 3;
        }

        public boolean isItalic() {
            return this.style == 2 || this.style == 3;
        }

        public String getPanose() {
            return this.panose;
        }

        public short getUnitsPerEm() {
            return this.unitsPerEm;
        }

        public double getEmScale() {
            return this.emScale;
        }
    }
}

