/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.lucene;

import coldfusion.orm.search.ORMSearchException;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RB;
import java.util.Hashtable;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;

public class AnalyzerProvider {
    private static Map<String, String> LUCENE_LANGUAGES = new CaseInsensitiveMap();
    private static Map<String, Analyzer> Lucene_AnalyzerMap = new Hashtable<String, Analyzer>();

    public static Analyzer getAnalyzer(String language) {
        Analyzer analyzer;
        if (LUCENE_LANGUAGES.containsKey(language)) {
            String caseSensetiveLanguageStr = LUCENE_LANGUAGES.get(language);
            analyzer = Lucene_AnalyzerMap.get(caseSensetiveLanguageStr);
            if (analyzer == null) {
                analyzer = AnalyzerProvider.getLuceneBasedAnalyer(caseSensetiveLanguageStr);
                Lucene_AnalyzerMap.put(caseSensetiveLanguageStr, analyzer);
            }
        } else {
            throw new ORMSearchException(RB.getString(AnalyzerProvider.class, (String)"UnsupportedLanguage", (Object)language));
        }
        return analyzer;
    }

    private static Analyzer getLuceneBasedAnalyer(String language) {
        DanishAnalyzer analyzer = null;
        if (language.equals("Danish")) {
            analyzer = new DanishAnalyzer();
        } else if (language.equals("Dutch")) {
            analyzer = new DutchAnalyzer();
        } else if (language.equals("English")) {
            analyzer = new EnglishAnalyzer();
        } else if (language.equals("Finnish")) {
            analyzer = new FinnishAnalyzer();
        } else if (language.equals("French")) {
            analyzer = new FrenchAnalyzer();
        } else if (language.equals("German2")) {
            analyzer = new GermanAnalyzer();
        } else if (language.equals("Hungarian")) {
            analyzer = new HungarianAnalyzer();
        } else if (language.equals("Italian")) {
            analyzer = new ItalianAnalyzer();
        } else if (language.equals("Norwegian")) {
            analyzer = new NorwegianAnalyzer();
        } else if (language.equals("Portuguese")) {
            analyzer = new PortugueseAnalyzer();
        } else if (language.equals("Romanian")) {
            analyzer = new RomanianAnalyzer();
        } else if (language.equals("Russian")) {
            analyzer = new RussianAnalyzer();
        } else if (language.equals("Spanish")) {
            analyzer = new SpanishAnalyzer();
        } else if (language.equals("Swedish")) {
            analyzer = new SwedishAnalyzer();
        } else if (language.equals("Turkish")) {
            analyzer = new TurkishAnalyzer();
        } else if (language.equals("Arabic")) {
            analyzer = new ArabicAnalyzer();
        } else if (language.equals("Brazilian")) {
            analyzer = new BrazilianAnalyzer();
        } else if (language.equals("Chinese")) {
            analyzer = new SmartChineseAnalyzer();
        } else if (language.equals("CJK")) {
            analyzer = new CJKAnalyzer();
        } else if (language.equals("Czech")) {
            analyzer = new CzechAnalyzer();
        } else if (language.equals("Greek")) {
            analyzer = new GreekAnalyzer();
        } else if (language.equals("Persian")) {
            analyzer = new PersianAnalyzer();
        } else if (language.equals("Thai")) {
            analyzer = new ThaiAnalyzer();
        }
        return analyzer;
    }

    static {
        LUCENE_LANGUAGES.put("Danish", "Danish");
        LUCENE_LANGUAGES.put("Dutch", "Dutch");
        LUCENE_LANGUAGES.put("English", "English");
        LUCENE_LANGUAGES.put("Finnish", "Finnish");
        LUCENE_LANGUAGES.put("French", "French");
        LUCENE_LANGUAGES.put("German2", "German2");
        LUCENE_LANGUAGES.put("Hungarian", "Hungarian");
        LUCENE_LANGUAGES.put("Italian", "Italian");
        LUCENE_LANGUAGES.put("Norwegian", "Norwegian");
        LUCENE_LANGUAGES.put("Portuguese", "Portuguese");
        LUCENE_LANGUAGES.put("Romanian", "Romanian");
        LUCENE_LANGUAGES.put("Russian", "Russian");
        LUCENE_LANGUAGES.put("Spanish", "Spanish");
        LUCENE_LANGUAGES.put("Swedish", "Swedish");
        LUCENE_LANGUAGES.put("Turkish", "Turkish");
        LUCENE_LANGUAGES.put("Arabic", "Arabic");
        LUCENE_LANGUAGES.put("Brazilian", "Brazilian");
        LUCENE_LANGUAGES.put("Chinese", "Chinese");
        LUCENE_LANGUAGES.put("CJK", "CJK");
        LUCENE_LANGUAGES.put("Czech", "Czech");
        LUCENE_LANGUAGES.put("Greek", "Greek");
        LUCENE_LANGUAGES.put("Persian", "Persian");
        LUCENE_LANGUAGES.put("Thai", "Thai");
    }
}

