/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.core;

import coldfusion.orm.search.ORMSearchException;
import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.ORMSearchSettings;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.IndexableField;
import coldfusion.orm.search.lucene.AnalyzerProvider;
import coldfusion.orm.search.lucene.FSDirectoryProvider;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class EntityWorkSpace {
    private static final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private final String entityName;
    private FSDirectoryProvider dirProvider;
    private IndexWriter indexWriter;
    private DirectoryReader indexReader;
    private Analyzer analyzer;
    private PerFieldAnalyzerWrapper FieldSpecificAnalyzer;

    public EntityWorkSpace(String entityName) {
        this.entityName = entityName;
        CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(entityName);
        String analyzerLanguage = smd.getLanguage();
        ORMSearchSettings searchSetting = ORMSearchManager.getCurrentSearchFactory().getSearchSettings();
        this.analyzer = AnalyzerProvider.getAnalyzer(analyzerLanguage);
        this.dirProvider = new FSDirectoryProvider();
        this.dirProvider.initialize(searchSetting.getIndexBaseDir(), entityName);
        HashMap<String, Analyzer> analyzerPerField = new HashMap<String, Analyzer>();
        for (IndexableField indexableField : smd.getIndexableFields()) {
            if (indexableField.isIndextokenize()) continue;
            analyzerPerField.put(indexableField.getIndexFieldName(), keywordAnalyzer);
        }
        this.FieldSpecificAnalyzer = new PerFieldAnalyzerWrapper(this.analyzer, analyzerPerField);
    }

    public PerFieldAnalyzerWrapper getFieldSpecificAnalyzer() {
        return this.FieldSpecificAnalyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public IndexWriter getIndexWriter() {
        if (this.indexWriter == null) {
            this.indexWriter = this._getIndexWriter();
        }
        return this.indexWriter;
    }

    private IndexWriter _getIndexWriter() {
        if (System.getSecurityManager() == null) {
            try {
                return new IndexWriter((Directory)this.dirProvider.getDirectory(), new IndexWriterConfig(this.analyzer));
            }
            catch (IOException e) {
                throw new ORMSearchException(RB.getString((Object)this, (String)"writerInitializationFailed", (Object)this.entityName), e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<IndexWriter>(){

                @Override
                public IndexWriter run() throws IOException {
                    return new IndexWriter((Directory)EntityWorkSpace.this.dirProvider.getDirectory(), new IndexWriterConfig(EntityWorkSpace.this.analyzer));
                }
            }, null, ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getWebInfClassesReadPermission());
        }
        catch (PrivilegedActionException e) {
            Exception exception = e.getException();
            throw new ORMSearchException(RB.getString((Object)this, (String)"writerInitializationFailed", (Object)this.entityName), exception);
        }
    }

    public void closeIndexWriter() {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
        }
        catch (IOException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"writerClosingFailed", (Object)this.entityName), e);
        }
    }

    public void closeIndexReader() {
        try {
            if (this.indexReader != null) {
                this.indexReader.close();
                this.indexReader = null;
            }
        }
        catch (IOException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"readerClosingFailed", (Object)this.entityName), e);
        }
    }

    public void commit() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"writerCommitFailed", (Object)this.entityName), e);
        }
    }

    public void flushWriter() {
        this.commit();
    }

    public IndexReader getIndexReader() {
        if (this.indexReader == null) {
            try {
                this.indexReader = DirectoryReader.open((Directory)this.dirProvider.getDirectory());
            }
            catch (IOException e) {
                throw new ORMSearchException(RB.getString((Object)this, (String)"readerInitializationFailed", (Object)this.entityName), e);
            }
        }
        try {
            boolean isCurrent = this.indexReader.isCurrent();
            if (!isCurrent) {
                this.indexReader = DirectoryReader.open((Directory)this.dirProvider.getDirectory());
            }
        }
        catch (IOException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"readerRefreshFailed", (Object)this.entityName), e);
        }
        return this.indexReader;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public CFCSearchMetadata getSearchMetadata() {
        return ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(this.entityName);
    }

    public void close() {
        this.closeIndexWriter();
        this.closeIndexReader();
    }
}

