/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling.mod;

import coldfusion.cfc.CFCProxy;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.scheduling.mod.CronUtil;
import coldfusion.scheduling.mod.ScheduleTagData;
import coldfusion.xml.rpc.CFCServlet;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class CronListener
implements JobListener,
TriggerListener {
    private String name = "";

    public CronListener(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + "_listener";
    }

    public void jobExecutionVetoed(JobExecutionContext arg0) {
    }

    public void jobToBeExecuted(JobExecutionContext ctx) {
    }

    public void triggerComplete(Trigger arg0, JobExecutionContext arg1, int arg2) {
    }

    public void triggerFired(Trigger arg0, JobExecutionContext arg1) {
    }

    public void triggerMisfired(Trigger trig) {
        ScheduleTagData metadata = (ScheduleTagData)((Object)trig.getJobDataMap().get((Object)"metadata"));
        if (null == metadata) {
            return;
        }
        if (metadata.shouldNotMisfire) {
            metadata.shouldNotMisfire = false;
            return;
        }
        CFLogs.SCHEDULER_LOG.info((Object)("Task " + metadata.getGroup() + "." + metadata.getTask() + " misfired."));
        String cfclistener = metadata.getEventhandler();
        Struct struct = new Struct();
        struct.put((Object)"task", (Object)metadata.getTask());
        struct.put((Object)"group", (Object)metadata.getGroup());
        struct.put((Object)"mode", (Object)metadata.getMode());
        struct.put((Object)"lastfiretime", (Object)trig.getPreviousFireTime());
        String misfire = metadata.getMisfire();
        if ("invokehandler".equalsIgnoreCase(misfire)) {
            this.invokeMethod(cfclistener, struct, "onmisfire", null);
        }
    }

    public boolean vetoJobExecution(Trigger arg0, JobExecutionContext ctx) {
        Struct struct;
        ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
        String cfclistener = metadata.getEventhandler();
        Object o = this.invokeMethod(cfclistener, struct = this.getInitialStruct(ctx), "ontaskstart", ctx);
        if (null == o) {
            return false;
        }
        boolean result = Cast._boolean((Object)(null == o ? Boolean.valueOf(false) : o));
        boolean veto = !result;
        return veto;
    }

    private Struct getInitialStruct(JobExecutionContext ctx) {
        ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
        Struct struct = new Struct();
        struct.put((Object)"task", (Object)metadata.getTask());
        struct.put((Object)"group", (Object)metadata.getGroupName());
        struct.put((Object)"mode", (Object)metadata.getMode());
        struct.put((Object)"fireinstanceid", (Object)ctx.getFireInstanceId());
        return struct;
    }

    private Object invokeMethod(String cfclistener, Struct struct, String method, JobExecutionContext ctx) {
        if (CronUtil.stringNullCheck(cfclistener)) {
            return null;
        }
        Object result = null;
        try {
            CFCProxy proxy = this.getCFCProxy(cfclistener, ctx);
            if (null != proxy) {
                proxy.setSchedulerEvent(true);
                result = proxy.invoke(method, new Object[]{struct});
            }
        }
        catch (Throwable ex) {
            CFLogs.SCHEDULER_LOG.error(ex);
        }
        return result;
    }

    private CFCProxy getCFCProxy(String cfclistener, JobExecutionContext ctx) {
        CFCProxy proxy = null;
        try {
            ScheduleTagData metadata = null;
            if (null != ctx) {
                metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
                proxy = metadata.getCfcProxy();
            }
            proxy = new CFCProxy(cfclistener, false);
        }
        catch (Throwable ex) {
            if (CFCServlet.getCFCServlet() == null) {
                try {
                    for (int retrycount = 0; CFCServlet.getCFCServlet() == null && retrycount < 5; ++retrycount) {
                        Thread.sleep(1000L);
                    }
                    proxy = new CFCProxy(cfclistener, false);
                }
                catch (Throwable ie) {
                    CFLogs.SCHEDULER_LOG.error(ie);
                }
            }
            CFLogs.SCHEDULER_LOG.error(ex);
        }
        return proxy;
    }

    public void jobWasExecuted(JobExecutionContext ctx, JobExecutionException exc) {
    }

    public void triggerComplete(Trigger arg0, JobExecutionContext arg1, Trigger.CompletedExecutionInstruction arg2) {
    }
}

