/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.im;

import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.im.IMGateway;
import coldfusion.eventgateway.im.XMPPGateway;
import coldfusion.runtime.Array;
import coldfusion.util.FastHashtable;
import com.zion.jbuddy.IBuddy;
import com.zion.jbuddy.IBuddyList;
import java.util.Date;
import java.util.Enumeration;

public abstract class IMGatewayHelper
implements GatewayHelper {
    private static FastHashtable permitmode = new FastHashtable(12);
    private static FastHashtable textmode = new FastHashtable(4);
    private static FastHashtable statusmode = new FastHashtable(18);
    private static FastHashtable protocolnames = new FastHashtable(6);
    private static FastHashtable listtypes = new FastHashtable(3);
    private IMGateway gateway = null;

    public IMGatewayHelper(IMGateway gateway) {
        this.gateway = gateway;
    }

    public boolean addBuddy(String username, String nickname, String group) {
        boolean result = this.gateway.addBuddy(username, nickname, group);
        if (this.gateway instanceof XMPPGateway) {
            ((XMPPGateway)this.gateway).sendConfigToServer();
        }
        return result;
    }

    public boolean addDeny(String username, String nickname, String group) {
        boolean result = this.gateway.addDeny(username, nickname, group);
        if (this.gateway instanceof XMPPGateway) {
            ((XMPPGateway)this.gateway).sendConfigToServer();
        }
        return result;
    }

    public boolean addPermit(String username, String nickname, String group) {
        boolean result = this.gateway.addPermit(username, nickname, group);
        if (this.gateway instanceof XMPPGateway) {
            ((XMPPGateway)this.gateway).sendConfigToServer();
        }
        return result;
    }

    public Array getBuddyList() {
        IBuddyList bl = this.gateway.getBuddyList();
        int total = bl.getTotalNumberOfBuddiesInList();
        Array buddylist = new Array();
        if (total > 0) {
            Enumeration groups = bl.getListOfGroups();
            while (groups.hasMoreElements()) {
                Enumeration buddies = bl.getBuddiesInGroup((String)groups.nextElement());
                while (buddies.hasMoreElements()) {
                    String buddyname = ((IBuddy)buddies.nextElement()).getName();
                    if (buddylist.contains((Object)buddyname)) continue;
                    buddylist.add((Object)buddyname);
                }
            }
        }
        return buddylist;
    }

    public String getCustomAwayMessage() {
        return this.gateway.getCustomAwayMessage();
    }

    public Array getDenyList() {
        IBuddyList bl = this.gateway.getDenyList();
        int total = bl.getTotalNumberOfBuddiesInList();
        Array denylist = new Array();
        if (total > 0) {
            Enumeration groups = bl.getListOfGroups();
            while (groups.hasMoreElements()) {
                Enumeration denybuddies = bl.getBuddiesInGroup((String)groups.nextElement());
                while (denybuddies.hasMoreElements()) {
                    String buddyname = ((IBuddy)denybuddies.nextElement()).getName();
                    if (denylist.contains((Object)buddyname)) continue;
                    denylist.add((Object)buddyname);
                }
            }
        }
        return denylist;
    }

    public String getName() {
        return this.gateway.getName();
    }

    public String getNickName() {
        return this.gateway.getNickName();
    }

    public Array getPermitList() {
        IBuddyList bl = this.gateway.getPermitList();
        int total = bl.getTotalNumberOfBuddiesInList();
        Array permitlist = new Array();
        if (total > 0) {
            Enumeration groups = bl.getListOfGroups();
            while (groups.hasMoreElements()) {
                Enumeration permitbuddies = bl.getBuddiesInGroup((String)groups.nextElement());
                while (permitbuddies.hasMoreElements()) {
                    String buddyname = ((IBuddy)permitbuddies.nextElement()).getName();
                    if (permitlist.contains((Object)buddyname)) continue;
                    permitlist.add((Object)buddyname);
                }
            }
        }
        return permitlist;
    }

    public String getPermitMode() {
        int mode = this.gateway.getPermitMode();
        String str_mode = (String)permitmode.get((Object)new Integer(mode));
        return str_mode;
    }

    public String getPlainTextMode() {
        int mode = this.gateway.getPlainTextMode();
        String str_mode = (String)textmode.get((Object)new Integer(mode));
        return str_mode;
    }

    public String getProtocolName() {
        return this.gateway.getProtocolName();
    }

    public Date getSignOnTimeStamp() {
        return this.gateway.getSignOnTimeStamp();
    }

    public String getStatusAsString() {
        return this.gateway.getStatusAsString();
    }

    public Date getStatusTimeStamp() {
        return this.gateway.getStatusTimeStamp();
    }

    public boolean isOnline() {
        return this.gateway.isOnline();
    }

    public int numberOfMessagesReceived() {
        return this.gateway.numberOfMessagesReceived();
    }

    public int numberOfMessagesSent() {
        return this.gateway.numberOfMessagesSent();
    }

    public boolean removeBuddy(String name, String group) {
        boolean result = this.gateway.removeBuddy(name, group);
        if (this.gateway instanceof XMPPGateway) {
            ((XMPPGateway)this.gateway).sendConfigToServer();
        }
        return result;
    }

    public boolean removeDeny(String name, String group) {
        boolean result = this.gateway.removeDeny(name, group);
        if (this.gateway instanceof XMPPGateway) {
            ((XMPPGateway)this.gateway).sendConfigToServer();
        }
        return result;
    }

    public boolean removePermit(String name, String group) {
        boolean result = this.gateway.removePermit(name, group);
        if (this.gateway instanceof XMPPGateway) {
            ((XMPPGateway)this.gateway).sendConfigToServer();
        }
        return result;
    }

    public boolean setNickName(String nickName) {
        return this.gateway.setNickName(nickName);
    }

    public boolean setPermitMode(String permitLevel) {
        int mode = (Integer)permitmode.get((Object)permitLevel.toUpperCase());
        return this.gateway.setPermitMode(mode);
    }

    public int setPlainTextMode(String textLevel) {
        int mode = (Integer)textmode.get((Object)textLevel.toUpperCase());
        return this.gateway.setPlainTextMode(mode);
    }

    public boolean setStatus(String newStatus, String customAwayMessage) {
        int status = (Integer)statusmode.get((Object)newStatus.toUpperCase());
        return this.gateway.setStatus(status, customAwayMessage);
    }

    public Array getBuddyInfo(String buddyname) {
        Array infolist = new Array();
        Array lists = new Array();
        lists.add((Object)this.gateway.getBuddyList());
        lists.add((Object)this.gateway.getDenyList());
        lists.add((Object)this.gateway.getPermitList());
        for (IBuddyList buddylist : lists) {
            Enumeration groups = buddylist.getAllGroupsForBuddy(buddyname);
            while (groups.hasMoreElements()) {
                String group = (String)groups.nextElement();
                IBuddy buddy = buddylist.getBuddyInGroup(group, buddyname);
                String nick = buddy.getNickName();
                String status = buddy.getStatusAsString();
                String protocol = (String)protocolnames.get((Object)new Integer(buddy.getProtocol()));
                Date signon = buddy.getSignOnTimeStamp();
                Integer idletime = new Integer(buddy.getIdleTime());
                Date statustime = buddy.getStatusTimeStamp();
                Integer warning = new Integer(buddy.getWarningPercent());
                Boolean isMobile = new Boolean(buddy.isMobile());
                String customAwayMessage = buddy.getCustomAwayMessage();
                String owner = buddy.getOwner();
                String listtype = (String)listtypes.get((Object)new Integer(buddylist.getListType()));
                FastHashtable info = new FastHashtable(3);
                info.put((Object)"BUDDYNAME", (Object)buddyname);
                info.put((Object)"BUDDYGROUP", (Object)group);
                if (nick == null) {
                    info.put((Object)"BUDDYNICKNAME", (Object)"");
                } else {
                    info.put((Object)"BUDDYNICKNAME", (Object)nick);
                }
                if (status == null) {
                    info.put((Object)"BUDDYSTATUS", (Object)"");
                } else {
                    info.put((Object)"BUDDYSTATUS", (Object)status);
                }
                if (protocol == null) {
                    info.put((Object)"BUDDYPROTOCOL", (Object)"");
                } else {
                    info.put((Object)"BUDDYPROTOCOL", (Object)protocol);
                }
                if (signon == null) {
                    info.put((Object)"BUDDYSIGNONTIME", (Object)"");
                } else {
                    info.put((Object)"BUDDYSIGNONTIME", (Object)signon);
                }
                if (statustime == null) {
                    info.put((Object)"BUDDYSTATUSTIME", (Object)"");
                } else {
                    info.put((Object)"BUDDYSTATUSTIME", (Object)statustime);
                }
                if (customAwayMessage == null) {
                    info.put((Object)"BUDDYCUSTOMAWAYMESSAGE", (Object)"");
                } else {
                    info.put((Object)"BUDDYCUSTOMAWAYMESSAGE", (Object)customAwayMessage);
                }
                if (owner == null) {
                    info.put((Object)"BUDDYOWNER", (Object)"");
                } else {
                    info.put((Object)"BUDDYOWNER", (Object)owner);
                }
                if (listtype == null) {
                    info.put((Object)"BUDDYLISTTYPE", (Object)"");
                } else {
                    info.put((Object)"BUDDYLISTTYPE", (Object)listtype);
                }
                info.put((Object)"BUDDYIDLETIME", (Object)idletime);
                info.put((Object)"BUDDYISMOBLE", (Object)isMobile);
                info.put((Object)"BUDDYWARNINGPERCENT", (Object)warning);
                infolist.add((Object)info);
            }
        }
        return infolist;
    }

    static {
        permitmode.put((Object)new Integer(1), (Object)"PERMIT_ALL");
        permitmode.put((Object)new Integer(0), (Object)"DENY_ALL");
        permitmode.put((Object)new Integer(2), (Object)"PERMIT_SOME");
        permitmode.put((Object)new Integer(3), (Object)"DENY_SOME");
        permitmode.put((Object)new Integer(4), (Object)"IGNORE_IN_LIST");
        permitmode.put((Object)new Integer(5), (Object)"IGNORE_NOT_IN_LIST");
        permitmode.put((Object)"PERMIT_ALL", (Object)new Integer(1));
        permitmode.put((Object)"DENY_ALL", (Object)new Integer(0));
        permitmode.put((Object)"PERMIT_SOME", (Object)new Integer(2));
        permitmode.put((Object)"DENY_SOME", (Object)new Integer(3));
        permitmode.put((Object)"IGNORE_IN_LIST", (Object)new Integer(4));
        permitmode.put((Object)"IGNORE_NOT_IN_LIST", (Object)new Integer(5));
        textmode.put((Object)new Integer(0), (Object)"PLAIN_TEXT");
        textmode.put((Object)new Integer(1), (Object)"RICH_TEXT");
        textmode.put((Object)"PLAIN_TEXT", (Object)new Integer(0));
        textmode.put((Object)"RICH_TEXT", (Object)new Integer(1));
        statusmode.put((Object)"ONLINE", (Object)new Integer(1));
        statusmode.put((Object)"OFFLINE", (Object)new Integer(0));
        statusmode.put((Object)"AWAY", (Object)new Integer(2));
        statusmode.put((Object)"DND", (Object)new Integer(14));
        statusmode.put((Object)"IDLE", (Object)new Integer(3));
        statusmode.put((Object)"INVISIBLE", (Object)new Integer(15));
        statusmode.put((Object)"NA", (Object)new Integer(16));
        statusmode.put((Object)"OCCUPIED", (Object)new Integer(17));
        statusmode.put((Object)"FREE_TO_CHAT", (Object)new Integer(18));
        statusmode.put((Object)"ONPHONE", (Object)new Integer(5));
        statusmode.put((Object)"ATLUNCH", (Object)new Integer(6));
        statusmode.put((Object)"BUSY", (Object)new Integer(7));
        statusmode.put((Object)"NOT_AT_HOME", (Object)new Integer(8));
        statusmode.put((Object)"NOT_AT_DESK", (Object)new Integer(9));
        statusmode.put((Object)"NOT_IN_OFFICE", (Object)new Integer(10));
        statusmode.put((Object)"ON_VACATION", (Object)new Integer(11));
        statusmode.put((Object)"STEPPED_OUT", (Object)new Integer(12));
        statusmode.put((Object)"CUSTOM_AWAY", (Object)new Integer(13));
        protocolnames.put((Object)new Integer(10), (Object)"AIM");
        protocolnames.put((Object)new Integer(20), (Object)"ICQ");
        protocolnames.put((Object)new Integer(30), (Object)"MSN");
        protocolnames.put((Object)new Integer(99), (Object)"JSC");
        protocolnames.put((Object)new Integer(50), (Object)"JABBER");
        protocolnames.put((Object)new Integer(60), (Object)"SAMETIME");
        listtypes.put((Object)new Integer(1), (Object)"BUDDY_LIST");
        listtypes.put((Object)new Integer(3), (Object)"DENY_LIST");
        listtypes.put((Object)new Integer(2), (Object)"PERMIT_LIST");
        listtypes.put((Object)new Integer(4), (Object)"REVERSE_LIST");
    }
}

