/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.storage;

import com.lotus.sametime.core.types.STAttribute;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class StorageRequest {
    public Integer m_requestId;
    public short m_type;
    public Vector m_data;
    protected static int NOT_HANDLED = -1;
    public int m_rc = NOT_HANDLED;
    public Vector m_response;
    public long m_issueTime;
    STUser m_stUser;

    public StorageRequest(Integer n, short s, Vector vector, STUser sTUser) {
        this.m_requestId = n;
        this.m_type = s;
        this.m_data = vector;
        this.m_issueTime = System.currentTimeMillis();
        this.m_stUser = sTUser;
    }

    public void writeToStream(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeInt(this.m_requestId);
        if (null != this.m_stUser) {
            this.m_stUser.getId().dump(ndrOutputStream);
        }
        ndrOutputStream.writeInt(this.m_data.size());
        Enumeration enumeration = this.m_data.elements();
        if (this.m_data.firstElement() instanceof Integer) {
            while (enumeration.hasMoreElements()) {
                int n = (Integer)enumeration.nextElement();
                ndrOutputStream.writeInt(n);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                ((STAttribute)enumeration.nextElement()).dump(ndrOutputStream, true);
            }
        }
    }

    public void readResponse(NdrInputStream ndrInputStream) throws IOException {
        this.m_rc = ndrInputStream.readInt();
        switch (this.m_type) {
            case 4: {
                this.readGetResponse(ndrInputStream);
                break;
            }
            case 6: {
                break;
            }
            default: {
                System.err.println(this + "Unknown type." + "can not read data from input stream");
            }
        }
    }

    private void readGetResponse(NdrInputStream ndrInputStream) throws IOException {
        int n = ndrInputStream.readInt();
        if (n > 0) {
            Vector<STAttribute> vector = new Vector<STAttribute>();
            for (int i = 0; i < n; ++i) {
                STAttribute sTAttribute = new STAttribute(ndrInputStream);
                vector.addElement(sTAttribute);
            }
            this.m_response = vector;
        }
    }

    private void readResponseList(NdrInputStream ndrInputStream) throws IOException {
        int n = ndrInputStream.readInt();
        if (n > 0) {
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < n; ++i) {
                int n2 = ndrInputStream.readInt();
                vector.addElement(new Integer(n2));
            }
            this.m_response = vector;
        }
    }
}

