/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceMember;
import com.lotus.sametime.places.PlaceMemberAdapter;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlaceMemberImpl;
import com.lotus.sametime.places.PlaceMemberListener;
import com.lotus.sametime.places.PlacesEvent;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.UserInPlaceListener;
import java.util.Enumeration;
import java.util.Vector;

public class UserInPlace
extends STUserInstance
implements PlaceMember {
    public static final int USER_VERSION_UNKNOWN = 0;
    public static final int USER_VERSION_EXTERNAL = 1;
    public static final int USER_VERSION_15 = 2;
    public static final int USER_VERSION_WATSON = 4;
    protected PlaceMemberImpl m_impl;
    protected Place m_place;
    protected Section m_section;
    protected int m_userVersion;
    protected Vector m_usersListeners = new Vector();

    protected UserInPlace(STSession sTSession, Integer n, Place place, Section section, STId sTId, String string, STLoginId sTLoginId, short s, int n2) {
        super(sTLoginId, s, sTId, string, "", null, new STServer(new STId("", ""), "", ""));
        this.m_place = place;
        this.m_section = section;
        this.m_userVersion = n2;
        this.m_impl = new PlaceMemberImpl(sTSession, place.getPlaceId(), n);
        this.addPlaceMemberListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserInPlaceListener(UserInPlaceListener userInPlaceListener) {
        UserInPlace userInPlace = this;
        synchronized (userInPlace) {
            Vector vector = (Vector)this.m_usersListeners.clone();
            vector.addElement(userInPlaceListener);
            this.m_usersListeners = vector;
        }
        this.m_impl.sendEvent(new PlaceMemberEvent(this, 8, userInPlaceListener));
    }

    public synchronized void removeUserInPlaceListener(UserInPlaceListener userInPlaceListener) {
        Vector vector = (Vector)this.m_usersListeners.clone();
        vector.removeElement(userInPlaceListener);
        this.m_usersListeners = vector;
    }

    public void sendText(String string) {
        this.m_impl.sendText(string);
    }

    public void sendData(int n, byte[] byArray) {
        this.m_impl.sendData(n, byArray);
    }

    public void queryAttrContent(int n) {
        this.m_impl.queryAttrContent(n);
    }

    public void changeAttribute(STExtendedAttribute sTExtendedAttribute) {
        this.m_impl.changeAttribute(sTExtendedAttribute);
    }

    public void removeAttribute(int n) {
        this.m_impl.removeAttribute(n);
    }

    public int getUserVersion() {
        return this.m_userVersion;
    }

    public Section getSection() {
        return this.m_section;
    }

    public Integer getMemberId() {
        return this.m_impl.getMemberId();
    }

    public Place getPlace() {
        return this.m_place;
    }

    public Enumeration getAttributes() {
        return this.m_impl.getAttributes();
    }

    public void processPlacesEvent(PlacesEvent placesEvent) {
        if (placesEvent instanceof PlaceMemberEvent) {
            PlaceMemberEvent placeMemberEvent = (PlaceMemberEvent)placesEvent;
            if (placesEvent.getId() == -2147483638) {
                this.sendSnapshot(placeMemberEvent.getListener());
            } else {
                this.m_impl.processPlaceMemberEvent(placeMemberEvent);
            }
        }
    }

    protected void sendSnapshot(PlaceMemberListener placeMemberListener) {
        Enumeration enumeration = this.m_impl.getAttributes();
        while (enumeration.hasMoreElements()) {
            STExtendedAttribute sTExtendedAttribute = (STExtendedAttribute)enumeration.nextElement();
            PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)this, -2147483647, sTExtendedAttribute);
            placeMemberListener.attributeChanged(placeMemberEvent);
        }
    }

    protected void sendFailed(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        Vector vector = this.m_usersListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlaceListener userInPlaceListener = (UserInPlaceListener)enumeration.nextElement();
            userInPlaceListener.sendFailed(placeMemberEvent);
        }
    }

    protected void attributeChanged(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        Vector vector = this.m_usersListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlaceListener userInPlaceListener = (UserInPlaceListener)enumeration.nextElement();
            userInPlaceListener.attributeChanged(placeMemberEvent);
        }
    }

    protected void attributeRemoved(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        Vector vector = this.m_usersListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlaceListener userInPlaceListener = (UserInPlaceListener)enumeration.nextElement();
            userInPlaceListener.attributeRemoved(placeMemberEvent);
        }
    }

    protected void changeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        Vector vector = this.m_usersListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlaceListener userInPlaceListener = (UserInPlaceListener)enumeration.nextElement();
            userInPlaceListener.changeAttributeFailed(placeMemberEvent);
        }
    }

    protected void removeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        Vector vector = this.m_usersListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlaceListener userInPlaceListener = (UserInPlaceListener)enumeration.nextElement();
            userInPlaceListener.removeAttributeFailed(placeMemberEvent);
        }
    }

    protected void queryAttrContentFailed(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        Vector vector = this.m_usersListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserInPlaceListener userInPlaceListener = (UserInPlaceListener)enumeration.nextElement();
            userInPlaceListener.queryAttrContentFailed(placeMemberEvent);
        }
    }

    private void addPlaceMemberListener() {
        this.m_impl.addPlaceMemberListener(new PlaceMemberAdapter(){

            public void sendFailed(PlaceMemberEvent placeMemberEvent) {
                UserInPlace.this.sendFailed(placeMemberEvent);
            }

            public void attributeChanged(PlaceMemberEvent placeMemberEvent) {
                UserInPlace.this.attributeChanged(placeMemberEvent);
            }

            public void attributeRemoved(PlaceMemberEvent placeMemberEvent) {
                UserInPlace.this.attributeRemoved(placeMemberEvent);
            }

            public void changeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
                UserInPlace.this.changeAttributeFailed(placeMemberEvent);
            }

            public void removeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
                UserInPlace.this.removeAttributeFailed(placeMemberEvent);
            }

            public void queryAttrContentFailed(PlaceMemberEvent placeMemberEvent) {
                UserInPlace.this.queryAttrContentFailed(placeMemberEvent);
            }
        });
    }
}

