/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlacesImpl;
import com.lotus.sametime.places.PlacesService;
import com.lotus.sametime.places.PlacesServiceEvent;
import com.lotus.sametime.places.PlacesServiceListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlacesComp
extends STComp
implements PlacesService {
    private Vector m_placesServiceListeners = new Vector();
    private boolean m_serviceUp;
    private PlacesImpl m_impl = null;
    private Hashtable m_places = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.places");

    public PlacesComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.places.PlacesComp", sTSession);
        this.m_impl = new PlacesImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public synchronized void addPlacesServiceListener(PlacesServiceListener placesServiceListener) {
        Vector vector = (Vector)this.m_placesServiceListeners.clone();
        vector.addElement(placesServiceListener);
        this.m_placesServiceListeners = vector;
    }

    public synchronized void removePlacesServiceListener(PlacesServiceListener placesServiceListener) {
        Vector vector = (Vector)this.m_placesServiceListeners.clone();
        vector.removeElement(placesServiceListener);
        this.m_placesServiceListeners = vector;
    }

    public boolean isServiceAvailable() {
        return this.m_impl.isServiceUp();
    }

    public Place createPlace(String string, String string2, EncLevel encLevel, int n) {
        return this.createPlace(string, string2, encLevel, n, (short)2);
    }

    public synchronized Place createPlace(String string, String string2, EncLevel encLevel, int n, short s) {
        Object v = this.m_places.get(string + n);
        if (v == null) {
            Place place = new Place(this.getSession(), string, string2, encLevel, n, s);
            this.m_places.put(string + n, place);
            return place;
        }
        return (Place)v;
    }

    synchronized void destroyPlace(Place place) {
        this.m_places.remove(place.getName() + place.getPlaceType());
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof PlacesServiceEvent) {
            this.processPlacesEvent((PlacesServiceEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processPlacesEvent(PlacesServiceEvent placesServiceEvent) {
        switch (placesServiceEvent.getId()) {
            case -2147483647: {
                this.serviceUp(placesServiceEvent);
                placesServiceEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.serviceDown(placesServiceEvent);
                placesServiceEvent.setConsumed(true);
            }
        }
    }

    protected void serviceUp(PlacesServiceEvent placesServiceEvent) {
        Vector vector = this.m_placesServiceListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlacesServiceListener placesServiceListener = (PlacesServiceListener)enumeration.nextElement();
            placesServiceListener.serviceAvailable(placesServiceEvent);
        }
    }

    protected void serviceDown(PlacesServiceEvent placesServiceEvent) {
        Vector vector = this.m_placesServiceListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlacesServiceListener placesServiceListener = (PlacesServiceListener)enumeration.nextElement();
            placesServiceListener.serviceUnavailable(placesServiceEvent);
        }
    }
}

