/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.core.comparch.MessageDispatcher;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceMember;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlaceMemberListener;
import com.lotus.sametime.places.PlacesEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlaceMemberImpl
implements PlaceMember {
    protected Integer m_placeId;
    protected Integer m_memberId;
    protected STSession m_session;
    private Vector m_memberListeners = new Vector();
    private Hashtable m_attributes = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.places");

    protected PlaceMemberImpl(STSession sTSession, Integer n, Integer n2) {
        this.m_session = sTSession;
        this.m_placeId = n;
        this.m_memberId = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPlaceMemberListener(PlaceMemberListener placeMemberListener) {
        PlaceMemberImpl placeMemberImpl = this;
        synchronized (placeMemberImpl) {
            Vector vector = (Vector)this.m_memberListeners.clone();
            vector.addElement(placeMemberListener);
            this.m_memberListeners = vector;
        }
        if (this.m_memberListeners.size() == 1) {
            this.subscribe();
        } else {
            this.requestSnapshot(placeMemberListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePlaceMemberListener(PlaceMemberListener placeMemberListener) {
        PlaceMemberImpl placeMemberImpl = this;
        synchronized (placeMemberImpl) {
            Vector vector = (Vector)this.m_memberListeners.clone();
            vector.removeElement(placeMemberListener);
            this.m_memberListeners = vector;
        }
        if (this.m_memberListeners.isEmpty()) {
            this.unsubscribe();
        }
    }

    protected void subscribe() {
        this.sendEvent(new PlaceMemberEvent((Object)this, 1, this.m_placeId, this.m_memberId));
    }

    protected void unsubscribe() {
        this.sendEvent(new PlaceMemberEvent((Object)this, 2, this.m_placeId, this.m_memberId));
    }

    public void sendText(String string) {
        this.sendEvent(new PlaceMemberEvent((Object)this, 3, this.m_placeId, this.m_memberId, string));
    }

    public void sendData(int n, byte[] byArray) {
        this.sendEvent(new PlaceMemberEvent(this, 4, this.m_placeId, this.m_memberId, n, byArray));
    }

    public void queryAttrContent(int n) {
        this.sendEvent(new PlaceMemberEvent((Object)this, 7, this.m_placeId, this.m_memberId, n));
    }

    public void changeAttribute(STExtendedAttribute sTExtendedAttribute) {
        this.sendEvent(new PlaceMemberEvent((Object)this, 5, this.m_placeId, this.m_memberId, sTExtendedAttribute));
    }

    public void removeAttribute(int n) {
        this.sendEvent(new PlaceMemberEvent((Object)this, 6, this.m_placeId, this.m_memberId, n));
    }

    public Integer getMemberId() {
        return this.m_memberId;
    }

    Integer getPlaceId() {
        return this.m_placeId;
    }

    public Place getPlace() {
        return null;
    }

    public Enumeration getAttributes() {
        Hashtable hashtable = (Hashtable)this.m_attributes.clone();
        return hashtable.elements();
    }

    protected void requestSnapshot(PlaceMemberListener placeMemberListener) {
        this.sendEvent(new PlaceMemberEvent(this, 8, placeMemberListener));
    }

    protected void sendSnapshot(PlaceMemberListener placeMemberListener) {
        Hashtable hashtable = (Hashtable)this.m_attributes.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            STExtendedAttribute sTExtendedAttribute = (STExtendedAttribute)enumeration.nextElement();
            PlaceMemberEvent placeMemberEvent = new PlaceMemberEvent((Object)this, -2147483647, sTExtendedAttribute);
            placeMemberListener.attributeChanged(placeMemberEvent);
        }
    }

    protected void sendEvent(STEvent sTEvent) {
        MessageDispatcher messageDispatcher = this.m_session.getDispatcher();
        messageDispatcher.sendEvent(sTEvent);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof PlaceMemberImpl) {
            PlaceMemberImpl placeMemberImpl = (PlaceMemberImpl)object;
            bl = this.m_memberId.equals(placeMemberImpl.getMemberId()) && this.m_placeId.equals(placeMemberImpl.getPlaceId());
        }
        return bl;
    }

    public int hashCode() {
        String string = this.m_placeId.toString() + this.m_memberId.toString();
        return string.hashCode();
    }

    public void processPlacesEvent(PlacesEvent placesEvent) {
        if (placesEvent instanceof PlaceMemberEvent) {
            this.processPlaceMemberEvent((PlaceMemberEvent)placesEvent);
        }
    }

    protected void processPlaceMemberEvent(PlaceMemberEvent placeMemberEvent) {
        placeMemberEvent.setSource(this);
        switch (placeMemberEvent.getId()) {
            case -2147483642: {
                this.handleSendFailed(placeMemberEvent);
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483647: {
                this.handleAttrChanged(placeMemberEvent);
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.handleAttrDeleted(placeMemberEvent);
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483640: {
                this.handleChangeAttrFailed(placeMemberEvent);
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483639: {
                this.handleDeleteAttrFailed(placeMemberEvent);
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483641: {
                this.handleGetAttrFailed(placeMemberEvent);
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483638: {
                this.sendSnapshot(placeMemberEvent.getListener());
                placeMemberEvent.setConsumed(true);
                break;
            }
            case -2147483645: {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "processPlaceMemberEvent", "PLACES: BUG: Subscribe failed on member " + this.m_memberId);
                }
                placeMemberEvent.setConsumed(true);
            }
        }
    }

    protected void handleSendFailed(PlaceMemberEvent placeMemberEvent) {
        Vector vector = this.m_memberListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceMemberListener placeMemberListener = (PlaceMemberListener)enumeration.nextElement();
            placeMemberListener.sendFailed(placeMemberEvent);
        }
    }

    protected void handleAttrChanged(PlaceMemberEvent placeMemberEvent) {
        this.m_attributes.put(new Integer(placeMemberEvent.getAttributeKey()), placeMemberEvent.getAttribute());
        Vector vector = this.m_memberListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceMemberListener placeMemberListener = (PlaceMemberListener)enumeration.nextElement();
            placeMemberListener.attributeChanged(placeMemberEvent);
        }
    }

    protected void handleAttrDeleted(PlaceMemberEvent placeMemberEvent) {
        this.m_attributes.remove(new Integer(placeMemberEvent.getAttributeKey()));
        Vector vector = this.m_memberListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceMemberListener placeMemberListener = (PlaceMemberListener)enumeration.nextElement();
            placeMemberListener.attributeRemoved(placeMemberEvent);
        }
    }

    protected void handleChangeAttrFailed(PlaceMemberEvent placeMemberEvent) {
        Vector vector = this.m_memberListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceMemberListener placeMemberListener = (PlaceMemberListener)enumeration.nextElement();
            placeMemberListener.changeAttributeFailed(placeMemberEvent);
        }
    }

    protected void handleDeleteAttrFailed(PlaceMemberEvent placeMemberEvent) {
        Vector vector = this.m_memberListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceMemberListener placeMemberListener = (PlaceMemberListener)enumeration.nextElement();
            placeMemberListener.removeAttributeFailed(placeMemberEvent);
        }
    }

    protected void handleGetAttrFailed(PlaceMemberEvent placeMemberEvent) {
        Vector vector = this.m_memberListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlaceMemberListener placeMemberListener = (PlaceMemberListener)enumeration.nextElement();
            placeMemberListener.queryAttrContentFailed(placeMemberEvent);
        }
    }
}

