/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.places.MyMsgListener;
import com.lotus.sametime.places.MySectionListener;
import com.lotus.sametime.places.MyselfEvent;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlacesEvent;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.UserInPlace;
import java.util.Enumeration;
import java.util.Vector;

public class MyselfInPlace
extends UserInPlace {
    private Vector m_msgListeners = new Vector();
    private Vector m_mySectionListeners = new Vector();

    protected MyselfInPlace(STSession sTSession, Integer n, Place place, Section section, STId sTId, String string, STLoginId sTLoginId, short s) {
        super(sTSession, n, place, section, sTId, string, sTLoginId, s, 4);
    }

    public synchronized void addMyMsgListener(MyMsgListener myMsgListener) {
        Vector vector = (Vector)this.m_msgListeners.clone();
        vector.addElement(myMsgListener);
        this.m_msgListeners = vector;
    }

    public synchronized void removeMyMsgListener(MyMsgListener myMsgListener) {
        Vector vector = (Vector)this.m_msgListeners.clone();
        vector.removeElement(myMsgListener);
        this.m_msgListeners = vector;
    }

    public synchronized void addMySectionListener(MySectionListener mySectionListener) {
        Vector vector = (Vector)this.m_mySectionListeners.clone();
        vector.addElement(mySectionListener);
        this.m_mySectionListeners = vector;
    }

    public synchronized void removeMySectionListener(MySectionListener mySectionListener) {
        Vector vector = (Vector)this.m_mySectionListeners.clone();
        vector.removeElement(mySectionListener);
        this.m_mySectionListeners = vector;
    }

    public void changeSection(Section section) {
        MyselfEvent myselfEvent = new MyselfEvent(this, 1, this.m_impl.m_placeId, section.getMemberId());
        this.m_impl.sendEvent(myselfEvent);
    }

    public void processPlacesEvent(PlacesEvent placesEvent) {
        if (placesEvent instanceof MyselfEvent) {
            this.processMyselfEvent((MyselfEvent)placesEvent);
        } else {
            super.processPlacesEvent(placesEvent);
        }
    }

    private void processMyselfEvent(MyselfEvent myselfEvent) {
        myselfEvent.setSource(this);
        switch (myselfEvent.getId()) {
            case -2147483647: {
                this.textReceived(myselfEvent);
                myselfEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.dataReceived(myselfEvent);
                myselfEvent.setConsumed(true);
                break;
            }
            case -2147483645: {
                this.sectionChanged(myselfEvent);
                myselfEvent.setConsumed(true);
                break;
            }
            case -2147483644: {
                this.changeSectionFailed(myselfEvent);
                myselfEvent.setConsumed(true);
            }
        }
    }

    private void textReceived(MyselfEvent myselfEvent) {
        Vector vector = this.m_msgListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MyMsgListener myMsgListener = (MyMsgListener)enumeration.nextElement();
            myMsgListener.textReceived(myselfEvent);
        }
    }

    private void dataReceived(MyselfEvent myselfEvent) {
        Vector vector = this.m_msgListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MyMsgListener myMsgListener = (MyMsgListener)enumeration.nextElement();
            myMsgListener.dataReceived(myselfEvent);
        }
    }

    protected void changeSectionFailed(MyselfEvent myselfEvent) {
        Vector vector = this.m_mySectionListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MySectionListener mySectionListener = (MySectionListener)enumeration.nextElement();
            mySectionListener.changeSectionFailed(myselfEvent);
        }
    }

    protected void sectionChanged(MyselfEvent myselfEvent) {
        this.m_section = myselfEvent.getSection();
        Vector vector = this.m_mySectionListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MySectionListener mySectionListener = (MySectionListener)enumeration.nextElement();
            mySectionListener.sectionChanged(myselfEvent);
        }
    }
}

