/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.names;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.names.NamesEvent;
import com.lotus.sametime.names.NamesService;
import com.lotus.sametime.names.NamesServiceListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamesComp
extends STComp
implements NamesService {
    private Vector m_listenerList = new Vector();
    private Hashtable m_usersTable = new Hashtable();
    private String m_nameDelimiter;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.names");

    public NamesComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.names.NamesComp", sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public synchronized void addNamesServiceListener(NamesServiceListener namesServiceListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.addElement(namesServiceListener);
        this.m_listenerList = vector;
    }

    public synchronized void removeNamesServiceListener(NamesServiceListener namesServiceListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.removeElement(namesServiceListener);
        this.m_listenerList = vector;
    }

    public void setUserName(STUser sTUser) {
        this.m_usersTable.put(sTUser.getId(), sTUser);
        NamesEvent namesEvent = new NamesEvent(this, sTUser, this.m_nameDelimiter);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((NamesServiceListener)enumeration.nextElement()).nameChanged(namesEvent);
        }
    }

    public STUser getUser(STUser sTUser) {
        STUser sTUser2 = (STUser)this.m_usersTable.get(sTUser.getId());
        if (null == sTUser2) {
            sTUser2 = sTUser;
        }
        sTUser2.setNameDelimiter(this.m_nameDelimiter);
        return sTUser2;
    }

    public String getNickname(STUser sTUser) {
        String string = sTUser.getNickName();
        STUser sTUser2 = (STUser)this.m_usersTable.get(sTUser.getId());
        if (null != sTUser2) {
            string = sTUser2.getNickName();
        }
        return string;
    }

    public void setNameDelimiter(String string) {
        this.m_nameDelimiter = string;
        NamesEvent namesEvent = new NamesEvent((Object)this, string);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((NamesServiceListener)enumeration.nextElement()).nameDelimiterChanged(namesEvent);
        }
    }

    public String getNameDelimiter() {
        return this.m_nameDelimiter;
    }
}

