/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.chat;

import com.lotus.sametime.guiutils.chat.ChatParagraph;
import com.lotus.sametime.guiutils.chat.ChatSelection;
import com.lotus.sametime.guiutils.chat.ChatTranscript;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ChatSelector
implements MouseListener,
MouseMotionListener,
FocusListener {
    protected ChatTranscript m_transcript;
    protected ChatSelection m_startSelection = new ChatSelection(0, 0);
    protected ChatSelection m_endSelection = new ChatSelection(0, 0);
    private ChatSelection m_anchor = new ChatSelection(0, 0);
    private boolean m_dragging = false;
    private boolean m_hadSelection = false;
    private boolean m_hasClipboardAccess = false;
    private Clipboard m_clipboard;
    private ChatSelection m_charRelSel = new ChatSelection(0, 0);
    private ChatSelection m_prevCharRelSel = new ChatSelection(0, 0);
    private ChatSelection m_prevStartSelection = new ChatSelection(0, 0);
    private ChatSelection m_prevEndSelection = new ChatSelection(0, 0);

    protected ChatSelector(ChatTranscript chatTranscript) {
        this.m_transcript = chatTranscript;
        this.m_transcript.addMouseListener(this);
        this.m_transcript.addMouseMotionListener(this);
        this.m_transcript.addFocusListener(this);
        try {
            this.m_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.m_hasClipboardAccess = true;
        }
        catch (SecurityException securityException) {
            System.out.println("Security violation on getSystemClipboard");
            this.m_hasClipboardAccess = false;
        }
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ChatSelector.this.keyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ChatSelector.this.keyReleased(keyEvent);
            }
        };
        this.m_transcript.addKeyListener(keyAdapter);
    }

    protected void highlightSelection(Graphics graphics, ChatSelection chatSelection, ChatSelection chatSelection2) {
        if (chatSelection == null) {
            chatSelection = this.m_startSelection;
            chatSelection2 = this.m_endSelection;
        }
        int n = this.m_transcript.getFirstVisibleParaIdx();
        int n2 = this.m_transcript.getLastVisibleParaIdx(n);
        if (chatSelection.equal(chatSelection2) || chatSelection2.m_paraIdx < n || chatSelection.m_paraIdx > n2) {
            return;
        }
        int n3 = chatSelection.m_paraIdx;
        int n4 = chatSelection2.m_paraIdx;
        int n5 = chatSelection.m_offset;
        int n6 = -1;
        if (chatSelection.m_paraIdx < n) {
            n3 = n;
            n5 = 0;
        }
        if (chatSelection2.m_paraIdx > n2) {
            n4 = n2;
        }
        for (int i = n3; i <= n4; ++i) {
            if (i > n3) {
                n5 = 0;
            }
            if (i == n4 && chatSelection2.m_paraIdx <= n2) {
                n6 = chatSelection2.m_offset;
            }
            this.m_transcript.m_paraArray[i].highlightPara(graphics, n5, n6);
        }
    }

    protected void selectAll() {
        boolean bl;
        if (this.m_transcript.empty()) {
            return;
        }
        boolean bl2 = bl = !this.m_startSelection.equal(this.m_endSelection);
        if (this.m_transcript.m_hasFocus && bl) {
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_startSelection, this.m_endSelection);
        }
        this.m_startSelection.setSelection(0, 0);
        int n = this.m_transcript.getParaCount() - 1;
        ChatParagraph chatParagraph = this.m_transcript.getParaByIdx(n);
        this.m_endSelection.setSelection(n, chatParagraph.getParaLength());
        if (this.m_transcript.m_hasFocus) {
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_startSelection, this.m_endSelection);
        }
        if (!bl) {
            this.m_transcript.getArea().statusChanged(true);
        }
    }

    protected String getSelectedText() {
        if (this.m_startSelection.equal(this.m_endSelection)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_startSelection.m_offset;
        for (int i = this.m_startSelection.m_paraIdx; i <= this.m_endSelection.m_paraIdx; ++i) {
            if (i > this.m_startSelection.m_paraIdx) {
                n = 0;
            }
            ChatParagraph chatParagraph = this.m_transcript.m_paraArray[i];
            int n2 = i == this.m_endSelection.m_paraIdx ? this.m_endSelection.m_offset : chatParagraph.getParaLength();
            stringBuffer.ensureCapacity(stringBuffer.length() + n2 - n);
            stringBuffer.append(chatParagraph.getTextByOffsets(n, n2) + "\n");
        }
        return stringBuffer.toString();
    }

    protected void copySelectionToClip() {
        if (this.m_startSelection.equal(this.m_endSelection)) {
            return;
        }
        if (this.m_clipboard != null) {
            StringSelection stringSelection = new StringSelection(this.getSelectedText());
            this.m_clipboard.setContents(stringSelection, null);
        }
    }

    protected void removeSelection() {
        boolean bl;
        if (this.m_transcript.empty()) {
            return;
        }
        boolean bl2 = bl = !this.m_startSelection.equal(this.m_endSelection);
        if (bl) {
            this.highlightSelection(this.m_transcript.getGraphics(), null, null);
            this.m_startSelection.setSelection(0, 0);
            this.m_endSelection.setSelection(0, 0);
            this.m_transcript.getArea().statusChanged(false);
        }
    }

    public boolean hasClipboardAccess() {
        return this.m_hasClipboardAccess;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        this.m_dragging = false;
        if (this.m_transcript.getParaCount() == 0) {
            return;
        }
        this.m_hadSelection = !this.m_startSelection.equal(this.m_endSelection);
        int n = mouseEvent.getModifiers();
        boolean bl2 = bl = mouseEvent.getID() == 401;
        if ((n & 4) != 0) {
            this.m_transcript.showPopup(mouseEvent.getX(), mouseEvent.getY(), this.m_startSelection.lessThan(this.m_endSelection));
        } else if ((n & 0x10) != 0 || bl) {
            if (!bl && this.m_transcript.mouseIsOverURL(mouseEvent.getPoint())) {
                this.m_transcript.requestURL(mouseEvent.getPoint());
            } else {
                if (this.m_transcript.hasFocus()) {
                    this.highlightSelection(this.m_transcript.getGraphics(), this.m_startSelection, this.m_endSelection);
                }
                Point point = mouseEvent.getPoint();
                this.m_startSelection = this.m_transcript.getSelectionByPoint(point);
                this.m_endSelection.setSelection(this.m_startSelection);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        this.m_dragging = false;
        if (!this.m_transcript.empty() && this.m_startSelection.equal(this.m_endSelection)) {
            ChatParagraph chatParagraph = this.m_transcript.m_paraArray[this.m_startSelection.getParaIdx()];
            if (this.m_startSelection.getOffset() == chatParagraph.getParaLength()) {
                this.m_startSelection.setOffset(chatParagraph.getParaLength() - 1);
            } else {
                this.m_endSelection.setOffset(this.m_startSelection.getOffset() + 1);
            }
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_startSelection, this.m_endSelection);
            this.m_anchor.setSelection(this.m_startSelection);
        }
        boolean bl2 = bl = !this.m_startSelection.equal(this.m_endSelection);
        if (bl != this.m_hadSelection) {
            this.m_transcript.getArea().statusChanged(!this.m_startSelection.equal(this.m_endSelection));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        if (this.m_transcript.getParaCount() == 0) {
            return;
        }
        int n = 0;
        if (!this.m_dragging) {
            this.m_charRelSel.setSelection(this.m_startSelection);
            this.m_anchor.setSelection(this.m_startSelection);
            this.m_dragging = true;
        } else {
            point = mouseEvent.getPoint();
            Rectangle rectangle = this.m_transcript.getViewPortRect();
            if (!rectangle.contains(point)) {
                Point point2 = this.m_transcript.getArea().getScrollPosition();
                if (point.y >= rectangle.height + point2.y) {
                    point.y = rectangle.height + point2.y - 1;
                    point.x = rectangle.width + point2.x - 1;
                    n = 15;
                } else if (point.y <= point2.y) {
                    point.y = point2.y + 1;
                    point.x = point2.x + 1;
                    n = -15;
                } else {
                    return;
                }
            }
            this.m_charRelSel = this.m_transcript.getSelectionByPoint(point);
            if (this.m_charRelSel.equal(this.m_prevCharRelSel)) {
                return;
            }
        }
        this.m_prevStartSelection.setSelection(this.m_startSelection);
        this.m_prevEndSelection.setSelection(this.m_endSelection);
        if (this.m_charRelSel.lessThan(this.m_anchor)) {
            this.m_startSelection.setSelection(this.m_charRelSel);
            this.m_endSelection.setSelection(this.m_anchor);
        } else {
            this.m_startSelection.setSelection(this.m_anchor);
            this.m_endSelection.setSelection(this.m_charRelSel);
        }
        if (this.m_startSelection.lessThan(this.m_prevStartSelection)) {
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_startSelection, this.m_prevStartSelection.minSelection(this.m_anchor));
            if (this.m_prevEndSelection.greaterThan(this.m_anchor)) {
                this.highlightSelection(this.m_transcript.getGraphics(), this.m_anchor, this.m_prevEndSelection);
            }
        } else if (this.m_startSelection.greaterThan(this.m_prevStartSelection)) {
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_prevStartSelection, this.m_startSelection.minSelection(this.m_anchor));
            if (this.m_endSelection.greaterThan(this.m_anchor)) {
                this.highlightSelection(this.m_transcript.getGraphics(), this.m_anchor, this.m_endSelection);
            }
        } else if (this.m_endSelection.greaterThan(this.m_prevEndSelection)) {
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_prevEndSelection, this.m_endSelection);
        } else {
            this.highlightSelection(this.m_transcript.getGraphics(), this.m_endSelection, this.m_prevEndSelection);
        }
        this.m_prevCharRelSel.setSelection(this.m_charRelSel);
        if (n != 0) {
            point = this.m_transcript.getArea().getScrollPosition();
            this.m_transcript.getArea().setScrollPosition(point.x, point.y + n);
            this.m_transcript.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_transcript.mouseIsOverURL(mouseEvent.getPoint())) {
            this.m_transcript.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.m_transcript.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n >= 37 && n <= 40) {
            boolean bl = !this.m_startSelection.equal(this.m_endSelection);
            boolean bl2 = keyEvent.isShiftDown();
            switch (n) {
                case 37: {
                    MouseEvent mouseEvent;
                    Point point;
                    int n2;
                    boolean bl3;
                    boolean bl4 = this.m_startSelection.lessThan(this.m_anchor) || this.m_endSelection.equal(this.m_startSelection);
                    ChatSelection chatSelection = bl4 ? this.m_startSelection : this.m_endSelection;
                    int n3 = chatSelection.getParaIdx();
                    ChatParagraph chatParagraph = this.m_transcript.m_paraArray[n3];
                    boolean bl5 = bl3 = chatSelection.getOffset() == 0;
                    if (bl3) {
                        if (n3 == 0) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                        chatParagraph = this.m_transcript.m_paraArray[n3 - 1];
                        n2 = chatParagraph.getParaLength() - 1;
                    } else {
                        n2 = chatSelection.getOffset() - 1;
                    }
                    if (!bl2) {
                        point = chatParagraph.getPosInParaByOffset(n2 + 1, false);
                        mouseEvent = new MouseEvent(this.m_transcript, 401, 0L, 0, point.x, point.y + 2, 1, false);
                        this.mousePressed(mouseEvent);
                        this.m_charRelSel.setSelection(this.m_endSelection);
                        this.m_anchor.setSelection(this.m_endSelection);
                        this.m_dragging = true;
                    }
                    point = chatParagraph.getPosInParaByOffset(n2, false);
                    mouseEvent = new MouseEvent(this.m_transcript, 506, 0L, 0, point.x, point.y + 2, 1, false);
                    this.mouseDragged(mouseEvent);
                    break;
                }
                case 38: {
                    break;
                }
                case 39: {
                    MouseEvent mouseEvent;
                    Point point;
                    int n4;
                    boolean bl6;
                    boolean bl7 = this.m_endSelection.greaterThan(this.m_anchor) || this.m_endSelection.equal(this.m_startSelection);
                    ChatSelection chatSelection = bl7 ? this.m_endSelection : this.m_startSelection;
                    int n5 = chatSelection.getParaIdx();
                    ChatParagraph chatParagraph = this.m_transcript.m_paraArray[n5];
                    boolean bl8 = bl6 = chatSelection.getOffset() == chatParagraph.getParaLength();
                    if (bl6) {
                        if (n5 == this.m_transcript.getParaCount() - 1) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                        chatParagraph = this.m_transcript.m_paraArray[n5 + 1];
                        n4 = 1;
                    } else {
                        n4 = chatSelection.getOffset() + 1;
                    }
                    if (!bl2) {
                        point = chatParagraph.getPosInParaByOffset(n4 - 1, true);
                        mouseEvent = new MouseEvent(this.m_transcript, 401, 0L, 0, point.x, point.y + 2, 1, false);
                        this.mousePressed(mouseEvent);
                        this.m_charRelSel.setSelection(this.m_endSelection);
                        this.m_anchor.setSelection(this.m_endSelection);
                        this.m_dragging = true;
                    }
                    point = chatParagraph.getPosInParaByOffset(n4, true);
                    mouseEvent = new MouseEvent(this.m_transcript, 506, 0L, 0, point.x, point.y + 2, 1, false);
                    this.mouseDragged(mouseEvent);
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.highlightSelection(this.m_transcript.getGraphics(), null, null);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.highlightSelection(this.m_transcript.getGraphics(), null, null);
    }
}

