/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.chat;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.guiutils.chat.ChatParagraph;
import com.lotus.sametime.guiutils.chat.ChatSelection;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class ChatLine {
    protected ChatParagraph m_paragraph;
    protected Point m_linePosition;
    protected int m_startOffset;
    protected int m_endOffset;
    protected Vector m_lineSegments = null;

    protected ChatLine(ChatParagraph chatParagraph, Point point, int n, int n2) {
        this.m_paragraph = chatParagraph;
        this.m_linePosition = point;
        this.m_startOffset = n;
        this.m_endOffset = n2;
        if (chatParagraph.m_paraLines.size() > 0) {
            ChatLine chatLine = (ChatLine)chatParagraph.m_paraLines.elementAt(0);
            int n3 = chatLine.getLineLength();
            this.m_startOffset += n3;
            this.m_endOffset += n3;
        }
        chatParagraph.m_paraLines.addElement(this);
    }

    Point getPosInLineByOffset(FontMetrics fontMetrics, int n) {
        int n2 = this.m_linePosition.x;
        int n3 = this.m_linePosition.y;
        if (n > this.m_startOffset) {
            String string = this.m_paragraph.getTextByOffsets(this.m_startOffset, n);
            n2 += fontMetrics.stringWidth(string);
        }
        return new Point(n2, n3);
    }

    protected void highlightLine(Graphics graphics, FontMetrics fontMetrics, int n, int n2) {
        String string;
        if (n == -1) {
            n = this.m_startOffset;
        }
        if (n2 == -1) {
            n2 = this.m_endOffset;
        }
        int n3 = this.m_linePosition.x;
        int n4 = this.m_linePosition.y;
        int n5 = this.m_paragraph.getTranscript().getLineHeight();
        if (n > this.m_startOffset) {
            string = this.m_paragraph.getTextByOffsets(this.m_startOffset, n);
            n3 += fontMetrics.stringWidth(string);
        }
        string = this.m_paragraph.getTextByOffsets(this.m_startOffset, n2);
        int n6 = fontMetrics.stringWidth(string) - n3 + this.m_linePosition.x;
        graphics.setXORMode(Color.yellow);
        graphics.fillRect(n3, n4, n6, n5);
        graphics.setPaintMode();
    }

    protected int getOffsetByPos(FontMetrics fontMetrics, int n) {
        String string = this.m_paragraph.getTextByOffsets(this.m_startOffset, this.m_endOffset);
        int n2 = 0;
        int n3 = fontMetrics.charWidth(string.charAt(n2));
        while (n >= this.m_linePosition.x + n3 && ++n2 != string.length()) {
            n3 += fontMetrics.charWidth(string.charAt(n2));
        }
        return this.m_startOffset + n2;
    }

    protected Point getLinePosition() {
        return this.m_linePosition;
    }

    protected int getStartOffset() {
        return this.m_startOffset;
    }

    protected int getEndOffset() {
        return this.m_endOffset;
    }

    protected int getLineLength() {
        return this.m_endOffset - this.m_startOffset;
    }

    protected void setLinePosition(Point point) {
        this.m_linePosition = point;
    }

    protected void adjustLinePositionY(int n) {
        this.m_linePosition.y -= n;
    }

    protected void setStartOffset(int n) {
        this.m_startOffset = n;
    }

    protected void setEndOffset(int n) {
        this.m_endOffset = n;
    }

    protected Vector getLineSegments() {
        return this.m_lineSegments;
    }

    protected void setLineSegments(Vector vector) {
        this.m_lineSegments = vector;
    }

    protected int getSegmentStart(int n) {
        int n2;
        Debug.stAssert(this.m_lineSegments != null && n <= this.m_lineSegments.size());
        if (n == this.m_lineSegments.size()) {
            n2 = this.getLineLength();
        } else {
            ChatSelection chatSelection = (ChatSelection)this.m_lineSegments.elementAt(n);
            n2 = chatSelection.getOffset();
        }
        return n2;
    }

    protected boolean segmentIsURL(int n) {
        ChatSelection chatSelection = (ChatSelection)this.m_lineSegments.elementAt(n);
        return chatSelection.getParaIdx() > 0;
    }

    protected boolean offsetIsURL(int n) {
        int n2 = this.getSegmentIdx(n);
        return this.segmentIsURL(n2);
    }

    protected int getSegmentIdx(int n) {
        int n2;
        Debug.stAssert(this.m_lineSegments != null);
        for (n2 = 0; n2 < this.m_lineSegments.size() && n > this.getSegmentStart(n2 + 1); ++n2) {
        }
        return n2;
    }
}

