/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.accessibility;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeyHandler
extends KeyAdapter {
    boolean m_altPressed = false;
    Vector m_keysActions;
    public static final String POLAND_COUNTRY_CODE = "PL";
    private Locale m_defaultLocale;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.guiutils.accessibility");

    public KeyHandler(Vector vector) {
        this.m_keysActions = vector;
        this.m_defaultLocale = Locale.getDefault();
    }

    public void keyPressed(KeyEvent keyEvent) {
        KeyAction keyAction;
        if (keyEvent.getKeyCode() == 18) {
            int n;
            block13: {
                n = 0;
                String string = this.m_defaultLocale.getCountry();
                if (StaticProps.m_JavaPlugIn && string.equals(POLAND_COUNTRY_CODE)) {
                    try {
                        Method method = keyEvent.getClass().getDeclaredMethod("getKeyLocation", null);
                        Integer n2 = (Integer)method.invoke((Object)keyEvent, null);
                        n = n2;
                    }
                    catch (Exception exception) {
                        if (!this.m_logger.isLoggable(Level.FINEST)) break block13;
                        this.m_logger.logp(Level.FINEST, this.getClass().getName(), "keyPressed", "Exception when invoking KeyEvent#getKeyLocation: " + exception.getLocalizedMessage());
                    }
                }
            }
            if (n != 3) {
                this.m_altPressed = true;
            }
        } else if (keyEvent.getKeyCode() == 10) {
            KeyAction keyAction2 = this.getKeyActionByKey(10);
            if (keyAction2 != null) {
                keyAction2.executeKeyMethod();
            }
        } else if (keyEvent.getKeyCode() == 27) {
            KeyAction keyAction3 = this.getKeyActionByKey(27);
            if (keyAction3 != null) {
                keyAction3.executeKeyMethod();
            }
        } else if (this.m_altPressed && (keyAction = this.getKeyActionByKey(keyEvent.getKeyCode())) != null) {
            this.m_altPressed = false;
            keyAction.executeKeyMethod();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 18) {
            this.m_altPressed = false;
        }
    }

    private KeyAction getKeyActionByKey(int n) {
        KeyAction keyAction = null;
        boolean bl = false;
        Enumeration enumeration = this.m_keysActions.elements();
        while (enumeration.hasMoreElements()) {
            keyAction = (KeyAction)enumeration.nextElement();
            if (keyAction.getKeyCode() != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            keyAction = null;
        }
        return keyAction;
    }
}

