/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.enc;

import java.util.logging.Level;
import java.util.logging.Logger;

public class RC2Cipher {
    public static final int RC2_128_KEY_LENGTH = 16;
    public static final int RC2_40_KEY_LENGTH = 5;
    public static final int ENCRYPT_MODE = 0;
    public static final int DECRYPT_MODE = 1;
    private static final int RC2_BLOCK_SIZE = 8;
    private static final byte[] Permute = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    public static final byte[] Default_IV = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
    private int Cipher_Mode = 0;
    private short[] Key = new short[64];
    private byte[] Active_IV = new byte[8];
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.enc");

    public static RC2Cipher getInstance(String string) {
        return new RC2Cipher();
    }

    public int getBlockSize() {
        return 8;
    }

    public int getOutputSize(int n) {
        return (n & 0xFFFFFFF8) + 8;
    }

    public void init(int n, byte[] byArray) {
        int n2 = 0;
        byte[] byArray2 = null;
        int n3 = 0;
        if (byArray == null || byArray.length == 0) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "init", "RC2Cipher: invalid key");
            }
            return;
        }
        this.Cipher_Mode = n;
        n2 = byArray.length;
        if (n2 > 128) {
            n2 = 128;
        }
        byArray2 = new byte[128];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        n3 = 0;
        while (n2 < 128) {
            byArray2[n2] = Permute[byArray2[n2 - 1] + byArray2[n3] & 0xFF];
            ++n2;
            ++n3;
        }
        byArray2[0] = Permute[byArray2[0] & 0xFF];
        for (n3 = 0; n3 < 64; ++n3) {
            this.Key[n3] = (short)(((short)byArray2[n3 * 2] & 0xFF) + ((short)byArray2[n3 * 2 + 1] << 8));
        }
        System.arraycopy(Default_IV, 0, this.Active_IV, 0, 8);
    }

    public void setIV(byte[] byArray) {
        System.arraycopy(byArray, 0, this.Active_IV, 0, 8);
    }

    public byte[] getIV() {
        return this.Active_IV;
    }

    public byte[] doFinal(byte[] byArray) {
        if (this.Cipher_Mode == 0) {
            return this.encrypt(byArray);
        }
        return this.decrypt(byArray);
    }

    private byte[] encrypt(byte[] byArray) {
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        if (byArray == null || byArray.length == 0) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "encrypt", "RC2Cipher: invalid input");
            }
            return null;
        }
        byArray2 = new byte[this.getOutputSize(byArray.length)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (n = byArray.length; n < byArray2.length; ++n) {
            byArray2[n] = (byte)(byArray2.length - byArray.length);
        }
        for (n = 0; n < byArray2.length; n += 8) {
            for (n2 = 0; n2 < 8; ++n2) {
                int n3 = n + n2;
                byArray2[n3] = (byte)(byArray2[n3] ^ this.Active_IV[n2]);
            }
            this.encryptBlock(byArray2, n);
            System.arraycopy(byArray2, n, this.Active_IV, 0, 8);
        }
        return byArray2;
    }

    private byte[] decrypt(byte[] byArray) {
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        byte by = 0;
        int n3 = 0;
        byte[] byArray3 = null;
        if (byArray == null || byArray.length == 0 || (byArray.length & 7) != 0) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "decrypt", "RC2Cipher: invalid input");
            }
            return null;
        }
        byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (n = 0; n < byArray2.length; n += 8) {
            this.decryptBlock(byArray2, n);
            for (n2 = 0; n2 < 8; ++n2) {
                int n4 = n + n2;
                byArray2[n4] = (byte)(byArray2[n4] ^ this.Active_IV[n2]);
            }
            System.arraycopy(byArray, n, this.Active_IV, 0, 8);
        }
        by = byArray2[byArray2.length - 1];
        n3 = by < 1 || by > 8 ? 0 : byArray2.length - by;
        byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    private void encryptBlock(byte[] byArray, int n) {
        short s = (short)(((short)byArray[n + 7] << 8) + ((short)byArray[n + 6] & 0xFF));
        short s2 = (short)(((short)byArray[n + 5] << 8) + ((short)byArray[n + 4] & 0xFF));
        short s3 = (short)(((short)byArray[n + 3] << 8) + ((short)byArray[n + 2] & 0xFF));
        short s4 = (short)(((short)byArray[n + 1] << 8) + ((short)byArray[n] & 0xFF));
        for (int i = 0; i < 16; ++i) {
            s4 = (short)(s4 + ((s3 & ~s) + (s2 & s) + this.Key[i * 4]));
            s4 = (short)((s4 << 1) + (s4 >> 15 & 1));
            s3 = (short)(s3 + ((s2 & ~s4) + (s & s4) + this.Key[i * 4 + 1]));
            s3 = (short)((s3 << 2) + (s3 >> 14 & 3));
            s2 = (short)(s2 + ((s & ~s3) + (s4 & s3) + this.Key[i * 4 + 2]));
            s2 = (short)((s2 << 3) + (s2 >> 13 & 7));
            s = (short)(s + ((s4 & ~s2) + (s3 & s2) + this.Key[i * 4 + 3]));
            s = (short)((s << 5) + (s >> 11 & 0x1F));
            if (i != 4 && i != 10) continue;
            s4 = (short)(s4 + this.Key[s & 0x3F]);
            s3 = (short)(s3 + this.Key[s4 & 0x3F]);
            s2 = (short)(s2 + this.Key[s3 & 0x3F]);
            s = (short)(s + this.Key[s2 & 0x3F]);
        }
        byArray[n] = (byte)s4;
        byArray[n + 1] = (byte)(s4 >> 8);
        byArray[n + 2] = (byte)s3;
        byArray[n + 3] = (byte)(s3 >> 8);
        byArray[n + 4] = (byte)s2;
        byArray[n + 5] = (byte)(s2 >> 8);
        byArray[n + 6] = (byte)s;
        byArray[n + 7] = (byte)(s >> 8);
    }

    private void decryptBlock(byte[] byArray, int n) {
        short s = (short)(((short)byArray[n + 7] << 8) + ((short)byArray[n + 6] & 0xFF));
        short s2 = (short)(((short)byArray[n + 5] << 8) + ((short)byArray[n + 4] & 0xFF));
        short s3 = (short)(((short)byArray[n + 3] << 8) + ((short)byArray[n + 2] & 0xFF));
        short s4 = (short)(((short)byArray[n + 1] << 8) + ((short)byArray[n] & 0xFF));
        for (int i = 15; i >= 0; --i) {
            s = (short)((s << 11) + (s >> 5 & 0x7FF));
            s = (short)(s - ((s4 & ~s2) + (s3 & s2) + this.Key[i * 4 + 3]));
            s2 = (short)((s2 << 13) + (s2 >> 3 & 0x1FFF));
            s2 = (short)(s2 - ((s & ~s3) + (s4 & s3) + this.Key[i * 4 + 2]));
            s3 = (short)((s3 << 14) + (s3 >> 2 & 0x3FFF));
            s3 = (short)(s3 - ((s2 & ~s4) + (s & s4) + this.Key[i * 4 + 1]));
            s4 = (short)((s4 << 15) + (s4 >> 1 & Short.MAX_VALUE));
            s4 = (short)(s4 - ((s3 & ~s) + (s2 & s) + this.Key[i * 4]));
            if (i != 5 && i != 11) continue;
            s = (short)(s - this.Key[s2 & 0x3F]);
            s2 = (short)(s2 - this.Key[s3 & 0x3F]);
            s3 = (short)(s3 - this.Key[s4 & 0x3F]);
            s4 = (short)(s4 - this.Key[s & 0x3F]);
        }
        byArray[n] = (byte)s4;
        byArray[n + 1] = (byte)(s4 >> 8);
        byArray[n + 2] = (byte)s3;
        byArray[n + 3] = (byte)(s3 >> 8);
        byArray[n + 4] = (byte)s2;
        byArray[n + 5] = (byte)(s2 >> 8);
        byArray[n + 6] = (byte)s;
        byArray[n + 7] = (byte)(s >> 8);
    }

    public static byte[] encryptOT(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        byte[] byArray3 = new byte[n];
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            byArray3[n2] = 0;
        }
        n2 = n >= byArray2.length ? 0 : byArray2.length - n;
        int n3 = n < byArray2.length ? n : byArray2.length;
        System.arraycopy(byArray2, n2, byArray3, n - n3, n3);
        RC2Cipher rC2Cipher = new RC2Cipher();
        rC2Cipher.init(0, byArray3);
        return rC2Cipher.doFinal(byArray);
    }

    public static byte[] decryptOT(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        byte[] byArray3 = new byte[n];
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            byArray3[n2] = 0;
        }
        n2 = n >= byArray2.length ? 0 : byArray2.length - n;
        int n3 = n < byArray2.length ? n : byArray2.length;
        System.arraycopy(byArray2, n2, byArray3, n - n3, n3);
        RC2Cipher rC2Cipher = new RC2Cipher();
        rC2Cipher.init(1, byArray3);
        return rC2Cipher.doFinal(byArray);
    }
}

