/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.enc;

import java.math.BigInteger;
import java.util.Random;

public class DiffieHellman {
    private BigInteger Modulus;
    private BigInteger Base;
    public static BigInteger Default_Modulus = new BigInteger("CF84AFCE86DDFA527F136D10357528EEFBA0AFEF808F29174E3B6A9E970001717C8F106C41C161A6CE91057B34DA62CBB87BFDC1B35C1B910FEA72249D566B9F", 16);
    public static BigInteger Default_Base = new BigInteger("3");

    public DiffieHellman(BigInteger bigInteger, BigInteger bigInteger2) {
        this.Modulus = bigInteger;
        this.Base = bigInteger2;
    }

    public byte[] generatePrivateKey(Random random) {
        BigInteger bigInteger = new BigInteger(this.getExponentBitLength(), random);
        return bigInteger.toByteArray();
    }

    public byte[] generatePublicKey(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = this.Base.modPow(bigInteger, this.Modulus);
        return bigInteger2.toByteArray();
    }

    public byte[] generateAgreedValue(byte[] byArray, byte[] byArray2) {
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        BigInteger bigInteger3 = bigInteger.modPow(bigInteger2, this.Modulus);
        return bigInteger3.toByteArray();
    }

    private int getExponentBitLength() {
        int n = this.Modulus.bitCount();
        if (n < 5) {
            return 0;
        }
        return 2 * (int)(2.4 * Math.pow(n, 0.3333333333333333) * Math.pow(Math.log(n), 0.6666666666666666) - 5.0);
    }
}

