/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.logging.TkLogger;
import com.lotus.sametime.core.util.Base64Encoder;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.RandomGenerator;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.core.util.connection.Sender;
import com.lotus.sametime.core.util.connection.WnetURLConnection;
import com.lotus.sametime.core.util.enc.DiffieHellman;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HybridPollingSender
extends Sender {
    private static final int RETRIES_COUNT = 10;
    private static final String HYBRID_POLLING_URL_FILE = "CommunityCBR/CC." + Integer.toHexString(57) + '.';
    private static final int MASTER_CNL_LENGTH = 4;
    private static final int CONTROL_MSG_POLLING_INTERVAL = 1;
    private static final int RC2_KEY_LENGTH = 16;
    private static final int REASON_OK = 0;
    private static final int REASON_IO_EXCEPTION = -1;
    private static final int BEEP_EMPTY_TYPE = 0;
    private static final int BEEP_CONTROL_START_TYPE = 1;
    private static final int BEEP_CONTROL_CLOSE_TYPE = 2;
    private static final int BEEP_CONTENT_DATA_TYPE = 3;
    private static final int ENCRYPTED_SERVER_VERSION = 1;
    private static final int CLIENT_VERSION = 1;
    private String m_host = null;
    private int m_port = 0;
    private URL m_hostUrl = null;
    PipedOutputStream m_receivedOutputStream;
    PipedInputStream m_receivedInputStream;
    private byte[] m_masterCnlId = null;
    private byte[] m_requestId = null;
    private byte[] m_nonEncryptedRequestId = null;
    private int m_prevMsgCount = 0;
    private String m_saLoginId = "";
    DiffieHellman m_keyGenerator;
    byte[] m_privateKey;
    RC2Cipher m_signCipher;
    RC2Cipher m_encryptCipher;
    RC2Cipher m_decryptCipher;
    private boolean m_vcIsOpen = false;
    private boolean m_useWNet = false;
    private boolean m_secure = false;
    int m_serverVersion;
    int encryptCount = 0;
    int decryptCount = 0;
    boolean m_popupAuthDialog = false;
    boolean m_useSystemProxySettings = false;
    String m_proxyServer;
    short m_proxyPort;
    String m_proxyUserName;
    String m_proxyPass;
    private static Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected HybridPollingSender(String string, short s, URL uRL, boolean bl, boolean bl2, String string2, short s2, boolean bl3, String string3, String string4, boolean bl4) {
        this.m_host = string;
        this.m_port = s;
        this.m_hostUrl = uRL;
        this.m_useWNet = StaticProps.m_bWindowsOS ? bl : false;
        this.m_secure = bl2;
        this.m_proxyServer = string2 == null ? "" : string2;
        this.m_proxyPort = s2;
        this.m_useSystemProxySettings = bl3;
        this.m_proxyUserName = string3;
        this.m_proxyPass = string4;
        this.m_popupAuthDialog = bl4;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "<init>", "Using " + (this.m_secure ? "https" : "plain http") + " connection, with " + (this.m_useWNet ? "WnetURLConnection" : "URLConnection"));
        }
        try {
            this.m_receivedInputStream = new PipedInputStream(){
                {
                    this.buffer = new byte[65536];
                }
            };
            this.m_receivedOutputStream = new PipedOutputStream(this.m_receivedInputStream);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        this.m_keyGenerator = new DiffieHellman(DiffieHellman.Default_Modulus, DiffieHellman.Default_Base);
        Random random = RandomGenerator.getRandomGenerator();
        this.m_privateKey = this.m_keyGenerator.generatePrivateKey(random);
    }

    public void setKeepAliveParams(long l, byte[] byArray) {
    }

    protected InputStream getPolledInputStream() {
        return this.m_receivedInputStream;
    }

    protected void initialize() {
    }

    protected void cleanup() {
    }

    public void run() {
        if (!this.createVirtualConnection()) {
            this.m_stopped = true;
        }
        while (!this.m_stopped) {
            if (!this.m_queue.isEmpty()) {
                if (this.flush()) continue;
                this.m_stopped = true;
                continue;
            }
            if (this.sendDummyMsg()) continue;
            this.m_stopped = true;
        }
        if (this.m_vcIsOpen) {
            this.destroyVirtualConnection();
        }
        this.m_thread = null;
    }

    protected void send(byte[] byArray) throws IOException {
        try {
            this.sendWithBeep(byArray, 3);
        }
        catch (IOException iOException) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "send", "=====HybridPollingSender send: IO Exception=====.", iOException);
            }
            throw new IOException(iOException.getMessage());
        }
    }

    private void sendWithBeep(byte[] byArray, int n) throws IOException {
        boolean bl = false;
        int n2 = 10;
        boolean bl2 = this.m_vcIsOpen || n == 1;
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        this.writeWithBeepHeader(byArray, ndrOutputStream, n);
        byArray = ndrOutputStream.toByteArray();
        if (this.m_serverVersion >= 1 && byArray != null && byArray.length != 0) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", "Encrypting msg");
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", TkLogger.formatBytes(byArray));
            }
            Debug.stAssert(this.m_encryptCipher != null);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", "----------encryptCount = " + ++this.encryptCount);
            }
            byArray = this.m_encryptCipher.doFinal(byArray);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", "Encrypted msg");
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", TkLogger.formatBytes(byArray));
            }
        }
        while (true) {
            try {
                Properties properties = System.getProperties();
                String string = properties.getProperty("http.proxyHost");
                String string2 = properties.getProperty("http.proxyPort");
                this.setProxyProperties(this.m_proxyServer, this.m_proxyPort);
                this.sendOnce(byArray, n);
                this.setProxyProperties(string, string2);
                bl = true;
            }
            catch (IOException iOException) {
                if (!m_logger.isLoggable(Level.FINEST)) continue;
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", "Exception on trying to connect: ", iOException);
                if (--n2 > 0 && bl2) continue;
            }
            break;
        }
        if (!bl) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithBeep", "send: exceeded the maximum number of retries...");
            }
            try {
                this.m_receivedOutputStream.flush();
                this.m_receivedOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("HybridPollingSender sendWithBeep: Exceeded the maximum number of retries.");
        }
    }

    private boolean createVirtualConnection() {
        boolean bl;
        block2: {
            bl = false;
            try {
                this.sendWithBeep(null, 1);
                bl = true;
            }
            catch (IOException iOException) {
                if (!m_logger.isLoggable(Level.FINEST)) break block2;
                m_logger.logp(Level.FINEST, this.getClass().getName(), "createVirtualConnection", "=====HybridPollingSender createVirtualConnection: IO Exception=====. ", iOException);
            }
        }
        return bl;
    }

    private void destroyVirtualConnection() {
        block2: {
            try {
                this.sendWithBeep(null, 2);
                this.m_vcIsOpen = false;
            }
            catch (IOException iOException) {
                if (!m_logger.isLoggable(Level.FINEST)) break block2;
                m_logger.logp(Level.FINEST, this.getClass().getName(), "destroyVirtualConnection", "=====HybridPollingSender destroyVirtualConnection: IO Exception=====. ", iOException);
            }
        }
    }

    private boolean sendDummyMsg() {
        boolean bl;
        block2: {
            bl = false;
            try {
                this.sendWithBeep(null, 0);
                bl = true;
            }
            catch (IOException iOException) {
                if (!m_logger.isLoggable(Level.FINEST)) break block2;
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendDummyMsg", "=====HybridPollingSender sendDummyMsg: IO Exception=====. ", iOException);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void sendOnce(byte[] byArray, int n) throws IOException {
        Object object;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "HybridPollingSender: polling at " + new Date());
            if (byArray != null) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(byArray));
            }
        }
        URLConnection uRLConnection = this.createURLConnection();
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        if (this.m_masterCnlId == null) {
            this.writeInitialMsg(byArray, ndrOutputStream);
        } else {
            this.writeRegularMsg(byArray, ndrOutputStream);
        }
        OutputStream outputStream = uRLConnection.getOutputStream();
        outputStream.write(ndrOutputStream.toByteArray());
        outputStream.flush();
        outputStream.close();
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "--------- Sent HTTP request. Waiting for response at " + new Date());
        }
        DataInputStream dataInputStream = null;
        if (n == 0) {
            InstreamWaiter instreamWaiter;
            block20: {
                instreamWaiter = new InstreamWaiter(uRLConnection);
                instreamWaiter.start();
                try {
                    while (instreamWaiter.m_inStream == null && instreamWaiter.m_exception == null && this.m_queue.isEmpty()) {
                        InstreamWaiter instreamWaiter2 = instreamWaiter;
                        object = instreamWaiter2;
                        // MONITORENTER : instreamWaiter2
                        instreamWaiter.wait(100L);
                        // MONITOREXIT : object
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!m_logger.isLoggable(Level.FINER)) break block20;
                    m_logger.logp(Level.FINER, this.getClass().getName(), "sendOnce", "Hybrid Polling sendOnce: wait interrupted: ", interruptedException);
                }
            }
            if (instreamWaiter.m_exception != null) {
                throw instreamWaiter.m_exception;
            }
            dataInputStream = instreamWaiter.m_inStream;
        } else {
            dataInputStream = new DataInputStream(HybridPollingSender.safeGetInputStream(uRLConnection));
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "--------- Out of wait at " + new Date() + " inStream = " + dataInputStream);
        }
        if (dataInputStream == null) return;
        int n2 = uRLConnection.getContentLength();
        if (n2 < 0) {
            throw new IOException("Unknown message length");
        }
        object = new byte[n2];
        dataInputStream.readFully((byte[])object);
        dataInputStream.close();
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "--------- Response = ");
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(object));
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "Received HTTP message:");
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(object));
        }
        dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
        byte[] byArray2 = this.m_masterCnlId == null ? this.readInitialResponse(dataInputStream) : this.readRegularResponse(dataInputStream);
        if (byArray2 == null) return;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "-----------SendOnce: writing to pipe");
            m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(byArray2));
        }
        try {
            this.m_receivedOutputStream.write(byArray2);
            return;
        }
        catch (IOException iOException) {
            throw new IOException("HybridPollingSender sendOnce: Failed to write to receiver.");
        }
    }

    private void writeInitialMsg(byte[] byArray, NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeInt(0);
        ndrOutputStream.writeInt(1);
        byte[] byArray2 = this.m_keyGenerator.generatePublicKey(this.m_privateKey);
        ndrOutputStream.writeBytes(byArray2);
        ndrOutputStream.write(byArray);
    }

    private void writeRegularMsg(byte[] byArray, NdrOutputStream ndrOutputStream) throws IOException {
        Debug.stAssert(this.m_masterCnlId != null);
        ndrOutputStream.write(this.m_masterCnlId);
        ndrOutputStream.writeBytes(this.m_requestId);
        ndrOutputStream.write(byArray);
    }

    private void writeWithBeepHeader(byte[] byArray, NdrOutputStream ndrOutputStream, int n) throws IOException {
        if (n != 0) {
            switch (n) {
                case 1: {
                    this.writeBeepStart(ndrOutputStream);
                    break;
                }
                case 3: {
                    this.writeBeepContentData(ndrOutputStream);
                    ndrOutputStream.writeBytes(byArray);
                    break;
                }
                case 2: {
                    this.writeBeepClose(ndrOutputStream, 0);
                }
            }
        }
    }

    private boolean isEqualByteArray(byte[] byArray, byte[] byArray2) {
        Debug.stAssert(byArray != null && byArray2 != null);
        boolean bl = true;
        int n = byArray.length;
        if (n == byArray2.length) {
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private byte[] readInitialResponse(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[4];
        this.readFully(dataInputStream, byArray2);
        String string = dataInputStream.readUTF();
        this.m_serverVersion = 0;
        if (string.length() == 0) {
            this.m_serverVersion = dataInputStream.readInt();
            string = dataInputStream.readUTF();
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "m_serverVersion = " + this.m_serverVersion);
        }
        byte[] byArray3 = this.readBytes(dataInputStream);
        byArray = this.readBytes(dataInputStream);
        int n = this.readByte(dataInputStream);
        while (n-- > 0) {
            int n2 = this.readByte(dataInputStream);
            if (n2 == 1) {
                dataInputStream.readInt();
                continue;
            }
            Debug.stAssert(false);
        }
        byte[] byArray4 = new byte[dataInputStream.available()];
        this.readFully(dataInputStream, byArray4);
        this.m_masterCnlId = byArray2;
        this.m_saLoginId = string;
        byte[] byArray5 = this.m_keyGenerator.generateAgreedValue(this.m_privateKey, byArray3);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "agreed key = ");
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", TkLogger.formatBytes(byArray5));
        }
        this.m_nonEncryptedRequestId = byArray;
        this.createCiphers(byArray5, 16);
        this.m_requestId = this.m_signCipher.doFinal(this.m_nonEncryptedRequestId);
        if (this.m_serverVersion >= 1 && byArray4 != null && byArray4.length != 0) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "encrypted msg = ");
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", TkLogger.formatBytes(byArray4));
            }
            Debug.stAssert(this.m_decryptCipher != null);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "----------decryptCount = " + ++this.decryptCount);
            }
            byArray4 = this.m_decryptCipher.doFinal(byArray4);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "decrypted msg = ");
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", TkLogger.formatBytes(byArray4));
            }
        }
        byte[] byArray6 = this.stripBeep(byArray4, 0);
        return byArray6;
    }

    private byte[] readRegularResponse(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = null;
        byArray = this.readBytes(dataInputStream);
        int n = this.readByte(dataInputStream);
        while (n-- > 0) {
            int n2 = this.readByte(dataInputStream);
            if (n2 != 1) continue;
            dataInputStream.readInt();
        }
        byte[] byArray2 = new byte[dataInputStream.available()];
        this.readFully(dataInputStream, byArray2);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", "-----------ReadReguar response: received a response");
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", TkLogger.formatBytes(byArray2));
        }
        int n3 = 0;
        boolean bl = this.isEqualByteArray(this.m_nonEncryptedRequestId, byArray);
        if (bl) {
            n3 = this.m_prevMsgCount;
        } else {
            this.m_nonEncryptedRequestId = byArray;
            Debug.stAssert(this.m_signCipher != null);
            this.m_requestId = this.m_signCipher.doFinal(this.m_nonEncryptedRequestId);
        }
        if (this.m_serverVersion >= 1 && byArray2 != null && byArray2.length != 0) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", "encrypted msg = ");
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", TkLogger.formatBytes(byArray2));
            }
            Debug.stAssert(this.m_decryptCipher != null);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", "----------decryptCount = " + ++this.decryptCount);
            }
            byArray2 = this.m_decryptCipher.doFinal(byArray2);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", "decrypted msg = ");
                m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", TkLogger.formatBytes(byArray2));
            }
        }
        byte[] byArray3 = this.stripBeep(byArray2, n3);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", "-----------ReadReguar response: stripped message is");
            m_logger.logp(Level.FINEST, this.getClass().getName(), "readRegularResponse", TkLogger.formatBytes(byArray3));
        }
        return byArray3;
    }

    private byte[] stripBeep(byte[] byArray, int n) throws IOException {
        byte[] byArray2;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        int n2 = 0;
        try {
            block7: while (dataInputStream.available() > 0) {
                ++n2;
                int n3 = dataInputStream.readInt();
                byte by = dataInputStream.readByte();
                switch ((char)by) {
                    case 'M': {
                        int n4 = dataInputStream.readInt();
                        if (n3 == 0) {
                            if (n2 <= n) continue block7;
                            this.handleVcControlMessage(dataInputStream);
                            continue block7;
                        }
                        byArray2 = new byte[n4];
                        dataInputStream.read(byArray2);
                        if (n2 <= n) continue block7;
                        ndrOutputStream.write(byArray2);
                        continue block7;
                    }
                    case 'S': {
                        int n5 = dataInputStream.readInt();
                        if (n2 <= n) continue block7;
                        continue block7;
                    }
                }
                Debug.stAssert(false);
            }
        }
        catch (EOFException eOFException) {
            throw new IOException("Hybrid Connection: stripBeep - response is broken");
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        this.m_prevMsgCount = n2;
        byArray2 = ndrOutputStream.toByteArray();
        return byArray2;
    }

    private void handleVcControlMessage(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        int n = dataInputStream.readInt();
        switch ((char)by) {
            case 'O': {
                this.m_vcIsOpen = true;
                if (!m_logger.isLoggable(Level.FINEST)) break;
                m_logger.logp(Level.FINEST, this.getClass().getName(), "handleVcControlMessage", "VC connection opened OK");
                break;
            }
            case 'E': {
                int n2 = dataInputStream.readInt();
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.logp(Level.FINEST, this.getClass().getName(), "handleVcControlMessage", "VC connection error = " + n2);
                }
                throw new IOException("Hybrid  polling: handleVcControlMessage - error = " + n2);
            }
            case 'C': {
                int n3 = dataInputStream.readInt();
                this.m_vcIsOpen = false;
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.logp(Level.FINEST, this.getClass().getName(), "handleVcControlMessage", "VC connection closed = " + n3);
                }
                throw new IOException("Hybrid  polling: handleVcControlMessage - close = " + n3);
            }
        }
    }

    protected void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        try {
            int n = byArray.length;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; i += n3) {
                n3 = inputStream.read(byArray, n2 + i, n - i);
                if (n3 > 0) continue;
                throw new EOFException();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("stream closed");
        }
    }

    int readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    protected URLConnection createURLConnection() throws IOException {
        Object object;
        String string;
        String string2;
        String string3 = HYBRID_POLLING_URL_FILE + this.encodeURL(this.m_saLoginId) + '/';
        String string4 = string2 = this.m_secure ? "https" : "http";
        if (this.m_hostUrl == null) {
            string = string2 + "://" + this.m_host + ":" + this.m_port + "/" + string3;
        } else {
            object = this.m_hostUrl.toString();
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            string = (String)object + string3;
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.logp(Level.FINEST, this.getClass().getName(), "createURLConnection", "Trying to connect to " + string);
        }
        object = new URL(string);
        URLConnection uRLConnection = this.m_useWNet ? new WnetURLConnection((URL)object, this.m_proxyUserName, this.m_proxyPass, this.m_proxyServer, this.m_proxyPort, this.m_useSystemProxySettings, this.m_proxyUserName, this.m_proxyPass) : this.openConnectionWithProxySettings((URL)object);
        uRLConnection.setAllowUserInteraction(this.m_popupAuthDialog);
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Pragma", "No-Cache");
        uRLConnection.setRequestProperty("Content-Type", "Application/Octet-Stream");
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        return uRLConnection;
    }

    public byte[] readBytes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        this.readFully(dataInputStream, byArray);
        return byArray;
    }

    private void writeBeepStart(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeInt(0);
        ndrOutputStream.writeByte(77);
        ndrOutputStream.writeInt(6);
        ndrOutputStream.writeByte(83);
        ndrOutputStream.writeInt(1);
        ndrOutputStream.writeByte(67);
    }

    private void writeBeepClose(NdrOutputStream ndrOutputStream, int n) throws IOException {
        ndrOutputStream.writeInt(0);
        ndrOutputStream.writeByte(77);
        ndrOutputStream.writeInt(5);
        ndrOutputStream.writeByte(67);
        ndrOutputStream.writeInt(1);
        ndrOutputStream.writeInt(n);
    }

    private void writeBeepContentData(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeInt(1);
        ndrOutputStream.writeByte(77);
    }

    private String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(URLEncoder.encode(string), "+");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append("%20");
        }
        return stringBuffer.toString();
    }

    protected static InputStream safeGetInputStream(URLConnection uRLConnection) throws IOException {
        try {
            return uRLConnection.getInputStream();
        }
        catch (SecurityException securityException) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.logp(Level.FINEST, HybridPollingSender.class.getName(), "safeGetInputStream", "Requesting privilage for HTTP connection is not granted");
            }
            return null;
        }
    }

    public void createCiphers(byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = new byte[n];
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray2[n2] = 0;
        }
        n2 = n >= byArray.length ? 0 : byArray.length - n;
        int n3 = n < byArray.length ? n : byArray.length;
        System.arraycopy(byArray, n2, byArray2, n - n3, n3);
        this.m_signCipher = new RC2Cipher();
        this.m_signCipher.init(0, byArray2);
        this.m_encryptCipher = new RC2Cipher();
        this.m_encryptCipher.init(0, byArray2);
        this.m_decryptCipher = new RC2Cipher();
        this.m_decryptCipher.init(1, byArray2);
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.logp(Level.FINER, this.getClass().getName(), "createCiphers", "Initialized cipher with ");
            m_logger.logp(Level.FINER, this.getClass().getName(), "createCiphers", TkLogger.formatBytes(byArray2));
        }
    }

    public byte[] buildCompoundMessage() throws IOException {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        while (!this.m_queue.isEmpty()) {
            ndrOutputStream.write((byte[])this.m_queue.getNext());
        }
        return ndrOutputStream.toByteArray();
    }

    URLConnection openConnectionWithProxySettings(URL uRL) throws IOException {
        Object object;
        Object object2;
        block4: {
            if (StaticProps.m_JavaPlugIn && !this.m_popupAuthDialog) {
                try {
                    object2 = Class.forName("com.lotus.sametime.core.util.SimpleAuthenticator");
                    object = new Class[]{String.class, String.class};
                    Constructor<?> constructor = ((Class)object2).getConstructor((Class<?>)object);
                    Object[] objectArray = new Object[]{this.m_proxyUserName, this.m_proxyPass};
                    Object obj = constructor.newInstance(objectArray);
                    Method method = ((Class)object2).getMethod("setThisAsDefault", null);
                    method.invoke(obj, null);
                }
                catch (Exception exception) {
                    if (!m_logger.isLoggable(Level.FINEST)) break block4;
                    m_logger.logp(Level.FINEST, this.getClass().getName(), "openConnectionWithProxySettings", "Exception in loading SimpleAuthenticator: ", exception);
                }
            }
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (this.m_proxyUserName != null && !this.m_proxyUserName.equals("") && this.m_proxyPass != null && !this.m_proxyPass.equals("")) {
            object2 = this.m_proxyUserName + ":" + this.m_proxyPass;
            object = Base64Encoder.encode(((String)object2).getBytes());
            uRLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
            uRLConnection.setRequestProperty("Proxy-authorization", "Basic " + (String)object);
        }
        return uRLConnection;
    }

    private void setProxyProperties(String string, String string2) {
        if (!this.m_useWNet && !this.m_useSystemProxySettings) {
            Properties properties = System.getProperties();
            if (string == null) {
                properties.remove("http.proxyHost");
                properties.remove("http.proxyPort");
            } else {
                properties.put("http.proxyHost", string);
                properties.put("http.proxyPort", string2);
            }
        }
    }

    private void setProxyProperties(String string, short s) {
        this.setProxyProperties(string, Short.toString(s));
    }

    class InstreamWaiter
    extends Thread {
        DataInputStream m_inStream = null;
        IOException m_exception = null;
        URLConnection m_connection;

        InstreamWaiter(URLConnection uRLConnection) {
            this.m_connection = uRLConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.m_inStream = new DataInputStream(HybridPollingSender.safeGetInputStream(this.m_connection));
            }
            catch (IOException iOException) {
                this.m_exception = iOException;
            }
            InstreamWaiter instreamWaiter = this;
            synchronized (instreamWaiter) {
                this.notify();
            }
        }
    }
}

