/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class HttpInputStream
extends PipedInputStream
implements Runnable {
    private static final String THREAD_NAME = "Sis. Thelma Http Poller thread ";
    private static int c_threadCount = 0;
    private InputStream m_inStream = null;
    private PipedOutputStream m_pipeOutput;
    private Thread m_thread = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected HttpInputStream(InputStream inputStream) throws IOException {
        this.m_pipeOutput = new PipedOutputStream(this);
        this.m_inStream = inputStream;
        this.m_thread = new Thread((Runnable)this, THREAD_NAME + ++c_threadCount);
        this.m_thread.start();
    }

    public void run() {
        block5: {
            try {
                int n;
                while ((n = this.m_inStream.read()) != -1) {
                    this.m_pipeOutput.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.m_pipeOutput.close();
            }
            catch (IOException iOException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block5;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "run", "Couldn't close pipe: ", iOException);
            }
        }
    }

    protected void interruptReading() {
        block2: {
            this.m_thread.stop();
            try {
                this.m_pipeOutput.close();
            }
            catch (IOException iOException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block2;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "interruptReading", "Couldn't close pipe: ", iOException);
            }
        }
    }
}

