/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncExecutionQueue
implements Runnable {
    private static final String THREAD_NAME = "ST async execution thread";
    private static int s_threadCount = 0;
    private Thread m_asyncThread = null;
    private boolean _stopped = true;
    private LinkedList m_queue = new LinkedList();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util");

    public void start() {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "start", "AsyncExecutionQueue started");
        }
        if (this.m_asyncThread == null) {
            this._stopped = false;
            this.m_asyncThread = new Thread((Runnable)this, THREAD_NAME + ++s_threadCount);
            this.m_asyncThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "stop", "AsyncExecutionQueue stopped");
        }
        this._stopped = true;
        AsyncExecutionQueue asyncExecutionQueue = this;
        synchronized (asyncExecutionQueue) {
            this.notifyAll();
        }
    }

    protected void executeAll() {
        while (!this.m_queue.isEmpty()) {
            Runnable runnable = (Runnable)this.m_queue.remove(0);
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "AsyncExecutionQueue running");
        }
        while (!this._stopped) {
            AsyncExecutionQueue asyncExecutionQueue = this;
            synchronized (asyncExecutionQueue) {
                if (this.m_queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.executeAll();
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "AsyncExecutionQueue exiting");
        }
    }

    public synchronized void executeLater(Runnable runnable) {
        this.m_queue.add(runnable);
        this.notify();
    }
}

