/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.enc;

import com.lotus.sametime.community.kernel.enc.EncData;
import com.lotus.sametime.community.kernel.enc.EncMethod;
import com.lotus.sametime.community.kernel.enc.EncParams;
import com.lotus.sametime.community.kernel.enc.rc2_128.EncMethodRc2_128;
import com.lotus.sametime.community.kernel.enc.rc2_40.EncMethodRc2_40;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.util.Debug;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EncMngr {
    public static final short ENC_TYPE_RC2_40 = 0;
    public static final short ENC_TYPE_RC2_128 = 1;
    public static final int ENC_ERR_CODE_OK = 0;
    public static final int ENC_ERR_CODE_NOT_INITIALIZED = 1;
    public static final int ENC_ERR_CODE_TOO_WEAK = 2;
    public static final int ENC_ERR_CODE_BAD_ARG = 3;
    public static final int ENC_ERR_CODE_NO_METHOD = 4;
    private static int c_encError = 0;
    private static Logger m_logger = Logger.getLogger("com.lotus.sametime.community.kernel.enc");
    private static EncMethod[] c_encMethods = new EncMethod[]{new EncMethodRc2_40(), new EncMethodRc2_128()};

    public static int createRequest(EncData encData) {
        EncLevel encLevel = encData.getEncLevel();
        if (encLevel.isEqual(EncLevel.ENC_LEVEL_NONE)) {
            c_encError = 0;
            return 0;
        }
        encData.setParamsList(new Vector());
        Vector vector = encData.getParamsList();
        vector.removeAllElements();
        for (int i = 0; i < c_encMethods.length; ++i) {
            EncMethod encMethod = c_encMethods[i];
            EncLevel encLevel2 = encMethod.getLevel();
            if (encLevel2.isLower(encLevel)) continue;
            EncParams encParams = encMethod.newParams(encData);
            if (encMethod.getEncError() != 0) continue;
            vector.addElement(encParams);
        }
        c_encError = 0;
        if (vector.size() == 0) {
            if (encLevel.isEqual(EncLevel.ENC_LEVEL_DONT_CARE)) {
                encData.setEncLevel(EncLevel.ENC_LEVEL_NONE);
                encData.setMinAgreedLevel(EncLevel.ENC_LEVEL_NONE);
            } else {
                c_encError = 4;
            }
        }
        return c_encError;
    }

    public static int localizeRequest(EncLevel encLevel, EncData encData) {
        EncLevel encLevel2 = encData.getEncLevel();
        if (encLevel2.isEqual(EncLevel.ENC_LEVEL_NONE)) {
            if (encLevel.isEqual(EncLevel.ENC_LEVEL_DONT_CARE)) {
                encLevel = EncLevel.ENC_LEVEL_NONE;
            }
            if (!encLevel.isEqual(EncLevel.ENC_LEVEL_NONE)) {
                c_encError = 3;
                return 3;
            }
        }
        if (encLevel2.isEqual(EncLevel.ENC_LEVEL_DONT_CARE) && encLevel.isEqual(EncLevel.ENC_LEVEL_DONT_CARE)) {
            encLevel = EncLevel.ENC_LEVEL_NONE;
        }
        encData.setEncLevel(encLevel);
        if (encLevel.isEqual(EncLevel.ENC_LEVEL_NONE)) {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.logp(Level.FINER, EncMngr.class.getName(), "localizeRequest", "EncMngr.localizeRequest: Selected ENC_LEVEL_NONE");
            }
            encData.setMinAgreedLevel(EncLevel.ENC_LEVEL_NONE);
            c_encError = 0;
            return 0;
        }
        try {
            encData.readParamsList();
        }
        catch (IOException iOException) {
            c_encError = 3;
            return 3;
        }
        try {
            encData.readMinLevelAndForceFlag();
            if (!encLevel2.isEqual(encData.getMinAgreedLevel())) {
                Debug.stAssert(false);
                c_encError = 3;
                return 3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        encData.setMinAgreedLevel(EncLevel.max(encLevel2, encLevel));
        Vector vector = encData.getParamsList();
        boolean bl = false;
        EncMethod encMethod = null;
        EncParams encParams = null;
        encLevel2 = null;
        EncMethod encMethod2 = null;
        EncParams encParams2 = null;
        EncLevel encLevel3 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            encParams = (EncParams)enumeration.nextElement();
            encMethod = encParams.getEncMethod();
            encLevel2 = encMethod.getLevel();
            if (encLevel2.isLower(encLevel) || encLevel3 != null && !encLevel3.isLower(encLevel2)) continue;
            encMethod2 = encMethod;
            encParams2 = encParams;
            encLevel3 = encLevel2;
        }
        if (encMethod2 == null) {
            c_encError = 4;
            return 4;
        }
        EncParams encParams3 = encMethod2.localizeParams(encData, encParams2, false);
        encData.setRemoteParams(encParams2);
        encData.setLocalParams(encParams3);
        encData.setEncLevel(encMethod2.getLevel());
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.logp(Level.FINER, EncMngr.class.getName(), "localizeRequest", "EncMngr.localizeRequest: Selected method " + encMethod2);
        }
        c_encError = 0;
        return 0;
    }

    public static int localizeReply(EncLevel encLevel, EncData encData) throws IOException {
        EncLevel encLevel2 = encData.getEncLevel();
        Vector vector = encData.getParamsList();
        if (encLevel2.isEqual(EncLevel.ENC_LEVEL_NONE)) {
            if (encLevel.isEqual(EncLevel.ENC_LEVEL_NONE) || encLevel.isEqual(EncLevel.ENC_LEVEL_DONT_CARE)) {
                if (m_logger.isLoggable(Level.FINER)) {
                    m_logger.logp(Level.FINER, EncMngr.class.getName(), "localizeReply", "EncMngr.localizeReply: Selected ENC_LEVEL_NONE");
                }
                encData.setMinAgreedLevel(EncLevel.ENC_LEVEL_NONE);
                c_encError = 0;
                return 0;
            }
            c_encError = 4;
            return 4;
        }
        encData.readRemoteParams();
        try {
            encData.readMinLevelAndForceFlag();
            if (encData.getMinAgreedLevel().isLower(encLevel)) {
                Debug.stAssert(false);
                c_encError = 3;
                return 3;
            }
        }
        catch (IOException iOException) {
            encData.setMinAgreedLevel(encData.getEncLevel());
        }
        EncParams encParams = encData.getRemoteParams();
        EncMethod encMethod = encParams.getEncMethod();
        boolean bl = false;
        EncMethod encMethod2 = null;
        EncParams encParams2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            encParams2 = (EncParams)enumeration.nextElement();
            encMethod2 = encParams2.getEncMethod();
            if (encMethod2.getType() != encMethod.getType()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            c_encError = 4;
            return 4;
        }
        EncParams encParams3 = encMethod2.localizeParams(encData, encParams2, true);
        encData.setLocalParams(encParams3);
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.logp(Level.FINER, EncMngr.class.getName(), "localizeReply", "EncMngr.localizeReply: Selected method " + encMethod2);
        }
        c_encError = 0;
        return 0;
    }

    public static byte[] encrypt(byte[] byArray, EncData encData) {
        if (encData.getEncLevel().isEqual(EncLevel.ENC_LEVEL_NONE)) {
            c_encError = 0;
            return byArray;
        }
        EncParams encParams = encData.getLocalParams();
        if (encParams == null) {
            c_encError = 4;
            return null;
        }
        EncMethod encMethod = encParams.getEncMethod();
        byte[] byArray2 = encMethod.encrypt(byArray, encData);
        c_encError = encMethod.getEncError();
        return byArray2;
    }

    public static byte[] decrypt(byte[] byArray, EncData encData) {
        if (encData.getEncLevel().isEqual(EncLevel.ENC_LEVEL_NONE)) {
            c_encError = 0;
            return byArray;
        }
        EncParams encParams = encData.getRemoteParams();
        if (encParams == null) {
            c_encError = 4;
            return null;
        }
        EncMethod encMethod = encParams.getEncMethod();
        byte[] byArray2 = encMethod.decrypt(byArray, encData);
        c_encError = encMethod.getEncError();
        return byArray2;
    }

    public static EncMethod getEncMethod(int n) {
        for (int i = 0; i < c_encMethods.length; ++i) {
            EncMethod encMethod = c_encMethods[i];
            if (encMethod.getType() != n) continue;
            c_encError = 0;
            return encMethod;
        }
        c_encError = 4;
        return null;
    }

    public static int getEncError() {
        return c_encError;
    }
}

