/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community.kernel.connhandler;

import com.lotus.sametime.community.kernel.connhandler.CnlListenerTable;
import com.lotus.sametime.community.kernel.connhandler.CnlMsgListener;
import com.lotus.sametime.community.kernel.connhandler.MasterCnlListener;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgIn;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgMultiCast;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgMultiSendOnCnls;
import com.lotus.sametime.community.kernel.vpkmsg.VpkMsgOut;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.UtilLibrary;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionFactory;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionListener;
import com.lotus.sametime.core.util.connection.HttpConnection;
import com.lotus.sametime.core.util.connection.RC2Connection;
import com.lotus.sametime.core.util.connection.SocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionHandler
implements ConnectionListener {
    private static final int DEFAULT_ST_PORT = 1533;
    private static final int DEFAULT_HTTP_PORT = 8082;
    private static final long DEFAULT_CONNECT_TIME_OUT = 5000L;
    private static final long DEFAULT_KEEP_ALIVE_RATE = 60000L;
    private static final byte KEEP_ALIVE_MASK = -128;
    private static final byte[] KEEP_ALIVE_MESSAGE = new byte[]{-128};
    private static final int LENGTH_BYTES = 4;
    private static final int STATE_RECEIVE_FIRST_BYTE = 0;
    private static final int STATE_RECEIVE_LENGTH = 1;
    private static final int STATE_RECEIVE_MESSAGE = 2;
    private static final String CHANNEL_ID_PREFIX = "@C ";
    private Connection m_connection = null;
    private long m_keepAliveRate = 60000L;
    private Hashtable m_masterChannelListeners = new Hashtable();
    private CnlListenerTable m_channelListeners = new CnlListenerTable();
    private ConnectionFactory m_connectionFactory;
    private byte m_firstByte;
    private int m_receiveState = 0;
    private boolean m_encryptionRequired = false;
    private byte[] m_key = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.community.kernel.connhandler");

    public synchronized void setMasterCnlListener(int n, MasterCnlListener masterCnlListener) {
        Integer n2 = new Integer(n);
        this.m_masterChannelListeners.put(n2, masterCnlListener);
    }

    public synchronized void removeMasterCnlListener(int n) {
        Integer n2 = new Integer(n);
        MasterCnlListener masterCnlListener = (MasterCnlListener)this.m_masterChannelListeners.remove(n2);
        this.m_channelListeners.removeListener(masterCnlListener);
    }

    public synchronized void setListenerForCnl(int n, CnlMsgListener cnlMsgListener) {
        this.m_channelListeners.setListenerForCnl(n, cnlMsgListener);
    }

    public synchronized void removeListenerForCnl(int n) {
        this.m_channelListeners.removeListenerForCnl(n);
    }

    public synchronized void setKeepAliveRate(long l) {
        this.m_keepAliveRate = l;
        if (this.m_connection != null) {
            this.m_connection.setKeepAliveParams(l, KEEP_ALIVE_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String string, Connection[] connectionArray, VpkMsgOut vpkMsgOut) {
        Debug.stAssert(this.m_connection == null);
        if (this.m_connection != null) {
            return;
        }
        if (connectionArray == null) {
            connectionArray = this.createDefaultConnectionList();
        }
        this.m_keepAliveRate = this.m_keepAliveRate == -1L ? 60000L : this.m_keepAliveRate;
        this.m_receiveState = 0;
        this.setBytesToReceive(1);
        ConnectionHandler connectionHandler = this;
        synchronized (connectionHandler) {
            this.m_connectionFactory = new ConnectionFactory();
            this.m_connectionFactory.connect(connectionArray, string, this.toOpaque(vpkMsgOut), this);
        }
    }

    public synchronized void close(int n) {
        if (this.m_connectionFactory != null) {
            this.m_connectionFactory.cancelConnect();
        }
        if (this.m_connection != null) {
            this.m_connection.close(n);
            this.m_connection = null;
            this.m_key = null;
        }
    }

    public InetAddress getLocalAddress() {
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = this.getAllLocalAddresses();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        int n = 0;
        int n2 = UtilLibrary.intFromByteArray(inetAddressArray[n].getAddress());
        for (int i = 1; i < inetAddressArray.length; ++i) {
            int n3 = UtilLibrary.intFromByteArray(inetAddressArray[i].getAddress());
            if (n3 >= n2) continue;
            n2 = n3;
            n = i;
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getLocalAddress", "Local machine IP " + inetAddressArray[n]);
        }
        return inetAddressArray[n];
    }

    public synchronized boolean isReady() {
        return this.m_connection != null;
    }

    public synchronized boolean send(VpkMsgOut vpkMsgOut, byte by) {
        if (this.m_connection != null) {
            this.m_connection.sendMessage(this.toOpaque(vpkMsgOut), by);
            return true;
        }
        return false;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.m_connection == null ? null : this.m_connection.getConnectionInfo();
    }

    public void encryptConnection(byte[] byArray) {
        Debug.stAssert(this.m_key == null);
        if (this.m_key != null) {
            return;
        }
        this.m_key = byArray;
        if (this.m_receiveState == 0) {
            this.createEncryptedConnection();
        } else {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "encryptConnection", "defering encrypted connection to next receive.");
            }
            this.m_encryptionRequired = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionClosed(int n, Connection connection) {
        Object object = this;
        synchronized (object) {
            this.m_connection = null;
            this.m_connectionFactory = null;
        }
        object = (Hashtable)this.m_masterChannelListeners.clone();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            MasterCnlListener masterCnlListener = (MasterCnlListener)enumeration.nextElement();
            masterCnlListener.onConnectionClosed(n, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected(Connection connection) {
        Object object = this;
        synchronized (object) {
            this.m_connectionFactory = null;
            this.m_connection = connection;
            this.m_connection.setKeepAliveParams(this.m_keepAliveRate, KEEP_ALIVE_MESSAGE);
        }
        object = (Hashtable)this.m_masterChannelListeners.clone();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            MasterCnlListener masterCnlListener = (MasterCnlListener)enumeration.nextElement();
            masterCnlListener.onConnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectFailed() {
        Object object = this;
        synchronized (object) {
            this.m_connectionFactory = null;
        }
        object = (Hashtable)this.m_masterChannelListeners.clone();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            MasterCnlListener masterCnlListener = (MasterCnlListener)enumeration.nextElement();
            masterCnlListener.onConnectFailed(this);
        }
    }

    public void onProtocolErrorOccured() {
        Hashtable hashtable = (Hashtable)this.m_masterChannelListeners.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            MasterCnlListener masterCnlListener = (MasterCnlListener)enumeration.nextElement();
            masterCnlListener.onProtocolErrorOccured(this);
        }
    }

    public void onReceive(byte[] byArray, Connection connection) {
        if (this.m_connection == null) {
            return;
        }
        switch (this.m_receiveState) {
            case 0: {
                Debug.stAssert(byArray.length == 1);
                if ((byArray[0] & 0xFFFFFF80) != 0) break;
                this.m_firstByte = byArray[0];
                this.m_receiveState = 1;
                this.setBytesToReceive(3);
                break;
            }
            case 1: {
                Debug.stAssert(byArray.length == 3);
                int n = this.m_firstByte & 0xFF;
                for (int i = 0; i < byArray.length; ++i) {
                    n = n << 8 | byArray[i] & 0xFF;
                }
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onReceive", "Expected message length = " + n);
                }
                this.m_receiveState = 2;
                this.setBytesToReceive(n);
                break;
            }
            case 2: {
                try {
                    VpkMsgIn vpkMsgIn = new VpkMsgIn(byArray);
                    this.m_receiveState = 0;
                    this.setBytesToReceive(1);
                    this.dispatchMessage(vpkMsgIn);
                }
                catch (IOException iOException) {
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, this.getClass().getName(), "onReceive", "ConnHandler: error dispatching message: ", iOException);
                    }
                    this.onProtocolErrorOccured();
                }
                if (!this.m_encryptionRequired) break;
                this.createEncryptedConnection();
                this.m_encryptionRequired = false;
                break;
            }
            default: {
                Debug.stAssert(false);
            }
        }
    }

    public byte[] toOpaque(VpkMsgOut vpkMsgOut) {
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            ndrOutputStream.writeBytes(vpkMsgOut.toByteArray());
            return ndrOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
            return null;
        }
    }

    private synchronized void setBytesToReceive(int n) {
        if (this.m_connection != null) {
            this.m_connection.setBytesToReceive(n);
        }
    }

    private void dispatchMessage(VpkMsgIn vpkMsgIn) throws IOException {
        int n = vpkMsgIn.getChannelId();
        CnlMsgListener cnlMsgListener = null;
        switch (vpkMsgIn.getType()) {
            case -32768: 
            case -32767: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 37: 
            case 38: {
                Integer n2 = new Integer(n);
                cnlMsgListener = (CnlMsgListener)this.m_masterChannelListeners.get(n2);
                break;
            }
            case 4: 
            case 6: {
                cnlMsgListener = this.m_channelListeners.getListenerForChannel(n);
                break;
            }
            case 3: {
                cnlMsgListener = this.m_channelListeners.getListenerForChannel(n);
                if (cnlMsgListener != null) break;
                Integer n3 = new Integer(n);
                cnlMsgListener = (CnlMsgListener)this.m_masterChannelListeners.get(n3);
                break;
            }
            case 5: {
                this.dispatchMultiSendOnChannels(vpkMsgIn);
                return;
            }
            case 25: {
                Hashtable hashtable = (Hashtable)this.m_masterChannelListeners.clone();
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    cnlMsgListener = (CnlMsgListener)enumeration.nextElement();
                    cnlMsgListener.onReceive((VpkMsgIn)vpkMsgIn.clone());
                }
                return;
            }
            case 34: {
                Debug.stAssert(n == 0);
                this.dispatchMultiCast(vpkMsgIn);
                return;
            }
            default: {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "dispatchMessage", "ConnectionHandler: Unknown message type " + vpkMsgIn.getType());
                }
                return;
            }
        }
        if (cnlMsgListener != null) {
            cnlMsgListener.onReceive(vpkMsgIn);
        } else if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "dispatchMessage", "Message received on a non-existing channel: " + vpkMsgIn);
        }
    }

    private void dispatchMultiCast(VpkMsgIn vpkMsgIn) throws IOException {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "dispatchMultiCast", "ConnectionHandler: Got MultiCast message");
        }
        boolean bl = vpkMsgIn.readBoolean();
        Debug.stAssert(bl);
        STUserInstance sTUserInstance = new STUserInstance(vpkMsgIn);
        short s = vpkMsgIn.readShort();
        byte[] byArray = vpkMsgIn.readBytes();
        int[] nArray = new int[vpkMsgIn.readInt()];
        for (int i = 0; i < nArray.length; ++i) {
            String string = vpkMsgIn.readUTF();
            if (string.toUpperCase().startsWith(CHANNEL_ID_PREFIX)) {
                try {
                    Integer n = Integer.valueOf(string.substring(3), 16);
                    this.sendMultiCastMsgToListeners(n, sTUserInstance, s, byArray);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!this.m_logger.isLoggable(Level.FINER)) continue;
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "dispatchMultiCast", "MultiCast Message", numberFormatException);
                }
                continue;
            }
            if (!this.m_logger.isLoggable(Level.FINER)) continue;
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "dispatchMultiCast", "Invalid MultiCast Channel id: " + string);
        }
    }

    private void sendMultiCastMsgToListeners(Integer n, STUserInstance sTUserInstance, short s, byte[] byArray) throws IOException {
        CnlMsgListener cnlMsgListener = (CnlMsgListener)this.m_masterChannelListeners.get(n);
        VpkMsgMultiCast vpkMsgMultiCast = new VpkMsgMultiCast((int)n, sTUserInstance, s, byArray);
        cnlMsgListener.onReceive(new VpkMsgIn(vpkMsgMultiCast.toByteArray()));
    }

    private void dispatchMultiSendOnChannels(VpkMsgIn vpkMsgIn) throws IOException {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "dispatchMultiSendOnChannels", "ConnectionHandler: Got multi-Send message");
        }
        int n = vpkMsgIn.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = vpkMsgIn.readInt();
        }
        byte[] byArray = new byte[vpkMsgIn.available()];
        vpkMsgIn.readFully(byArray);
        Hashtable hashtable = this.m_channelListeners.splitChListByListener(nArray);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            CnlMsgListener cnlMsgListener = (CnlMsgListener)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(cnlMsgListener);
            VpkMsgIn vpkMsgIn2 = this.createMultiSendOnChannelMsg(vector, byArray);
            cnlMsgListener.onReceive(vpkMsgIn2);
        }
    }

    private VpkMsgIn createMultiSendOnChannelMsg(Vector vector, byte[] byArray) {
        VpkMsgIn vpkMsgIn = null;
        try {
            VpkMsgMultiSendOnCnls vpkMsgMultiSendOnCnls = new VpkMsgMultiSendOnCnls(vector, byArray);
            byte[] byArray2 = vpkMsgMultiSendOnCnls.toByteArray();
            vpkMsgIn = new VpkMsgIn(byArray2);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        return vpkMsgIn;
    }

    private Connection[] createDefaultConnectionList() {
        Connection[] connectionArray = new Connection[]{new SocketConnection(1533, 5000L), new HttpConnection(8082, 5000L)};
        return connectionArray;
    }

    private InetAddress[] getAllLocalAddresses() throws UnknownHostException {
        try {
            InetAddress[] inetAddressArray;
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostName();
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "getAllLocalAddresses", "Local Machine name = " + string);
            }
            if ((inetAddressArray = InetAddress.getAllByName(string)) == null || inetAddressArray.length == 0) {
                throw new UnknownHostException("Couldn't lookup " + string);
            }
            return inetAddressArray;
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException) {
                throw (UnknownHostException)exception;
            }
            throw new UnknownHostException("Exception during lookup: " + exception);
        }
    }

    private void createEncryptedConnection() {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "createEncryptedConnection", "ConnectionHandler: encrypting connection");
        }
        this.m_connection = new RC2Connection(this.m_connection, this.m_key);
    }

    public Connection getConnection() {
        return this.m_connection;
    }
}

