/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community;

import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.STBase;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class Channel {
    private Integer m_channelId;
    private STBase m_vpBase;
    private Vector m_listenerList = new Vector();
    private int m_serviceType = -1;
    private int m_prType = -1;
    private int m_prVersion = -1;
    private EncLevel m_encLevel;
    private byte[] m_createData;
    private STUserInstance m_remoteInfo;
    private STId m_toId;
    private boolean m_isOpen = false;
    private boolean m_isPending = false;
    private boolean m_isReceived = false;
    private byte m_priority = (byte)7;
    private STUserInstance m_creator = null;
    private STUser m_toUser;

    protected Channel(STBase sTBase, int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STId sTId, byte by) {
        this.m_vpBase = sTBase;
        this.m_serviceType = n;
        this.m_prType = n2;
        this.m_prVersion = n3;
        this.m_encLevel = encLevel;
        this.m_createData = byArray;
        this.m_toId = sTId;
        this.m_priority = by;
        this.m_creator = null;
    }

    protected Channel(STBase sTBase, int n, int n2, int n3, EncLevel encLevel, byte[] byArray, STId sTId, byte by, STUserInstance sTUserInstance) {
        this.m_vpBase = sTBase;
        this.m_serviceType = n;
        this.m_prType = n2;
        this.m_prVersion = n3;
        this.m_encLevel = encLevel;
        this.m_createData = byArray;
        this.m_toId = sTId;
        this.m_priority = by;
        this.m_creator = sTUserInstance;
    }

    protected Channel(STBase sTBase, ChannelEvent channelEvent) {
        Debug.stAssert(channelEvent.getId() == -2147483646);
        this.m_vpBase = sTBase;
        this.m_channelId = channelEvent.getChannelId();
        this.m_serviceType = channelEvent.getServiceType();
        this.m_prType = channelEvent.getProtocolType();
        this.m_prVersion = channelEvent.getProtocolVersion();
        this.m_encLevel = channelEvent.getEncLevel();
        this.m_createData = channelEvent.getData();
        this.m_remoteInfo = channelEvent.getRemoteInfo();
        this.m_toId = this.m_remoteInfo.getId();
        this.m_priority = channelEvent.getPriority();
        this.m_toUser = channelEvent.getToUser();
        this.m_isPending = true;
        this.m_isReceived = false;
    }

    public synchronized void addChannelListener(ChannelListener channelListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.addElement(channelListener);
        this.m_listenerList = vector;
    }

    public synchronized void removeChannelListener(ChannelListener channelListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.removeElement(channelListener);
        this.m_listenerList = vector;
    }

    public synchronized void open() {
        Debug.stAssert(this.m_channelId == null);
        this.m_channelId = STCompPart.getUniqueId();
        this.m_vpBase.createChannel(this, this.m_toId, this.m_serviceType, this.m_prType, this.m_prVersion, this.m_encLevel, this.m_createData, 0, this.m_priority, this.m_creator);
    }

    public void accept(EncLevel encLevel, byte[] byArray) {
        this.accept(encLevel, byArray, (byte)7);
    }

    public void accept(EncLevel encLevel, byte[] byArray, STUserInstance sTUserInstance) {
        this.accept(encLevel, byArray, (byte)7, sTUserInstance);
    }

    public synchronized void accept(EncLevel encLevel, byte[] byArray, byte by) {
        this.accept(encLevel, byArray, by, null);
    }

    public synchronized void accept(EncLevel encLevel, byte[] byArray, byte by, STUserInstance sTUserInstance) {
        Debug.stAssert(this.m_channelId != null);
        if (by > this.m_priority && by <= 15) {
            this.m_priority = by;
        }
        this.m_isPending = false;
        this.m_isReceived = true;
        this.m_vpBase.acceptChannel(this, this.m_serviceType, this.m_prType, this.m_prVersion, encLevel, byArray, this.m_remoteInfo, this.m_priority, sTUserInstance);
    }

    public synchronized void sendMsg(short s, byte[] byArray, boolean bl) {
        Debug.stAssert(this.m_channelId != null);
        this.m_vpBase.sendOnChannel(this, s, byArray, bl);
    }

    public synchronized void close(int n, byte[] byArray) {
        Debug.stAssert(this.m_channelId != null);
        this.m_isPending = false;
        this.m_isReceived = true;
        this.m_vpBase.destroyChannel(this, n, byArray);
    }

    public void pend() {
        this.m_isReceived = true;
    }

    protected void channelCreated(ChannelEvent channelEvent) {
        this.m_serviceType = channelEvent.getServiceType();
        this.m_prType = channelEvent.getProtocolType();
        this.m_prVersion = channelEvent.getProtocolVersion();
        this.m_encLevel = channelEvent.getEncLevel();
        this.m_createData = channelEvent.getData();
        this.m_remoteInfo = channelEvent.getRemoteInfo();
        this.m_priority = channelEvent.getPriority();
        this.m_isOpen = true;
        channelEvent.setSource(this);
        channelEvent.setChannel(this);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ChannelListener channelListener = (ChannelListener)enumeration.nextElement();
            channelListener.channelOpened(channelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelDestroyed(ChannelEvent channelEvent) {
        Object object;
        boolean bl = this.m_isOpen;
        this.m_isOpen = false;
        this.m_isPending = false;
        channelEvent.setSource(this);
        channelEvent.setChannel(this);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ChannelListener)enumeration.nextElement();
            if (bl) {
                object.channelClosed(channelEvent);
                continue;
            }
            object.channelOpenFailed(channelEvent);
        }
        object = this;
        synchronized (object) {
            this.m_channelId = null;
        }
    }

    protected void channelSent(ChannelEvent channelEvent) {
        channelEvent.setSource(this);
        channelEvent.setChannel(this);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ChannelListener channelListener = (ChannelListener)enumeration.nextElement();
            channelListener.channelMsgReceived(channelEvent);
        }
    }

    protected Integer getChannelId() {
        return this.m_channelId;
    }

    public int getServiceType() {
        return this.m_serviceType;
    }

    public int getProtocolType() {
        return this.m_prType;
    }

    public int getProtocolVersion() {
        return this.m_prVersion;
    }

    public void setProtocolVersion(int n) {
        if (this.m_prVersion > n) {
            this.m_prVersion = n;
        }
    }

    public EncLevel getEncLevel() {
        return this.m_encLevel;
    }

    public byte[] getCreateData() {
        return this.m_createData;
    }

    public STUserInstance getRemoteInfo() {
        return this.m_remoteInfo;
    }

    public boolean isOpen() {
        return this.m_isOpen;
    }

    public boolean isPending() {
        return this.m_isPending;
    }

    protected boolean isReceived() {
        return this.m_isReceived;
    }

    public byte getPriority() {
        return this.m_priority;
    }

    public STUser getToUser() {
        return this.m_toUser;
    }

    public STUserInstance getCreator() {
        return this.m_creator;
    }
}

