/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.community;

import com.lotus.sametime.community.AwarenessPermissionEvent;
import com.lotus.sametime.community.AwarenessPermissionListener;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.community.MyPrivacyEvent;
import com.lotus.sametime.community.MyPrivacyListener;
import com.lotus.sametime.community.STBase;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STPrivacyList;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.UtilLibrary;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AwarenessPermissionManager
implements MyPrivacyListener {
    private Vector m_listeners = new Vector();
    private STBase m_vpBase;

    AwarenessPermissionManager(STBase sTBase) {
        this.m_vpBase = sTBase;
        Login login = sTBase.getLogin();
        login.addMyPrivacyListener(this);
    }

    public synchronized void addAwarenessPermissionListener(AwarenessPermissionListener awarenessPermissionListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(awarenessPermissionListener);
        this.m_listeners = vector;
    }

    public synchronized void removeAwarenessPermissionListener(AwarenessPermissionListener awarenessPermissionListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(awarenessPermissionListener);
        this.m_listeners = vector;
    }

    public void requestAwarenessPermission(STUser[] sTUserArray) {
        this.requestVisibility(sTUserArray);
    }

    public void cancelAwarenessPermissionRequest(STUser[] sTUserArray) {
        this.cancelVisibility(sTUserArray);
    }

    public void acceptAwarenessPermissionRequest(STUser sTUser) {
        STPrivacyList sTPrivacyList = this.m_vpBase.getPrivacy();
        if (sTPrivacyList.getRequestors().containsKey(sTUser.getId())) {
            STUser[] sTUserArray = new STUser[]{sTUser};
            this.requestVisibility(sTUserArray);
        }
    }

    public void declineAwarenessPermissionRequest(STUser sTUser) {
        STPrivacyList sTPrivacyList = this.m_vpBase.getPrivacy();
        if (sTPrivacyList.getRequestors().containsKey(sTUser.getId())) {
            STUser[] sTUserArray = new STUser[]{sTUser};
            this.cancelVisibility(sTUserArray);
        }
    }

    private void requestVisibility(STUser[] sTUserArray) {
        Serializable serializable;
        STPrivacyList sTPrivacyList = this.m_vpBase.getPrivacy();
        Hashtable<STId, STUser> hashtable = new Hashtable<STId, STUser>();
        for (int i = 0; i < sTUserArray.length; ++i) {
            serializable = sTUserArray[i];
            hashtable.put(serializable.getId(), (STUser)serializable);
        }
        Hashtable hashtable2 = UtilLibrary.joinTables(sTPrivacyList.getPeople(), hashtable);
        serializable = new Hashtable();
        STPrivacyList sTPrivacyList2 = new STPrivacyList(sTPrivacyList.isExcluding(), hashtable2, hashtable, (Hashtable)serializable);
        this.m_vpBase.setPrivacy(sTPrivacyList2);
    }

    private void cancelVisibility(STUser[] sTUserArray) {
        Serializable serializable;
        STPrivacyList sTPrivacyList = this.m_vpBase.getPrivacy();
        Hashtable<STId, STUser> hashtable = new Hashtable<STId, STUser>();
        for (int i = 0; i < sTUserArray.length; ++i) {
            serializable = sTUserArray[i];
            hashtable.put(serializable.getId(), (STUser)serializable);
        }
        Hashtable hashtable2 = UtilLibrary.subtractTables(sTPrivacyList.getPeople(), hashtable);
        serializable = new Hashtable();
        STPrivacyList sTPrivacyList2 = new STPrivacyList(sTPrivacyList.isExcluding(), hashtable2, (Hashtable)serializable, hashtable);
        this.m_vpBase.setPrivacy(sTPrivacyList2);
    }

    protected void processAwarenessPermissionsEvent(AwarenessPermissionEvent awarenessPermissionEvent) {
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessPermissionListener awarenessPermissionListener = (AwarenessPermissionListener)enumeration.nextElement();
            switch (awarenessPermissionEvent.getId()) {
                case -2147483647: {
                    awarenessPermissionEvent.setSource(this);
                    awarenessPermissionListener.AwarenessPermissionRequest(awarenessPermissionEvent);
                    awarenessPermissionEvent.setConsumed(true);
                    break;
                }
                case -2147483645: {
                    awarenessPermissionEvent.setSource(this);
                    awarenessPermissionListener.AwarenessPermissionRequestCanceled(awarenessPermissionEvent);
                    awarenessPermissionEvent.setConsumed(true);
                }
            }
        }
    }

    public void changeMyPrivacyDenied(MyPrivacyEvent myPrivacyEvent) {
        Vector vector = this.m_listeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessPermissionListener awarenessPermissionListener = (AwarenessPermissionListener)enumeration.nextElement();
            awarenessPermissionListener.AwarenessPermissionRequestFailed(new AwarenessPermissionEvent((Object)this, -2147483644, myPrivacyEvent.getReason()));
        }
    }

    public void myPrivacyChanged(MyPrivacyEvent myPrivacyEvent) {
    }
}

