/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.awarenessui.list.AwarenessList;
import com.lotus.sametime.commui.ResolveListController;
import com.lotus.sametime.commui.ResolveListListener;
import com.lotus.sametime.commui.ResolveViewEvent;
import com.lotus.sametime.commui.ResolveViewListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.lookup.LookupService;
import com.lotus.sametime.lookup.ResolveEvent;
import com.lotus.sametime.lookup.ResolveListener;
import com.lotus.sametime.lookup.Resolver;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;

public class ResolvePanel
extends Panel {
    private STSession m_session;
    private Resolver m_resolver;
    private AwarenessList m_list;
    private Button m_btnSearch;
    private STTextField m_tfName;
    private STBundle m_resource;
    private String m_originalName;
    private Vector m_listeners = new Vector();

    public ResolvePanel(STSession sTSession, STUser[] sTUserArray, String string) {
        this.m_session = sTSession;
        this.m_resource = ((ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/commui");
        this.init(false);
        this.showMatches(string, sTUserArray);
        this.m_tfName.setText(string);
        this.m_tfName.setEnabled(false);
        this.m_btnSearch.setEnabled(false);
    }

    public ResolvePanel(STSession sTSession) {
        this.m_session = sTSession;
        this.m_resource = ((ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/commui");
        LookupService lookupService = (LookupService)this.m_session.getCompApi("com.lotus.sametime.lookup.LookupComp");
        Debug.stAssert(lookupService != null);
        this.m_resolver = lookupService.createResolver(false, true, true, false);
        this.m_resolver.addResolveListener(new ResolveListener(){

            public void resolveFailed(ResolveEvent resolveEvent) {
                ResolvePanel.this.resolveFailed(resolveEvent);
            }

            public void resolveConflict(ResolveEvent resolveEvent) {
                ResolvePanel.this.resolveConflict(resolveEvent);
            }

            public void resolved(ResolveEvent resolveEvent) {
                ResolvePanel.this.resolved(resolveEvent);
            }
        });
        this.init(true);
    }

    private void init(boolean bl) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResolvePanel.this.actionPerformed(actionEvent);
            }
        };
        String string = this.m_resource.getString("BTN_LBL_SEARCH");
        String[] stringArray = new String[]{string};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, actionListener);
        this.m_btnSearch = buttonsPanel.getButton(string);
        this.m_tfName = new STTextField();
        this.m_list = new AwarenessList(this.m_session, true);
        ResolveListListener resolveListListener = new ResolveListListener(){

            public void stObjectSelected(String string, STObject sTObject) {
                ResolvePanel.this.stObjectSelected(string, sTObject);
            }
        };
        this.m_list.setController(new ResolveListController(this.m_list, resolveListListener));
        this.m_tfName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ResolvePanel.this.keyPressed(keyEvent);
            }
        });
        this.setLayout(new BorderLayout(3, 10));
        this.setBackground(SystemColor.control);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 0));
        panel.add((Component)this.m_tfName, "Center");
        panel.add((Component)buttonsPanel, "East");
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", new Label(this.m_resource.getString("LBL_SEARCH_PANEL")));
        panel2.add("Center", panel);
        if (bl) {
            this.add("North", panel2);
        } else {
            this.add("North", new Label(this.m_resource.getString("LBL_SELECT_USER")));
        }
        this.add("Center", this.m_list);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_tfName.setBackground(Color.white);
    }

    public void cleanUp() {
        this.m_list.dispose();
        this.m_listeners.removeAllElements();
    }

    protected void resolved(ResolveEvent resolveEvent) {
        this.stObjectSelected(resolveEvent.getName(), resolveEvent.getResolved());
    }

    protected void resolveConflict(ResolveEvent resolveEvent) {
        STObject[] sTObjectArray = resolveEvent.getResolvedList();
        STUser[] sTUserArray = new STUser[sTObjectArray.length];
        for (int i = 0; i < sTUserArray.length; ++i) {
            sTUserArray[i] = (STUser)sTObjectArray[i];
        }
        this.showMatches(resolveEvent.getName(), sTUserArray);
    }

    protected void resolveFailed(ResolveEvent resolveEvent) {
        String[] stringArray = resolveEvent.getFailedNames();
        Debug.stAssert(stringArray.length == 1);
        ResolveViewEvent resolveViewEvent = new ResolveViewEvent((Object)this, stringArray[0], resolveEvent.getReason());
        this.sendEvent(resolveViewEvent);
    }

    protected void stObjectSelected(String string, STObject sTObject) {
        if (string == null) {
            string = this.m_originalName;
        }
        this.m_list.reset();
        this.m_tfName.setText("");
        ResolveViewEvent resolveViewEvent = new ResolveViewEvent((Object)this, string, (STUser)sTObject);
        this.sendEvent(resolveViewEvent);
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnSearch) {
            this.searchClicked();
        }
    }

    protected void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.searchClicked();
        }
    }

    protected void searchClicked() {
        String string = this.m_tfName.getText();
        if (string == null || string.equals("")) {
            return;
        }
        this.m_list.reset();
        this.m_resolver.resolve(string);
    }

    protected void showMatches(String string, STUser[] sTUserArray) {
        this.m_list.addUsers(sTUserArray);
        this.m_originalName = string;
    }

    public void addResolveViewListener(ResolveViewListener resolveViewListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(resolveViewListener);
        this.m_listeners = vector;
    }

    public void removeResolveViewListener(ResolveViewListener resolveViewListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(resolveViewListener);
        this.m_listeners = vector;
    }

    protected void sendEvent(ResolveViewEvent resolveViewEvent) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ResolveViewListener resolveViewListener = (ResolveViewListener)enumeration.nextElement();
            switch (resolveViewEvent.getId()) {
                case 2: {
                    resolveViewListener.resolveFailed(resolveViewEvent);
                    break;
                }
                case 1: {
                    resolveViewListener.resolved(resolveViewEvent);
                }
            }
        }
    }
}

