/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.invitation;

import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.awarenessui.AwarenessViewListener;
import com.lotus.sametime.awarenessui.av.CapabilitiesList;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.chatui.invitation.InviteDialogListener;
import com.lotus.sametime.commui.AddDialog;
import com.lotus.sametime.commui.ResolveViewEvent;
import com.lotus.sametime.commui.ResolveViewListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.GroupPanel;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.misc.UbqDialogListener;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class InviteDialog
extends Dialog
implements WindowListener,
ActionListener,
TextListener,
ResolveViewListener,
AwarenessViewListener,
LoginListener,
UbqDialogListener,
ItemListener {
    private STSession m_session;
    CommunityService m_community;
    private InviteDialogListener m_listener;
    private CapabilitiesList m_lstPeople;
    private AddDialog m_dlgAdd = null;
    private STBundle m_res;
    private int m_meetingNameMax;
    private int m_inviteMax;
    private STUser m_loggedInUser = null;
    private Button m_btnSend;
    private Button m_btnCancel;
    private Button m_btnAdd;
    private STTextField m_tfMeetingName;
    private TextArea m_taInviteText;
    private boolean m_isTabFromTA = false;
    private Checkbox m_cbSecureMeeting;
    private Checkbox m_cbAudioBridge;
    private Checkbox m_cbChat;
    private Checkbox m_cbVideo;
    private Checkbox m_cbAudio;
    private Checkbox m_cbBoard;
    private Checkbox m_cbShare;
    private String m_meetingName;
    private boolean m_allowChange;
    private Dimension m_smallDialog;
    private Dimension m_largeDialog;
    private Frame m_parentFrame;

    public InviteDialog(Frame frame, STSession sTSession) {
        this(frame, sTSession, "", "", EncLevel.ENC_LEVEL_NONE, null, null, true);
    }

    public InviteDialog(Frame frame, STSession sTSession, String string, String string2, EncLevel encLevel, STUser[] sTUserArray, Vector vector, boolean bl) {
        super(frame);
        this.m_session = sTSession;
        this.m_parentFrame = frame;
        this.m_res = ((ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/chatui");
        this.m_inviteMax = this.m_res.getInt("INVITATION_MAXLENGTH");
        this.m_meetingNameMax = this.m_res.getInt("MEETING_NAME_MAXLENGTH");
        this.m_meetingName = string;
        this.m_allowChange = bl;
        this.m_community = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        STUserInstance sTUserInstance = this.m_community.getLogin().getMyUserInstance();
        Debug.stAssert(sTUserInstance != null);
        String string3 = sTUserInstance.getName();
        this.m_loggedInUser = sTUserInstance;
        this.m_community.addLoginListener(this);
        if (string == null || string.length() == 0) {
            string = this.m_res.formatString("DEFAULT_MEETING_NAME", string3);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = this.m_res.getString("DEFAULT_INVITATION");
        }
        this.init(frame, string, string2, encLevel, vector);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.m_taInviteText.addTextListener(this);
        this.m_tfMeetingName.addTextListener(this);
        this.m_lstPeople.addAwarenessViewListener(this);
        this.addWindowListener(this);
        if (sTUserArray != null) {
            this.m_lstPeople.addUsers(sTUserArray);
        }
        if (sTUserArray != null && sTUserArray.length == 1) {
            this.checkExternalUser(sTUserArray[0]);
        }
    }

    void checkExternalUser(STUser sTUser) {
        if (sTUser.isExternalUser()) {
            this.m_btnAdd.setEnabled(false);
            this.m_cbChat.setState(false);
            this.m_cbChat.setEnabled(false);
            this.m_cbAudioBridge.setEnabled(false);
            this.m_cbShare.setState(false);
            this.m_cbShare.setEnabled(false);
            this.m_cbBoard.setState(false);
            this.m_cbBoard.setEnabled(false);
            this.m_cbSecureMeeting.setState(false);
            this.m_cbSecureMeeting.setEnabled(false);
        }
    }

    public void setListener(InviteDialogListener inviteDialogListener) {
        this.m_listener = inviteDialogListener;
    }

    public Insets getInsets() {
        Insets insets = (Insets)super.getInsets().clone();
        insets.top += 10;
        insets.bottom += 10;
        insets.left += 10;
        insets.right += 10;
        return insets;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnCancel) {
            this.cancelDialog();
        } else if (actionEvent.getSource() == this.m_btnAdd) {
            this.showAddDialog();
        } else if (actionEvent.getSource() == this.m_btnSend) {
            this.sendInvitation();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.cancelDialog();
        }
        if (this.m_dlgAdd != null) {
            this.m_dlgAdd.setVisible(false);
            this.m_dlgAdd = null;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.m_dlgAdd) {
            this.m_dlgAdd = null;
            this.toFront();
            this.m_btnSend.requestFocus();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.m_tfMeetingName && this.m_tfMeetingName.getText().length() > this.m_meetingNameMax) {
            String string = this.m_tfMeetingName.getText();
            String string2 = string.substring(0, string.length() - 1);
            this.m_tfMeetingName.setText(string2);
            this.m_tfMeetingName.setCaretPosition(this.m_meetingNameMax);
        } else if (textEvent.getSource() == this.m_taInviteText && this.m_taInviteText.getText().length() > this.m_inviteMax) {
            String string = this.m_taInviteText.getText();
            String string3 = string.substring(0, string.length() - 1);
            this.m_taInviteText.setText(string3);
            this.m_taInviteText.setCaretPosition(this.m_inviteMax);
        }
    }

    public void resolved(ResolveViewEvent resolveViewEvent) {
        STUser[] sTUserArray = new STUser[]{resolveViewEvent.getUser()};
        this.m_lstPeople.addUsers(sTUserArray);
    }

    public void resolveFailed(ResolveViewEvent resolveViewEvent) {
        String[] stringArray;
        Object object;
        Object[] objectArray = new Object[]{resolveViewEvent.getResolvedName()};
        if (resolveViewEvent.getReason() == -2147483645) {
            object = new String[]{this.m_res.getString("NOT_AUTHORIZED")};
            stringArray = object;
        } else {
            stringArray = this.m_res.formatStringArray("USER_NOT_FOUND", objectArray);
        }
        object = new UbqDialog(this.m_parentFrame);
        String string = this.m_res.getString("ALERT_TITLE");
        String[] stringArray2 = new String[]{this.m_res.getString("BTN_LBL_OK")};
        ((UbqDialog)object).resetDialog(string, stringArray, stringArray2, false, "");
        ((UbqDialog)object).addListener(this);
        ((Dialog)object).setModal(false);
        ((UbqDialog)object).setVisible(true);
    }

    public void statusChanged(AwarenessViewEvent awarenessViewEvent) {
    }

    public void usersRemoved(AwarenessViewEvent awarenessViewEvent) {
        if (this.m_lstPeople.getItems().length == 0) {
            this.m_btnSend.setEnabled(false);
        }
    }

    public void usersAdded(AwarenessViewEvent awarenessViewEvent) {
        this.m_btnSend.setEnabled(true);
    }

    public void addUserFailed(AwarenessViewEvent awarenessViewEvent) {
    }

    public void selectionChanged(AwarenessViewEvent awarenessViewEvent) {
    }

    public void serviceAvailable(AwarenessViewEvent awarenessViewEvent) {
    }

    public void serviceUnavailable(AwarenessViewEvent awarenessViewEvent) {
    }

    public void loggedIn(LoginEvent loginEvent) {
        STUserInstance sTUserInstance = this.m_community.getLogin().getMyUserInstance();
        STUserInstance sTUserInstance2 = sTUserInstance;
        if (!sTUserInstance2.equals(this.m_loggedInUser)) {
            this.dispose();
        } else {
            this.m_btnAdd.setEnabled(true);
            this.m_btnSend.setEnabled(this.m_lstPeople.getItems().length > 0);
        }
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_btnAdd.setEnabled(false);
        this.m_btnSend.setEnabled(false);
        if (this.m_dlgAdd != null) {
            this.m_dlgAdd.setVisible(false);
            this.m_dlgAdd = null;
        }
    }

    public void ubqDialogClosed(UbqDialog ubqDialog, int n, boolean bl) {
        if (this.m_dlgAdd != null) {
            this.m_dlgAdd.toFront();
            this.m_dlgAdd.requestFocus();
        }
    }

    protected void init(Frame frame, String string, String string2, EncLevel encLevel, Vector vector) {
        this.setTitle(this.m_res.getString("INVITE_DIALOG_TITLE"));
        this.setBackground(SystemColor.control);
        this.setFont(this.m_res.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE"));
        this.m_largeDialog = new Dimension(this.m_res.getInt("INVITE_DIALOG_WIDTH"), this.m_res.getInt("INVITE_DIALOG_HEIGHT"));
        this.m_smallDialog = new Dimension(this.m_res.getInt("SMALL_INVITE_DIALOG_WIDTH"), this.m_res.getInt("SMALL_INVITE_DIALOG_HEIGHT"));
        this.m_taInviteText = new TextArea(string2, 2, 30, 1);
        this.m_taInviteText.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\t') {
                    String string = InviteDialog.this.m_taInviteText.getText();
                    InviteDialog.this.m_taInviteText.setText(string.trim());
                    if (InviteDialog.this.m_isTabFromTA) {
                        InviteDialog.this.m_taInviteText.nextFocus();
                        InviteDialog.this.m_isTabFromTA = false;
                    } else {
                        InviteDialog.this.m_taInviteText.selectAll();
                        keyEvent.consume();
                        InviteDialog.this.m_isTabFromTA = true;
                    }
                }
            }
        });
        this.m_taInviteText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                InviteDialog.this.m_isTabFromTA = true;
            }
        });
        this.m_tfMeetingName = new STTextField(string);
        this.m_lstPeople = new CapabilitiesList(this.m_session, true);
        this.m_lstPeople.enableDelete(true);
        this.m_lstPeople.setNameColData(new CellData(this.m_res.getString("INVITE_DLG_LIST_TITLE")));
        this.m_taInviteText.setBackground(SystemColor.window);
        this.m_tfMeetingName.setBackground(SystemColor.window);
        this.setLayout(new BorderLayout(0, 5));
        Panel panel = this.createButtonsPanel();
        this.m_btnSend.setEnabled(false);
        Panel panel2 = this.createToolsPanel();
        Panel panel3 = this.createSecurityPanel(this.isEncrypted(encLevel));
        this.initializeTools(vector);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout(3, 7));
        if (this.m_allowChange) {
            panel4.add("North", panel2);
            panel4.add("Center", panel3);
            panel4.add("South", panel);
        } else {
            panel4.add("Center", panel);
            this.m_tfMeetingName.setEditable(false);
            this.m_tfMeetingName.setEnabled(false);
        }
        this.add("Center", this.createInviteesPanel());
        this.add("North", this.createMeetingInfoPanel());
        this.add("South", panel4);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        if (frame != null) {
            Point point = frame.getLocation();
            Insets insets = frame.getInsets();
            point.translate(insets.left, insets.top);
            this.setLocation(point);
        } else {
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        }
        this.m_taInviteText.requestFocus();
    }

    public void requestFocus() {
        super.requestFocus();
        this.m_taInviteText.getCursor();
        this.m_btnSend.requestFocus();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.m_allowChange ? this.m_largeDialog : this.m_smallDialog;
        int n = dimension.width < dimension2.width ? dimension2.width : dimension.width;
        int n2 = dimension.height < dimension2.height ? dimension2.height : dimension.height;
        return new Dimension(n, n2);
    }

    protected Panel createMeetingInfoPanel() {
        Panel panel = new Panel(new BorderLayout(0, 4));
        Panel panel2 = new Panel(new BorderLayout(0, 4));
        panel2.add("North", new Label(this.m_res.getString("LBL_INVITATION")));
        panel2.add("Center", new Panel());
        panel.add("North", new Label(this.m_res.getString("LBL_MEETING_NAME")));
        panel.add("Center", panel2);
        Panel panel3 = new Panel(new BorderLayout(0, 4));
        panel3.add("North", this.m_tfMeetingName);
        panel3.add("Center", this.m_taInviteText);
        Panel panel4 = new Panel(new BorderLayout(0, 4));
        panel4.add("West", panel);
        panel4.add("Center", panel3);
        return panel4;
    }

    protected Panel createButtonsPanel() {
        String[] stringArray = new String[]{this.m_res.getString("BTN_LBL_ADD_INVITEES"), this.m_res.getString("BTN_LBL_SEND"), this.m_res.getString("BTN_LBL_CANCEL")};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, this, 2);
        this.m_btnSend = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_SEND"));
        this.m_btnAdd = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_ADD_INVITEES"));
        this.m_btnCancel = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_CANCEL"));
        return buttonsPanel;
    }

    protected Panel createInviteesPanel() {
        Panel panel = new Panel(new BorderLayout(5, 1));
        panel.add("Center", this.m_lstPeople);
        panel.add("North", new Label(this.m_res.getString("INVITEES_HEADER")));
        return panel;
    }

    protected Panel createToolsPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 3));
        this.m_cbChat = new Checkbox(this.m_res.getString("LBL_CHAT"));
        panel.add(this.m_cbChat);
        this.m_cbVideo = new Checkbox(this.m_res.getString("LBL_VIDEO"));
        panel.add(this.m_cbVideo);
        this.m_cbAudio = new Checkbox(this.m_res.getString("LBL_AUDIO"));
        panel.add(this.m_cbAudio);
        this.m_cbAudioBridge = new Checkbox(this.m_res.getString("LBL_AUDIOBRIDGE"));
        panel.add(this.m_cbAudioBridge);
        this.m_cbBoard = new Checkbox(this.m_res.getString("LBL_WHITE_BOARD"));
        panel.add(this.m_cbBoard);
        this.m_cbShare = new Checkbox(this.m_res.getString("LBL_SCREEN_SHARE"));
        panel.add(this.m_cbShare);
        GroupPanel groupPanel = new GroupPanel(this.m_res.getString("TOOLS_HEADER"));
        groupPanel.setLayout(new BorderLayout());
        groupPanel.add((Component)panel, "Center");
        return groupPanel;
    }

    protected Panel createSecurityPanel(boolean bl) {
        Panel panel = new Panel(new GridLayout(1, 3));
        this.m_cbSecureMeeting = new Checkbox(this.m_res.getString("LBL_SECURE"), bl);
        panel.add(this.m_cbSecureMeeting);
        return panel;
    }

    protected void cancelDialog() {
        if (this.m_dlgAdd != null) {
            this.m_dlgAdd.dispose();
            this.m_dlgAdd = null;
        }
        if (this.m_listener != null) {
            this.m_listener.inviteDialogCanceled(this);
        }
        this.dispose();
    }

    protected void showAddDialog() {
        if (this.m_dlgAdd == null) {
            String string = this.m_res.getString("ADD_DIALOG_TITLE");
            this.m_dlgAdd = new AddDialog(this.m_parentFrame, this.m_session, string);
            this.m_dlgAdd.addResolveViewListener(this);
            this.m_dlgAdd.pack();
            this.m_dlgAdd.setVisible(true);
            this.m_dlgAdd.addWindowListener(this);
        }
        if (!this.m_dlgAdd.isVisible()) {
            this.m_dlgAdd.setVisible(true);
        }
        this.m_dlgAdd.toFront();
        this.m_dlgAdd.requestFocus();
    }

    protected void sendInvitation() {
        boolean bl;
        Object object;
        Vector vector = this.getSelectedActivities();
        if (vector.size() == 0) {
            this.cancelDialog();
            return;
        }
        if (this.m_dlgAdd != null) {
            this.m_dlgAdd.setVisible(false);
            this.m_dlgAdd = null;
        }
        String string = !this.m_allowChange && this.m_meetingName != null ? this.m_meetingName : this.m_tfMeetingName.getText();
        String string2 = this.m_taInviteText.getText();
        string2 = string2.replace('\n', ' ');
        STWatchedUser[] sTWatchedUserArray = this.m_lstPeople.getItems();
        STUser[] sTUserArray = this.getActiveInvitees(sTWatchedUserArray);
        if (sTUserArray.length < sTWatchedUserArray.length) {
            Frame frame = (Frame)this.m_session.getSessionProperty("mainFrame");
            if (frame == null) {
                frame = new Frame();
            }
            object = new UbqDialog(frame, this.m_res.getString("FRM_TITLE_ALERT"), this.m_res.formatStringArray("INVITE_USERS_NOTAVAIL"), this.m_res.formatStringArray("BTN_LBL_OK"));
            ((Dialog)object).setModal(false);
            ((UbqDialog)object).setVisible(true);
        }
        object = (bl = this.m_cbSecureMeeting.getState()) ? EncLevel.ENC_LEVEL_RC2_40 : EncLevel.ENC_LEVEL_NONE;
        this.setVisible(false);
        this.m_listener.inviteDlgSendClicked(this, string, string2, sTUserArray, (EncLevel)object, vector);
    }

    protected STWatchedUser[] getActiveInvitees(STWatchedUser[] sTWatchedUserArray) {
        Vector<STWatchedUser> vector = new Vector<STWatchedUser>();
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            STUserStatus sTUserStatus = sTWatchedUserArray[i].getStatus();
            if (sTUserStatus.isStatus((short)0) || sTUserStatus.isStatus((short)128)) continue;
            vector.addElement(sTWatchedUserArray[i]);
        }
        Object[] objectArray = new STWatchedUser[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected boolean isEncrypted(EncLevel encLevel) {
        return encLevel == EncLevel.ENC_LEVEL_RC2_40 || encLevel == EncLevel.ENC_LEVEL_ALL;
    }

    private Vector getSelectedActivities() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.m_cbAudioBridge.getState()) {
            vector.addElement(new Integer(38101));
        }
        if (this.m_cbChat.getState()) {
            vector.addElement(new Integer(37126));
        }
        if (this.m_cbAudio.getState()) {
            vector.addElement(new Integer(37123));
        }
        if (this.m_cbVideo.getState()) {
            vector.addElement(new Integer(37123));
            vector.addElement(new Integer(37124));
        }
        if (this.m_cbShare.getState()) {
            vector.addElement(new Integer(37122));
        }
        if (this.m_cbBoard.getState()) {
            vector.addElement(new Integer(37121));
        }
        if (this.m_cbShare.getState() || this.m_cbBoard.getState()) {
            vector.addElement(new Integer(37130));
            vector.addElement(new Integer(37129));
        }
        return vector;
    }

    private void initializeTools(Vector vector) {
        boolean bl;
        if (vector == null) {
            vector = new Vector<Integer>();
            vector.addElement(new Integer(37126));
        }
        if (bl = this.isWatsonServer()) {
            this.m_cbChat.setEnabled(true);
            this.m_cbChat.setState(vector.contains(new Integer(37126)));
        } else {
            this.m_cbChat.setEnabled(false);
            this.m_cbChat.setState(true);
        }
        ChatUI chatUI = (ChatUI)this.m_session.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_cbAudioBridge.setEnabled(!StaticProps.m_bMacOSX && bl && chatUI.isAudioBridgeEnabled());
        if (this.m_cbAudioBridge.isEnabled()) {
            this.m_cbAudioBridge.addItemListener(this);
            this.m_cbVideo.addItemListener(this);
            this.m_cbAudio.addItemListener(this);
        }
        this.m_cbVideo.setEnabled(!StaticProps.m_bMacOSX && bl && chatUI.isVideoEnabled());
        this.m_cbAudio.setEnabled(!StaticProps.m_bMacOSX && bl && chatUI.isAudioEnabled());
        this.m_cbShare.setEnabled(!StaticProps.m_bMacOSX && bl && chatUI.isMeetingEnabled() && chatUI.isAppShareEnabled());
        this.m_cbBoard.setEnabled(!StaticProps.m_bMacOSX && bl && chatUI.isMeetingEnabled() && chatUI.isWhiteBoardEnabled());
        this.m_cbAudioBridge.setState(this.m_cbAudioBridge.isEnabled() && vector.contains(new Integer(38101)));
        this.m_cbVideo.setState(this.m_cbVideo.isEnabled() && vector.contains(new Integer(37124)));
        this.m_cbAudio.setState(this.m_cbAudio.isEnabled() && vector.contains(new Integer(37123)));
        this.m_cbShare.setState(this.m_cbShare.isEnabled() && vector.contains(new Integer(37122)));
        this.m_cbBoard.setState(this.m_cbBoard.isEnabled() && vector.contains(new Integer(37121)));
    }

    protected boolean isWatsonServer() {
        int n = this.m_community.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        return s > 30 || s == 30 && s2 >= 25;
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                InviteDialog.this.sendInvitation();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                InviteDialog.this.cancelDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_ADD_INVITEES"))){

            public void executeKeyMethod() {
                InviteDialog.this.showAddDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_SEND"))){

            public void executeKeyMethod() {
                InviteDialog.this.sendInvitation();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_CANCEL"))){

            public void executeKeyMethod() {
                InviteDialog.this.cancelDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_TEXT_TOPIC"))){

            public void executeKeyMethod() {
                InviteDialog.this.m_tfMeetingName.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_TEXT_MESSAGE"))){

            public void executeKeyMethod() {
                InviteDialog.this.m_taInviteText.requestFocus();
            }
        });
        return new KeyHandler(vector);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.m_cbAudioBridge) && this.m_cbAudioBridge.getState()) {
            if (this.m_cbAudio.getState() || this.m_cbVideo.getState()) {
                this.m_btnSend.setEnabled(false);
                UbqDialog ubqDialog = new UbqDialog(this.m_parentFrame);
                String string = this.m_res.getString("ALERT_TITLE");
                String[] stringArray = new String[]{this.m_res.getString("AUDIOBRIDGE_NOAV_WARNING")};
                String[] stringArray2 = new String[]{this.m_res.getString("BTN_LBL_OK"), this.m_res.getString("BTN_LBL_CANCEL")};
                ubqDialog.resetDialog(string, stringArray, stringArray2, false, "");
                Frame frame = this.m_parentFrame;
                ubqDialog.addListener(new UbqDialogListener(){

                    public void ubqDialogClosed(UbqDialog ubqDialog, int n, boolean bl) {
                        switch (n) {
                            case 0: {
                                InviteDialog.this.m_cbAudio.setState(false);
                                InviteDialog.this.m_cbVideo.setState(false);
                                InviteDialog.this.m_cbAudioBridge.setState(true);
                                InviteDialog.this.m_btnSend.setEnabled(true);
                                break;
                            }
                            case 1: {
                                InviteDialog.this.m_cbAudioBridge.setState(false);
                                InviteDialog.this.m_btnSend.setEnabled(true);
                                break;
                            }
                            default: {
                                InviteDialog.this.m_cbAudioBridge.setState(false);
                                InviteDialog.this.m_cbAudio.setState(false);
                                InviteDialog.this.m_cbVideo.setState(false);
                                InviteDialog.this.m_btnSend.setEnabled(true);
                            }
                        }
                    }
                });
                ubqDialog.setModal(true);
                ubqDialog.toFront();
                ubqDialog.setVisible(true);
            }
        } else if ((itemEvent.getSource().equals(this.m_cbAudio) || itemEvent.getSource().equals(this.m_cbVideo)) && this.m_cbAudioBridge.getState() && (this.m_cbAudio.getState() || this.m_cbVideo.getState())) {
            this.m_btnSend.setEnabled(false);
            UbqDialog ubqDialog = new UbqDialog(this.m_parentFrame);
            String string = this.m_res.getString("ALERT_TITLE");
            String[] stringArray = new String[]{this.m_res.getString("AV_NOAUDIOBRIDGE_WARNING")};
            String[] stringArray3 = new String[]{this.m_res.getString("BTN_LBL_OK"), this.m_res.getString("BTN_LBL_CANCEL")};
            ubqDialog.resetDialog(string, stringArray, stringArray3, false, "");
            Frame frame = this.m_parentFrame;
            ubqDialog.addListener(new UbqDialogListener(){

                public void ubqDialogClosed(UbqDialog ubqDialog, int n, boolean bl) {
                    switch (n) {
                        case 0: {
                            InviteDialog.this.m_cbAudioBridge.setState(false);
                            InviteDialog.this.m_btnSend.setEnabled(true);
                            break;
                        }
                        case 1: {
                            InviteDialog.this.m_cbAudio.setState(false);
                            InviteDialog.this.m_cbVideo.setState(false);
                            InviteDialog.this.m_btnSend.setEnabled(true);
                            break;
                        }
                        default: {
                            InviteDialog.this.m_cbAudioBridge.setState(false);
                            InviteDialog.this.m_cbAudio.setState(false);
                            InviteDialog.this.m_cbVideo.setState(false);
                            InviteDialog.this.m_btnSend.setEnabled(true);
                        }
                    }
                }
            });
            ubqDialog.setModal(true);
            ubqDialog.toFront();
            ubqDialog.setVisible(true);
        }
    }
}

