/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui.conf;

import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.ChatUIComp;
import com.lotus.sametime.chatui.MeetingHandler;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.ServerAttributes;
import com.lotus.sametime.chatui.ServerWatcher;
import com.lotus.sametime.chatui.conf.ConfModel;
import com.lotus.sametime.chatui.conf.ConfModelListener;
import com.lotus.sametime.chatui.invitation.Invitation;
import com.lotus.sametime.chatui.invitation.InvitationManager;
import com.lotus.sametime.chatui.invitation.Inviter;
import com.lotus.sametime.chatui.invitation.InviterListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.names.NamesEvent;
import com.lotus.sametime.names.NamesService;
import com.lotus.sametime.names.NamesServiceListener;
import com.lotus.sametime.places.MyMsgListener;
import com.lotus.sametime.places.MyselfEvent;
import com.lotus.sametime.places.MyselfInPlace;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlaceEvent;
import com.lotus.sametime.places.PlaceListener;
import com.lotus.sametime.places.PlaceMember;
import com.lotus.sametime.places.PlaceMemberEvent;
import com.lotus.sametime.places.PlacesService;
import com.lotus.sametime.places.Section;
import com.lotus.sametime.places.SectionEvent;
import com.lotus.sametime.places.SectionListener;
import com.lotus.sametime.places.UserInPlace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlacesModelImpl
implements ConfModel,
PlaceListener,
SectionListener,
MyMsgListener,
LoginListener,
InviterListener,
NamesServiceListener {
    private static final int RESPONSE_STARTED_DATA_TYPE = 1;
    private STSession m_session;
    private CommunityService m_commService;
    private PlacesService m_placesService;
    private NamesService m_namesService;
    private Place m_place;
    private MeetingInfo m_confInfo;
    private Vector m_peopleToInvite = new Vector();
    private Vector m_peopleToAutoInvite = new Vector();
    private String m_inviteText;
    private Hashtable m_peopleList = new Hashtable();
    private STUserInstance m_myUserInstance = null;
    private Vector m_Listeners = new Vector();
    private Vector m_messagesList;
    private boolean m_isEncrypted = false;
    private boolean m_inInvitation = false;
    private boolean m_confCreated = true;
    private boolean m_isViewEnabled = true;
    private boolean m_inUpgrade = false;
    private InvitationManager m_inviteManager;
    private ServerWatcher m_serverWatcher;
    private Invitation m_invitation;
    private boolean m_isReconnecting = false;
    private boolean m_waitingForTools = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui.conf");

    public PlacesModelImpl(STSession sTSession, String string, EncLevel encLevel, STUser[] sTUserArray, String string2) {
        this.m_session = sTSession;
        this.m_isEncrypted = !encLevel.isLower(EncLevel.ENC_LEVEL_ALL);
        this.m_placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
        this.m_commService.addLoginListener(this);
        this.m_namesService = (NamesService)sTSession.getCompApi("com.lotus.sametime.names.NamesComp");
        if (this.m_namesService != null) {
            this.m_namesService.addNamesServiceListener(this);
        }
        ChatUIComp chatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_inviteManager = chatUIComp.getInvitationManager();
        this.m_serverWatcher = chatUIComp.getServerWatcher();
        this.addToInvitation(sTUserArray);
        this.m_inviteText = string2;
        this.m_confCreated = false;
        String string3 = this.createUniqueName();
        this.m_place = this.m_placesService.createPlace(string3, string, encLevel, 0, (short)2);
        this.m_place.addPlaceListener(this);
        this.m_place.enter("", (short)0, true);
        this.m_confInfo = new MeetingInfo(MeetingTypes.ST_CHAT_MEETING, string, encLevel, string3, "", "", chatUIComp.getSSLPort(), chatUIComp.getMeetingURL());
        if (chatUIComp.getSaveTranscriptMode()) {
            this.m_messagesList = new Vector(50);
        }
    }

    private String createUniqueName() {
        String string = this.m_myUserInstance.getLoginId().getId();
        return string + System.currentTimeMillis();
    }

    public PlacesModelImpl(STSession sTSession, MeetingInfo meetingInfo) {
        this.m_confInfo = meetingInfo;
        this.m_session = sTSession;
        this.m_isEncrypted = !this.m_confInfo.getEncLevel().isLower(EncLevel.ENC_LEVEL_ALL);
        this.m_placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
        this.m_commService.addLoginListener(this);
        ChatUIComp chatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_inviteManager = chatUIComp.getInvitationManager();
        this.m_serverWatcher = chatUIComp.getServerWatcher();
        this.m_confCreated = true;
        this.m_inInvitation = false;
        this.m_place = this.m_placesService.createPlace(this.m_confInfo.getPlaceName(), this.m_confInfo.getDisplayName(), this.m_confInfo.getEncLevel(), 0, (short)2);
        this.m_place.addPlaceListener(this);
        this.m_place.enter(this.m_confInfo.getPassword(), (short)1, true);
        if (chatUIComp.getSaveTranscriptMode()) {
            this.m_messagesList = new Vector(50);
        }
    }

    public PlacesModelImpl(STSession sTSession, Invitation invitation) {
        this.m_invitation = invitation;
        this.m_confInfo = invitation.getMeetingInfo();
        this.m_session = sTSession;
        this.m_isEncrypted = !this.m_confInfo.getEncLevel().isLower(EncLevel.ENC_LEVEL_ALL);
        this.m_placesService = (PlacesService)sTSession.getCompApi("com.lotus.sametime.places.PlacesComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
        this.m_commService.addLoginListener(this);
        ChatUIComp chatUIComp = (ChatUIComp)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_inviteManager = chatUIComp.getInvitationManager();
        this.m_serverWatcher = chatUIComp.getServerWatcher();
        this.m_confCreated = false;
        this.m_inInvitation = true;
        if (chatUIComp.getSaveTranscriptMode()) {
            this.m_messagesList = new Vector(50);
        }
    }

    public void addConfModelListener(ConfModelListener confModelListener) {
        this.m_Listeners.addElement(confModelListener);
    }

    public void removeConfModelListener(ConfModelListener confModelListener) {
        this.m_Listeners.removeElement(confModelListener);
    }

    public void sendMessage(String string) {
        if (this.m_place != null) {
            Section section = this.m_place.getMySection();
            section.sendText(string);
        }
    }

    public void sendResponseStarted() {
        if (this.m_place != null) {
            STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(8);
            this.m_place.getMyselfInPlace().changeAttribute(sTExtendedAttribute);
        }
    }

    public void sendResponseCleared() {
        if (this.m_place != null) {
            this.m_place.getMyselfInPlace().removeAttribute(8);
        }
    }

    public synchronized void inviteToConference(STUser[] sTUserArray, String string) {
        if (this.m_confCreated) {
            STUser[] sTUserArray2 = this.removeParticipants(sTUserArray);
            Inviter inviter = this.m_inviteManager.createInviter();
            inviter.setListener(this);
            inviter.invite(this.m_confInfo, string, sTUserArray2, false, false);
        } else {
            this.addToInvitation(sTUserArray);
        }
    }

    public synchronized void autoInviteToConference(STUser sTUser) {
        if (this.m_confCreated) {
            Inviter inviter = this.m_inviteManager.createInviter();
            inviter.setListener(this);
            STUser[] sTUserArray = new STUser[]{sTUser};
            inviter.invite(this.m_confInfo, "", sTUserArray, true, true);
        } else {
            this.m_peopleToAutoInvite.addElement(sTUser);
        }
    }

    public void closeChat() {
        if (null != this.m_namesService) {
            this.m_namesService.removeNamesServiceListener(this);
        }
        if (null != this.m_commService) {
            this.m_commService.removeLoginListener(this);
        }
        if (this.m_place != null) {
            this.m_place.removePlaceListener(this);
            this.m_place.close();
            this.m_place = null;
        }
        this.requestShowView(false);
    }

    public MeetingInfo getConfInfo() {
        return this.m_confInfo;
    }

    public Place getPlace() {
        return this.m_place;
    }

    public STSession getSession() {
        return this.m_session;
    }

    public synchronized STUser[] getPeople() {
        STUser[] sTUserArray = new STUser[this.m_peopleList.size()];
        Enumeration enumeration = this.m_peopleList.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            sTUserArray[n] = (STUser)enumeration.nextElement();
            ++n;
        }
        return sTUserArray;
    }

    public boolean isEncrypted() {
        return this.m_isEncrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatMessage[] getChatTranscript() {
        Object[] objectArray = null;
        if (null != this.m_messagesList) {
            Vector vector = this.m_messagesList;
            synchronized (vector) {
                objectArray = new ChatMessage[this.m_messagesList.size()];
                this.m_messagesList.copyInto(objectArray);
            }
        } else {
            objectArray = new ChatMessage[]{};
        }
        return objectArray;
    }

    public boolean isAudioEnabled() {
        if (this.m_place == null || !this.m_place.isInPlace()) {
            return false;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_place.getServer());
        return serverAttributes != null ? serverAttributes.isAudioEnabled() : false;
    }

    public boolean isAudioBridgeEnabled() {
        if (this.m_place == null || !this.m_place.isInPlace()) {
            return false;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_place.getServer());
        return serverAttributes != null ? serverAttributes.isAudioBridgeEnabled() : false;
    }

    public boolean isVideoEnabled() {
        if (this.m_place == null || !this.m_place.isInPlace()) {
            return false;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_place.getServer());
        return serverAttributes != null ? serverAttributes.isVideoEnabled() : false;
    }

    public boolean isMeetingEnabled() {
        if (this.m_place == null || !this.m_place.isInPlace()) {
            this.m_waitingForTools = true;
            return false;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_place.getServer());
        return serverAttributes != null ? serverAttributes.isMeetingEnabled() : false;
    }

    public boolean isViewEnabled() {
        return this.m_isViewEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTranscript(ChatMessage[] chatMessageArray) {
        if (null != this.m_messagesList) {
            Vector vector = this.m_messagesList;
            synchronized (vector) {
                for (int i = 0; i < chatMessageArray.length; ++i) {
                    this.m_messagesList.addElement(chatMessageArray[i]);
                }
            }
        }
    }

    public void acceptInvitation() {
        Debug.stAssert(this.m_inInvitation);
        this.m_invitation.accept();
        this.m_place = this.m_placesService.createPlace(this.m_confInfo.getPlaceName(), this.m_confInfo.getDisplayName(), this.m_confInfo.getEncLevel(), 0, (short)2);
        this.m_place.addPlaceListener(this);
        this.m_place.enter(this.m_confInfo.getPassword(), (short)1, true);
        this.requestShowView(true);
        this.m_inInvitation = false;
    }

    public void declineInvitation() {
        Debug.stAssert(this.m_inInvitation);
        this.m_invitation.decline(0);
        this.m_inInvitation = false;
    }

    public void requestShowView(boolean bl) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.setVisible(bl);
        }
    }

    public void requestToFront() {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.toFront();
        }
    }

    private void notifySwitchToMeeting(MeetingInfo meetingInfo) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.switchToMeeting(meetingInfo);
        }
    }

    public void invitationDeclined(Inviter inviter, STUser sTUser, int n) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.invitationDeclined(sTUser, n);
        }
    }

    public void invitationToOldClient(Inviter inviter, STUser sTUser) {
        this.m_place.invite15User(sTUser, inviter.getInviteText(), inviter.getAutoInvite());
    }

    public void loggedIn(LoginEvent loginEvent) {
        if (this.m_isReconnecting) {
            this.m_place.enter();
            this.enableSendMessage(true);
            this.m_isReconnecting = false;
        } else {
            STId sTId = this.m_myUserInstance.getId();
            STId sTId2 = this.m_commService.getLogin().getMyUserInstance().getId();
            if (!sTId2.equals(sTId)) {
                this.closeChat();
            }
            this.m_myUserInstance = this.m_commService.getLogin().getMyUserInstance();
        }
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_isReconnecting = loginEvent.isReconnecting();
        this.enableSendMessage(false);
    }

    protected void enableSendMessage(boolean bl) {
        this.m_isViewEnabled = bl;
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.enableSendMessage(bl);
        }
    }

    protected void sendFailed(int n) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.sendFailed(n);
        }
    }

    protected void toolsEnabled(ServerAttributes serverAttributes) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.toolsEnabled(serverAttributes);
        }
    }

    protected void encryptionModeChanged(boolean bl) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.encryptionModeChanged(bl);
        }
    }

    protected void addToInvitation(STUser[] sTUserArray) {
        for (int i = 0; i < sTUserArray.length; ++i) {
            this.m_peopleToInvite.addElement(sTUserArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entered(PlaceEvent placeEvent) {
        Place place = placeEvent.getPlace();
        Section section = place.getMySection();
        section.addSectionListener(this);
        STServer sTServer = place.getServer();
        this.m_serverWatcher.addServer(sTServer);
        this.m_confInfo.setServerName(sTServer.getName());
        place.addActivity(37126, null);
        this.requestShowView(true);
        this.enableSendMessage(true);
        Object object = this;
        synchronized (object) {
            this.m_confCreated = true;
            if (!this.m_peopleToInvite.isEmpty()) {
                STUser[] sTUserArray = new STUser[this.m_peopleToInvite.size()];
                for (int i = 0; i < sTUserArray.length; ++i) {
                    sTUserArray[i] = (STUser)this.m_peopleToInvite.elementAt(i);
                }
                this.inviteToConference(sTUserArray, this.m_inviteText);
                this.m_peopleToInvite.removeAllElements();
            }
            if (!this.m_peopleToAutoInvite.isEmpty()) {
                for (int i = 0; i < this.m_peopleToAutoInvite.size(); ++i) {
                    STUser sTUser = (STUser)this.m_peopleToAutoInvite.elementAt(i);
                    this.autoInviteToConference(sTUser);
                }
                this.m_peopleToInvite.removeAllElements();
            }
        }
        object = place.getMyselfInPlace();
        ((MyselfInPlace)object).addMyMsgListener(this);
        if (this.m_waitingForTools) {
            this.toolsEnabled(this.m_serverWatcher.getServerAttributes(sTServer));
            this.m_waitingForTools = false;
        }
    }

    public void enterFailed(PlaceEvent placeEvent) {
        this.m_place = null;
        this.sendFailed(placeEvent.getReason());
        this.enableSendMessage(false);
    }

    public void left(PlaceEvent placeEvent) {
        if (!this.m_isReconnecting) {
            this.m_place.removePlaceListener(this);
            this.m_place = null;
            int n = placeEvent.getReason();
            if (n != 0) {
                this.sendFailed(n);
            }
        }
        this.enableSendMessage(false);
    }

    public void activityAdded(PlaceEvent placeEvent) {
    }

    public void addActivityFailed(PlaceEvent placeEvent) {
    }

    public void sectionAdded(PlaceEvent placeEvent) {
    }

    public void sectionRemoved(PlaceEvent placeEvent) {
    }

    public void invite15UserFailed(PlaceEvent placeEvent) {
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.invitationDeclined(placeEvent.getUser(), placeEvent.getReason());
        }
    }

    public void activityRemoved(PlaceEvent placeEvent) {
    }

    public void addAllowedUsersFailed(PlaceEvent placeEvent) {
    }

    public void removeAllowedUsersFailed(PlaceEvent placeEvent) {
    }

    public synchronized void usersEntered(SectionEvent sectionEvent) {
        UserInPlace[] userInPlaceArray = sectionEvent.getUsers();
        for (int i = 0; i < userInPlaceArray.length; ++i) {
            STLoginId sTLoginId = userInPlaceArray[i].getLoginId();
            UserInPlace userInPlace = userInPlaceArray[i];
            if (null != this.m_namesService) {
                userInPlace.setNickName(this.m_namesService.getNickname(userInPlace));
                userInPlace.setNameDelimiter(this.m_namesService.getNameDelimiter());
            }
            this.m_peopleList.put(sTLoginId, userInPlace);
            Enumeration enumeration = this.m_Listeners.elements();
            while (enumeration.hasMoreElements()) {
                ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
                confModelListener.userEntered(userInPlace);
            }
        }
    }

    public synchronized void userLeft(SectionEvent sectionEvent) {
        UserInPlace userInPlace = sectionEvent.getUser();
        Object v = this.m_peopleList.remove(userInPlace.getLoginId());
        Debug.stAssert(v != null);
        Enumeration enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
            confModelListener.userLeft(userInPlace);
        }
    }

    public void textReceived(MyselfEvent myselfEvent) {
        PlaceMember placeMember = myselfEvent.getSender();
        if (placeMember instanceof UserInPlace) {
            UserInPlace userInPlace = (UserInPlace)placeMember;
            STLoginId sTLoginId = userInPlace.getLoginId();
            STUser sTUser = (STUser)this.m_peopleList.get(sTLoginId);
            boolean bl = sTLoginId.equals(this.m_myUserInstance.getLoginId());
            ChatMessage chatMessage = new ChatMessage(sTUser, myselfEvent.getText(), bl);
            Enumeration enumeration = this.m_Listeners.elements();
            if (null != this.m_messagesList) {
                this.m_messagesList.addElement(chatMessage);
            }
            while (enumeration.hasMoreElements()) {
                ConfModelListener confModelListener = (ConfModelListener)enumeration.nextElement();
                confModelListener.messageReceived(chatMessage);
            }
        }
    }

    public void dataReceived(MyselfEvent myselfEvent) {
    }

    public void nameChanged(NamesEvent namesEvent) {
        Hashtable hashtable = (Hashtable)this.m_peopleList.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            STUser sTUser = (STUser)enumeration.nextElement();
            if (!sTUser.getId().equals(namesEvent.getUser().getId())) continue;
            sTUser.setNickName(namesEvent.getUser().getNickName());
            break;
        }
    }

    public void nameDelimiterChanged(NamesEvent namesEvent) {
        Hashtable hashtable = (Hashtable)this.m_peopleList.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            STUser sTUser = (STUser)enumeration.nextElement();
            sTUser.setNameDelimiter(namesEvent.getNameDelimiter());
        }
    }

    public void attributeChanged(PlaceMemberEvent placeMemberEvent) {
        if (placeMemberEvent.getAttributeKey() == 9002 && !this.m_inUpgrade) {
            Vector<Integer> vector = new Vector<Integer>();
            String string = placeMemberEvent.getAttribute().getString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string2 = stringTokenizer.nextToken();
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    return;
                }
                vector.addElement(new Integer(n));
            }
            this.upgradeToMeeting(vector, false);
        }
    }

    public void upgradeToMeeting(Vector vector, boolean bl) {
        this.m_inUpgrade = true;
        MeetingInfo meetingInfo = null;
        MeetingTypes meetingTypes = ChatConstants.getMeetingType(vector);
        if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING)) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "upgradeToMeeting", "MODEL: UPGRADE TO CONFERENCE?");
            }
            return;
        }
        meetingInfo = new MeetingInfo(meetingTypes, this.m_confInfo.getDisplayName(), this.m_confInfo.getEncLevel(), this.m_confInfo.getPlaceName(), this.m_confInfo.getPassword(), this.m_confInfo.getServerName(), this.m_confInfo.getSSLPort(), this.m_confInfo.getURL());
        new MeetingHandler(meetingInfo, this.m_session, this.m_place, this.getChatTranscript(), vector, bl);
        this.enableSendMessage(false);
        this.notifySwitchToMeeting(meetingInfo);
    }

    private STUser[] removeParticipants(STUser[] sTUserArray) {
        Vector<STUser> vector = new Vector<STUser>();
        for (int i = 0; i < sTUserArray.length; ++i) {
            if (this.m_peopleList.contains(sTUserArray[i])) continue;
            vector.addElement(sTUserArray[i]);
        }
        Object[] objectArray = new STUser[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void sendFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void attributeRemoved(PlaceMemberEvent placeMemberEvent) {
    }

    public void changeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void removeAttributeFailed(PlaceMemberEvent placeMemberEvent) {
    }

    public void addAllowedUsersFailed(SectionEvent sectionEvent) {
    }

    public void removeAllowedUsersFailed(SectionEvent sectionEvent) {
    }

    public void queryAttrContentFailed(PlaceMemberEvent placeMemberEvent) {
    }
}

