/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.ChatFrame;
import com.lotus.sametime.chatui.ChatModel;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.GroupPanel;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.misc.UbqDialogListener;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class UpgradeDialog
extends Dialog
implements ActionListener,
ItemListener {
    private static int PREF_WIDTH = 280;
    private static int PREF_HEIGHT = 160;
    private ChatFrame m_chatFrame;
    private Checkbox m_cbAudioBridge;
    private Button m_btnSend;
    private Checkbox m_cbChat;
    private Checkbox m_cbVideo;
    private Checkbox m_cbAudio;
    private Checkbox m_cbBoard;
    private Checkbox m_cbShare;
    private String m_lblSend;
    private String m_lblClose;
    private STBundle m_res;
    private ChatUI m_chatUI = null;

    public UpgradeDialog(ChatFrame chatFrame, STSession sTSession, String string) {
        super(chatFrame, string, false);
        this.m_chatFrame = chatFrame;
        this.m_res = ((ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"))).getBundle("properties/chatui");
        this.m_chatUI = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        ChatModel chatModel = this.m_chatFrame.getChatModel();
        Panel panel = this.createToolsPanel(chatModel);
        this.m_cbChat.setState(true);
        this.m_cbChat.setEnabled(false);
        this.m_lblSend = this.m_res.getString("BTN_LBL_SEND");
        this.m_lblClose = this.m_res.getString("BTN_LBL_CLOSE");
        String[] stringArray = new String[]{this.m_lblSend, this.m_lblClose};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, this, 2);
        this.m_btnSend = buttonsPanel.getButton(this.m_res.getString("BTN_LBL_SEND"));
        this.add("Center", panel);
        this.add("South", buttonsPanel);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UpgradeDialog.this.dispose();
            }
        });
        this.pack();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    protected Panel createToolsPanel(ChatModel chatModel) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 0, 0));
        Panel panel2 = new Panel(new GridLayout(2, 1, 0, 0));
        this.m_cbChat = new Checkbox(this.m_res.getString("LBL_CHAT"));
        this.m_cbAudioBridge = new Checkbox(this.m_res.getString("LBL_AUDIOBRIDGE"));
        this.m_cbShare = new Checkbox(this.m_res.getString("LBL_SCREEN_SHARE"));
        this.m_cbBoard = new Checkbox(this.m_res.getString("LBL_WHITE_BOARD"));
        this.m_cbAudio = new Checkbox(this.m_res.getString("LBL_AUDIO"));
        this.m_cbVideo = new Checkbox(this.m_res.getString("LBL_VIDEO"));
        if (StaticProps.m_bUnixOS) {
            this.m_cbAudio.setEnabled(false);
            this.m_cbVideo.setEnabled(false);
        }
        panel2.add(this.m_cbChat);
        if (chatModel.isMeetingEnabled() && this.m_chatUI.isAudioBridgeEnabled()) {
            panel2.add(this.m_cbAudioBridge);
        } else {
            panel2.add(new Panel());
        }
        panel.add(panel2);
        if (chatModel.isMeetingEnabled() && this.m_chatUI.isAudioBridgeEnabled()) {
            this.m_cbAudioBridge.addItemListener(this);
            this.m_cbAudio.addItemListener(this);
            this.m_cbVideo.addItemListener(this);
        }
        panel2 = new Panel(new GridLayout(2, 1, 0, 0));
        if (chatModel.isMeetingEnabled()) {
            if (this.m_chatUI.isAppShareEnabled()) {
                panel2.add(this.m_cbShare);
            }
            if (this.m_chatUI.isWhiteBoardEnabled()) {
                panel2.add(this.m_cbBoard);
            }
        }
        panel.add(panel2);
        panel2 = new Panel(new GridLayout(2, 1, 0, 0));
        if (chatModel.isMeetingEnabled() && chatModel.isAudioEnabled()) {
            panel2.add(this.m_cbAudio);
        } else {
            panel2.add(new Panel());
        }
        if (chatModel.isMeetingEnabled() && chatModel.isVideoEnabled()) {
            panel2.add(this.m_cbVideo);
        } else {
            panel2.add(new Panel());
        }
        panel.add(panel2);
        Label label = new Label(this.m_res.getString("UPGRADE_ONCE"));
        Panel panel3 = new Panel(new BorderLayout());
        panel3.add("Center", panel);
        panel3.add("South", label);
        GroupPanel groupPanel = new GroupPanel(this.m_res.getString("TOOLS_HEADER"));
        groupPanel.setLayout(new BorderLayout(0, 0));
        groupPanel.add((Component)panel3, "Center");
        return groupPanel;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, PREF_WIDTH);
        dimension.height = Math.max(dimension.height, PREF_HEIGHT);
        return dimension;
    }

    public Insets getInsets() {
        Insets insets = (Insets)super.getInsets().clone();
        insets.top += 5;
        insets.bottom += 5;
        insets.left += 5;
        insets.right += 5;
        return insets;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == this.m_lblSend) {
            Vector vector = this.getSelectedActivities();
            this.m_chatFrame.upgrade(vector);
            this.dispose();
        } else if (actionEvent.getActionCommand() == this.m_lblClose) {
            this.dispose();
        }
    }

    private Vector getSelectedActivities() {
        boolean bl = false;
        Vector<Integer> vector = new Vector<Integer>();
        if (this.m_cbAudioBridge.getState()) {
            vector.addElement(new Integer(38101));
        }
        if (this.m_cbChat.getState()) {
            vector.addElement(new Integer(37126));
        }
        if (this.m_cbAudio.getState()) {
            vector.addElement(new Integer(37123));
        }
        if (this.m_cbVideo.getState()) {
            vector.addElement(new Integer(37124));
        }
        if (this.m_cbShare.getState()) {
            bl = true;
            vector.addElement(new Integer(37122));
        }
        if (this.m_cbBoard.getState()) {
            bl = true;
            vector.addElement(new Integer(37121));
        }
        if (bl) {
            vector.addElement(new Integer(37130));
            vector.addElement(new Integer(37129));
        }
        return vector;
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                Vector vector = UpgradeDialog.this.getSelectedActivities();
                UpgradeDialog.this.m_chatFrame.upgrade(vector);
                UpgradeDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                UpgradeDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_SEND"))){

            public void executeKeyMethod() {
                Vector vector = UpgradeDialog.this.getSelectedActivities();
                UpgradeDialog.this.m_chatFrame.upgrade(vector);
                UpgradeDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_res.getString("MN_BTN_CANCEL"))){

            public void executeKeyMethod() {
                UpgradeDialog.this.dispose();
            }
        });
        return new KeyHandler(vector);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.m_cbAudioBridge) && this.m_cbAudioBridge.getState()) {
            if (this.m_cbAudio.getState() || this.m_cbVideo.getState()) {
                this.m_btnSend.setEnabled(false);
                UbqDialog ubqDialog = new UbqDialog(this.m_chatFrame);
                String string = this.m_res.getString("ALERT_TITLE");
                String[] stringArray = new String[]{this.m_res.getString("AUDIOBRIDGE_NOAV_WARNING")};
                String[] stringArray2 = new String[]{this.m_res.getString("BTN_LBL_OK"), this.m_res.getString("BTN_LBL_CANCEL")};
                ubqDialog.resetDialog(string, stringArray, stringArray2, false, "");
                ChatFrame chatFrame = this.m_chatFrame;
                ubqDialog.addListener(new UbqDialogListener(){

                    public void ubqDialogClosed(UbqDialog ubqDialog, int n, boolean bl) {
                        switch (n) {
                            case 0: {
                                UpgradeDialog.this.m_cbAudio.setState(false);
                                UpgradeDialog.this.m_cbVideo.setState(false);
                                UpgradeDialog.this.m_cbAudioBridge.setState(true);
                                UpgradeDialog.this.m_btnSend.setEnabled(true);
                                break;
                            }
                            case 1: {
                                UpgradeDialog.this.m_cbAudioBridge.setState(false);
                                UpgradeDialog.this.m_btnSend.setEnabled(true);
                                break;
                            }
                            default: {
                                UpgradeDialog.this.m_cbAudioBridge.setState(false);
                                UpgradeDialog.this.m_cbAudio.setState(false);
                                UpgradeDialog.this.m_cbVideo.setState(false);
                                UpgradeDialog.this.m_btnSend.setEnabled(true);
                            }
                        }
                    }
                });
                ubqDialog.setModal(true);
                ubqDialog.toFront();
                ubqDialog.setVisible(true);
            }
        } else if ((itemEvent.getSource().equals(this.m_cbAudio) || itemEvent.getSource().equals(this.m_cbVideo)) && this.m_cbAudioBridge.getState() && (this.m_cbAudio.getState() || this.m_cbVideo.getState())) {
            this.m_btnSend.setEnabled(false);
            UbqDialog ubqDialog = new UbqDialog(this.m_chatFrame);
            String string = this.m_res.getString("ALERT_TITLE");
            String[] stringArray = new String[]{this.m_res.getString("AV_NOAUDIOBRIDGE_WARNING")};
            String[] stringArray3 = new String[]{this.m_res.getString("BTN_LBL_OK"), this.m_res.getString("BTN_LBL_CANCEL")};
            ubqDialog.resetDialog(string, stringArray, stringArray3, false, "");
            ChatFrame chatFrame = this.m_chatFrame;
            ubqDialog.addListener(new UbqDialogListener(){

                public void ubqDialogClosed(UbqDialog ubqDialog, int n, boolean bl) {
                    switch (n) {
                        case 0: {
                            UpgradeDialog.this.m_cbAudioBridge.setState(false);
                            UpgradeDialog.this.m_btnSend.setEnabled(true);
                            break;
                        }
                        case 1: {
                            UpgradeDialog.this.m_cbAudio.setState(false);
                            UpgradeDialog.this.m_cbVideo.setState(false);
                            UpgradeDialog.this.m_btnSend.setEnabled(true);
                            break;
                        }
                        default: {
                            UpgradeDialog.this.m_cbAudioBridge.setState(false);
                            UpgradeDialog.this.m_cbAudio.setState(false);
                            UpgradeDialog.this.m_cbVideo.setState(false);
                            UpgradeDialog.this.m_btnSend.setEnabled(true);
                        }
                    }
                }
            });
            ubqDialog.setModal(true);
            ubqDialog.toFront();
            ubqDialog.setVisible(true);
        }
    }
}

