/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeListener;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.STWatchedObject;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.chatui.ServerAttributes;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerWatcher
implements AttributeListener {
    WatchList m_watchList;
    Hashtable m_watchedServers = new Hashtable();
    private CommunityService m_comm;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui");

    public ServerWatcher(STSession sTSession) {
        AwarenessService awarenessService = (AwarenessService)sTSession.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        Debug.stAssert(awarenessService != null);
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        int[] nArray = new int[]{9002, 9003, 9001, 9010, 9019, 9018, 9025, 9024, 9028, 9029};
        awarenessService.addToAttrFilter(nArray);
        this.m_watchList = awarenessService.createWatchList();
        this.m_watchList.addAttrListener(this);
    }

    public ServerAttributes getServerAttributes(STServer sTServer) {
        Object v = this.m_watchedServers.get(sTServer);
        if (v == null) {
            this.addServer(sTServer);
            return null;
        }
        return (ServerAttributes)v;
    }

    public void addServer(STServer sTServer) {
        if (this.m_watchedServers.get(sTServer) == null) {
            this.m_watchedServers.put(sTServer, new ServerAttributes());
            this.m_watchList.addItem(sTServer);
            String string = this.m_comm.getLogin().getMyUserInstance().getCommunityName();
            if (!string.equals("")) {
                STServer sTServer2 = new STServer(new STId(sTServer.getId().getId(), string), sTServer.getName(), sTServer.getDesc());
                this.m_watchList.addItem(sTServer2);
            }
        }
    }

    public void attrChanged(AttributeEvent attributeEvent) {
        Object object;
        Login login = this.m_comm.getLogin();
        if (login == null) {
            return;
        }
        STUserInstance sTUserInstance = login.getMyUserInstance();
        if (null == sTUserInstance) {
            return;
        }
        String string = sTUserInstance.getCommunityName();
        STWatchedObject sTWatchedObject = attributeEvent.getWatchedObject();
        STServer sTServer = (STServer)((Object)sTWatchedObject);
        String string2 = sTServer.getId().getCommunityName();
        if (!string2.equals("")) {
            object = new STServer(new STId(sTServer.getId().getId(), ""), sTServer.getName(), sTServer.getDesc());
            sTServer = object;
        }
        if ((object = this.m_watchedServers.get(sTServer)) == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "attrChanged", "Server watcher got a changed event on an unwatched server");
            }
            return;
        }
        ServerAttributes serverAttributes = (ServerAttributes)object;
        STExtendedAttribute[] sTExtendedAttributeArray = attributeEvent.getAttributeList();
        for (int i = 0; i < sTExtendedAttributeArray.length; ++i) {
            if (sTExtendedAttributeArray[i].getKey() == 9029) {
                serverAttributes.audioBridgeEnabled = true;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9002) {
                serverAttributes.audioEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9003) {
                serverAttributes.videoEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9001) {
                serverAttributes.meetingEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9010) {
                serverAttributes.sslPort = sTExtendedAttributeArray[i].getInt();
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9019) {
                serverAttributes.urlPushEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9018) {
                serverAttributes.questionsAndAnswersEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9024) {
                serverAttributes.appShareEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9025) {
                serverAttributes.wbEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() != 9028 || (!string2.equals("") || !string.equals("")) && (string2.equals("") || string.equals(""))) continue;
            serverAttributes.meetingURL = sTExtendedAttributeArray[i].getString();
        }
    }

    public void attrRemoved(AttributeEvent attributeEvent) {
        Object object;
        STWatchedObject sTWatchedObject = attributeEvent.getWatchedObject();
        STServer sTServer = (STServer)((Object)sTWatchedObject);
        String string = sTServer.getId().getCommunityName();
        String string2 = this.m_comm.getLogin().getMyUserInstance().getCommunityName();
        if (!string.equals("")) {
            object = new STServer(new STId(sTServer.getId().getId(), ""), sTServer.getName(), sTServer.getDesc());
            sTServer = object;
        }
        if ((object = this.m_watchedServers.get(sTServer)) == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "attrRemoved", "Server watcher got a removed event on an unwatched server");
            }
            return;
        }
        ServerAttributes serverAttributes = (ServerAttributes)object;
        int n = attributeEvent.getAttributeKey();
        if (n == 9029) {
            serverAttributes.audioBridgeEnabled = false;
        } else if (n == 9002) {
            serverAttributes.audioEnabled = false;
        } else if (n == 9003) {
            serverAttributes.videoEnabled = false;
        } else if (n == 9001) {
            serverAttributes.meetingEnabled = false;
        } else if (n == 9010) {
            serverAttributes.sslPort = 0;
        } else if (n == 9019) {
            serverAttributes.urlPushEnabled = false;
        } else if (n == 9018) {
            serverAttributes.questionsAndAnswersEnabled = false;
        } else if (n == 9025) {
            serverAttributes.wbEnabled = false;
        } else if (n == 9024) {
            serverAttributes.appShareEnabled = false;
        } else if (n == 9028) {
            serverAttributes.meetingURL = "";
        }
    }

    public void attrContentQueried(AttributeEvent attributeEvent) {
    }

    public void queryAttrContentFailed(AttributeEvent attributeEvent) {
    }
}

