/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.MeetingListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.token.Token;
import com.lotus.sametime.token.TokenEvent;
import com.lotus.sametime.token.TokenService;
import com.lotus.sametime.token.TokenServiceListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeetingLauncher
implements TokenServiceListener {
    MeetingInfo m_meetingInfo;
    Vector m_listeners;
    boolean m_oldInvite;
    boolean m_initiator;
    TokenService m_tokenService;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui");

    public MeetingLauncher(STSession sTSession, MeetingInfo meetingInfo, Vector vector, boolean bl, boolean bl2) {
        this.m_meetingInfo = meetingInfo;
        this.m_listeners = vector;
        this.m_oldInvite = bl;
        this.m_initiator = bl2;
        CommunityService communityService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        boolean bl3 = communityService.getLogin().getMyUserInstance().isAnon();
        if (bl3) {
            URL uRL = this.prepareUrl("Anonymous", "");
            this.notifyListeners(uRL);
        } else {
            this.m_tokenService = (TokenService)sTSession.getCompApi("com.lotus.sametime.token.TokenComp");
            this.m_tokenService.addTokenServiceListener(this);
            this.m_tokenService.generateToken();
        }
    }

    public void tokenGenerated(TokenEvent tokenEvent) {
        Token token = tokenEvent.getToken();
        URL uRL = this.prepareUrl(token.getLoginName(), token.getTokenString());
        this.notifyListeners(uRL);
        this.m_tokenService.removeTokenServiceListener(this);
    }

    public void generateTokenFailed(TokenEvent tokenEvent) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "generateTokenFailed", "LAUNCHER: Failed to get token");
        }
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MeetingListener meetingListener = (MeetingListener)enumeration.nextElement();
            meetingListener.meetingCreationFailed(this.m_meetingInfo, -2147482362);
        }
        this.m_tokenService.removeTokenServiceListener(this);
    }

    public void serviceAvailable(TokenEvent tokenEvent) {
    }

    private URL prepareUrl(String string, String string2) {
        URL uRL;
        int n = this.m_meetingInfo.getSSLPort();
        String string3 = this.m_meetingInfo.getURL();
        if (this.m_meetingInfo.getType().equals(MeetingTypes.ST_AUDIO_CALL)) {
            string3 = n != 0 ? "https://" + this.m_meetingInfo.getServerName() + ":" + n : "http://" + this.m_meetingInfo.getServerName();
            string3 = string3 + "/stsrc.nsf/joinCTD?OpenForm";
        } else if (string3.equals("")) {
            string3 = n != 0 ? "https://" + this.m_meetingInfo.getServerName() + ":" + n : "http://" + this.m_meetingInfo.getServerName();
            string3 = string3 + "/stsrc.nsf/join?OpenForm";
        }
        string3 = this.m_oldInvite ? string3 + "&cid=" + this.encode(this.m_meetingInfo.getConfId().toString()) : string3 + "&mid=" + this.encode(this.m_meetingInfo.getPlaceName());
        string3 = string3 + "&toktype=1&tok=";
        if (this.m_oldInvite && string2.length() != 0 && string2.charAt(0) == '(') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        string3 = string3 + string2 + "&port=" + 8081;
        string3 = string3 + "&ismgr=" + (this.m_initiator ? "1" : "0");
        string3 = string3 + "&uname=" + this.encodeUnicodeString(string);
        string3 = string3 + "&recorded=" + (this.m_meetingInfo.isRecorded() ? "1" : "0");
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    private String encode(String string) {
        String string2 = "";
        String string3 = URLEncoder.encode(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "+");
        string2 = string2 + stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + "%20";
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    private String encodeUnicodeString(String string) {
        if (null == string || string.length() == 0) {
            return string;
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "encodeUnicodeString", "Meeting Launcher String to encode: " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= 'A' && cArray[i] <= 'Z' || cArray[i] >= '0' && cArray[i] <= '9') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append("%26%23");
            stringBuffer.append(Integer.toString(cArray[i]));
            stringBuffer.append("%3B");
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "encodeUnicodeString", "Meeting Launcher Encoded String: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private void notifyListeners(URL uRL) {
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MeetingListener meetingListener = (MeetingListener)enumeration.nextElement();
            meetingListener.launchMeeting(this.m_meetingInfo, uRL);
        }
    }
}

