/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatFactory;
import com.lotus.sametime.chatui.ChatModel;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.chatui.JoinMeetingListener;
import com.lotus.sametime.chatui.MeetingHandler;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.MeetingLauncher;
import com.lotus.sametime.chatui.MeetingListener;
import com.lotus.sametime.chatui.ResolveListener;
import com.lotus.sametime.chatui.Resolver;
import com.lotus.sametime.chatui.ServerAttributes;
import com.lotus.sametime.chatui.ServerWatcher;
import com.lotus.sametime.chatui.UrlClickListener;
import com.lotus.sametime.chatui.conf.ConfModel;
import com.lotus.sametime.chatui.conf.ConfModelAdapter;
import com.lotus.sametime.chatui.im.ImModelAdapter;
import com.lotus.sametime.chatui.invitation.Invitation;
import com.lotus.sametime.chatui.invitation.InvitationListener;
import com.lotus.sametime.chatui.invitation.InvitationManager;
import com.lotus.sametime.chatui.invitation.InviteDialogListener;
import com.lotus.sametime.chatui.invitation.MeetingInviter;
import com.lotus.sametime.commui.CommUI;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImServiceListener;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.places.Place;
import java.awt.Dialog;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatUIComp
extends STComp
implements ChatUI,
InviteDialogListener,
ResolveListener,
InvitationListener,
JoinMeetingListener,
LoginListener {
    private STSession m_session;
    private InstantMessagingService m_ImService;
    private CommUI m_commuiMethods;
    private CommunityService m_commService;
    private Hashtable m_ImModelList;
    private Hashtable m_confModelList;
    private Vector m_meetingListeners;
    private ChatFactory m_chatFactory;
    private boolean m_blinkOnMessage;
    private boolean m_beepOnMessage;
    private boolean m_toFrontOnMessage;
    private Hashtable m_pendingImResolves;
    private Hashtable m_pendingConfResolves;
    private Hashtable m_pendingInvitations;
    private InvitationManager m_inviteManager;
    private ServerWatcher m_serverWatcher;
    private STServer m_ourServer;
    private STUserInstance m_myInfo;
    private boolean m_saveTranscript;
    private Logger m_logger;

    public ChatUIComp(STSession sTSession) throws DuplicateObjectException {
        Object object;
        block14: {
            super("com.lotus.sametime.chatui.ChatUIComp", sTSession);
            this.m_ImModelList = new Hashtable();
            this.m_confModelList = new Hashtable();
            this.m_meetingListeners = new Vector();
            this.m_blinkOnMessage = true;
            this.m_beepOnMessage = true;
            this.m_toFrontOnMessage = false;
            this.m_pendingImResolves = new Hashtable();
            this.m_pendingConfResolves = new Hashtable();
            this.m_pendingInvitations = new Hashtable();
            this.m_saveTranscript = true;
            this.m_logger = Logger.getLogger("com.lotus.sametime.chatui");
            this.m_session = sTSession;
            sTSession.registerComponent(this.getName(), this);
            try {
                object = Class.forName("com.lotus.sametime.chatui.DefaultChatFactory");
                Constructor<?> constructor = ((Class)object).getConstructor(STSession.class);
                if (constructor != null) {
                    this.m_chatFactory = (ChatFactory)constructor.newInstance(this.m_session);
                }
            }
            catch (InstantiationException instantiationException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed instantiate default chat factory");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed instantiate default chat factory");
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed instantiate default chat factory consructor");
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed instantiate default chat factory consructor");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block14;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "Failed to find class");
            }
        }
        this.m_ImService = (InstantMessagingService)sTSession.getCompApi("com.lotus.sametime.im.ImComp");
        if (this.m_ImService != null) {
            this.addImServiceListener();
            this.m_ImService.registerImType(1);
        }
        this.m_commuiMethods = (CommUI)sTSession.getCompApi("com.lotus.sametime.commui.CommUIComp");
        this.m_serverWatcher = new ServerWatcher(sTSession);
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (this.m_commService != null) {
            this.m_commService.addLoginListener(this);
            if (this.m_commService.isLoggedIn()) {
                object = this.m_commService.getLogin();
                this.m_myInfo = ((Login)object).getMyUserInstance();
                this.m_ourServer = ((Login)object).getServer();
                this.m_serverWatcher.addServer(this.m_ourServer);
            }
        }
        this.m_inviteManager = new InvitationManager(this.getSession());
        this.m_inviteManager.setListener(this);
    }

    public void start() {
        Debug.stAssert(this.m_ImService != null);
    }

    public void stop() {
        this.closeAll();
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_ImService && sTCompApi instanceof InstantMessagingService) {
            this.m_ImService = (InstantMessagingService)sTCompApi;
            this.addImServiceListener();
            this.m_ImService.registerImType(1);
        }
        if (null == this.m_commuiMethods && sTCompApi instanceof CommUI) {
            this.m_commuiMethods = (CommUI)sTCompApi;
        }
        if (null == this.m_commService && sTCompApi instanceof CommunityService) {
            this.m_commService = (CommunityService)sTCompApi;
            this.m_commService.addLoginListener(this);
            if (this.m_commService.isLoggedIn()) {
                Login login = this.m_commService.getLogin();
                this.m_myInfo = login.getMyUserInstance();
                this.m_ourServer = login.getServer();
                this.m_serverWatcher.addServer(this.m_ourServer);
            }
        }
    }

    public void addMeetingListener(MeetingListener meetingListener) {
        this.m_meetingListeners.addElement(meetingListener);
    }

    public void removeMeetingListener(MeetingListener meetingListener) {
        this.m_meetingListeners.removeElement(meetingListener);
    }

    public void addUrlClickListener(UrlClickListener urlClickListener) {
        this.m_chatFactory.addUrlClickListener(urlClickListener);
    }

    public void removeUrlClickListener(UrlClickListener urlClickListener) {
        this.m_chatFactory.removeUrlClickListener(urlClickListener);
    }

    public void createMeeting(MeetingTypes meetingTypes, String string, String string2, boolean bl, STUser[] sTUserArray) {
        if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING)) {
            this.createConferenceChat(string, string2, bl, sTUserArray);
            return;
        }
        if (meetingTypes.equals(MeetingTypes.ST_AUDIO_CALL)) {
            new MeetingHandler(meetingTypes, string, sTUserArray, EncLevel.ENC_LEVEL_RC2_40, this.getSession());
            return;
        }
        if (bl) {
            this.m_chatFactory.doInviteDialog(this.getSession(), meetingTypes, string, string2, sTUserArray, true, this);
        } else {
            new MeetingHandler(meetingTypes, string, null, string2, sTUserArray, EncLevel.ENC_LEVEL_RC2_40, this.getSession());
        }
    }

    public void createMeeting(String string, Vector vector, String string2, STUser[] sTUserArray, EncLevel encLevel) {
        STUser[] sTUserArray2 = this.removeMyselfFromList(sTUserArray);
        MeetingTypes meetingTypes = ChatConstants.getMeetingType(vector);
        if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING)) {
            ChatModel chatModel = new ChatModel(this.getSession(), string, encLevel, sTUserArray2, string2);
            this.m_chatFactory.createView(chatModel, null, false);
            return;
        }
        new MeetingHandler(meetingTypes, string, vector, string2, sTUserArray2, encLevel, this.getSession());
    }

    public void inviteToMeeting(MeetingInfo meetingInfo, Place place, String string, STUser[] sTUserArray, boolean bl, boolean bl2) {
        this.inviteToMeeting(meetingInfo, place, string, sTUserArray, bl, bl2, false);
    }

    public void inviteToMeeting(MeetingInfo meetingInfo, Place place, String string, STUser[] sTUserArray, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = bl2 = bl2 && sTUserArray.length == 1;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "inviteToMeeting", "Inviting to meeting. SSL port = " + meetingInfo.getSSLPort());
        }
        new MeetingInviter(meetingInfo, place, string, sTUserArray, bl, bl2, bl3, this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create1On1Chat(String string) {
        String[] stringArray = new String[]{string};
        ChatUIComp chatUIComp = this;
        synchronized (chatUIComp) {
            Resolver resolver = new Resolver(stringArray, this.m_commuiMethods, this);
            this.m_pendingImResolves.put(resolver, string);
        }
    }

    public void create1On1ChatById(STUser sTUser) {
        ChatModel chatModel = (ChatModel)this.m_ImModelList.get(sTUser.getId());
        if (chatModel == null) {
            AwarenessService awarenessService = (AwarenessService)this.m_session.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
            STUserStatus sTUserStatus = awarenessService.findUserStatus(sTUser);
            if (sTUserStatus != null && (sTUserStatus.isStatus((short)0) || sTUserStatus.isStatus((short)128))) {
                this.m_chatFactory.displayErrorMessage(this.m_session, -2147475455, false);
            } else {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "create1On1ChatById", "create1On1ChatById creating model, user = " + sTUser);
                }
                EncLevel encLevel = sTUser.isExternalUser() ? EncLevel.ENC_LEVEL_NONE : EncLevel.ENC_LEVEL_RC2_40;
                Im im = this.m_ImService.createIm(sTUser, encLevel, 1);
                chatModel = ChatModel.getImModel(this.getSession(), sTUser, im, true);
                this.m_chatFactory.createView(chatModel, sTUser.getName(), true);
            }
        } else {
            chatModel.requestToFront();
        }
    }

    public void createConferenceChat(String string, String string2, boolean bl, STUser[] sTUserArray) {
        if (!bl) {
            ChatModel chatModel = new ChatModel(this.getSession(), string, ConfModel.CONF_ENC_LEVEL, sTUserArray, string2);
            this.m_chatFactory.createView(chatModel, null, false);
        } else {
            this.m_chatFactory.doInviteDialog(this.getSession(), MeetingTypes.ST_CHAT_MEETING, string, string2, sTUserArray, true, this);
        }
    }

    public void setBeepOnMessage(boolean bl) {
        this.m_beepOnMessage = bl;
    }

    public boolean getBeepOnMessage() {
        return this.m_beepOnMessage;
    }

    public void setBlinkOnMessage(boolean bl) {
        this.m_blinkOnMessage = bl;
    }

    public boolean getBlinkOnMessage() {
        return this.m_blinkOnMessage;
    }

    public void setToFrontOnMessage(boolean bl) {
        this.m_toFrontOnMessage = bl;
    }

    public boolean getToFrontOnMessage() {
        return this.m_toFrontOnMessage;
    }

    public void setChatFactory(ChatFactory chatFactory) {
        this.m_chatFactory = chatFactory;
    }

    public ChatFactory getChatFactory() {
        return this.m_chatFactory;
    }

    public boolean isAudioBridgeEnabled() {
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.audioBridgeEnabled : false;
    }

    public boolean isAudioEnabled() {
        if (StaticProps.m_bUnixOS) {
            return false;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.audioEnabled : false;
    }

    public boolean isVideoEnabled() {
        if (StaticProps.m_bUnixOS) {
            return false;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.videoEnabled : false;
    }

    public boolean isAppShareEnabled() {
        if (!this.isSavannahServer()) {
            return true;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.appShareEnabled : false;
    }

    public boolean isWhiteBoardEnabled() {
        if (!this.isSavannahServer()) {
            return true;
        }
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.wbEnabled : false;
    }

    public boolean isMeetingEnabled() {
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.meetingEnabled : false;
    }

    public int getSSLPort() {
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.sslPort : 0;
    }

    public String getMeetingURL() {
        ServerAttributes serverAttributes = this.m_serverWatcher.getServerAttributes(this.m_ourServer);
        return serverAttributes != null ? serverAttributes.meetingURL : "";
    }

    public InvitationManager getInvitationManager() {
        return this.m_inviteManager;
    }

    public ServerWatcher getServerWatcher() {
        return this.m_serverWatcher;
    }

    public void setCascadingDirection(int n) {
        this.m_chatFactory.setCascadingDirection(n);
    }

    public int getCascadingDirection() {
        return this.m_chatFactory.getCascadingDirection();
    }

    synchronized void addModel(ChatModel chatModel) {
        if (chatModel.isInConfMode()) {
            String string = chatModel.getConfInfo().getName();
            this.m_confModelList.put(string, chatModel);
            this.addConfModelListener(chatModel);
        } else {
            this.m_ImModelList.put(chatModel.getPartner().getId(), chatModel);
            this.addImModelListener(chatModel);
        }
    }

    synchronized void removeModel(ChatModel chatModel) {
        if (chatModel.isInConfMode()) {
            String string = chatModel.getConfInfo().getName();
            this.m_confModelList.remove(string);
        } else {
            this.m_ImModelList.remove(chatModel.getPartner().getId());
        }
    }

    synchronized void modelSwitchedToConference(ChatModel chatModel, String string) {
        this.m_ImModelList.remove(chatModel.getPartner().getId());
        this.m_confModelList.put(string, chatModel);
        this.addConfModelListener(chatModel);
    }

    ChatModel getImModel(STId sTId) {
        return (ChatModel)this.m_ImModelList.get(sTId);
    }

    private void imReceived(ImEvent imEvent) {
        Im im = (Im)imEvent.getSource();
        if (im.getType() != 1) {
            return;
        }
        STUserInstance sTUserInstance = im.getPartnerDetails();
        STId sTId = sTUserInstance.getId();
        if (this.m_ImModelList.get(sTId) == null) {
            ChatModel chatModel = ChatModel.getImModel(this.getSession(), sTUserInstance, im, false);
            if (this.m_ImModelList.get(sTId) == null) {
                this.m_ImModelList.put(sTId, chatModel);
                this.addImModelListener(chatModel);
            }
            String string = im.getPartnerDetails().getName();
            this.m_chatFactory.createView(chatModel, string, false);
        }
    }

    public void invitedToMeeting(Invitation invitation, boolean bl) {
        MeetingTypes meetingTypes = invitation.getMeetingInfo().getType();
        if (!this.isMeetingTypeSupported(meetingTypes)) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "invitedToMeeting", "Invited to an unsupported meeting type: " + meetingTypes);
            }
            return;
        }
        if (!meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING) && this.m_meetingListeners.isEmpty()) {
            System.out.println("Programer: In order to deal with this invitation you should register a meeting listener to the ChatUI component.");
            int n = -2147482363;
            this.m_chatFactory.displayErrorMessage(this.getSession(), n, true);
            invitation.decline(n);
            return;
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.autoJoinMeeting(invitation);
        }
        if (!bl || !bl2) {
            MeetingInfo meetingInfo = invitation.getMeetingInfo();
            this.m_pendingInvitations.put(new Integer(meetingInfo.hashCode()), invitation);
            this.m_chatFactory.showJoinDialog(this.getSession(), meetingInfo, invitation.getInviter(), invitation.getInviteMessage(), this);
        }
    }

    public void acceptMeeting(MeetingInfo meetingInfo) {
        Invitation invitation = (Invitation)this.m_pendingInvitations.remove(new Integer(meetingInfo.hashCode()));
        Debug.stAssert(invitation != null);
        if (meetingInfo.getType().equals(MeetingTypes.ST_CHAT_MEETING)) {
            if (this.m_confModelList.get(meetingInfo.getName()) == null) {
                ChatModel chatModel = new ChatModel(this.getSession(), invitation);
                chatModel.acceptInvitation();
                this.m_chatFactory.createView(chatModel, null, false);
            }
        } else {
            invitation.accept();
            this.launchMeeting(meetingInfo, invitation.getType() == 3, false);
        }
    }

    public void declineMeeting(MeetingInfo meetingInfo) {
        Invitation invitation = (Invitation)this.m_pendingInvitations.remove(new Integer(meetingInfo.hashCode()));
        Debug.stAssert(invitation != null);
        invitation.decline(0);
    }

    public void inviteDlgSendClicked(Dialog dialog, String string, String string2, STUser[] sTUserArray, EncLevel encLevel, Vector vector) {
        this.createMeeting(string, vector, string2, sTUserArray, encLevel);
    }

    public void inviteDialogCanceled(Dialog dialog) {
    }

    public synchronized void resolved(Resolver resolver, STUser[] sTUserArray) {
        if (this.m_pendingImResolves.remove(resolver) != null) {
            this.create1On1ChatById(sTUserArray[0]);
        }
    }

    public void resolveFailed(Resolver resolver, int n) {
    }

    public void sendFailed(int n, boolean bl) {
        if (n != 0) {
            this.m_chatFactory.displayErrorMessage(this.getSession(), n, bl);
        }
    }

    private boolean autoJoinMeeting(Invitation invitation) {
        boolean bl = true;
        MeetingInfo meetingInfo = invitation.getMeetingInfo();
        if (meetingInfo.getType().equals(MeetingTypes.ST_CHAT_MEETING)) {
            boolean bl2 = invitation.getType() == 2;
            bl = this.autoJoinConference(meetingInfo, invitation.getInviter(), bl2);
        } else {
            STId sTId = invitation.getInviter().getId();
            ChatModel chatModel = (ChatModel)this.m_ImModelList.remove(sTId);
            if (chatModel != null) {
                chatModel.upgradeToMeeting(meetingInfo);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isMeetingTypeSupported(MeetingTypes meetingTypes) {
        return meetingTypes.equals(MeetingTypes.ST_AUDIO_MEETING) || meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING) || meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING) || meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING) || meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING) || meetingTypes.equals(MeetingTypes.ST_AUDIOBRIDGE_MEETING) || meetingTypes.equals(MeetingTypes.ST_AUDIO_CALL);
    }

    private STUser[] removeMyselfFromList(STUser[] sTUserArray) {
        if (sTUserArray == null) {
            return null;
        }
        Vector<STUser> vector = new Vector<STUser>();
        for (int i = 0; i < sTUserArray.length; ++i) {
            if (sTUserArray[i].getId().equals(this.m_myInfo.getId())) continue;
            vector.addElement(sTUserArray[i]);
        }
        Object[] objectArray = new STUser[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean autoJoinConference(MeetingInfo meetingInfo, STUser sTUser, boolean bl) {
        boolean bl2 = true;
        STId sTId = sTUser.getId();
        ChatModel chatModel = (ChatModel)this.m_ImModelList.remove(sTId);
        if (chatModel == null) {
            Enumeration enumeration = this.m_ImModelList.elements();
            while (enumeration.hasMoreElements()) {
                ChatModel chatModel2 = (ChatModel)enumeration.nextElement();
                if (!chatModel2.isPartnerId(sTId)) continue;
                chatModel = chatModel2;
            }
        }
        if (chatModel != null) {
            chatModel.switchToConference(this.getSession(), meetingInfo, bl);
        } else {
            bl2 = false;
        }
        return bl2;
    }

    void launchMeeting(MeetingInfo meetingInfo, boolean bl) {
        this.launchMeeting(meetingInfo, false, bl);
    }

    void launchMeeting(MeetingInfo meetingInfo, boolean bl, boolean bl2) {
        Vector vector = (Vector)this.m_meetingListeners.clone();
        new MeetingLauncher(this.getSession(), meetingInfo, vector, bl, bl2);
    }

    protected void addImServiceListener() {
        this.m_ImService.addImServiceListener(new ImServiceListener(){

            public void imReceived(ImEvent imEvent) {
                ChatUIComp.this.imReceived(imEvent);
            }
        });
    }

    protected void addImModelListener(ChatModel chatModel) {
        chatModel.addImModelListener(new ImModelAdapter(){

            public void sendFailed(int n) {
                ChatUIComp.this.sendFailed(n, false);
            }
        });
    }

    protected void addConfModelListener(ChatModel chatModel) {
        chatModel.addConfModelListener(new ConfModelAdapter(){

            public void sendFailed(int n) {
                ChatUIComp.this.sendFailed(n, true);
            }
        });
    }

    void closeAll() {
        ChatModel chatModel;
        Enumeration enumeration = this.m_ImModelList.elements();
        while (enumeration.hasMoreElements()) {
            chatModel = (ChatModel)enumeration.nextElement();
            chatModel.closeChat();
        }
        enumeration = this.m_confModelList.elements();
        while (enumeration.hasMoreElements()) {
            chatModel = (ChatModel)enumeration.nextElement();
            chatModel.closeChat();
        }
        this.m_chatFactory.closeAllWindows();
    }

    public void loggedIn(LoginEvent loginEvent) {
        Login login = this.m_commService.getLogin();
        STUserInstance sTUserInstance = login.getMyUserInstance();
        if (this.m_myInfo != null && !this.m_myInfo.getId().equals(sTUserInstance.getId())) {
            this.closeAll();
        } else {
            this.m_confModelList.clear();
        }
        this.m_myInfo = sTUserInstance;
        this.m_ourServer = login.getServer();
        this.m_serverWatcher.addServer(this.m_ourServer);
    }

    public void loggedOut(LoginEvent loginEvent) {
    }

    public void setSaveTranscriptMode(boolean bl) {
        this.m_saveTranscript = bl;
    }

    public boolean getSaveTranscriptMode() {
        return this.m_saveTranscript;
    }

    protected boolean isSavannahServer() {
        CommunityService communityService = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        if (!communityService.isLoggedIn()) {
            return false;
        }
        int n = communityService.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        return s > 30 || s == 30 && s2 >= 29;
    }
}

