/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.ChatEditListener;
import com.lotus.sametime.chatui.ChatModel;
import com.lotus.sametime.chatui.ChatModelListener;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.TextModifier;
import com.lotus.sametime.chatui.conf.ConfPanel;
import com.lotus.sametime.chatui.im.ImPanel;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.guiutils.chat.ChatAreaListener;
import com.lotus.sametime.guiutils.chat.ChatSendField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.util.Vector;

public class ChatPanel
extends Panel
implements ChatModelListener {
    private Panel m_panel = null;
    private boolean m_isInConfMode = false;
    private ChatModel m_model;
    private Vector m_chatAreaListeners = new Vector();
    private TextModifier m_textModifier;

    public ChatPanel(ChatModel chatModel) {
        this.m_isInConfMode = true;
        this.m_panel = new ConfPanel(chatModel);
        this.m_model = chatModel;
        chatModel.addChatModelListener(this);
        this.arrange();
    }

    public ChatPanel(ChatModel chatModel, boolean bl, String string) {
        this.m_isInConfMode = false;
        this.m_panel = new ImPanel(chatModel, bl, string);
        this.m_model = chatModel;
        chatModel.addChatModelListener(this);
        this.arrange();
    }

    public void switchToConference() {
        Object object;
        int n;
        Vector vector = ((ImPanel)this.m_panel).getChatEditListeners();
        this.m_isInConfMode = true;
        this.m_panel = new ConfPanel(this.m_model);
        ((ConfPanel)this.m_panel).setTextModifier(this.m_textModifier);
        for (n = 0; n < vector.size(); ++n) {
            object = (ChatEditListener)vector.elementAt(n);
            this.addChatEditListener((ChatEditListener)object);
        }
        for (n = 0; n < this.m_chatAreaListeners.size(); ++n) {
            object = (ChatAreaListener)this.m_chatAreaListeners.elementAt(n);
            ((ConfPanel)this.m_panel).addChatAreaListener((ChatAreaListener)object);
        }
        this.arrange();
    }

    public void switchToMeeting(MeetingInfo meetingInfo) {
    }

    public void requestFocus() {
        this.m_panel.requestFocus();
    }

    public void sendAllText() {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).sendAllText();
        } else {
            ((ImPanel)this.m_panel).sendAllText();
        }
    }

    public void setTextModifier(TextModifier textModifier) {
        this.m_textModifier = textModifier;
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).setTextModifier(textModifier);
        } else {
            ((ImPanel)this.m_panel).setTextModifier(textModifier);
        }
    }

    public ChatSendField getChatSendField() {
        if (this.m_isInConfMode) {
            return ((ConfPanel)this.m_panel).getChatSendField();
        }
        return ((ImPanel)this.m_panel).getChatSendField();
    }

    public void setVisible(boolean bl) {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).setVisible(bl);
        } else {
            ((ImPanel)this.m_panel).setVisible(bl);
        }
    }

    public STUser[] getSelectedUsers() {
        STBoolean sTBoolean = new STBoolean(false);
        return this.getSelectedUsers(false, sTBoolean);
    }

    public STUser[] getSelectedUsers(boolean bl, STBoolean sTBoolean) {
        if (this.m_isInConfMode) {
            STUser[] sTUserArray = ((ConfPanel)this.m_panel).getSelectedUsers();
            if (bl) {
                Vector<STUser> vector = new Vector<STUser>();
                for (int i = 0; i < sTUserArray.length; ++i) {
                    if (!sTUserArray[i].isExternalUser()) {
                        vector.addElement(sTUserArray[i]);
                        continue;
                    }
                    sTBoolean.setValue(true);
                }
                Object[] objectArray = new STUser[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            return sTUserArray;
        }
        STUser[] sTUserArray = new STUser[]{this.m_model.getPartner()};
        return sTUserArray;
    }

    public void addChatEditListener(ChatEditListener chatEditListener) {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).addChatEditListener(chatEditListener);
        } else {
            ((ImPanel)this.m_panel).addChatEditListener(chatEditListener);
        }
    }

    public void removeChatEditListener(ChatEditListener chatEditListener) {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).removeChatEditListener(chatEditListener);
        } else {
            ((ImPanel)this.m_panel).removeChatEditListener(chatEditListener);
        }
    }

    public void addChatAreaListener(ChatAreaListener chatAreaListener) {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).addChatAreaListener(chatAreaListener);
        } else {
            ((ImPanel)this.m_panel).addChatAreaListener(chatAreaListener);
        }
        this.m_chatAreaListeners.addElement(chatAreaListener);
    }

    public void removeChatAreaListener(ChatAreaListener chatAreaListener) {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).removeChatAreaListener(chatAreaListener);
        } else {
            ((ImPanel)this.m_panel).removeChatAreaListener(chatAreaListener);
        }
        this.m_chatAreaListeners.removeElement(chatAreaListener);
    }

    public void cut() {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).cut();
        } else {
            ((ImPanel)this.m_panel).cut();
        }
    }

    public void copy() {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).copy();
        } else {
            ((ImPanel)this.m_panel).copy();
        }
    }

    public void paste() {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).paste();
        } else {
            ((ImPanel)this.m_panel).paste();
        }
    }

    public void clearAll() {
        if (this.m_isInConfMode) {
            ((ConfPanel)this.m_panel).clearAll();
        } else {
            ((ImPanel)this.m_panel).clearAll();
        }
    }

    private void arrange() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_panel, "Center");
        this.validate();
    }
}

