/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.chatui.AddToListListener;
import com.lotus.sametime.chatui.Blinker;
import com.lotus.sametime.chatui.ChatConstants;
import com.lotus.sametime.chatui.ChatEditEvent;
import com.lotus.sametime.chatui.ChatEditListener;
import com.lotus.sametime.chatui.ChatFactory;
import com.lotus.sametime.chatui.ChatMessage;
import com.lotus.sametime.chatui.ChatModel;
import com.lotus.sametime.chatui.ChatModelListener;
import com.lotus.sametime.chatui.ChatPanel;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.chatui.DefaultChatFactory;
import com.lotus.sametime.chatui.EscWarningOnCloseChat;
import com.lotus.sametime.chatui.MeetingInfo;
import com.lotus.sametime.chatui.ServerAttributes;
import com.lotus.sametime.chatui.UpgradeDialog;
import com.lotus.sametime.chatui.conf.ConfModelListener;
import com.lotus.sametime.chatui.im.ImModelListener;
import com.lotus.sametime.chatui.invitation.InviteDialogListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.constants.MeetingTypes;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.ImageResources;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.filetransferui.FileTransferUI;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.chat.ChatAreaListener;
import com.lotus.sametime.guiutils.chat.ChatSendFieldAdapter;
import com.lotus.sametime.guiutils.chat.ChatSendFieldEvent;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.ImagePanel;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.statusbar.Statusbar;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatFrame
extends Frame {
    private static final int SEND_MODE = 1;
    private static final int IM_MODE = 2;
    private static final int CONF_MODE = 3;
    private ChatPanel m_chatPanel;
    private ChatModel m_chatModel;
    private int m_frameState = 1;
    private Blinker m_blinker;
    private boolean m_isActivated = false;
    private boolean m_keyListenerAdded = false;
    private STBundle m_resourceFile;
    private ResourceLoaderService m_resService;
    private FileTransferUI m_fileTransferService;
    private CommunityService m_commService;
    private KeyHandler m_keyHandler;
    private UpgradeDialog m_upgradeDlg;
    private ChatAreaListener m_chatAreaListener;
    private Button m_btnSend;
    private Button m_btnInvite;
    private Button m_btnClose;
    private Menu m_mnPeople;
    private MenuItem m_miInvite;
    private MenuItem m_miAddTools;
    private MenuItem m_miAudio;
    private MenuItem m_miShare;
    private MenuItem m_miChat;
    private MenuItem m_miVideo;
    private MenuItem m_miCollaborate;
    private MenuItem m_miSendFile;
    private MenuItem m_miAddToList;
    private MenuItem m_miClose;
    private MenuItem m_miCut;
    private MenuItem m_miCopy;
    private MenuItem m_miPaste;
    private MenuItem m_miClearAll;
    private Statusbar m_statusbar;
    private ButtonsPanel m_buttonsPanel;
    private Dialog m_inviteDialog;
    private ChatUI m_ChatUIComp;
    private boolean m_showView = false;
    private boolean m_initialized = false;
    private boolean m_isEnable = true;
    private boolean m_reshaped = false;
    private Dimension m_minimumSize;
    InviteDialogListenerImpl m_inviteDialogListenerImpl;
    ChatModelListenerImpl m_chatModelListenerImpl;
    ImModelListenerImpl m_imModelListenerImpl;
    ConfModelListenerImpl m_confModelListenerImpl;
    ActionListenerImpl m_actionListenerImpl;
    ChatEditListenerImpl m_chatEditListenerImpl;
    private boolean m_isSetVisibleFisrtTime = true;
    private boolean m_firstTime = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.chatui");

    public ChatFrame(ChatModel chatModel, boolean bl, String string) {
        this.m_chatModel = chatModel;
        STSession sTSession = chatModel.getSession();
        this.m_resService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = this.m_resService.getBundle("properties/chatui");
        this.m_minimumSize = new Dimension(this.m_resourceFile.getInt("FRM_SEND_WIDTH"), this.m_resourceFile.getInt("FRM_SEND_HEIGHT"));
        this.m_ChatUIComp = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_fileTransferService = (FileTransferUI)sTSession.getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
        this.createListeners();
        this.m_frameState = bl ? 1 : 2;
        this.m_chatPanel = new ChatPanel(this.m_chatModel, bl, string);
        this.m_chatPanel.addChatEditListener(this.m_chatEditListenerImpl);
        this.m_chatModel.addImModelListener(this.m_imModelListenerImpl);
        this.init(string);
        chatModel.addChatModelListener(this.m_chatModelListenerImpl);
        this.setTextModifier();
        STUserStatus sTUserStatus = chatModel.getPartnerStatus();
        if (bl && sTUserStatus != null && !sTUserStatus.isStatus((short)0) && !sTUserStatus.isStatus((short)128)) {
            this.setVisible(true);
        }
    }

    public ChatFrame(ChatModel chatModel) {
        this.m_chatModel = chatModel;
        STSession sTSession = chatModel.getSession();
        this.m_resService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = this.m_resService.getBundle("properties/chatui");
        this.m_minimumSize = new Dimension(this.m_resourceFile.getInt("FRM_SEND_WIDTH"), this.m_resourceFile.getInt("FRM_SEND_HEIGHT"));
        this.m_ChatUIComp = (ChatUI)sTSession.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_fileTransferService = (FileTransferUI)sTSession.getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
        this.createListeners();
        this.m_frameState = 3;
        this.m_chatPanel = new ChatPanel(this.m_chatModel);
        this.m_chatPanel.addChatEditListener(this.m_chatEditListenerImpl);
        this.m_chatModel.addConfModelListener(this.m_confModelListenerImpl);
        this.init(chatModel.getConfInfo().getDisplayName());
        chatModel.addChatModelListener(this.m_chatModelListenerImpl);
        this.setTextModifier();
        this.setVisible(true);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top, insets.left + 10, insets.bottom + 10, insets.right + 10);
    }

    public ChatModel getChatModel() {
        return this.m_chatModel;
    }

    public ChatPanel getChatPanel() {
        return this.m_chatPanel;
    }

    public void addChatAreaListener(ChatAreaListener chatAreaListener) {
        this.m_chatAreaListener = chatAreaListener;
        this.m_chatPanel.addChatAreaListener(chatAreaListener);
    }

    public void setTextModifier() {
        DefaultChatFactory defaultChatFactory = (DefaultChatFactory)this.m_ChatUIComp.getChatFactory();
        this.m_chatPanel.setTextModifier(defaultChatFactory.getTextModifier(this));
    }

    private void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.closeChat();
        }
    }

    private void windowDeiconified(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.setSize(this.getPreferredSize());
        }
    }

    public void setVisible(boolean bl) {
        if (this.m_initialized) {
            if (this.m_chatPanel != null) {
                this.m_chatPanel.setVisible(bl);
            }
            if (!this.m_reshaped) {
                this.pack();
                this.setPosition();
                this.reshapeFrame();
            }
            this.m_keyHandler = this.m_frameState == 1 ? this.createKeyHandlerForSend() : this.createKeyHandler();
            AccessibilityHelpers.addKeyListenerToSubComponents(this, this.m_keyHandler);
            this.m_keyListenerAdded = true;
            if (this.m_frameState == 1 && this.m_isSetVisibleFisrtTime) {
                this.m_btnSend.setEnabled(false);
                this.m_isSetVisibleFisrtTime = false;
            }
            if (this.m_chatPanel.getChatSendField() != null) {
                this.m_chatPanel.getChatSendField().addSendFieldListener(new ChatSendFieldAdapter(){

                    public void contentChanged(ChatSendFieldEvent chatSendFieldEvent) {
                        if (ChatFrame.this.m_frameState == 1) {
                            ChatFrame.this.m_btnSend.setEnabled(!chatSendFieldEvent.getIsEmpty());
                        }
                    }
                });
            }
            super.setVisible(bl);
        } else {
            this.m_showView = bl;
        }
        if (!bl && this.m_inviteDialog != null) {
            this.m_inviteDialog.dispose();
            this.m_inviteDialog = null;
        }
        if (!bl) {
            if (this.m_blinker != null) {
                this.m_blinker.terminateThread();
            }
            if (this.m_showView != bl) {
                this.m_showView = bl;
                this.dispose();
            }
        }
    }

    public void toFront() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "toFront", "Chat Frame To Front " + this.getTitle());
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        super.toFront();
        this.requestFocus();
    }

    public void toolsEnabled(ServerAttributes serverAttributes) {
        if (serverAttributes.isMeetingEnabled()) {
            this.reshapeFrame();
        }
    }

    private void messageReceived(ChatMessage chatMessage) {
        Object object;
        if (!this.m_initialized) {
            return;
        }
        this.requestFocus();
        if (!this.isVisible() && !chatMessage.isMyText()) {
            this.setVisible(true);
            this.m_chatPanel.setVisible(true);
        }
        this.m_statusbar.setStatus("");
        if (this.m_frameState == 1) {
            this.switchToIm();
            object = this.m_resourceFile.getString("WAITING_FOR_RESPONSE");
            this.m_statusbar.setStatus((String)object);
        }
        if (this.m_ChatUIComp != null && this.m_ChatUIComp.getToFrontOnMessage()) {
            this.toFront();
        } else if (!this.isShowing() && !chatMessage.isMyText()) {
            this.toBack();
        }
        this.m_blinker.stopBlinking();
        if (!this.m_isActivated && this.m_ChatUIComp != null && this.m_ChatUIComp.getBlinkOnMessage() && !chatMessage.isMyText()) {
            this.m_blinker.startBlinking();
        }
        if (this.m_ChatUIComp != null) {
            object = (DefaultChatFactory)this.m_ChatUIComp.getChatFactory();
            ((DefaultChatFactory)object).messageReceived(chatMessage, this.m_ChatUIComp.getBeepOnMessage());
        }
    }

    private void windowActivated(WindowEvent windowEvent) {
        if (this.m_firstTime) {
            this.m_firstTime = false;
        } else {
            this.m_isActivated = true;
            this.m_blinker.stopBlinking();
        }
    }

    private void windowDeactivated(WindowEvent windowEvent) {
        this.m_isActivated = false;
    }

    private void enableSendMessage(boolean bl) {
        this.m_isEnable = bl;
        if (this.m_btnSend != null) {
            this.m_btnSend.setEnabled(bl);
        }
        if (this.m_btnInvite != null) {
            this.m_btnInvite.setEnabled(bl && !this.isExternalUser());
        }
        if (this.m_miAddTools != null) {
            if (!bl) {
                this.m_miAddTools.setEnabled(false);
            } else {
                this.enableAddToolsMenuItems();
            }
        }
        if (this.m_miAddToList != null) {
            this.m_miAddToList.setEnabled(bl);
        }
        if (this.m_miInvite != null) {
            this.m_miInvite.setEnabled(bl && !this.isExternalUser());
        }
        if (this.m_mnPeople != null) {
            this.m_mnPeople.setEnabled(bl);
        }
        if (this.m_statusbar != null) {
            String string = bl ? this.m_resourceFile.getString("CONNECTED") : (this.m_commService.isLoggedIn() ? this.m_resourceFile.getString("CHAT_CANT_CONTINUE") : this.m_resourceFile.getString("DISCONNECTED"));
            this.m_statusbar.setStatus(string);
        }
    }

    private void encryptionModeChanged(boolean bl) {
        if (this.m_statusbar != null) {
            if (bl) {
                this.m_statusbar.setEncImage(this.m_resService.getImage("images/encrypt_key.gif"));
            } else {
                this.m_statusbar.setEncImage(this.m_resService.getImage("images/no_encrypt_key.gif"));
            }
        }
    }

    private void responseStarted(STUser sTUser) {
        if (this.m_statusbar != null) {
            String string = sTUser.getDisplayName();
            String string2 = this.m_resourceFile.formatString("USER_RESPONDING", string);
            this.m_statusbar.setStatus(string2);
        }
    }

    private void responseCleared(STUser sTUser) {
        if (this.m_statusbar != null) {
            this.m_statusbar.setStatus("");
        }
    }

    private void invitationDeclined(STUser sTUser, int n) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "invitationDeclined", "invitation declined, reason = " + n);
        }
        Dialog dialog = null;
        if (n == -2147475455 || n == -2147483642) {
            Object[] objectArray = new String[]{sTUser.getDisplayName()};
            dialog = new UbqDialog((Frame)this, this.m_resourceFile.getString("FRM_TITLE_ALERT"), this.m_resourceFile.formatStringArray("USER_DND_CONF", objectArray), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        } else if (n == -2147483617 || n == -2147483619) {
            String string = this.m_chatModel.getConfInfo().getDisplayName();
            Object[] objectArray = new String[]{sTUser.getDisplayName(), string};
            dialog = new UbqDialog((Frame)this, this.m_resourceFile.getString("FRM_TITLE_ENC_NOT_SUPPORTED"), this.m_resourceFile.formatStringArray("ENC_NOT_SUPPORTED_CONF", objectArray), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
        }
        if (dialog != null) {
            dialog.setModal(false);
            ((UbqDialog)dialog).setVisible(true);
        }
    }

    private void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSend) {
            this.m_chatPanel.sendAllText();
            this.m_chatPanel.requestFocus();
        } else if (object == this.m_btnInvite || object == this.m_miInvite) {
            this.doInviteDialog();
        } else if (object == this.m_btnClose || object == this.m_miClose) {
            this.closeChat();
        } else if (object == this.m_miAddToList) {
            this.handleAddToList();
        } else if (object == this.m_miAddTools) {
            this.launchUpgradeDialog();
        } else if (object == this.m_miAudio) {
            this.launchMeeting(MeetingTypes.ST_AUDIO_MEETING);
        } else if (object == this.m_miVideo) {
            this.launchMeeting(MeetingTypes.ST_VIDEO_MEETING);
        } else if (object == this.m_miShare) {
            this.launchMeeting(MeetingTypes.ST_SHARE_MEETING);
        } else if (object == this.m_miCollaborate) {
            this.launchMeeting(MeetingTypes.ST_COLLABORATION_MEETING);
        } else if (object == this.m_miChat) {
            this.launchMeeting(MeetingTypes.ST_CHAT_MEETING);
        } else if (object == this.m_miSendFile) {
            this.createFileTransfer();
        } else if (object == this.m_miCut) {
            this.m_chatPanel.cut();
        } else if (object == this.m_miCopy) {
            this.m_chatPanel.copy();
        } else if (object == this.m_miPaste) {
            this.m_chatPanel.paste();
        } else if (object == this.m_miClearAll) {
            this.m_chatPanel.clearAll();
        }
    }

    private void launchMeeting(MeetingTypes meetingTypes) {
        STUser[] sTUserArray = this.m_chatPanel.getSelectedUsers();
        if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING) && sTUserArray.length == 1) {
            this.m_ChatUIComp.create1On1ChatById(sTUserArray[0]);
        } else {
            STBoolean sTBoolean = new STBoolean(false);
            STUser[] sTUserArray2 = this.m_chatPanel.getSelectedUsers(true, sTBoolean);
            if (sTUserArray2.length > 0) {
                this.m_ChatUIComp.createMeeting(meetingTypes, "", "", true, sTUserArray2);
            }
            if (sTBoolean.getValue()) {
                String string = "NON_ST_USERS_IN_CHAT";
                if (meetingTypes.equals(MeetingTypes.ST_AUDIOBRIDGE_MEETING)) {
                    string = "NON_ST_USERS_IN_AUDIOBRIDGE_MEETING";
                } else if (meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING)) {
                    string = "NON_ST_USERS_IN_VIDEO_MEETING";
                } else if (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING)) {
                    string = "NON_ST_USERS_IN_AUDIO_MEETING";
                } else if (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING)) {
                    string = "NON_ST_USERS_IN_COLLABORATION_MEETING";
                } else if (meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING)) {
                    string = "NON_ST_USERS_IN_APPSHARE_MEETING";
                }
                Image image = ImageResources.getInstance().getImage("images/alert.gif");
                UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), this.m_resourceFile.getString("SAMETIME_TITLE"), this.m_resourceFile.formatStringArray(string), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
                ubqDialog.setImage(image);
                ubqDialog.setVisible(true);
            }
        }
    }

    private void launchUpgradeDialog() {
        if (this.m_upgradeDlg == null) {
            String string = this.m_resourceFile.getString("UPGRADE_DIALOG_TITLE");
            this.m_upgradeDlg = new UpgradeDialog(this, this.m_chatModel.getSession(), string);
            this.m_upgradeDlg.setVisible(true);
            this.m_upgradeDlg.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ChatFrame.this.m_upgradeDlg = null;
                }

                public void windowClosed(WindowEvent windowEvent) {
                    ChatFrame.this.m_upgradeDlg = null;
                }
            });
        } else {
            this.m_upgradeDlg.toFront();
        }
    }

    protected void createFileTransfer() {
        STBoolean sTBoolean = new STBoolean(false);
        STUser[] sTUserArray = this.m_chatPanel.getSelectedUsers(true, sTBoolean);
        if (sTBoolean.getValue()) {
            Image image = ImageResources.getInstance().getImage("images/alert.gif");
            UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), this.m_resourceFile.getString("SAMETIME_TITLE"), this.m_resourceFile.formatStringArray("NON_ST_USERS_IN_CHAT"), this.m_resourceFile.formatStringArray("BTN_LBL_OK"));
            ubqDialog.setImage(image);
            ubqDialog.setVisible(true);
        } else if (sTUserArray.length == 1) {
            this.m_fileTransferService.sendFile(sTUserArray[0]);
        }
    }

    private void switchToConference() {
        AccessibilityHelpers.removeKeyListenerFromSubComponents(this, this.m_keyHandler);
        this.m_chatModel.removeImModelListener(this.m_imModelListenerImpl);
        this.m_chatModel.addConfModelListener(this.m_confModelListenerImpl);
        this.m_frameState = 3;
        this.reshapeFrame();
        this.m_keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, this.m_keyHandler);
        this.m_keyListenerAdded = true;
    }

    private void userEntered(STUser sTUser) {
        if (this.m_statusbar != null) {
            String string = sTUser.getDisplayName();
            String string2 = this.m_resourceFile.formatString("USER_ENTERED", string);
            this.m_statusbar.setStatus(string2);
        }
    }

    private void userLeft(STUser sTUser) {
        if (this.m_statusbar != null) {
            String string = sTUser.getDisplayName();
            String string2 = this.m_resourceFile.formatString("USER_LEFT", string);
            this.m_statusbar.setStatus(string2);
        }
    }

    private void inviteDialogCanceled(Dialog dialog) {
        this.m_inviteDialog = null;
    }

    private void inviteDlgSendClicked(Dialog dialog, String string, String string2, STUser[] sTUserArray, EncLevel encLevel, Vector vector) {
        this.m_inviteDialog = null;
        MeetingTypes meetingTypes = ChatConstants.getMeetingType(vector);
        if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING)) {
            if (this.m_chatModel.isInConfMode()) {
                this.m_chatModel.inviteToConference(sTUserArray, string2);
            } else {
                this.m_chatModel.switchToConference(this.m_chatModel.getSession(), string, encLevel, sTUserArray, string2);
            }
        }
    }

    void upgrade(Vector vector) {
        this.m_upgradeDlg = null;
        this.m_chatModel.upgradeToMeeting(vector, true);
    }

    private void init(String string) {
        this.m_firstTime = true;
        if (this.m_frameState == 1) {
            this.setTitle(this.m_resourceFile.getString("SEND_TITLE"));
        } else {
            this.setFrameTitle(string);
        }
        DefaultChatFactory defaultChatFactory = (DefaultChatFactory)this.m_ChatUIComp.getChatFactory();
        if (StaticProps.m_bUnixOS) {
            this.setBackground(Color.lightGray);
        } else {
            this.setBackground(SystemColor.control);
        }
        this.setLayout(new BorderLayout(0, 4));
        Panel panel = defaultChatFactory.getCustomizedPanels(1, this);
        if (panel != null) {
            this.add("North", panel);
        }
        this.add("Center", this.m_chatPanel);
        Panel panel2 = new Panel(new BorderLayout(0, 4));
        this.m_buttonsPanel = new ButtonsPanel();
        Panel panel3 = this.createUserTypeIconPanel();
        panel2.add("Center", this.m_buttonsPanel);
        panel2.add("West", panel3);
        Panel panel4 = new Panel(new BorderLayout(0, 4));
        Panel panel5 = defaultChatFactory.getCustomizedPanels(3, this);
        panel4.add("North", panel2);
        if (panel5 != null) {
            panel4.add("South", panel5);
        }
        Panel panel6 = new Panel(new BorderLayout(0, 4));
        Panel panel7 = defaultChatFactory.getCustomizedPanels(2, this);
        if (panel7 != null) {
            panel6.add("North", panel7);
        }
        panel6.add("Center", panel4);
        this.createStatusBar();
        panel6.add("South", this.m_statusbar);
        this.add("South", panel6);
        this.createWindowListener();
        this.m_blinker = new Blinker(this, this.m_resourceFile.getString("BLINKING_MESSAGE"));
        this.m_initialized = true;
        if (this.m_showView) {
            this.setVisible(true);
        }
        if (!this.m_chatModel.isViewEnabled()) {
            this.enableSendMessage(false);
        }
        this.m_statusbar.setStatus("");
    }

    private void switchToIm() {
        AccessibilityHelpers.removeKeyListenerFromSubComponents(this, this.m_keyHandler);
        this.m_frameState = 2;
        this.setFrameTitle(this.m_chatModel.getPartner().getDisplayName());
        this.reshapeFrame();
        this.m_keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, this.m_keyHandler);
        this.m_keyListenerAdded = true;
    }

    private void reshapeFrame() {
        this.setMenu();
        this.setButtons();
        Dimension dimension = ((DefaultChatFactory)this.m_ChatUIComp.getChatFactory()).getFrameSize();
        int n = dimension.height;
        int n2 = dimension.width;
        if (n != 0 || n2 != 0) {
            this.setSize(dimension);
        } else {
            this.setSize(this.getPreferredSize());
        }
        this.validate();
        this.m_reshaped = true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = dimension.width < this.m_minimumSize.width ? this.m_minimumSize.width : dimension.width;
        int n2 = dimension.height < this.m_minimumSize.height ? this.m_minimumSize.height : dimension.height;
        return new Dimension(n, n2);
    }

    private void setMenu() {
        if (this.m_frameState == 1) {
            return;
        }
        boolean bl = false;
        Integer n = (Integer)this.m_chatModel.getSession().getSessionProperty("fileTransferMaxFileSize");
        if (n != null && n != 0) {
            bl = true;
        }
        Menu menu = new Menu(this.m_resourceFile.getString("MENU_MEETING"));
        this.m_miAddTools = new MenuItem(this.m_resourceFile.getString("MENUITEM_UPGRADE"));
        if (StaticProps.m_bMacOSX) {
            this.m_miAddTools.setEnabled(false);
        }
        if (this.m_chatModel.isMeetingEnabled()) {
            this.m_miAddTools.addActionListener(this.m_actionListenerImpl);
            menu.add(this.m_miAddTools);
        }
        if (!this.isExternalUser()) {
            this.m_miInvite = new MenuItem(this.m_resourceFile.getString("MENUITEM_INVITE"));
            this.m_miInvite.addActionListener(this.m_actionListenerImpl);
            menu.add(this.m_miInvite);
        }
        this.addUserItems(menu);
        menu.addSeparator();
        if (this.m_frameState == 3) {
            boolean bl2 = this.m_ChatUIComp.isAudioEnabled();
            boolean bl3 = this.m_ChatUIComp.isVideoEnabled();
            boolean bl4 = this.m_ChatUIComp.isAudioBridgeEnabled();
            this.m_mnPeople = new Menu(this.m_resourceFile.getString("MENU_PEOPLE"));
            this.m_miChat = new MenuItem(this.m_resourceFile.getString("MENUITEM_CHAT"));
            this.m_miChat.addActionListener(this.m_actionListenerImpl);
            this.m_mnPeople.add(this.m_miChat);
            this.m_miAudio = new MenuItem(this.m_resourceFile.getString("MENUITEM_AUDIO"));
            this.m_miAudio.addActionListener(this.m_actionListenerImpl);
            if (bl2 && this.m_chatModel.isMeetingEnabled()) {
                if (StaticProps.m_bUnixOS) {
                    this.m_miAudio.setEnabled(false);
                }
                this.m_mnPeople.add(this.m_miAudio);
            }
            this.m_miVideo = new MenuItem(this.m_resourceFile.getString("MENUITEM_VIDEO"));
            this.m_miVideo.addActionListener(this.m_actionListenerImpl);
            if (bl3 && this.m_chatModel.isMeetingEnabled()) {
                if (StaticProps.m_bUnixOS) {
                    this.m_miVideo.setEnabled(false);
                }
                this.m_mnPeople.add(this.m_miVideo);
            }
            if (this.m_chatModel.isMeetingEnabled() && (this.m_ChatUIComp.isAppShareEnabled() || this.m_ChatUIComp.isWhiteBoardEnabled())) {
                this.m_miShare = new MenuItem(this.m_resourceFile.getString("MENUITEM_SHARE"));
                this.m_miShare.addActionListener(this.m_actionListenerImpl);
                this.m_mnPeople.add(this.m_miShare);
            }
            if (this.m_chatModel.isMeetingEnabled()) {
                this.m_miCollaborate = new MenuItem(this.m_resourceFile.getString("MENUITEM_COLLABORATE"));
                this.m_miCollaborate.addActionListener(this.m_actionListenerImpl);
                this.m_mnPeople.add(this.m_miCollaborate);
            }
            this.m_miSendFile = new MenuItem(this.m_resourceFile.getString("MENUITEM_SEND_FILE"));
            this.m_miSendFile.addActionListener(this.m_actionListenerImpl);
            if (bl) {
                this.m_mnPeople.addSeparator();
                this.m_mnPeople.add(this.m_miSendFile);
            }
            menu.add(this.m_mnPeople);
            menu.addSeparator();
        } else {
            this.m_miSendFile = new MenuItem(this.m_resourceFile.getString("MENUITEM_SEND_FILE"));
            this.m_miSendFile.addActionListener(this.m_actionListenerImpl);
            if (bl) {
                menu.add(this.m_miSendFile);
                menu.addSeparator();
            }
        }
        String string = this.m_frameState == 3 ? "MENUITEM_CLOSE_CONF" : "MENUITEM_CLOSE";
        this.m_miClose = new MenuItem(this.m_resourceFile.getString(string));
        this.m_miClose.addActionListener(this.m_actionListenerImpl);
        menu.add(this.m_miClose);
        Menu menu2 = new Menu(this.m_resourceFile.getString("MENU_EDIT"));
        this.m_miCut = new MenuItem(this.m_resourceFile.getString("MENUITEM_CUT"));
        this.m_miCut.addActionListener(this.m_actionListenerImpl);
        menu2.add(this.m_miCut);
        this.m_miCopy = new MenuItem(this.m_resourceFile.getString("MENUITEM_COPY"));
        this.m_miCopy.addActionListener(this.m_actionListenerImpl);
        menu2.add(this.m_miCopy);
        this.m_miPaste = new MenuItem(this.m_resourceFile.getString("MENUITEM_PASTE"));
        this.m_miPaste.addActionListener(this.m_actionListenerImpl);
        menu2.add(this.m_miPaste);
        menu2.addSeparator();
        this.m_miClearAll = new MenuItem(this.m_resourceFile.getString("MENUITEM_CLEAR_ALL"));
        this.m_miClearAll.addActionListener(this.m_actionListenerImpl);
        menu2.add(this.m_miClearAll);
        MenuBar menuBar = new MenuBar();
        menuBar.add(menu);
        menuBar.add(menu2);
        this.enableAddToolsMenuItems();
        this.disableEditMenuItems();
        DefaultChatFactory defaultChatFactory = (DefaultChatFactory)this.m_ChatUIComp.getChatFactory();
        defaultChatFactory.getCustomizedMenu(menuBar);
        this.setMenuBar(menuBar);
    }

    private void enableAddToolsMenuItems() {
        if (this.m_frameState == 3) {
            boolean bl = this.m_chatModel.isPlacesModel();
        } else {
            boolean bl = this.m_chatModel.isWatsonServer(this.m_chatModel.getSession()) && !this.m_chatModel.getPartner().isExternalUser();
        }
    }

    private void disableEditMenuItems() {
        this.m_miCut.setEnabled(false);
        this.m_miCopy.setEnabled(false);
        this.m_miPaste.setEnabled(false);
        this.m_miClearAll.setEnabled(false);
    }

    private void setButtons() {
        this.m_buttonsPanel.removeAll();
        String[] stringArray = new String[this.m_frameState != 1 && !this.isExternalUser() ? 3 : 2];
        stringArray[0] = this.m_resourceFile.getString("BTN_LBL_SEND");
        if (this.m_frameState != 1 && !this.isExternalUser()) {
            stringArray[1] = this.m_resourceFile.getString("BTN_LBL_INVITE");
        }
        String string = this.m_frameState == 3 ? "BTN_LBL_CLOSE_CONF" : "BTN_LBL_CLOSE";
        stringArray[stringArray.length - 1] = this.m_resourceFile.getString(string);
        this.m_buttonsPanel.setButtons(stringArray, this.m_actionListenerImpl, (short)2);
        this.m_btnSend = this.m_buttonsPanel.getButton(stringArray[0]);
        this.m_btnSend.setEnabled(this.m_isEnable);
        if (this.m_frameState != 1 && !this.isExternalUser()) {
            this.m_btnInvite = this.m_buttonsPanel.getButton(stringArray[1]);
            this.m_btnInvite.setEnabled(this.m_isEnable);
        }
        this.m_btnClose = this.m_buttonsPanel.getButton(stringArray[stringArray.length - 1]);
    }

    private Panel createUserTypeIconPanel() {
        STUserStatus sTUserStatus = this.m_chatModel.getPartnerStatus();
        if (this.m_frameState == 1 || this.m_frameState == 2) {
            boolean bl = this.m_chatModel.getPartner().isExternalUser();
            if (sTUserStatus != null && sTUserStatus.isStatus((short)512)) {
                Image image = this.m_resService.getImage("images/mobile.gif");
                ImagePanel imagePanel = new ImagePanel(image, 0, 1);
                return imagePanel;
            }
            if (bl) {
                Image image = this.m_resService.getImage("images/external.gif");
                ImagePanel imagePanel = new ImagePanel(image, 0, 1);
                return imagePanel;
            }
        }
        Panel panel = new Panel();
        return panel;
    }

    private void createStatusBar() {
        Image image = null;
        image = this.m_chatModel.isEncrypted() ? this.m_resService.getImage("images/encrypt_key.gif") : this.m_resService.getImage("images/no_encrypt_key.gif");
        this.m_statusbar = new Statusbar(this.m_resourceFile.getString("DEFAULT_STATUS_MSG"), this.m_resourceFile.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE"), this.m_resourceFile.getInt("STATUSBAR_HEIGHT"), image);
    }

    protected void doInviteDialog() {
        if (this.m_inviteDialog == null) {
            boolean bl = this.m_chatModel.isInConfMode();
            String string = bl ? this.m_chatModel.getConfInfo().getDisplayName() : null;
            Vector vector = ChatConstants.getActivities(MeetingTypes.ST_CHAT_MEETING, false);
            ChatFactory chatFactory = this.m_ChatUIComp.getChatFactory();
            this.m_inviteDialog = chatFactory.doInviteDialog(this.m_chatModel.getSession(), MeetingTypes.ST_CHAT_MEETING, string, "", null, false, this.m_inviteDialogListenerImpl);
        }
        this.m_inviteDialog.toFront();
        this.m_inviteDialog.requestFocus();
    }

    protected void createWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChatFrame.this.windowClosing(windowEvent);
            }

            public void windowActivated(WindowEvent windowEvent) {
                ChatFrame.this.windowActivated(windowEvent);
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                ChatFrame.this.windowDeactivated(windowEvent);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                ChatFrame.this.windowDeiconified(windowEvent);
            }
        });
    }

    protected void setPosition() {
        ChatFactory chatFactory = this.m_ChatUIComp.getChatFactory();
        chatFactory.position(this);
    }

    public void requestFocus() {
        this.m_chatPanel.requestFocus();
    }

    protected void addUserItems(Menu menu) {
        DefaultChatFactory defaultChatFactory = (DefaultChatFactory)this.m_ChatUIComp.getChatFactory();
        if (defaultChatFactory.getAddToListListener() != null) {
            this.m_miAddToList = new MenuItem(this.m_resourceFile.getString("MENUITEM_ADD_TO_LIST"));
            this.m_miAddToList.addActionListener(this.m_actionListenerImpl);
            menu.add(this.m_miAddToList);
        }
        Enumeration enumeration = defaultChatFactory.getFrameMenuItems();
        while (enumeration.hasMoreElements()) {
            menu.add((MenuItem)enumeration.nextElement());
        }
    }

    protected void handleAddToList() {
        ChatFactory chatFactory = this.m_ChatUIComp.getChatFactory();
        AddToListListener addToListListener = chatFactory.getAddToListListener();
        if (addToListListener != null) {
            addToListListener.addToList(this.m_chatPanel.getSelectedUsers());
        }
    }

    private void editStatusChanged(ChatEditEvent chatEditEvent) {
        if (this.m_miCut == null || this.m_miCopy == null || this.m_miPaste == null || this.m_miClearAll == null) {
            return;
        }
        this.m_miCut.setEnabled(chatEditEvent.getCutEnabled());
        this.m_miCopy.setEnabled(chatEditEvent.getCopyEnabled());
        this.m_miPaste.setEnabled(chatEditEvent.getPasteEnabled());
        this.m_miClearAll.setEnabled(chatEditEvent.getClearAllEnabled());
    }

    protected void closeChat() {
        if (this.m_chatAreaListener != null) {
            this.m_chatPanel.removeChatAreaListener(this.m_chatAreaListener);
        }
        this.m_chatModel.closeChat();
        this.m_blinker.terminateThread();
    }

    private KeyHandler createKeyHandlerForSend() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                if (ChatFrame.this.m_logger.isLoggable(Level.FINER)) {
                    ChatFrame.this.m_logger.logp(Level.FINER, this.getClass().getName(), "executeKeyMethod", "Esc Button Was pressed : createKeyHandlerForSend()");
                }
                EscWarningOnCloseChat escWarningOnCloseChat = new EscWarningOnCloseChat(true, ChatFrame.this);
                escWarningOnCloseChat.setVisible(true);
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_SEND"))){

            public void executeKeyMethod() {
                ChatFrame.this.m_chatPanel.sendAllText();
                ChatFrame.this.m_chatPanel.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
                ChatFrame.this.closeChat();
            }
        });
        return new KeyHandler(vector);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                if (ChatFrame.this.m_logger.isLoggable(Level.FINER)) {
                    ChatFrame.this.m_logger.logp(Level.FINER, this.getClass().getName(), "createKeyHandler", "Esc Button Was pressed : createKeyHandler()");
                }
                EscWarningOnCloseChat escWarningOnCloseChat = new EscWarningOnCloseChat(true, ChatFrame.this);
                escWarningOnCloseChat.setVisible(true);
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_SEND"))){

            public void executeKeyMethod() {
                ChatFrame.this.m_chatPanel.sendAllText();
                ChatFrame.this.m_chatPanel.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_INVITE_OTHERS"))){

            public void executeKeyMethod() {
                ChatFrame.this.doInviteDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_TEXT_TYPE_YOUR_TEXT"))){

            public void executeKeyMethod() {
                ChatFrame.this.m_chatPanel.requestFocus();
            }
        });
        if (this.m_frameState == 2) {
            vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_CLOSE"))){

                public void executeKeyMethod() {
                    ChatFrame.this.closeChat();
                }
            });
        } else {
            vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_LEAVE"))){

                public void executeKeyMethod() {
                    ChatFrame.this.closeChat();
                }
            });
        }
        return new KeyHandler(vector);
    }

    private void createListeners() {
        this.m_inviteDialogListenerImpl = new InviteDialogListenerImpl();
        this.m_chatModelListenerImpl = new ChatModelListenerImpl();
        this.m_imModelListenerImpl = new ImModelListenerImpl();
        this.m_confModelListenerImpl = new ConfModelListenerImpl();
        this.m_actionListenerImpl = new ActionListenerImpl();
        this.m_chatEditListenerImpl = new ChatEditListenerImpl();
    }

    private void setFrameTitle(String string) {
        Date date = new Date();
        String string2 = DateFormat.getTimeInstance(3).format(new Date(System.currentTimeMillis()));
        Object[] objectArray = new String[]{string, string2};
        this.setTitle(this.m_resourceFile.formatString("CONVERSATION_TITLE", objectArray));
    }

    protected Frame getMainFrame() {
        Frame frame = (Frame)this.m_chatModel.getSession().getSessionProperty("mainFrame");
        return frame == null ? new Frame() : frame;
    }

    private boolean isExternalUser() {
        STUser sTUser;
        boolean bl = false;
        if (this.m_frameState != 3 && null != (sTUser = this.m_chatModel.getPartner())) {
            bl = sTUser.isExternalUser();
        }
        return bl;
    }

    protected STBundle getResourceFile() {
        return this.m_resourceFile;
    }

    class ChatEditListenerImpl
    implements ChatEditListener {
        ChatEditListenerImpl() {
        }

        public void editStatusChanged(ChatEditEvent chatEditEvent) {
            ChatFrame.this.editStatusChanged(chatEditEvent);
        }
    }

    class ActionListenerImpl
    implements ActionListener {
        ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChatFrame.this.actionPerformed(actionEvent);
        }
    }

    class ConfModelListenerImpl
    implements ConfModelListener {
        ConfModelListenerImpl() {
        }

        public void setVisible(boolean bl) {
            ChatFrame.this.setVisible(bl);
        }

        public void toFront() {
            ChatFrame.this.toFront();
        }

        public void toolsEnabled(ServerAttributes serverAttributes) {
            ChatFrame.this.toolsEnabled(serverAttributes);
        }

        public void enableSendMessage(boolean bl) {
            ChatFrame.this.enableSendMessage(bl);
        }

        public void messageReceived(ChatMessage chatMessage) {
            ChatFrame.this.messageReceived(chatMessage);
        }

        public void responseStarted(STUser sTUser) {
            ChatFrame.this.responseStarted(sTUser);
        }

        public void responseCleared(STUser sTUser) {
            ChatFrame.this.responseCleared(sTUser);
        }

        public void sendFailed(int n) {
        }

        public void userEntered(STUser sTUser) {
            ChatFrame.this.userEntered(sTUser);
        }

        public void userLeft(STUser sTUser) {
            ChatFrame.this.userLeft(sTUser);
        }

        public void encryptionModeChanged(boolean bl) {
            ChatFrame.this.encryptionModeChanged(bl);
        }

        public void invitationDeclined(STUser sTUser, int n) {
            ChatFrame.this.invitationDeclined(sTUser, n);
        }

        public void switchToMeeting(MeetingInfo meetingInfo) {
        }
    }

    class ImModelListenerImpl
    implements ImModelListener {
        ImModelListenerImpl() {
        }

        public void setVisible(boolean bl) {
            ChatFrame.this.setVisible(bl);
        }

        public void toFront() {
            ChatFrame.this.toFront();
        }

        public void enableSendMessage(boolean bl) {
            ChatFrame.this.enableSendMessage(bl);
        }

        public void messageReceived(ChatMessage chatMessage) {
            ChatFrame.this.messageReceived(chatMessage);
        }

        public void encryptionModeChanged(boolean bl) {
            ChatFrame.this.encryptionModeChanged(bl);
        }

        public void responseStarted(STUser sTUser) {
            ChatFrame.this.responseStarted(sTUser);
        }

        public void responseCleared(STUser sTUser) {
            ChatFrame.this.responseCleared(sTUser);
        }

        public void sendFailed(int n) {
        }
    }

    class ChatModelListenerImpl
    implements ChatModelListener {
        ChatModelListenerImpl() {
        }

        public void switchToConference() {
            ChatFrame.this.switchToConference();
        }

        public void switchToMeeting(MeetingInfo meetingInfo) {
        }
    }

    class InviteDialogListenerImpl
    implements InviteDialogListener {
        InviteDialogListenerImpl() {
        }

        public void inviteDialogCanceled(Dialog dialog) {
            ChatFrame.this.inviteDialogCanceled(dialog);
        }

        public void inviteDlgSendClicked(Dialog dialog, String string, String string2, STUser[] sTUserArray, EncLevel encLevel, Vector vector) {
            ChatFrame.this.inviteDlgSendClicked(dialog, string, string2, sTUserArray, encLevel, vector);
        }
    }
}

