/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui.tree;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeListener;
import com.lotus.sametime.awareness.AwarenessServiceEvent;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.StatusEvent;
import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.awarenessui.tree.STFakedWatchedUser;
import com.lotus.sametime.awarenessui.tree.STPrivateGroup;
import com.lotus.sametime.awarenessui.tree.STPublicGroup;
import com.lotus.sametime.awarenessui.tree.STTreeEvent;
import com.lotus.sametime.awarenessui.tree.STTreeFilter;
import com.lotus.sametime.awarenessui.tree.STTreeGroup;
import com.lotus.sametime.awarenessui.tree.TreeStatusEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.guiutils.tree.EmptyNode;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TreeEvent;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.names.NamesEvent;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STTreeModel
extends AwarenessModel
implements AttributeListener {
    private static final boolean RETRIEVE_FIRST = true;
    private static final boolean RETRIEVE_ALL = false;
    private String m_publicEmptyNode;
    private String m_privateEmptyNode;
    private Hashtable m_usersOnWatchQue = new Hashtable();
    private boolean addingUser = false;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awarenessui.tree");

    public STTreeModel(STSession sTSession) {
        super(sTSession);
        this.m_publicEmptyNode = this.m_res.getString("PUBLIC_EMPTY_NODE");
        this.m_privateEmptyNode = this.m_res.getString("PRIVATE_EMPTY_NODE");
    }

    public STWatchedUser[] getSelectedUsers(Vector vector) {
        Vector<ModelNode> vector2 = new Vector<ModelNode>();
        STUser[] sTUserArray = vector.elements();
        while (sTUserArray.hasMoreElements()) {
            ModelNode modelNode = (ModelNode)sTUserArray.nextElement();
            if (this.isGroup(modelNode)) continue;
            vector2.addElement(modelNode);
        }
        sTUserArray = new STUser[vector2.size()];
        sTUserArray = this.getUsersFromNodes(vector2);
        STWatchedUser[] sTWatchedUserArray = new STWatchedUser[sTUserArray.length];
        for (int i = 0; i < sTUserArray.length; ++i) {
            sTWatchedUserArray[i] = (STWatchedUser)sTUserArray[i];
        }
        return sTWatchedUserArray;
    }

    public STTreeGroup[] getSelectedGroups(Vector vector) {
        Vector<STTreeGroup> vector2 = new Vector<STTreeGroup>();
        Object[] objectArray = vector.elements();
        while (objectArray.hasMoreElements()) {
            ModelNode modelNode = (ModelNode)objectArray.nextElement();
            if (!this.isGroup(modelNode)) continue;
            STTreeGroup sTTreeGroup = (STTreeGroup)modelNode.getKey();
            vector2.addElement(sTTreeGroup);
        }
        objectArray = new STTreeGroup[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public STTreeGroup[] getGroups(int n) {
        Object[] objectArray = this.getAllGroups();
        if (n != 0 && null != objectArray) {
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                int n2 = objectArray[i].isShortcut() ? 2 : 1;
                if (n2 != n) continue;
                vector.addElement(objectArray[i]);
            }
            if (vector.size() == 0) {
                objectArray = null;
            } else {
                objectArray = new STTreeGroup[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public STUser[] getUsersInGroup(STTreeGroup sTTreeGroup) {
        Vector vector = ((ModelNode)this.getRoot()).getUnfilteredChilds();
        STUser[] sTUserArray = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ModelNode modelNode = (ModelNode)enumeration.nextElement();
            if (!sTTreeGroup.equals(modelNode.getKey())) continue;
            Vector vector2 = modelNode.getUnfilteredChilds();
            sTUserArray = this.getUsersFromNodes(vector2);
            break;
        }
        if (sTUserArray == null) {
            sTUserArray = new STWatchedUser[]{};
        }
        return sTUserArray;
    }

    private int getCurChildCount(ModelNode modelNode, Hashtable hashtable) {
        Object object = modelNode.getKey();
        Integer n = (Integer)hashtable.get(object);
        int n2 = n != null ? n.intValue() : modelNode.getChilds().size();
        return n2;
    }

    private void setCurChildCount(ModelNode modelNode, Hashtable hashtable, int n) {
        Object object = modelNode.getKey();
        Integer n2 = (Integer)hashtable.get(object);
        n2 = n2 != null ? new Integer(n2 + n) : new Integer(modelNode.getChilds().size() + n);
        hashtable.put(object, n2);
    }

    public boolean isGroup(ModelNode modelNode) {
        return modelNode.getParent().equals(this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addUsers(STUser[] sTUserArray, STTreeGroup sTTreeGroup) {
        Object object;
        ModelNode modelNode = this.searchNode((ModelNode)this.getRoot(), sTTreeGroup);
        if (modelNode == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "addUsers", "addUsers - Group does not exist");
            }
            this.sendEvent(new AwarenessViewEvent(2, this, sTUserArray, -2147482366));
            return;
        }
        if (sTTreeGroup.isShortcut()) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "addUsers", "Cannot add users to a shortcut group");
            }
            this.sendEvent(new AwarenessViewEvent(2, this, sTUserArray, -2147482364));
            return;
        }
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        Vector<STUser> vector2 = new Vector<STUser>();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < sTUserArray.length; ++i) {
            boolean bl;
            ModelNode modelNode2 = this.searchNode(modelNode, sTUserArray[i]);
            if (modelNode2 != null) {
                object = new STUser[]{sTUserArray[i]};
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "addUsers", "addUsers - user already in group");
                }
                this.sendEvent(new AwarenessViewEvent(2, this, (STUser[])object, -2147482367));
                continue;
            }
            Vector vector3 = this.getUserOccurances(sTUserArray[i], false, 0);
            boolean bl2 = bl = vector3.size() == 0;
            if (!bl) {
                bl = true;
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    object = ((ModelNode)enumeration.nextElement()).getParent();
                    if (!(((TreeNode)object).getKey() instanceof STPrivateGroup)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                vector2.addElement(sTUserArray[i]);
                continue;
            }
            object = (STWatchedUser)((ModelNode)vector3.elementAt(0)).getKey();
            AwarenessNode awarenessNode = this.createNewNode((STWatchedUser)object);
            awarenessNode.setParent(modelNode);
            vector.addElement(awarenessNode);
            if (this.isShowOnlineOnly() && awarenessNode.isOnline() && this.getCurChildCount(modelNode, hashtable) == 0) {
                this.notifyGroupNodesVisible(modelNode, false);
            }
            if (this.isShowOnlineOnly() && !awarenessNode.isOnline()) continue;
            this.setCurChildCount(modelNode, hashtable, 1);
        }
        if (vector2.size() > 0) {
            Object[] objectArray = new STUser[vector2.size()];
            vector2.copyInto(objectArray);
            this.addUsers((STUser[])objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = this;
                synchronized (object2) {
                    this.addingUser = true;
                }
                object = (Vector)this.m_usersOnWatchQue.get(objectArray[i]);
                boolean bl = false;
                if (object == null) {
                    object = new Vector();
                    this.m_usersOnWatchQue.put(objectArray[i], object);
                } else {
                    object2 = ((Vector)object).elements();
                    while (object2.hasMoreElements()) {
                        AwarenessNode awarenessNode = (AwarenessNode)object2.nextElement();
                        if (!awarenessNode.getKey().equals(modelNode.getKey())) continue;
                        bl = true;
                    }
                }
                if (!bl) {
                    ((Vector)object).addElement(modelNode);
                }
                object2 = this;
                synchronized (object2) {
                    this.addingUser = false;
                    this.notify();
                    continue;
                }
            }
        }
        if (vector.size() > 0) {
            this.insertNodes(vector);
            STUser[] sTUserArray2 = this.nodesToSTuser(vector);
            object = new STTreeEvent(1, (Object)this, sTUserArray2, sTTreeGroup);
            this.sendEvent((AwarenessViewEvent)object);
        }
    }

    public synchronized void addGroups(STTreeGroup[] sTTreeGroupArray) {
        Vector<STTreeGroup> vector = new Vector<STTreeGroup>();
        Vector<STTreeGroup> vector2 = new Vector<STTreeGroup>();
        for (int i = 0; i < sTTreeGroupArray.length; ++i) {
            AwarenessNode awarenessNode = (AwarenessNode)this.searchNode((ModelNode)this.getRoot(), sTTreeGroupArray[i]);
            if (awarenessNode != null) {
                this.sendEvent(new STTreeEvent(21, (Object)this, new STTreeGroup[]{sTTreeGroupArray[i]}, -2147482368));
                continue;
            }
            awarenessNode = this.createNewGroupNode(sTTreeGroupArray[i]);
            this.insertNode(awarenessNode);
            if (sTTreeGroupArray[i].isShortcut()) {
                vector2.addElement(sTTreeGroupArray[i]);
            } else {
                STUser[] sTUserArray = ((STPrivateGroup)sTTreeGroupArray[i]).getUsersInGroup();
                if (sTUserArray != null && sTUserArray.length > 0) {
                    this.addUsers(sTUserArray, sTTreeGroupArray[i]);
                }
            }
            vector.addElement(sTTreeGroupArray[i]);
        }
        if (vector2.size() > 0) {
            Object[] objectArray = new STObject[vector2.size()];
            vector2.copyInto(objectArray);
            this.m_watchList.addItems((STObject[])objectArray);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new STTreeGroup[vector.size()];
            vector.copyInto(objectArray);
            this.sendEvent(new STTreeEvent(20, (Object)this, (STTreeGroup[])objectArray));
        }
    }

    public synchronized void removeUsers(STWatchedUser[] sTWatchedUserArray, STTreeGroup sTTreeGroup) {
        ModelNode[] modelNodeArray;
        ModelNode modelNode = this.searchNode((ModelNode)this.getRoot(), sTTreeGroup);
        if (modelNode == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "removeUsers", "removeUsers - Group does not exist");
            }
            return;
        }
        if (sTTreeGroup.isShortcut()) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "removeUsers", "Cannot remove users from a public group");
            }
            return;
        }
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        Vector<STWatchedUser> vector2 = new Vector<STWatchedUser>();
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            Vector vector3;
            boolean bl;
            Object object;
            ModelNode modelNode2;
            AwarenessNode awarenessNode = (AwarenessNode)this.searchNode(modelNode, sTWatchedUserArray[i]);
            if (awarenessNode == null) {
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "removeUsers", "Cannot remove user - user not found in group");
                continue;
            }
            vector.addElement(awarenessNode);
            modelNodeArray = new ModelNode[]{awarenessNode};
            this.removeNodes(modelNodeArray);
            if (this.isShowOnlineOnly() && awarenessNode.isOnline() && modelNode.getChilds().size() == 0) {
                modelNode2 = (ModelNode)this.getRoot();
                modelNode2.getChilds().removeElement(modelNode);
                modelNode2.getSortedChilds().removeElement(modelNode);
                object = new Vector();
                ((Vector)object).addElement(modelNode);
                this.notifyGroupNodesNotVisible((Vector)object);
            }
            boolean bl2 = bl = (vector3 = this.getUserOccurances(sTWatchedUserArray[i], false, 0)).size() == 0;
            if (!bl) {
                bl = true;
                object = vector3.elements();
                while (object.hasMoreElements()) {
                    modelNode2 = ((ModelNode)object.nextElement()).getParent();
                    if (!(modelNode2.getKey() instanceof STPrivateGroup)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            vector2.addElement(sTWatchedUserArray[i]);
        }
        if (vector2.size() > 0) {
            Object[] objectArray = new STUser[vector2.size()];
            vector2.copyInto(objectArray);
            this.m_watchList.removeItems((STObject[])objectArray);
        }
        if (vector.size() > 0) {
            STUser[] sTUserArray = this.nodesToSTuser(vector);
            modelNodeArray = new STTreeEvent(12, (Object)this, sTUserArray, sTTreeGroup);
            this.sendEvent((AwarenessViewEvent)modelNodeArray);
        }
    }

    public void reset() {
        STTreeGroup[] sTTreeGroupArray = this.getAllGroups();
        if (sTTreeGroupArray != null) {
            this.removeGroups(sTTreeGroupArray, false);
        }
    }

    public synchronized void removeGroups(STTreeGroup[] sTTreeGroupArray, boolean bl) {
        Object[] objectArray;
        Vector<STTreeGroup> vector = new Vector<STTreeGroup>();
        Vector<STTreeGroup> vector2 = new Vector<STTreeGroup>();
        Vector<STUser> vector3 = new Vector<STUser>();
        Vector<AwarenessNode> vector4 = new Vector<AwarenessNode>();
        for (int i = 0; i < sTTreeGroupArray.length; ++i) {
            AwarenessNode awarenessNode = (AwarenessNode)this.searchNode((ModelNode)this.getRoot(), sTTreeGroupArray[i]);
            if (awarenessNode == null) {
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "removeGroups", "removeGroup - group does not exists");
                continue;
            }
            Object[] objectArray2 = new ModelNode[awarenessNode.getUnfilteredChilds().size()];
            awarenessNode.getUnfilteredChilds().copyInto(objectArray2);
            this.removeNodes((ModelNode[])objectArray2);
            if (sTTreeGroupArray[i].isShortcut()) {
                vector2.addElement(sTTreeGroupArray[i]);
            } else {
                for (int j = 0; j < objectArray2.length; ++j) {
                    STUser sTUser = (STUser)((TreeNode)objectArray2[j]).getKey();
                    Vector vector5 = this.getUserOccurances(sTUser, true, 1);
                    if (vector5.size() != 0) continue;
                    vector3.addElement(sTUser);
                }
            }
            vector.addElement(sTTreeGroupArray[i]);
            vector4.addElement(awarenessNode);
        }
        if (vector2.size() > 0) {
            objectArray = new STObject[vector2.size()];
            vector2.copyInto(objectArray);
            this.m_watchList.removeItems((STObject[])objectArray);
        }
        if (vector3.size() > 0) {
            objectArray = new STObject[vector3.size()];
            vector3.copyInto(objectArray);
            this.m_watchList.removeItems((STObject[])objectArray);
        }
        if (vector4.size() > 0) {
            Object[] objectArray3 = new ModelNode[vector4.size()];
            vector4.copyInto(objectArray3);
            this.removeNodes((ModelNode[])objectArray3);
        }
        if (vector.size() > 0) {
            Object[] objectArray4 = new STTreeGroup[vector.size()];
            vector.copyInto(objectArray4);
            if (bl) {
                this.sendEvent(new STTreeEvent(22, (Object)this, (STTreeGroup[])objectArray4));
            }
        }
    }

    public void renameGroup(STTreeGroup sTTreeGroup, String string) {
        AwarenessNode awarenessNode = (AwarenessNode)this.searchNode((ModelNode)this.getRoot(), sTTreeGroup);
        if (awarenessNode == null) {
            this.sendEvent(new STTreeEvent(24, (Object)this, new STTreeGroup[]{sTTreeGroup}, -2147482366));
            return;
        }
        STTreeGroup sTTreeGroup2 = (STTreeGroup)awarenessNode.getKey();
        if (sTTreeGroup2.isShortcut()) {
            this.sendEvent(new STTreeEvent(24, (Object)this, new STTreeGroup[]{sTTreeGroup}, -2147482364));
            return;
        }
        STTreeGroup[] sTTreeGroupArray = this.getAllGroups();
        boolean bl = false;
        for (int i = 0; i < sTTreeGroupArray.length; ++i) {
            if (sTTreeGroupArray[i].isShortcut() || !sTTreeGroupArray[i].getName().equals(string)) continue;
            bl = true;
            break;
        }
        STId sTId = new STId(string, sTTreeGroup.getId().getCommunityName());
        STPrivateGroup sTPrivateGroup = new STPrivateGroup(sTId, string, sTTreeGroup.getDesc(), sTTreeGroup.getGroupOpenStatus(), ((STPrivateGroup)sTTreeGroup).getUsersInGroup());
        if (bl) {
            this.sendEvent(new STTreeEvent(24, (Object)this, new STTreeGroup[]{sTPrivateGroup}, -2147482368));
            return;
        }
        awarenessNode.setKey(sTPrivateGroup);
        awarenessNode.setValue(string);
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        vector.addElement(awarenessNode);
        this.notifyNodesChanged(vector);
        this.sendEvent(new STTreeEvent(23, (Object)this, (STTreeGroup)sTPrivateGroup, string));
    }

    public void changeGroupState(boolean bl, ModelNode modelNode) {
        STTreeGroup sTTreeGroup = (STTreeGroup)modelNode.getKey();
        this.sendEvent(new STTreeEvent(25, (Object)this, sTTreeGroup, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userStatusChanged(StatusEvent statusEvent) {
        Object object;
        AwarenessNode awarenessNode;
        STWatchedUser[] sTWatchedUserArray = statusEvent.getWatchedUsers();
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        Vector<AwarenessNode> vector2 = new Vector<AwarenessNode>();
        Vector<AwarenessNode> vector3 = new Vector<AwarenessNode>();
        Vector vector4 = new Vector();
        Vector<AwarenessNode> vector5 = new Vector<AwarenessNode>();
        Vector vector6 = new Vector();
        Vector<AwarenessNode> vector7 = new Vector<AwarenessNode>();
        Hashtable hashtable = new Hashtable();
        AwarenessNode awarenessNode2 = null;
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            AwarenessNode awarenessNode3;
            boolean bl;
            Vector vector8;
            boolean bl2;
            STTreeGroup sTTreeGroup = (STTreeGroup)((Object)sTWatchedUserArray[i].getGroup());
            boolean bl3 = bl2 = sTTreeGroup != null;
            if (bl2) {
                vector8 = new Vector();
                awarenessNode2 = (AwarenessNode)this.searchNode((ModelNode)this.getRoot(), sTTreeGroup);
                if (awarenessNode2 == null) {
                    if (!this.m_logger.isLoggable(Level.FINER)) continue;
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "userStatusChanged", "Can't add user - public group to add to is unknown");
                    continue;
                }
                awarenessNode = (AwarenessNode)this.searchNode(awarenessNode2, sTWatchedUserArray[i]);
                if (awarenessNode != null) {
                    vector8.addElement(awarenessNode);
                }
            } else {
                vector8 = this.getUserOccurances(sTWatchedUserArray[i], false, 1);
            }
            boolean bl4 = bl = sTWatchedUserArray[i].getStatus().getStatusType() != 0;
            if (vector8.size() == 0) {
                if (bl2) {
                    if (!bl) continue;
                    awarenessNode3 = this.createNewNode(sTWatchedUserArray[i]);
                    awarenessNode3.setParent(awarenessNode2);
                    vector.addElement(awarenessNode3);
                    vector3.addElement(awarenessNode3);
                    if (this.isShowOnlineOnly() && this.getCurChildCount(awarenessNode2, hashtable) == 0) {
                        this.notifyGroupNodesVisible(awarenessNode2, false);
                    }
                    this.setCurChildCount(awarenessNode2, hashtable, 1);
                    continue;
                }
                STTreeModel sTTreeModel = this;
                synchronized (sTTreeModel) {
                    block33: {
                        try {
                            while (this.addingUser) {
                                this.wait(1000L);
                            }
                        }
                        catch (Exception exception) {
                            if (!this.m_logger.isLoggable(Level.FINER)) break block33;
                            this.m_logger.logp(Level.FINER, this.getClass().getName(), "userStatusChanged", "wait timeout");
                        }
                    }
                }
                Vector vector9 = (Vector)this.m_usersOnWatchQue.get(sTWatchedUserArray[i]);
                if (vector9 == null) {
                    if (!this.m_logger.isLoggable(Level.FINER)) continue;
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "userStatusChanged", "Can't add user - private group to add to is unknown");
                    continue;
                }
                boolean bl5 = false;
                Enumeration enumeration = vector9.elements();
                while (enumeration.hasMoreElements()) {
                    awarenessNode2 = (AwarenessNode)enumeration.nextElement();
                    awarenessNode3 = this.createNewNode(sTWatchedUserArray[i]);
                    awarenessNode3.setParent(awarenessNode2);
                    vector.addElement(awarenessNode3);
                    if (!bl5 && awarenessNode3.isOnline()) {
                        vector3.addElement(awarenessNode3);
                        bl5 = true;
                    }
                    if (this.isShowOnlineOnly() && bl && this.getCurChildCount(awarenessNode2, hashtable) == 0) {
                        this.notifyGroupNodesVisible(awarenessNode2, false);
                    }
                    if (this.isShowOnlineOnly() && !bl) continue;
                    this.setCurChildCount(awarenessNode2, hashtable, 1);
                }
                this.m_usersOnWatchQue.remove(sTWatchedUserArray[i]);
                continue;
            }
            Enumeration enumeration = vector8.elements();
            while (enumeration.hasMoreElements()) {
                awarenessNode3 = (AwarenessNode)enumeration.nextElement();
                awarenessNode2 = (AwarenessNode)awarenessNode3.getParent();
                boolean bl6 = awarenessNode3.isOnline();
                object = sTWatchedUserArray[i].getStatus();
                awarenessNode3.setStatus((STUserStatus)object);
                awarenessNode3.setIcon(this.getIcon(sTWatchedUserArray[i]));
                awarenessNode3.setKey(sTWatchedUserArray[i]);
                if ((this.isShowOnlineOnly() || bl2) && bl6 != awarenessNode3.isOnline()) {
                    if (awarenessNode3.isOnline()) {
                        if (this.isShowOnlineOnly() && this.getCurChildCount(awarenessNode2, hashtable) == 0) {
                            this.notifyGroupNodesVisible(awarenessNode2, false);
                        }
                        awarenessNode2.getChilds().addElement(awarenessNode3);
                        awarenessNode2.getSortedChilds().addElement(awarenessNode3);
                        this.reSort(awarenessNode2);
                        Vector<AwarenessNode> vector10 = new Vector<AwarenessNode>();
                        vector10.addElement(awarenessNode3);
                        this.notifyNodesVisible(vector10);
                        vector3.addElement(awarenessNode3);
                        this.setCurChildCount(awarenessNode2, hashtable, 1);
                        continue;
                    }
                    if (this.isShowOnlineOnly() && this.getCurChildCount(awarenessNode2, hashtable) == 1) {
                        vector7.addElement(awarenessNode2);
                    }
                    if (bl2) {
                        ModelNode[] modelNodeArray = new ModelNode[]{awarenessNode3};
                        this.removeNodes(modelNodeArray);
                    } else {
                        vector5.addElement(awarenessNode3);
                    }
                    vector3.addElement(awarenessNode3);
                    this.setCurChildCount(awarenessNode2, hashtable, -1);
                    if (!this.isShowOnlineOnly() || bl2) continue;
                    boolean bl7 = awarenessNode2.getChilds().removeElement(awarenessNode3);
                    boolean bl8 = awarenessNode2.getSortedChilds().removeElement(awarenessNode3);
                    if (bl7 && bl8 || !this.m_logger.isLoggable(Level.FINER)) continue;
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "userStatusChanged", "could not remove child node when went offline");
                    continue;
                }
                vector2.addElement(awarenessNode3);
                vector3.addElement(awarenessNode3);
            }
        }
        if (vector.size() > 0) {
            this.insertNodes(vector);
            STUser[] sTUserArray = this.nodesToSTuser(vector);
            for (int i = 0; i < sTUserArray.length; ++i) {
                awarenessNode = (AwarenessNode)vector.elementAt(i);
                STTreeGroup sTTreeGroup = (STTreeGroup)awarenessNode.getParent().getKey();
                if (sTTreeGroup.isShortcut()) continue;
                object = new STTreeEvent(1, (Object)this, new STUser[]{sTUserArray[i]}, sTTreeGroup);
                this.sendEvent((AwarenessViewEvent)object);
            }
        }
        if (vector6.size() > 0 || vector7.size() > 0) {
            this.reFilter((ModelNode)this.getRoot());
            this.reSort((ModelNode)this.getRoot());
        }
        if (vector2.size() > 0) {
            this.notifyNodesChanged(vector2);
        }
        if (vector4.size() > 0) {
            this.notifyNodesVisible(vector4);
        }
        if (vector5.size() > 0) {
            this.notifyNodesNotVisible(vector5);
        }
        if (vector7.size() > 0) {
            this.notifyGroupNodesNotVisible(vector7);
        }
        if (vector3.size() > 0) {
            STUser[] sTUserArray = this.nodesToSTuser(vector3);
            STTreeEvent sTTreeEvent = new STTreeEvent(7, (Object)this, sTUserArray, null);
            this.sendEvent(sTTreeEvent);
        }
    }

    protected void notifyGroupNodesVisible(ModelNode modelNode, boolean bl) {
        ModelNode modelNode2 = (ModelNode)this.getRoot();
        modelNode2.getChilds().addElement(modelNode);
        modelNode2.getSortedChilds().addElement(modelNode);
        this.reSort(modelNode2);
        TreeNode[] treeNodeArray = new ModelNode[1];
        TreeNode[] treeNodeArray2 = new ModelNode[1];
        int[] nArray = new int[1];
        treeNodeArray[0] = modelNode;
        treeNodeArray2[0] = modelNode.getParent();
        Vector vector = this.isSortOn(modelNode.getParent()) ? modelNode.getParent().getSortedChilds() : modelNode.getParent().getChilds();
        nArray[0] = vector.indexOf(modelNode);
        TreeEvent treeEvent = new TreeEvent(5, treeNodeArray, treeNodeArray2, nArray);
        this.sendEvent(treeEvent);
        if (bl) {
            Vector<ModelNode> vector2 = new Vector<ModelNode>();
            vector2.addElement(modelNode);
            STTreeGroup[] sTTreeGroupArray = this.nodesToGroups(vector2);
            this.sendEvent(new STTreeEvent(20, (Object)this, sTTreeGroupArray));
        }
    }

    protected void notifyGroupNodesNotVisible(Vector vector) {
        Object[] objectArray = new ModelNode[vector.size()];
        vector.copyInto(objectArray);
        TreeEvent treeEvent = new TreeEvent(6, (TreeNode[])objectArray);
        this.sendEvent(treeEvent);
        STTreeGroup[] sTTreeGroupArray = this.nodesToGroups(vector);
        this.sendEvent(new STTreeEvent(22, (Object)this, sTTreeGroupArray));
    }

    private AwarenessNode createNewGroupNode(STTreeGroup sTTreeGroup) {
        AwarenessNode awarenessNode = new AwarenessNode(sTTreeGroup, sTTreeGroup.getName(), this.getGroupIcon(sTTreeGroup), this.m_res);
        awarenessNode.setParent((ModelNode)this.getRoot());
        awarenessNode.setExpanded(sTTreeGroup.getGroupOpenStatus());
        String string = sTTreeGroup.isShortcut() ? this.m_res.getString("IS_A_PUBLIC_GROUP") : this.m_res.getString("IS_A_PERSONAL_GROUP");
        STUserStatus sTUserStatus = new STUserStatus(0, 0, string);
        awarenessNode.setStatus(sTUserStatus);
        return awarenessNode;
    }

    public boolean isPersonalGroup(TreeNode treeNode) {
        return ((ModelNode)treeNode).getKey() instanceof STPrivateGroup;
    }

    public boolean isPublicGroup(TreeNode treeNode) {
        return ((ModelNode)treeNode).getKey() instanceof STPublicGroup;
    }

    public boolean isSortOn(TreeNode treeNode) {
        return this.isPublicGroup(treeNode) ? true : this.getSortMode();
    }

    protected STTreeGroup[] nodesToGroups(Vector vector) {
        STTreeGroup[] sTTreeGroupArray = new STTreeGroup[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            sTTreeGroupArray[i] = (STTreeGroup)((AwarenessNode)vector.elementAt(i)).getKey();
        }
        return sTTreeGroupArray;
    }

    public STTreeGroup[] getAllGroups() {
        Object[] objectArray = this.nodesToGroups(((ModelNode)this.getRoot()).getUnfilteredChilds());
        if (objectArray != null) {
            Vector<STTreeGroup> vector = new Vector<STTreeGroup>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof EmptyNode) continue;
                vector.addElement(objectArray[i]);
            }
            if (vector.size() == 0) {
                objectArray = null;
            } else {
                objectArray = new STTreeGroup[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    private Vector getUserOccurances(STUser sTUser, boolean bl, int n) {
        Vector<ModelNode> vector = new Vector<ModelNode>();
        Enumeration enumeration = ((ModelNode)this.getRoot()).getUnfilteredChilds().elements();
        while (enumeration.hasMoreElements()) {
            ModelNode modelNode = (ModelNode)enumeration.nextElement();
            boolean bl2 = true;
            if (n != 0) {
                STTreeGroup sTTreeGroup = (STTreeGroup)modelNode.getKey();
                int n2 = sTTreeGroup.isShortcut() ? 2 : 1;
                boolean bl3 = bl2 = n2 == n;
            }
            if (!bl2) continue;
            Enumeration enumeration2 = modelNode.getUnfilteredChilds().elements();
            while (enumeration2.hasMoreElements()) {
                ModelNode modelNode2 = (ModelNode)enumeration2.nextElement();
                if (!this.keysEqual(sTUser, modelNode2.getKey())) continue;
                vector.addElement(modelNode2);
                if (!bl) continue;
                return vector;
            }
        }
        return vector;
    }

    public void showOnlineOnly(boolean bl) {
        this.m_showOnineOnly = bl;
        if (this.m_showOnineOnly) {
            this.setFilter(new STTreeFilter());
        } else {
            this.setFilter(null);
        }
    }

    protected Image getGroupIcon(STTreeGroup sTTreeGroup) {
        if (sTTreeGroup.isShortcut()) {
            return this.m_shortcutImage;
        }
        return this.m_groupImage;
    }

    public void serviceUnavailable(AwarenessServiceEvent awarenessServiceEvent) {
        Object object;
        Vector vector = ((ModelNode)this.getRoot()).getChilds();
        Vector<STFakedWatchedUser> vector2 = new Vector<STFakedWatchedUser>();
        Hashtable<STWatchedUser, STWatchedUser> hashtable = new Hashtable<STWatchedUser, STWatchedUser>();
        Object[] objectArray = vector.elements();
        while (objectArray.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)objectArray.nextElement();
            STTreeGroup sTTreeGroup = (STTreeGroup)awarenessNode.getKey();
            boolean bl = sTTreeGroup.isShortcut();
            object = awarenessNode.getChilds().elements();
            while (object.hasMoreElements()) {
                AwarenessNode awarenessNode2 = (AwarenessNode)object.nextElement();
                STWatchedUser sTWatchedUser = (STWatchedUser)awarenessNode2.getKey();
                if (!bl && hashtable.get(sTWatchedUser) != null) continue;
                if (!bl) {
                    hashtable.put(sTWatchedUser, sTWatchedUser);
                }
                STFakedWatchedUser sTFakedWatchedUser = new STFakedWatchedUser(sTWatchedUser);
                if (sTWatchedUser.getStatus().getStatusType() == 0) continue;
                STUserStatus sTUserStatus = new STUserStatus(0, 0, "");
                sTFakedWatchedUser.setStatus(sTUserStatus);
                vector2.addElement(sTFakedWatchedUser);
            }
        }
        if (vector2.size() > 0) {
            objectArray = new STWatchedUser[vector2.size()];
            vector2.copyInto(objectArray);
            object = new TreeStatusEvent((Object)this, (STWatchedUser[])objectArray);
            this.userStatusChanged((StatusEvent)object);
        }
    }

    public void insertEmptyNode(TreeNode treeNode, EmptyNode emptyNode) {
        if (this.isPersonalGroup(treeNode)) {
            emptyNode.setValue(this.m_privateEmptyNode);
        } else {
            emptyNode.setValue(this.m_publicEmptyNode);
        }
    }

    public void nameChanged(NamesEvent namesEvent) {
        STUser sTUser = namesEvent.getUser();
        Vector vector = this.getUserOccurances(sTUser, false, 0);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            ((STUser)awarenessNode.getKey()).setNickName(sTUser.getNickName());
            awarenessNode.setValue(((STUser)awarenessNode.getKey()).getDisplayName());
        }
        this.reSort();
        this.notifyTreeInitialized();
    }

    public void attrChanged(AttributeEvent attributeEvent) {
        AwarenessNode awarenessNode = (AwarenessNode)this.getNode(attributeEvent.getWatchedObject());
        if (null != awarenessNode) {
            STWatchedUser sTWatchedUser = (STWatchedUser)awarenessNode.getKey();
            STExtendedAttribute[] sTExtendedAttributeArray = attributeEvent.getAttributeList();
            boolean bl = false;
            Hashtable hashtable = sTWatchedUser.getAttributes();
            for (int i = 0; i < sTExtendedAttributeArray.length; ++i) {
                hashtable.put(new Integer(sTExtendedAttributeArray[i].getKey()), sTExtendedAttributeArray[i]);
            }
        }
    }

    public void attrRemoved(AttributeEvent attributeEvent) {
        AwarenessNode awarenessNode = (AwarenessNode)this.getNode(attributeEvent.getWatchedObject());
        if (null != awarenessNode) {
            STWatchedUser sTWatchedUser = (STWatchedUser)awarenessNode.getKey();
            Hashtable hashtable = sTWatchedUser.getAttributes();
            hashtable.remove(new Integer(attributeEvent.getAttributeKey()));
        }
    }
}

