/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeListener;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.AwarenessServiceEvent;
import com.lotus.sametime.awareness.AwarenessServiceListener;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.StatusEvent;
import com.lotus.sametime.awareness.StatusListener;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.awarenessui.AwarenessModelListener;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.awarenessui.OnlineFilter;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.guiutils.tree.CellData;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.ModelNode;
import com.lotus.sametime.guiutils.tree.TreeEvent;
import com.lotus.sametime.guiutils.tree.TreeModel;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.names.NamesEvent;
import com.lotus.sametime.names.NamesService;
import com.lotus.sametime.names.NamesServiceListener;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AwarenessModel
extends TreeModel
implements StatusListener,
AttributeListener,
AwarenessServiceListener,
NamesServiceListener {
    private static final short ST_USER_STATUS_EXTERNAL_ACTIVE = 8224;
    private static final short ST_USER_STATUS_EXTERNAL_AWAY = 8288;
    private static final short ST_USER_STATUS_EXTERNAL_DND = 8320;
    protected STSession m_session;
    protected AwarenessService m_awarenessService;
    protected NamesService m_namesService;
    protected WatchList m_watchList;
    protected STBundle m_res;
    private Vector m_stModelListeners = new Vector();
    protected boolean m_showOnineOnly = false;
    protected Vector m_leftAttributes = new Vector();
    protected Vector m_rightAttributes = new Vector();
    Hashtable m_statusImages;
    protected Image m_groupImage;
    protected Image m_shortcutImage;
    protected int[] m_attrResort;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awarenessui");

    public AwarenessModel(STSession sTSession) {
        this.m_session = sTSession;
        this.m_awarenessService = (AwarenessService)sTSession.getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        Debug.stAssert(this.m_awarenessService != null);
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_res = resourceLoaderService.getBundle("properties/awarenessui");
        this.loadImages(resourceLoaderService);
        this.m_namesService = (NamesService)sTSession.getCompApi("com.lotus.sametime.names.NamesComp");
        if (null != this.m_namesService) {
            this.m_namesService.addNamesServiceListener(this);
        }
        int[] nArray = new int[]{6};
        this.m_awarenessService.addToAttrFilter(nArray);
        this.m_awarenessService.addAwarenessServiceListener(this);
        this.m_watchList = this.m_awarenessService.createWatchList();
        this.m_watchList.addStatusListener(this);
        this.m_watchList.addAttrListener(this);
    }

    public void addAwarenessModelListener(AwarenessModelListener awarenessModelListener) {
        this.m_stModelListeners.addElement(awarenessModelListener);
    }

    public void removeAwarenessModelListener(AwarenessModelListener awarenessModelListener) {
        this.m_stModelListeners.removeElement(awarenessModelListener);
    }

    public void addUsers(STUser[] sTUserArray) {
        this.m_watchList.addItems(sTUserArray);
    }

    public void addUser(STUser sTUser) {
        this.m_watchList.addItem(sTUser);
    }

    public void removeUser(STUser sTUser) {
        STUser[] sTUserArray = new STUser[]{sTUser};
        this.removeUsers(sTUserArray);
    }

    public void removeUsers(STUser[] sTUserArray) {
        this.m_watchList.removeItems(sTUserArray);
        Vector<ModelNode> vector = new Vector<ModelNode>();
        for (int i = 0; i < sTUserArray.length; ++i) {
            ModelNode modelNode = this.getNode(sTUserArray[i]);
            if (null == modelNode) continue;
            vector.addElement(modelNode);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new ModelNode[vector.size()];
            vector.copyInto(objectArray);
            this.removeNodes((ModelNode[])objectArray);
            STUser[] sTUserArray2 = this.nodesToSTuser(vector);
            AwarenessViewEvent awarenessViewEvent = new AwarenessViewEvent(12, (Object)this, sTUserArray2);
            this.sendEvent(awarenessViewEvent);
        }
    }

    public void reset() {
        this.m_watchList.reset();
        this.resetTree();
    }

    public STSession getSession() {
        return this.m_session;
    }

    public boolean isShowOnlineOnly() {
        return this.m_showOnineOnly;
    }

    public void showOnlineOnly(boolean bl) {
        this.m_showOnineOnly = bl;
        if (this.m_showOnineOnly) {
            this.setFilter(new OnlineFilter());
        } else {
            this.setFilter(null);
        }
    }

    public void setSortMode(boolean bl) {
        this.sortOnOff(bl);
    }

    public void dispose() {
        if (this.m_watchList != null) {
            this.m_watchList.close();
            this.m_watchList.removeStatusListener(this);
            this.m_watchList.removeAttrListener(this);
            this.m_awarenessService.removeAwarenessServiceListener(this);
        }
        if (null != this.m_namesService) {
            this.m_namesService.removeNamesServiceListener(this);
        }
    }

    protected void sendEvent(AwarenessViewEvent awarenessViewEvent) {
        Enumeration enumeration = this.m_stModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessModelListener awarenessModelListener = (AwarenessModelListener)enumeration.nextElement();
            awarenessModelListener.processAwarenessViewEvent(awarenessViewEvent);
        }
    }

    protected Image getIcon(STUserStatus sTUserStatus) {
        if (sTUserStatus == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIcon", "NULL STATUS!!");
            }
            return null;
        }
        return (Image)this.m_statusImages.get(new Short(sTUserStatus.getStatusType()));
    }

    protected Image getIcon(STWatchedUser sTWatchedUser) {
        if (sTWatchedUser == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "getIcon", "NULL USER!!");
            }
            return null;
        }
        STUserStatus sTUserStatus = sTWatchedUser.getStatus();
        if (sTWatchedUser.isExternalUser()) {
            if (sTUserStatus.isStatus((short)0)) {
                return (Image)this.m_statusImages.get(new Short(0));
            }
            if (sTUserStatus.isStatus((short)32)) {
                return (Image)this.m_statusImages.get(new Short(8224));
            }
            if (sTUserStatus.isStatus((short)96) | sTUserStatus.isStatus((short)64)) {
                return (Image)this.m_statusImages.get(new Short(8288));
            }
            if (sTUserStatus.isStatus((short)128)) {
                return (Image)this.m_statusImages.get(new Short(8320));
            }
            return (Image)this.m_statusImages.get(new Short(8224));
        }
        return this.getIcon(sTUserStatus);
    }

    public Vector getItems() {
        return ((ModelNode)this.getRoot()).getChilds();
    }

    protected void loadImages(ResourceLoaderService resourceLoaderService) {
        this.m_groupImage = resourceLoaderService.getImage("images/base_gro.gif");
        this.m_shortcutImage = resourceLoaderService.getImage("images/shortcut.gif");
        this.m_statusImages = new Hashtable();
        this.m_statusImages.put(new Short(32), resourceLoaderService.getImage("images/active.gif"));
        this.m_statusImages.put(new Short(96), resourceLoaderService.getImage("images/away.gif"));
        this.m_statusImages.put(new Short(128), resourceLoaderService.getImage("images/dnd.gif"));
        this.m_statusImages.put(new Short(64), resourceLoaderService.getImage("images/away.gif"));
        this.m_statusImages.put(new Short(new Integer(544).shortValue()), resourceLoaderService.getImage("images/activemobile.gif"));
        this.m_statusImages.put(new Short(new Integer(608).shortValue()), resourceLoaderService.getImage("images/awaymobile.gif"));
        this.m_statusImages.put(new Short(new Integer(640).shortValue()), resourceLoaderService.getImage("images/dndmobile.gif"));
        this.m_statusImages.put(new Short(8224), resourceLoaderService.getImage("images/activeexternal.gif"));
        this.m_statusImages.put(new Short(8288), resourceLoaderService.getImage("images/awayexternal.gif"));
        this.m_statusImages.put(new Short(8320), resourceLoaderService.getImage("images/dndexternal.gif"));
    }

    public STUser[] getUsersFromNodes(Vector vector) {
        STBoolean sTBoolean = new STBoolean(false);
        return this.getUsersFromNodes(vector, false, sTBoolean);
    }

    public STUser[] getUsersFromNodes(Vector vector, boolean bl, STBoolean sTBoolean) {
        Vector<STUser> vector2 = new Vector<STUser>();
        for (int i = 0; i < vector.size(); ++i) {
            AwarenessNode awarenessNode = (AwarenessNode)vector.elementAt(i);
            STUser sTUser = (STUser)awarenessNode.getKey();
            if (bl) {
                if (!sTUser.isExternalUser()) {
                    vector2.addElement(sTUser);
                    continue;
                }
                sTBoolean.setValue(true);
                continue;
            }
            vector2.addElement(sTUser);
        }
        Object[] objectArray = new STUser[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public boolean isGroup(ModelNode modelNode) {
        return false;
    }

    public AwarenessNode[] getChilds(AwarenessNode awarenessNode) {
        int n = this.getChildCount(awarenessNode);
        if (n == 0) {
            return null;
        }
        AwarenessNode[] awarenessNodeArray = new AwarenessNode[n];
        for (int i = 0; i < n; ++i) {
            awarenessNodeArray[i] = (AwarenessNode)this.getChild(awarenessNode, i);
        }
        return awarenessNodeArray;
    }

    public void userStatusChanged(StatusEvent statusEvent) {
        this.handleStatusChanged(statusEvent.getWatchedUsers());
    }

    protected void handleStatusChanged(STWatchedUser[] sTWatchedUserArray) {
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        Vector<AwarenessNode> vector2 = new Vector<AwarenessNode>();
        Vector<AwarenessNode> vector3 = new Vector<AwarenessNode>();
        Vector<AwarenessNode> vector4 = new Vector<AwarenessNode>();
        for (int i = 0; i < sTWatchedUserArray.length; ++i) {
            AwarenessNode awarenessNode = (AwarenessNode)this.getNode(sTWatchedUserArray[i]);
            if (null == awarenessNode) {
                awarenessNode = this.createNewNode(sTWatchedUserArray[i]);
                vector.addElement(awarenessNode);
                continue;
            }
            boolean bl = awarenessNode.isOnline();
            awarenessNode.setStatus(sTWatchedUserArray[i].getStatus());
            awarenessNode.setIcon(this.getIcon(sTWatchedUserArray[i]));
            if (this.isShowOnlineOnly() && bl != awarenessNode.isOnline()) {
                this.reFilter(awarenessNode.getParent());
                this.reSort(awarenessNode.getParent());
                if (awarenessNode.isOnline()) {
                    vector3.addElement(awarenessNode);
                    continue;
                }
                vector4.addElement(awarenessNode);
                continue;
            }
            vector2.addElement(awarenessNode);
        }
        if (vector.size() > 0) {
            this.insertNodes(vector);
            STUser[] sTUserArray = this.nodesToSTuser(vector);
            AwarenessViewEvent awarenessViewEvent = new AwarenessViewEvent(1, (Object)this, sTUserArray);
            this.sendEvent(awarenessViewEvent);
        }
        if (vector2.size() > 0) {
            this.notifyNodesChanged(vector2);
        }
        if (vector3.size() > 0) {
            this.notifyNodesVisible(vector3);
        }
        if (vector4.size() > 0) {
            this.notifyNodesNotVisible(vector4);
        }
    }

    protected AwarenessNode createNewNode(STWatchedUser sTWatchedUser) {
        Vector vector = null;
        Vector vector2 = null;
        if (this.m_leftAttributes.size() > 0) {
            vector = new Vector();
            vector.setSize(this.m_leftAttributes.size());
        }
        if (this.m_rightAttributes.size() > 0) {
            vector2 = new Vector();
            vector2.setSize(this.m_rightAttributes.size());
        }
        if (null != this.m_namesService) {
            sTWatchedUser.setNickName(this.m_namesService.getNickname(sTWatchedUser));
            sTWatchedUser.setNameDelimiter(this.m_namesService.getNameDelimiter());
        }
        AwarenessNode awarenessNode = new AwarenessNode(sTWatchedUser, sTWatchedUser.getDisplayName(), sTWatchedUser.getName(), this.getIcon(sTWatchedUser), vector, vector2, this.m_res);
        awarenessNode.setStatus(sTWatchedUser.getStatus());
        awarenessNode.setParent((ModelNode)this.getRoot());
        this.updateNode(awarenessNode);
        return awarenessNode;
    }

    protected void notifyNodesVisible(Vector vector) {
        Object[] objectArray = new ModelNode[vector.size()];
        vector.copyInto(objectArray);
        TreeNode[] treeNodeArray = new ModelNode[vector.size()];
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            treeNodeArray[i] = ((ModelNode)objectArray[i]).getParent();
            Vector vector2 = this.isSortOn(((ModelNode)objectArray[i]).getParent()) ? ((ModelNode)objectArray[i]).getParent().getSortedChilds() : ((ModelNode)objectArray[i]).getParent().getChilds();
            nArray[i] = vector2.indexOf(objectArray[i]);
        }
        TreeEvent treeEvent = new TreeEvent(5, (TreeNode[])objectArray, treeNodeArray, nArray);
        this.sendEvent(treeEvent);
        STUser[] sTUserArray = this.nodesToSTuser(vector);
        AwarenessViewEvent awarenessViewEvent = new AwarenessViewEvent(1, (Object)this, sTUserArray);
        this.sendEvent(awarenessViewEvent);
    }

    protected void notifyNodesNotVisible(Vector vector) {
        Object[] objectArray = new ModelNode[vector.size()];
        vector.copyInto(objectArray);
        TreeEvent treeEvent = new TreeEvent(6, (TreeNode[])objectArray);
        this.sendEvent(treeEvent);
        STUser[] sTUserArray = this.nodesToSTuser(vector);
        AwarenessViewEvent awarenessViewEvent = new AwarenessViewEvent(12, (Object)this, sTUserArray);
        this.sendEvent(awarenessViewEvent);
    }

    protected void notifyNodesChanged(Vector vector) {
        Object[] objectArray = new ModelNode[vector.size()];
        vector.copyInto(objectArray);
        this.notifyNodesChanged((ModelNode[])objectArray);
    }

    private void notifyNodesChanged(ModelNode[] modelNodeArray) {
        TreeEvent treeEvent = new TreeEvent(1, modelNodeArray);
        this.sendEvent(treeEvent);
    }

    public void serviceUnavailable(AwarenessServiceEvent awarenessServiceEvent) {
        ModelNode modelNode = (ModelNode)this.getRoot();
        Enumeration enumeration = modelNode.getChilds().elements();
        Vector<AwarenessNode> vector = new Vector<AwarenessNode>();
        STUserStatus sTUserStatus = new STUserStatus(0, 0, "");
        Image image = (Image)this.m_statusImages.get(new Short(0));
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            awarenessNode.setStatus(sTUserStatus);
            awarenessNode.setIcon(image);
            vector.addElement(awarenessNode);
        }
        if (this.isShowOnlineOnly()) {
            this.setFilter(this.getFilter());
        } else if (vector.size() > 0) {
            this.notifyNodesChanged(vector);
        }
    }

    protected Vector getRightAttributes() {
        return this.m_rightAttributes;
    }

    protected Vector getLeftAttributes() {
        return this.m_leftAttributes;
    }

    public int[] getResortAttribs() {
        return this.m_attrResort;
    }

    public void setResortAttribs(int[] nArray) {
        this.m_attrResort = nArray;
    }

    protected void updateNode(AwarenessNode awarenessNode) {
        this.updateNodeColumns(awarenessNode, awarenessNode.getLeftData(), this.getLeftAttributes());
        this.updateNodeColumns(awarenessNode, awarenessNode.getRightData(), this.getRightAttributes());
    }

    private void updateNodeColumns(AwarenessNode awarenessNode, Vector vector, Vector vector2) {
        Hashtable hashtable = awarenessNode.getAttributes();
        boolean bl = false;
        vector.setSize(vector2.size());
        for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
            CellData cellData;
            ColumnAttributes columnAttributes = (ColumnAttributes)vector2.elementAt(i);
            bl = false;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                STExtendedAttribute sTExtendedAttribute = (STExtendedAttribute)enumeration.nextElement();
                if (!columnAttributes.containsAttribute(sTExtendedAttribute.getKey())) continue;
                cellData = columnAttributes.getProvider().getContent(columnAttributes, awarenessNode.getAttributes());
                vector.setElementAt(cellData, i);
                bl = true;
                break;
            }
            if (bl) continue;
            vector.removeElementAt(i);
            cellData = columnAttributes.getProvider().getEmptyContent(columnAttributes);
            vector.insertElementAt(cellData, i);
        }
    }

    public STUser[] nodesToSTuser(Vector vector) {
        STUser[] sTUserArray = new STUser[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            sTUserArray[i] = (STUser)((TreeNode)vector.elementAt(i)).getKey();
        }
        return sTUserArray;
    }

    public int addColumn(ColumnAttributes columnAttributes) {
        int n = columnAttributes.getPseudoOrder();
        Vector vector = n > 0 ? this.getRightAttributes() : this.getLeftAttributes();
        int n2 = columnAttributes.getRealOrder(vector);
        vector.insertElementAt(columnAttributes, Math.abs(n2) - 1);
        Vector vector2 = this.getItems();
        if (null != vector2) {
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
                awarenessNode.getLeftData().removeAllElements();
                awarenessNode.getRightData().removeAllElements();
                this.updateNode(awarenessNode);
            }
        }
        return n2;
    }

    protected boolean isAttribWatched(int n) {
        ColumnAttributes columnAttributes;
        boolean bl = false;
        Enumeration enumeration = this.getLeftAttributes().elements();
        while (enumeration.hasMoreElements()) {
            columnAttributes = (ColumnAttributes)enumeration.nextElement();
            if (!columnAttributes.containsAttribute(n)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            enumeration = this.getRightAttributes().elements();
            while (enumeration.hasMoreElements()) {
                columnAttributes = (ColumnAttributes)enumeration.nextElement();
                if (!columnAttributes.containsAttribute(n)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void nameChanged(NamesEvent namesEvent) {
        STUser sTUser = namesEvent.getUser();
        AwarenessNode awarenessNode = (AwarenessNode)this.getNode(sTUser);
        if (null != awarenessNode) {
            ((STUser)awarenessNode.getKey()).setNickName(sTUser.getNickName());
            awarenessNode.setValue(((STUser)awarenessNode.getKey()).getDisplayName());
            this.reSort(awarenessNode.getParent());
            this.notifyTreeInitialized();
        }
    }

    public void nameDelimiterChanged(NamesEvent namesEvent) {
        Vector vector = ((ModelNode)this.getRoot()).getUnfilteredChilds();
        Vector<AwarenessNode> vector2 = new Vector<AwarenessNode>();
        Enumeration enumeration = vector.elements();
        String string = namesEvent.getNameDelimiter();
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            Object object = awarenessNode.getKey();
            if (object instanceof STUser) {
                ((STUser)awarenessNode.getKey()).setNameDelimiter(string);
                awarenessNode.setValue(((STUser)awarenessNode.getKey()).getDisplayName());
                vector2.addElement(awarenessNode);
                continue;
            }
            Vector vector3 = awarenessNode.getUnfilteredChilds();
            if (vector3 == null) continue;
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                awarenessNode = (AwarenessNode)enumeration2.nextElement();
                ((STUser)awarenessNode.getKey()).setNameDelimiter(string);
                awarenessNode.setValue(((STUser)awarenessNode.getKey()).getDisplayName());
                vector2.addElement(awarenessNode);
            }
        }
        this.notifyNodesChanged(vector2);
    }

    public boolean resortIfNeeded(int n) {
        boolean bl = false;
        int[] nArray = this.getResortAttribs();
        for (int i = 0; null != nArray && i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            this.reSort();
            this.notifyTreeInitialized();
            bl = true;
            break;
        }
        return bl;
    }

    public void serviceAvailable(AwarenessServiceEvent awarenessServiceEvent) {
    }

    public void groupCleared(StatusEvent statusEvent) {
    }

    public void attrChanged(AttributeEvent attributeEvent) {
    }

    public void attrRemoved(AttributeEvent attributeEvent) {
    }

    public void attrContentQueried(AttributeEvent attributeEvent) {
    }

    public void queryAttrContentFailed(AttributeEvent attributeEvent) {
    }
}

