/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awareness;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeListener;
import com.lotus.sametime.awareness.AwarenessComp;
import com.lotus.sametime.awareness.StatusEvent;
import com.lotus.sametime.awareness.StatusListener;
import com.lotus.sametime.core.types.STObject;
import java.util.Enumeration;
import java.util.Vector;

public class WatchList {
    private AwarenessComp m_wioComp;
    private Vector m_statuslisteners = new Vector();
    private Vector m_attrListeners = new Vector();
    private Integer m_listId;

    WatchList(AwarenessComp awarenessComp, Integer n) {
        this.m_wioComp = awarenessComp;
        this.m_listId = n;
    }

    public synchronized void addAttrListener(AttributeListener attributeListener) {
        Vector vector = (Vector)this.m_attrListeners.clone();
        vector.addElement(attributeListener);
        this.m_attrListeners = vector;
    }

    public synchronized void removeAttrListener(AttributeListener attributeListener) {
        Vector vector = (Vector)this.m_attrListeners.clone();
        vector.removeElement(attributeListener);
        this.m_attrListeners = vector;
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector = (Vector)this.m_statuslisteners.clone();
        vector.addElement(statusListener);
        this.m_statuslisteners = vector;
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        Vector vector = (Vector)this.m_statuslisteners.clone();
        vector.removeElement(statusListener);
        this.m_statuslisteners = vector;
    }

    public void addItems(STObject[] sTObjectArray) {
        this.m_wioComp.watchObjects(this.m_listId, sTObjectArray);
    }

    public void addItem(STObject sTObject) {
        STObject[] sTObjectArray = new STObject[]{sTObject};
        this.addItems(sTObjectArray);
    }

    public void removeItem(STObject sTObject) {
        STObject[] sTObjectArray = new STObject[]{sTObject};
        this.removeItems(sTObjectArray);
    }

    public void removeItems(STObject[] sTObjectArray) {
        this.m_wioComp.stopWatch(this.m_listId, sTObjectArray);
    }

    public void reset() {
        this.m_wioComp.resetList(this.m_listId);
    }

    public synchronized void close() {
        this.m_wioComp.destroyList(this.m_listId);
        Vector vector = (Vector)this.m_statuslisteners.clone();
        vector.removeAllElements();
        this.m_statuslisteners = vector;
        vector = (Vector)this.m_attrListeners.clone();
        vector.removeAllElements();
        this.m_attrListeners = vector;
    }

    public void queryAttributeContent(STObject sTObject, int n) {
        this.m_wioComp.getAttributeContent(this.m_listId, sTObject, n);
    }

    protected void dispatchStatusEvent(StatusEvent statusEvent) {
        Vector vector = this.m_statuslisteners;
        Enumeration enumeration = vector.elements();
        statusEvent.setSource(this);
        while (enumeration.hasMoreElements()) {
            StatusListener statusListener = (StatusListener)enumeration.nextElement();
            switch (statusEvent.getId()) {
                case -2147483647: {
                    statusListener.userStatusChanged(statusEvent);
                    break;
                }
                case -2147483642: {
                    statusListener.groupCleared(statusEvent);
                }
            }
        }
    }

    protected void dispatchAttrEvent(AttributeEvent attributeEvent) {
        Vector vector = this.m_attrListeners;
        Enumeration enumeration = vector.elements();
        attributeEvent.setSource(this);
        while (enumeration.hasMoreElements()) {
            AttributeListener attributeListener = (AttributeListener)enumeration.nextElement();
            switch (attributeEvent.getId()) {
                case 601: {
                    attributeListener.attrChanged(attributeEvent);
                    break;
                }
                case 602: {
                    attributeListener.attrRemoved(attributeEvent);
                    break;
                }
                case 609: {
                    attributeListener.attrContentQueried(attributeEvent);
                    break;
                }
                case 608: {
                    attributeListener.queryAttrContentFailed(attributeEvent);
                }
            }
        }
    }
}

