/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awareness;

import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AttributeProtocol;
import com.lotus.sametime.awareness.AwarenessImpl;
import com.lotus.sametime.awareness.STWatchedObject;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.Session;
import com.lotus.sametime.awareness.WioGroup;
import com.lotus.sametime.awareness.WioObject;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttribProtocolImpl
implements AttributeProtocol {
    private Hashtable m_attributeList = new Hashtable();
    private Vector m_pendingAttributeList = new Vector();
    private int[] m_filter;
    private AwarenessImpl m_wioImpl;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awareness");

    public AttribProtocolImpl(AwarenessImpl awarenessImpl) {
        this.m_wioImpl = awarenessImpl;
    }

    public void processSTEvent(STEvent sTEvent) {
        if (!(sTEvent instanceof AttributeEvent)) {
            return;
        }
        AttributeEvent attributeEvent = (AttributeEvent)sTEvent;
        switch (attributeEvent.getId()) {
            case 201: {
                this.setMyAttribute(attributeEvent.getAttribute());
                attributeEvent.setConsumed(true);
                break;
            }
            case 202: {
                this.removeMyAttribute(attributeEvent.getAttributeKey());
                attributeEvent.setConsumed(true);
                break;
            }
            case 203: {
                this.setFilter(attributeEvent.getFilter());
                attributeEvent.setConsumed(true);
                break;
            }
            case 205: {
                this.addToFilter(attributeEvent.getFilter());
                attributeEvent.setConsumed(true);
                break;
            }
            case 206: {
                this.removeFromFilter(attributeEvent.getFilter());
                attributeEvent.setConsumed(true);
                break;
            }
            case 204: {
                this.getAttributeContent(attributeEvent.getObjectId(), attributeEvent.getAttributeKey(), attributeEvent.getRequestId());
            }
        }
    }

    public void handleMsg(short s, byte[] byArray, boolean bl) {
        switch (s) {
            case 601: {
                this.attributeChanged(byArray);
                break;
            }
            case 602: {
                this.attributeDeleted(byArray);
                break;
            }
            case 605: 
            case 606: {
                this.attributeSuccessResponse(s, byArray);
                break;
            }
            case 603: 
            case 607: {
                this.attributeFailResponse(s, byArray);
                break;
            }
            case 204: {
                this.respondToGetContentRequest(byArray);
                break;
            }
            case 608: {
                this.getContentFailed(byArray);
                break;
            }
            case 609: {
                this.getContentSuccess(byArray);
            }
        }
    }

    private void setMyAttribute(STExtendedAttribute sTExtendedAttribute) {
        this.m_pendingAttributeList.addElement(sTExtendedAttribute);
        if (this.m_wioImpl.isChannelOpen()) {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            try {
                sTExtendedAttribute.dump(ndrOutputStream, this.m_wioImpl.m_maxAttributeSize);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.m_wioImpl.m_channel.sendMsg((short)201, ndrOutputStream.toByteArray(), false);
        }
    }

    private void removeMyAttribute(int n) {
        if (!this.m_wioImpl.isChannelOpen()) {
            this.m_attributeList.remove(new Integer(n));
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        try {
            ndrOutputStream.startMark();
            ndrOutputStream.writeInt(n);
            ndrOutputStream.dumpMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_wioImpl.m_channel.sendMsg((short)202, ndrOutputStream.toByteArray(), false);
    }

    private void setFilter(int[] nArray) {
        Enumeration enumeration;
        Object object;
        this.m_filter = nArray;
        if (this.m_wioImpl.isChannelOpen()) {
            object = new NdrOutputStream();
            try {
                ((NdrOutputStream)object).startMark();
                ((DataOutputStream)object).writeInt(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    ((DataOutputStream)object).writeInt(nArray[i]);
                }
                ((NdrOutputStream)object).dumpMarks();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.m_wioImpl.m_channel.sendMsg((short)203, ((NdrOutputStream)object).toByteArray(), false);
        }
        if (null != (enumeration = this.m_wioImpl.m_watchedEntities.getUsers())) {
            while (enumeration.hasMoreElements()) {
                object = (WioObject)enumeration.nextElement();
                ((WioObject)object).getWatchedObject().getAttributes().clear();
            }
        }
    }

    private void addToFilter(int[] nArray) {
        if (null == this.m_filter) {
            this.setFilter(nArray);
            return;
        }
        int[] nArray2 = new int[this.m_filter.length + nArray.length];
        boolean bl = false;
        boolean bl2 = false;
        int n = this.m_filter.length;
        System.arraycopy(this.m_filter, 0, nArray2, 0, this.m_filter.length);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.m_filter.length; ++j) {
                if (nArray[i] != this.m_filter[j]) continue;
                bl = true;
                break;
            }
            if (!bl) {
                nArray2[n] = nArray[i];
                ++n;
                bl2 = true;
            }
            bl = false;
        }
        if (bl2) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            this.setFilter(nArray3);
        }
    }

    private void removeFromFilter(int[] nArray) {
        if (null == this.m_filter) {
            return;
        }
        int[] nArray2 = new int[this.m_filter.length];
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < this.m_filter.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != this.m_filter[i]) continue;
                bl = false;
                bl2 = true;
                break;
            }
            if (bl) {
                nArray2[n] = this.m_filter[i];
                ++n;
            }
            bl = true;
        }
        if (bl2) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            this.setFilter(nArray3);
        }
    }

    private void getAttributeContent(STObject sTObject, int n, int n2) {
        if (!this.m_wioImpl.isChannelOpen()) {
            return;
        }
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        STWatchedObject sTWatchedObject = this.m_wioImpl.m_watchedEntities.getObj(sTObject.getId()).getWatchedObject();
        short s = this.m_wioImpl.m_objectFactory.getType(sTWatchedObject);
        try {
            ndrOutputStream.startMark();
            ndrOutputStream.writeShort(s);
            sTObject.getId().dump(ndrOutputStream);
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeInt(n2);
            ndrOutputStream.dumpMarks();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_wioImpl.m_channel.sendMsg((short)204, ndrOutputStream.toByteArray(), false);
    }

    private void attributeChanged(byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.loadMark();
            ndrInputStream.readShort();
            STId sTId = new STId(ndrInputStream);
            STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(ndrInputStream);
            WioObject wioObject = this.m_wioImpl.m_watchedEntities.getObj(sTId);
            Hashtable hashtable = wioObject.getWatchedObject().getAttributes();
            hashtable.put(new Integer(sTExtendedAttribute.getKey()), sTExtendedAttribute);
            STExtendedAttribute[] sTExtendedAttributeArray = new STExtendedAttribute[]{sTExtendedAttribute};
            this.notifyAtrributeChange((short)601, wioObject, sTExtendedAttributeArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void attributeDeleted(byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.loadMark();
            ndrInputStream.readShort();
            STId sTId = new STId(ndrInputStream);
            int n = ndrInputStream.readInt();
            WioObject wioObject = this.m_wioImpl.m_watchedEntities.getObj(sTId);
            Hashtable hashtable = wioObject.getWatchedObject().getAttributes();
            hashtable.remove(new Integer(n));
            this.notifyAtrributeChange((short)602, wioObject, new Integer(n));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void attributeSuccessResponse(short s, byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            AttributeEvent attributeEvent;
            ndrInputStream.loadMark();
            int n = ndrInputStream.readInt();
            if (s == 605) {
                Integer n2 = new Integer(n);
                STExtendedAttribute sTExtendedAttribute = null;
                for (int i = 0; i < this.m_pendingAttributeList.size(); ++i) {
                    STExtendedAttribute sTExtendedAttribute2 = (STExtendedAttribute)this.m_pendingAttributeList.elementAt(i);
                    if (sTExtendedAttribute2.getKey() != n) continue;
                    sTExtendedAttribute = sTExtendedAttribute2;
                    this.m_pendingAttributeList.removeElementAt(i);
                    break;
                }
                if (sTExtendedAttribute == null) {
                    return;
                }
                this.m_attributeList.put(n2, sTExtendedAttribute);
                attributeEvent = new AttributeEvent((Object)this, (int)s, sTExtendedAttribute);
            } else {
                attributeEvent = new AttributeEvent((Object)this, (int)s, n);
            }
            this.sendEvent(attributeEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void attributeFailResponse(short s, byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            AttributeEvent attributeEvent;
            ndrInputStream.loadMark();
            int n = ndrInputStream.readInt();
            int n2 = ndrInputStream.readInt();
            if (s == 603) {
                STExtendedAttribute sTExtendedAttribute = null;
                for (int i = 0; i < this.m_pendingAttributeList.size(); ++i) {
                    STExtendedAttribute sTExtendedAttribute2 = (STExtendedAttribute)this.m_pendingAttributeList.elementAt(i);
                    if (sTExtendedAttribute2.getKey() != n) continue;
                    sTExtendedAttribute = sTExtendedAttribute2;
                    this.m_pendingAttributeList.removeElementAt(i);
                    break;
                }
                attributeEvent = new AttributeEvent((Object)this, (int)s, sTExtendedAttribute, n2);
            } else {
                attributeEvent = new AttributeEvent((Object)this, (int)s, n, n2);
            }
            this.sendEvent(attributeEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void notifyAtrributeChange(short s, WioObject wioObject, Object object) {
        AttributeEvent attributeEvent;
        Integer n;
        Enumeration enumeration = wioObject.getWatchingSessions();
        STWatchedObject sTWatchedObject = (STWatchedObject)wioObject.getWatchedObject().clone();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            if (!this.m_wioImpl.m_watchedEntities.getSession(n).isVisible()) continue;
            attributeEvent = this.generateEvent(s, n, sTWatchedObject, object);
            this.sendEvent(attributeEvent);
        }
        Enumeration enumeration2 = wioObject.getWatchingGroups();
        while (enumeration2.hasMoreElements()) {
            STGroup sTGroup = (STGroup)enumeration2.nextElement();
            WioGroup wioGroup = this.m_wioImpl.m_watchedEntities.getGroup(sTGroup.getId());
            enumeration = wioGroup.getWatchingSessions();
            STWatchedUser sTWatchedUser = (STWatchedUser)sTWatchedObject.clone();
            sTWatchedUser.setGroup(sTGroup);
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                if (!this.m_wioImpl.m_watchedEntities.getSession(n).isVisible()) continue;
                attributeEvent = this.generateEvent(s, n, sTWatchedUser, object);
                this.sendEvent(attributeEvent);
            }
        }
    }

    private void respondToGetContentRequest(byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        int n = Integer.MIN_VALUE;
        try {
            ndrInputStream.loadMark();
            ndrInputStream.readShort();
            new STId(ndrInputStream);
            Integer n2 = new Integer(ndrInputStream.readInt());
            int n3 = ndrInputStream.readInt();
            STExtendedAttribute sTExtendedAttribute = (STExtendedAttribute)this.m_attributeList.get(n2);
            if (null != sTExtendedAttribute) {
                n = 0;
            }
            ndrOutputStream.startMark();
            ndrOutputStream.writeInt(n);
            ndrOutputStream.writeInt(n3);
            ndrOutputStream.writeShort(2);
            this.m_wioImpl.m_loginInfo.getId().dump(ndrOutputStream);
            ndrOutputStream.writeInt(n2);
            if (n == 0) {
                sTExtendedAttribute.dump(ndrOutputStream, 0);
            }
            ndrOutputStream.dumpMarks();
            short s = n == 0 ? (short)609 : 608;
            this.m_wioImpl.m_channel.sendMsg(s, ndrOutputStream.toByteArray(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void getContentSuccess(byte[] byArray) {
        try {
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            ndrInputStream.loadMark();
            int n = ndrInputStream.readInt();
            Debug.stAssert(n == 0);
            int n2 = ndrInputStream.readInt();
            ndrInputStream.readShort();
            STId sTId = new STId(ndrInputStream);
            ndrInputStream.readInt();
            STExtendedAttribute sTExtendedAttribute = new STExtendedAttribute(ndrInputStream);
            STWatchedObject sTWatchedObject = this.m_wioImpl.m_watchedEntities.getObj(sTId).getWatchedObject();
            AttributeEvent attributeEvent = new AttributeEvent((Object)this, 609, n2, (STObject)sTWatchedObject, sTExtendedAttribute);
            this.sendEvent(attributeEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void getContentFailed(byte[] byArray) {
        try {
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            ndrInputStream.loadMark();
            int n = ndrInputStream.readInt();
            Debug.stAssert(n != 0);
            int n2 = ndrInputStream.readInt();
            ndrInputStream.readShort();
            STId sTId = new STId(ndrInputStream);
            int n3 = ndrInputStream.readInt();
            STWatchedObject sTWatchedObject = this.m_wioImpl.m_watchedEntities.getObj(sTId).getWatchedObject();
            AttributeEvent attributeEvent = new AttributeEvent(this, 608, n2, sTWatchedObject, n3, n);
            this.sendEvent(attributeEvent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private AttributeEvent generateEvent(short s, Integer n, STWatchedObject sTWatchedObject, Object object) {
        AttributeEvent attributeEvent;
        switch (s) {
            case 601: {
                attributeEvent = new AttributeEvent((Object)this, (int)s, n, sTWatchedObject, (STExtendedAttribute[])object);
                break;
            }
            case 602: {
                attributeEvent = new AttributeEvent((Object)this, (int)s, n, sTWatchedObject, (int)((Integer)object));
                break;
            }
            default: {
                attributeEvent = null;
                if (!this.m_logger.isLoggable(Level.FINER)) break;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "generateEvent", "AttributeImpl: Failed to construct a AttributeEvent object");
            }
        }
        return attributeEvent;
    }

    private void sendEvent(STEvent sTEvent) {
        this.m_wioImpl.getSession().getDispatcher().sendEvent(sTEvent);
    }

    public void setFilter() {
        if (null != this.m_filter) {
            this.setFilter(this.m_filter);
        }
    }

    public void sendAttributesSnapshot(STWatchedObject sTWatchedObject, Integer n) {
        int n2 = 0;
        Hashtable hashtable = sTWatchedObject.getAttributes();
        STExtendedAttribute[] sTExtendedAttributeArray = new STExtendedAttribute[hashtable.size()];
        Enumeration enumeration = sTWatchedObject.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            sTExtendedAttributeArray[n2++] = (STExtendedAttribute)enumeration.nextElement();
        }
        AttributeEvent attributeEvent = new AttributeEvent((Object)this, 601, n, sTWatchedObject, sTExtendedAttributeArray);
        this.sendEvent(attributeEvent);
    }

    private void sendAttributesSnapshot(STWatchedObject sTWatchedObject) {
        Enumeration enumeration = null;
        if (sTWatchedObject instanceof STWatchedUser && ((STWatchedUser)sTWatchedObject).getGroup() != null) {
            STGroup sTGroup = ((STWatchedUser)sTWatchedObject).getGroup();
            enumeration = this.m_wioImpl.m_watchedEntities.getGroupWatchingSessions(sTGroup.getId());
        } else {
            enumeration = this.m_wioImpl.m_watchedEntities.getObjWatchingSessions(sTWatchedObject.getId());
        }
        while (enumeration.hasMoreElements()) {
            Session session = this.m_wioImpl.m_watchedEntities.getSession((Integer)enumeration.nextElement());
            if (!session.isVisible()) continue;
            this.sendAttributesSnapshot(sTWatchedObject, session.getId());
        }
    }

    public void sendAttributesSnapshot(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.sendAttributesSnapshot((STWatchedObject)enumeration.nextElement());
        }
    }

    public void resendAttributes() {
        Vector vector = (Vector)this.m_pendingAttributeList.clone();
        this.m_pendingAttributeList.removeAllElements();
        Enumeration<Object> enumeration = this.m_attributeList.elements();
        while (enumeration.hasMoreElements()) {
            this.setMyAttribute((STExtendedAttribute)enumeration.nextElement());
        }
        this.m_attributeList.clear();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.setMyAttribute((STExtendedAttribute)enumeration.nextElement());
        }
    }
}

