/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ORMUtils;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.CaseInsensitiveMap;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class HibernateEventHandler
extends EmptyInterceptor
implements PostInsertEventListener,
PostUpdateEventListener,
PreDeleteEventListener,
PostDeleteEventListener,
PreLoadEventListener,
PostLoadEventListener {
    private TemplateProxy appInterceptor;
    private static String interceptorInterface = "cfide.orm.IEventHandler";
    private static final String PRE_INSERT = "preInsert";
    private static final String POST_INSERT = "postInsert";
    private static final String PRE_DELETE = "preDelete";
    private static final String POST_DELETE = "postDelete";
    private static final String PRE_UPDATE = "preUpdate";
    private static final String POST_UPDATE = "postUpdate";
    private static final String PRE_LOAD = "preLoad";
    private static final String POST_LOAD = "postLoad";
    private static final String PRE_FLUSH = "preFlush";
    private static final String POST_FLUSH = "postFlush";
    private final Object[] noArgs = new Object[0];

    public HibernateEventHandler(String handlerCFC) {
        if (handlerCFC != null) {
            FusionContext context = FusionContext.getCurrent();
            String oldPagePath = context.getPagePath();
            try {
                String applicationPath = context.getApplicationPath();
                File applicationFile = new File(applicationPath, "Application.cfc");
                TemplateProxy appCFCTemplate = TemplateProxyFactory.resolveFile((NeoPageContext)context.pageContext, (File)applicationFile);
                context.setPagePath(applicationFile.getAbsolutePath());
                this.appInterceptor = TemplateProxyFactory.resolveName((String)handlerCFC, (NeoPageContext)appCFCTemplate.page.pageContext);
                try {
                    this.appInterceptor.verifyInterfacesImpl(appCFCTemplate.page.pageContext);
                }
                catch (ApplicationException ae) {
                    throw new InvalidInterceptorException(handlerCFC);
                }
            }
            catch (InvalidInterceptorException iie) {
                throw iie;
            }
            catch (Throwable th) {
                throw new InstantiationException(handlerCFC, th);
            }
            finally {
                context.setPagePath(oldPagePath);
            }
            if (!this.appInterceptor.isInstanceOf(interceptorInterface)) {
                throw new InvalidInterceptorException(handlerCFC);
            }
        }
    }

    public void preFlush(Iterator entities) {
        ArrayList dirtyEntities = new ArrayList();
        while (entities.hasNext()) {
            dirtyEntities.add(entities.next());
        }
        this.invokeMethod(PRE_FLUSH, dirtyEntities, null);
    }

    public void postFlush(Iterator entities) {
        ArrayList dirtyEntities = new ArrayList();
        while (entities.hasNext()) {
            dirtyEntities.add(entities.next());
        }
        this.invokeMethod(POST_FLUSH, dirtyEntities, null);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        return this.invokeInterceptorMethod(PRE_INSERT, entity, propertyNames, types, state, null);
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return this.invokeInterceptorMethod(PRE_UPDATE, entity, propertyNames, types, currentState, this.createMap(propertyNames, previousState));
    }

    public void onPostInsert(PostInsertEvent event) {
        this.invokeMethod(POST_INSERT, event.getEntity(), null);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.invokeMethod(POST_UPDATE, event.getEntity(), null);
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        return this.invokeMethod(PRE_DELETE, event.getEntity(), null);
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.invokeMethod(POST_DELETE, event.getEntity(), null);
    }

    public void onPreLoad(PreLoadEvent event) {
        this.invokeMethod(PRE_LOAD, event.getEntity(), null);
    }

    public void onPostLoad(PostLoadEvent event) {
        this.invokeMethod(POST_LOAD, event.getEntity(), null);
    }

    private boolean invokeInterceptorMethod(String methodName, Object entity, String[] properties, Type[] types, Object[] state, Map previousState) {
        this.invokeMethod(methodName, entity, previousState);
        boolean changed = false;
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            Object oldVal = state[i];
            Object currentVal = this.getPropertyValue(entity, property);
            if (types[i] != null && types[i].getReturnedClass() != Map.class) {
                currentVal = ORMUtils.getTypedValue(currentVal, types[i].getReturnedClass());
            }
            if (oldVal == currentVal || currentVal != null && currentVal.equals(oldVal)) continue;
            state[i] = currentVal;
            changed = true;
        }
        return changed;
    }

    private Object getPropertyValue(Object entity, String propertyName) {
        if (entity instanceof PersistentTemplateProxy) {
            return ((PersistentTemplateProxy)((Object)entity)).getProperty(propertyName);
        }
        return null;
    }

    private boolean invokeMethod(String methodName, Object entity, Map previousState) {
        Object cfcResult = null;
        Object appCfcResult = null;
        FusionContext context = FusionContext.getCurrent();
        NeoPageContext pageContext = context.pageContext;
        if (entity instanceof PersistentTemplateProxy) {
            UDFMethod cfcMethod;
            PersistentTemplateProxy cfc = (PersistentTemplateProxy)((Object)entity);
            Object value = cfc.get(methodName);
            UDFMethod uDFMethod = cfcMethod = value instanceof UDFMethod ? (UDFMethod)value : null;
            if (cfcMethod == null && this.appInterceptor == null) {
                return false;
            }
            boolean oldRemoting = context.setIsRemoting(false);
            try {
                if (cfcMethod != null) {
                    cfcResult = methodName.equals(PRE_UPDATE) ? cfc.invoke(methodName, new Object[]{previousState}, (PageContext)pageContext) : cfc.invoke(methodName, this.noArgs, (PageContext)pageContext);
                }
            }
            catch (Throwable th) {
                throw new HibernateException(th);
            }
            finally {
                context.setIsRemoting(oldRemoting);
            }
        }
        if (!(this.appInterceptor == null || cfcResult != null && Cast._boolean(cfcResult))) {
            boolean oldRemoting = context.setIsRemoting(false);
            try {
                appCfcResult = methodName.equals(PRE_UPDATE) ? this.appInterceptor.invoke(methodName, new Object[]{entity, previousState}, (PageContext)pageContext) : this.appInterceptor.invoke(methodName, new Object[]{entity}, (PageContext)pageContext);
            }
            catch (Throwable th) {
                throw new HibernateException(th);
            }
            finally {
                context.setIsRemoting(oldRemoting);
            }
        }
        if (cfcResult != null && Cast._boolean(cfcResult)) {
            return true;
        }
        return appCfcResult != null && Cast._boolean(appCfcResult);
    }

    private Map<String, Object> createMap(String[] propertyNames, Object[] state) {
        if (state == null) {
            return Collections.EMPTY_MAP;
        }
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            map.put(name, state[i]);
        }
        return map;
    }

    public boolean requiresPostCommitHanding(EntityPersister arg0) {
        return false;
    }

    public static class InvalidInterceptorException
    extends ApplicationException {
        public String cfc;

        public InvalidInterceptorException(String cfc) {
            this.cfc = cfc;
        }
    }

    public static class InstantiationException
    extends ApplicationException {
        public String cfc;

        public InstantiationException(String cfc, Throwable th) {
            super(th);
            this.cfc = cfc;
        }
    }
}

