/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.Base64Encoder;
import coldfusion.document.webkit.PDFgCryptoException;
import coldfusion.document.webkit.PDFgServiceManagerSetupException;
import coldfusion.util.KeystoreUtils;
import coldfusion.util.RB;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PDFgCryptoUtils {
    private static final String BC = "BC";
    private static final String AES = "AES";
    public static final String CHARSET = "UTF-8";
    private static final String BASEENCODING = "Base64";
    private static final char PADCHAR = '#';
    private static final String AES_CBC_PKCS5_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String RSA_GENERATOR_ALGORITHM = "RSA";
    private static final String PROVIDER = "BC";
    private static final String KEY_PROVIDER = "BC";
    public static final String KEYS_LOAD_ERROR = "KEYS_LOAD_ERROR";
    private static Random secRandom = new SecureRandom();

    public static long byteToLong(byte[] buff) {
        assert (buff.length == 8);
        ByteBuffer bb = ByteBuffer.wrap(buff);
        return bb.getLong();
    }

    public static long generateRandom() {
        return secRandom.nextLong();
    }

    public static byte[] rsaEncrypt(byte[] cipherData, PublicKey publicKey) throws PDFgCryptoException {
        byte[] data = null;
        try {
            KeystoreUtils.addBCProvider();
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM, "BC");
            cipher.init(1, publicKey);
            data = cipher.doFinal(cipherData);
        }
        catch (Exception e) {
            throw new PDFgCryptoException();
        }
        finally {
            KeystoreUtils.removeBCProvider();
        }
        return data;
    }

    public static byte[] rsaDecrypt(byte[] cipherData, PrivateKey privateKey) {
        byte[] data = null;
        try {
            KeystoreUtils.addBCProvider();
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM, "BC");
            cipher.init(2, privateKey);
            data = cipher.doFinal(cipherData);
        }
        catch (Exception e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgCryptoUtils.class, (String)KEYS_LOAD_ERROR), e);
        }
        finally {
            KeystoreUtils.removeBCProvider();
        }
        return data;
    }

    public static String encrypt(String pKey, String seed) throws PDFgCryptoException {
        byte[] bytes;
        try {
            bytes = pKey.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new PDFgCryptoException();
        }
        byte[] enc = PDFgCryptoUtils.encrypt(bytes, PDFgCryptoUtils.generateAesKey(seed), AES_CBC_PKCS5_ALGORITHM);
        return PDFgCryptoUtils.binaryEncode(enc, BASEENCODING);
    }

    public static String decrypt(String encryptedPassword, String seedval) throws PDFgCryptoException {
        try {
            byte[] decoded = PDFgCryptoUtils.binaryDecode(encryptedPassword, BASEENCODING);
            byte[] decrypted = PDFgCryptoUtils.decrypt(decoded, PDFgCryptoUtils.generateAesKey(seedval), AES_CBC_PKCS5_ALGORITHM);
            return new String(decrypted, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new PDFgCryptoException();
        }
    }

    public static PublicKey createPublicKeyObj(BigInteger pKeyMod, BigInteger pKeyExp) throws PDFgCryptoException {
        try {
            KeyFactory fact = KeyFactory.getInstance(RSA_GENERATOR_ALGORITHM, "BC");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(pKeyMod, pKeyExp);
            return fact.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFgCryptoException();
        }
        catch (InvalidKeySpecException e) {
            throw new PDFgCryptoException();
        }
        catch (NoSuchProviderException e) {
            throw new PDFgCryptoException();
        }
    }

    public static PrivateKey createPrivateKeyObj(BigInteger pKeyMod, BigInteger pKeyExp) {
        try {
            KeyFactory fact = KeyFactory.getInstance(RSA_GENERATOR_ALGORITHM, "BC");
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(pKeyMod, pKeyExp);
            return fact.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgCryptoUtils.class, (String)KEYS_LOAD_ERROR), e);
        }
        catch (InvalidKeySpecException e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgCryptoUtils.class, (String)KEYS_LOAD_ERROR), e);
        }
        catch (NoSuchProviderException e) {
            throw new PDFgCryptoException();
        }
    }

    private static String generateAesKey(String seed) {
        if (seed == null || seed != null && seed.length() == 0) {
            return null;
        }
        byte[] seedBytes = null;
        try {
            seedBytes = seed.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            seedBytes = seed.getBytes();
        }
        int seedLen = seedBytes.length;
        seedBytes = Arrays.copyOf(seedBytes, 16);
        if (seedLen < 16) {
            for (int i = seedLen; i < 16; ++i) {
                seedBytes[i] = 35;
            }
        }
        SecretKeySpec secretKey = new SecretKeySpec(seedBytes, AES);
        return Base64Encoder.encode(secretKey.getEncoded());
    }

    private static String binaryEncode(byte[] inputbinary, String encoding) throws PDFgCryptoException {
        return Base64Encoder.encode(inputbinary);
    }

    private static byte[] binaryDecode(String string, String encoding) throws PDFgCryptoException {
        try {
            return Base64Encoder.decode(string);
        }
        catch (Exception e) {
            throw new PDFgCryptoException();
        }
    }

    private static byte[] encrypt(byte[] bytes, String key, String algorithm) throws PDFgCryptoException {
        byte[] enc;
        try {
            enc = PDFgCryptoUtils.processCipherWork(bytes, null, key, algorithm, 1, null, 0);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new PDFgCryptoException();
        }
        return enc;
    }

    private static byte[] decrypt(byte[] bytes, String key, String algorithm) throws PDFgCryptoException {
        byte[] decrypted;
        try {
            decrypted = PDFgCryptoUtils.processCipherWork(null, bytes, key, algorithm, 2, null, 0);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new PDFgCryptoException();
        }
        return decrypted;
    }

    private static byte[] processCipherWork(byte[] original, byte[] decoded, String key, String algorithm, int CRYPT_MODE, byte[] prefix, int iter) throws NoSuchAlgorithmException, PDFgCryptoException {
        byte[] enc;
        int offset = 0;
        try {
            int slshIndx = algorithm.indexOf(47);
            String algName = algorithm;
            boolean feedbackMode = false;
            if (slshIndx != -1) {
                algName = algorithm.substring(0, slshIndx);
                String mode = algorithm.substring(slshIndx + 1);
                if (!mode.startsWith("ECB")) {
                    feedbackMode = true;
                }
            }
            Cipher cipher = Cipher.getInstance(algorithm);
            SecretKey recreatedSecretKey = PDFgCryptoUtils.retrieveSecretKey(key, algName);
            if (feedbackMode) {
                if (prefix == null) {
                    prefix = new byte[cipher.getBlockSize()];
                    offset = prefix.length;
                    if (CRYPT_MODE == 1) {
                        new SecureRandom().nextBytes(prefix);
                    } else {
                        System.arraycopy(decoded, 0, prefix, 0, offset);
                    }
                }
                IvParameterSpec ivParamSpec = new IvParameterSpec(prefix);
                cipher.init(CRYPT_MODE, (Key)recreatedSecretKey, ivParamSpec);
            } else {
                cipher.init(CRYPT_MODE, recreatedSecretKey);
            }
            if (CRYPT_MODE == 2) {
                enc = cipher.doFinal(decoded, offset, decoded.length - offset);
            } else {
                enc = new byte[cipher.getOutputSize(original.length) + offset];
                if (offset != 0) {
                    System.arraycopy(prefix, 0, enc, 0, offset);
                }
                cipher.doFinal(original, 0, original.length, enc, offset);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw new PDFgCryptoException();
        }
        catch (Exception e) {
            throw new PDFgCryptoException();
        }
        catch (ExceptionInInitializerError initerr) {
            throw new PDFgCryptoException();
        }
        catch (Error err) {
            throw new PDFgCryptoException();
        }
        return enc;
    }

    private static SecretKey retrieveSecretKey(String key, String algorithm) throws PDFgCryptoException {
        byte[] encodedkey = Base64Encoder.decode(key);
        return new SecretKeySpec(encodedkey, algorithm);
    }

    protected static boolean addBCProvider() {
        if (Security.getProvider("BC") == null) {
            BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider((Provider)bouncyCastleProvider);
            return true;
        }
        return false;
    }

    protected static void removeBCProvider() {
        if (Security.getProvider("BC") != null) {
            Security.removeProvider("BC");
        }
    }
}

