/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Struct;
import coldfusion.s3.consumer.NoncurrentVersionTransitionConsumer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.services.s3.model.TransitionStorageClass;

public class TransitionConsumer
extends ConsumerMap<Transition.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static TransitionConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransitionConsumer getInstance() {
        if (instance != null) return instance;
        Class<NoncurrentVersionTransitionConsumer> clazz = NoncurrentVersionTransitionConsumer.class;
        synchronized (NoncurrentVersionTransitionConsumer.class) {
            instance = new TransitionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TransitionConsumer() {
        this.put("days", new ConsumerValidator((builder, value) -> builder.days(Integer.valueOf(this.cast.getIntegerProperty(value))), Collections.emptyList()));
        this.put("date", new ConsumerValidator((builder, value) -> builder.date(this.cast.getMidNightInstant(value)), Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"storageClass");
            builder.storageClass(TransitionStorageClass.valueOf((String)input));
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }

    public List<Struct> getStruct(List<Transition> transitions) {
        return ((List)Optional.ofNullable(transitions).orElse(new LinkedList())).stream().map(transition -> {
            Struct struct = new Struct();
            if (Objects.nonNull(transition.days())) {
                struct.put((Object)"days", (Object)transition.days());
            }
            if (Objects.nonNull(transition.storageClass())) {
                struct.put((Object)"storageClass", (Object)transition.storageClass().name());
            }
            if (Objects.nonNull(transition.date())) {
                struct.put((Object)"date", (Object)transition.date().toString());
            }
            return struct;
        }).collect(Collectors.toList());
    }
}

