/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.s3.request.AbstractGetObjectRequest;
import java.nio.charset.Charset;
import java.util.Collections;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;

public class AbstractGetObjectRequestConsumer<T extends AbstractGetObjectRequest>
extends ConsumerMap<T> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public AbstractGetObjectRequestConsumer() {
        this.put("ifMatch", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ifMatch");
            getObjectRequest.getObjectRequest().ifMatch(input);
        }, Collections.emptyList()));
        this.put("ifModifiedSince", new ConsumerValidator((getObjectRequest, value) -> getObjectRequest.getObjectRequest().ifModifiedSince(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("ifNoneMatch", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ifNoneMatch");
            getObjectRequest.getObjectRequest().ifNoneMatch(input);
        }, Collections.emptyList()));
        this.put("ifUnmodifiedSince", new ConsumerValidator((getObjectRequest, value) -> getObjectRequest.getObjectRequest().ifUnmodifiedSince(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("key", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            getObjectRequest.getObjectRequest().key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("range", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"range");
            getObjectRequest.getObjectRequest().range(input);
        }, Collections.emptyList()));
        this.put("cacheControl", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"cacheControl");
            getObjectRequest.getObjectRequest().responseCacheControl(input);
        }, Collections.emptyList()));
        this.put("contentDisposition", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentDisposition");
            getObjectRequest.getObjectRequest().responseContentDisposition(input);
        }, Collections.emptyList()));
        this.put("contentEncoding", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentEncoding");
            getObjectRequest.getObjectRequest().responseContentEncoding(input);
        }, Collections.emptyList()));
        this.put("contentLanguage", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentLanguage");
            getObjectRequest.getObjectRequest().responseContentLanguage(input);
        }, Collections.emptyList()));
        this.put("contentType", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentType");
            getObjectRequest.getObjectRequest().responseContentType(input);
        }, Collections.emptyList()));
        this.put("expires", new ConsumerValidator((getObjectRequest, value) -> getObjectRequest.getObjectRequest().responseExpires(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("versionId", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"versionId");
            getObjectRequest.getObjectRequest().versionId(input);
        }, Collections.emptyList()));
        this.put("sseCustomerAlgorithm", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerAlgorithm");
            getObjectRequest.getObjectRequest().sseCustomerAlgorithm(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKey", new ConsumerValidator((getObjectRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerKey");
            String key = input;
            getObjectRequest.getObjectRequest().sseCustomerKey(BinaryUtils.toBase64((byte[])key.getBytes(Charset.forName(RuntimeServiceImpl.getDefaultCharset()))));
            getObjectRequest.getObjectRequest().sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])key.getBytes(Charset.forName(RuntimeServiceImpl.getDefaultCharset()))));
        }, Collections.emptyList()));
        this.put("requestPayer", new ConsumerValidator((getObjectRequest, value) -> getObjectRequest.getObjectRequest().requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("partNumber", new ConsumerValidator((getObjectRequest, value) -> getObjectRequest.getObjectRequest().partNumber(Integer.valueOf(this.cast.getIntegerProperty(value))), Collections.emptyList()));
    }
}

