/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util.PageDecorator;

import coldfusion.document.CFDocument;
import coldfusion.document.StaticHeaderFooterContentProvider;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.PageNoCallbackHandler;
import com.icesoft.util.trackers.RenderDoneTracker;
import com.icesoft.util.trackers.RenderDoneTrackerListener;
import com.lowagie.text.pdf.PdfGraphics2D;
import ice.pilots.html4.DocPaneXml;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.ContentLoaderFactory;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.PageDecoration;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

public class HeaderFooterDecoration
implements PageDecoration,
RenderDoneTrackerListener {
    private int location = 0;
    private StormBase base = null;
    private URL baseurl = null;
    private double calcScale = 0.0;
    private HeaderFooterContentProvider contentProvider;
    private DocumentProperties docProps;
    private PageNoCallbackHandler pageNoCallbackHandler;
    private MyCallbackViewString myCallbackViewString;
    private final Object renderLock = new Object();
    private int renderTimeout = 60;

    public HeaderFooterDecoration(StormBase base, HeaderFooterContentProvider contentProvider, URL baseurl, DocumentProperties docProps, int location) throws Exception {
        this.contentProvider = contentProvider;
        this.docProps = docProps;
        this.location = location;
        this.base = base;
        this.baseurl = baseurl;
        this.myCallbackViewString = new MyCallbackViewString(base, this);
    }

    public void setPageNoCallbackHandler(PageNoCallbackHandler pageNoCallbackHandler) {
        this.pageNoCallbackHandler = pageNoCallbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, int currentPageIndex, int pageCount, StormPageFormat pageFormat) {
        StormPrinter printer = null;
        Graphics2D g2d = (Graphics2D)g;
        try {
            double y;
            double x;
            double height;
            ByteArrayInputStream in;
            CFDocument doc = this.docProps.getDocument();
            int currPageNo = doc.getCurrentPageNumber() + 1;
            int currentSectionPageNumber = doc.getCurrentSectionPageNumber();
            int totalSectionPageCount = doc.getTotalSectionPageCount();
            if (this.pageNoCallbackHandler != null) {
                this.pageNoCallbackHandler.setCurrentPageNumber(currPageNo);
                if (currentSectionPageNumber != 0) {
                    this.pageNoCallbackHandler.setCurrentSectionPageNumber(currentSectionPageNumber);
                }
                if (totalSectionPageCount != 0) {
                    this.pageNoCallbackHandler.setTotalSectionPageCount(totalSectionPageCount);
                }
                this.pageNoCallbackHandler.setTotalPageCount(doc.getTotalPageCount());
            }
            try {
                String htmlContent = this.contentProvider.getContent(currPageNo, doc.getTotalPageCount(), currentSectionPageNumber, totalSectionPageCount);
                if (htmlContent == null || htmlContent.trim().length() == 0) {
                    return;
                }
                in = new ByteArrayInputStream(htmlContent.getBytes(this.contentProvider.getCharset()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.myCallbackViewString.registerWith(this.base);
            ContentLoaderFactory contentLoaderFactory = this.base.getContentLoaderFactory();
            ContentLoader cl = contentLoaderFactory.createContentLoader(this.baseurl, (InputStream)in, "text/html; charset=" + this.contentProvider.getCharset());
            this.base.renderContent(cl, "HeaderFooterDecoration_" + this.location);
            Object object = this.renderLock;
            synchronized (object) {
                this.renderLock.wait(this.renderTimeout * 1000);
            }
            MyCallbackViewString mcvs = (MyCallbackViewString)this.base.getViewportCallback();
            Viewport vp = mcvs.getViewPort();
            if (vp == null) {
                return;
            }
            Pilot pilot = vp.getPilot();
            printer = pilot.createPrinter();
            AffineTransform trans = g2d.getTransform();
            StormPageFormat htmlPageFormat = printer.getStormPageFormat();
            htmlPageFormat.setBackgroundVisible(this.docProps.isBackGroundVisible());
            htmlPageFormat.setTextWrapping(true);
            htmlPageFormat.setHtmlSmartPaging(false);
            if (this.location == 0) {
                if (pageFormat.getMargin(1) <= 0.0) {
                    throw new InvalidHeaderFooterSizeException(1, pageFormat.getMargin(1));
                }
                height = pageFormat.getMargin(1);
                htmlPageFormat.setPageSize((Unit)new PointUnit(pageFormat.getImageableWidth()), (Unit)new PointUnit(pageFormat.getMargin(1)));
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 2);
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 4);
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 1);
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 3);
                x = pageFormat.getMargin(2);
                y = 0.0;
            } else {
                if (pageFormat.getMargin(3) <= 0.0) {
                    throw new InvalidHeaderFooterSizeException(3, pageFormat.getMargin(3));
                }
                height = (double)((int)pageFormat.getPageHeight()) - pageFormat.getImageableHeight() - pageFormat.getMargin(1);
                htmlPageFormat.setPageSize((Unit)new PointUnit(pageFormat.getImageableWidth()), (Unit)new PointUnit(height));
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 2);
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 4);
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 1);
                htmlPageFormat.setMargin((Unit)new PointUnit(0.0), 3);
                x = pageFormat.getMargin(2);
                y = pageFormat.getMargin(1) + pageFormat.getImageableHeight();
            }
            g2d.translate(x, y);
            htmlPageFormat.setScaleToFitEnabled(false);
            this.setAppropriateScale(printer, htmlPageFormat, height, pilot);
            if (g2d instanceof PdfGraphics2D) {
                ((PdfGraphics2D)g2d).setHeaderFooter(true);
            }
            if (this.location == 0) {
                g.setClip(0, 0, (int)pageFormat.getPageWidth(), (int)htmlPageFormat.getImageableHeight());
            }
            printer.print((Graphics)g2d);
            g2d.setTransform(trans);
            if (g2d instanceof PdfGraphics2D) {
                ((PdfGraphics2D)g2d).setHeaderFooter(false);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            if (printer != null) {
                printer.dispose();
            }
        }
    }

    private void setAppropriateScale(StormPrinter printer, StormPageFormat format, double height, Pilot pilot) {
        if (this.calcScale != 0.0 && this.contentProvider instanceof StaticHeaderFooterContentProvider) {
            format.setScale(this.calcScale);
            printer.setStormPageFormat(format);
            return;
        }
        double docHeight = this.getDocHeight(pilot);
        double vscale = height / docHeight;
        double hscale = format.getImageableWidth() / printer.getDimension().getWidth();
        double minScale = hscale < vscale ? hscale : vscale;
        minScale = 0.9 * (minScale < 1.0 ? minScale : 1.0);
        double scale = 1.0;
        if (printer.getPageCount() > 1) {
            double ulimit = 1.0;
            double llimit = minScale;
            while (ulimit - llimit > 0.002) {
                scale = (ulimit + llimit) / 2.0;
                format.setScale(scale);
                printer.setStormPageFormat(format);
                if (printer.getPageCount() > 1) {
                    ulimit = scale;
                    continue;
                }
                llimit = scale;
            }
            if (printer.getPageCount() > 1) {
                scale = llimit;
                format.setScale(scale);
                printer.setStormPageFormat(format);
            }
        }
        if ((hscale = format.getImageableWidth() / printer.getDimension().getWidth()) < 1.0) {
            scale = hscale * scale;
            scale = (int)(scale * 1000.0);
            format.setScale(scale /= 1000.0);
            printer.setStormPageFormat(format);
        }
        this.calcScale = scale;
    }

    private int getDocHeight(Pilot pilot) {
        DocPaneXml dPane = (DocPaneXml)pilot.getDocPane();
        return dPane.getBodyHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderingDone(String viewportID, int resolutionType, String message) {
        Object object = this.renderLock;
        synchronized (object) {
            this.renderLock.notifyAll();
        }
    }

    public static class InvalidHeaderFooterSizeException
    extends RuntimeException {
        private int type;
        private double size;

        public InvalidHeaderFooterSizeException(int type, double size) {
            this.type = type;
            this.size = size;
        }

        public int getType() {
            return this.type;
        }

        public double getSize() {
            return this.size;
        }
    }

    static class MyCallbackViewString
    extends CallbackAdapter {
        private Viewport viewport;
        private StormBase stormBase;
        private HeaderFooterDecoration decoration;

        public MyCallbackViewString(StormBase stormBase, HeaderFooterDecoration decoration) {
            this.stormBase = stormBase;
            this.decoration = decoration;
        }

        public Container createTopLevelContainer(Viewport viewport) {
            this.viewport = viewport;
            RenderDoneTracker tracker = new RenderDoneTracker(viewport.getId(), false);
            tracker.addTrackerListener(this.decoration);
            this.stormBase.addPropertyChangeListener((PropertyChangeListener)tracker, viewport.getId());
            return new Panel();
        }

        public String getViewPortName() {
            return this.viewport.getId();
        }

        public Viewport getViewPort() {
            return this.viewport;
        }
    }
}

