/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import macromedia.fonts.FontFace;
import macromedia.swf.builder.types.PathIteratorWrapper;
import macromedia.swf.builder.types.ShapeBuilder;
import macromedia.swf.builder.types.ShapeIterator;
import macromedia.swf.types.GlyphEntry;
import macromedia.swf.types.Rect;
import macromedia.swf.types.Shape;

public class CFFontFace
extends FontFace {
    private Font mAwtFont = null;
    private HashMap mMap = null;
    private static Graphics2D graphics;
    private FontRenderContext frc;
    private FontMetrics fontMetrics;
    private int ascent;
    private int descent;
    private int lineGap;
    private double emScale;
    private AffineTransform scaleTransform;

    public CFFontFace(Font font) {
        this.mAwtFont = font;
        this.init();
    }

    private void init() {
        this.mMap = new HashMap();
        this.emScale = 1024.0 / this.getPointSize();
        this.scaleTransform = new AffineTransform();
        this.scaleTransform.setToScale(this.emScale, this.emScale);
        if (graphics == null) {
            BufferedImage bi = new BufferedImage(50, 50, 1);
            graphics = bi.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        this.frc = new FontRenderContext(null, true, false);
        this.fontMetrics = graphics.getFontMetrics(this.mAwtFont);
        this.ascent = (int)StrictMath.rint((double)this.fontMetrics.getAscent() * this.emScale);
        this.descent = (int)StrictMath.rint((double)this.fontMetrics.getDescent() * this.emScale);
        int leading = (int)StrictMath.rint((double)this.fontMetrics.getLeading() * this.emScale);
        this.lineGap = leading == 0 ? (int)StrictMath.rint(StrictMath.abs(this.getPointSize() - (double)this.ascent - (double)this.descent)) : leading;
    }

    public boolean canDisplay(char c) {
        return this.mAwtFont.canDisplay(c);
    }

    public String getFamily() {
        return this.mAwtFont.getName();
    }

    public int getFirstChar() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlyphEntry getGlyphEntry(char c) {
        HashMap hashMap = this.mMap;
        synchronized (hashMap) {
            GlyphEntry entry = (GlyphEntry)this.mMap.get(new Character(c));
            if (entry == null) {
                entry = this.createGlyphEntry(c);
                this.mMap.put(new Character(c), entry);
            }
            return entry;
        }
    }

    public GlyphEntry createGlyphEntry(char c) {
        Shape swfShape = null;
        Rect bounds = null;
        int advance = 0;
        GlyphVector gv = this.mAwtFont.createGlyphVector(this.frc, new char[]{c});
        java.awt.Shape glyphOutline = gv.getGlyphOutline(0);
        advance = this.getAdvance(c);
        java.awt.Shape scaledShape = this.scaleTransform.createTransformedShape(glyphOutline);
        swfShape = this.createGlyphShape(scaledShape);
        bounds = new Rect();
        GlyphEntry ge = new GlyphEntry();
        ge.advance = (int)((double)advance * this.emScale);
        ge.setShape(swfShape);
        ge.bounds = bounds;
        ge.character = c;
        return ge;
    }

    private Shape createGlyphShape(java.awt.Shape outline) {
        ShapeBuilder shape = new ShapeBuilder(false);
        shape.setCurrentLineStyle(0);
        shape.setCurrentFillStyle1(1);
        shape.setUseFillStyle1(true);
        shape.processShape((ShapeIterator)new PathIteratorWrapper(outline.getPathIterator(null)));
        return shape.build();
    }

    public int getAdvance(char c) {
        return this.fontMetrics.charWidth(c);
    }

    public Font getFont() {
        return this.mAwtFont;
    }

    public int getMissingGlyphCode() {
        return this.mAwtFont.getMissingGlyphCode();
    }

    public double getPointSize() {
        return this.mAwtFont.getSize2D();
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLineGap() {
        return this.lineGap;
    }

    public int getNumGlyphs() {
        return this.mAwtFont.getNumGlyphs();
    }

    public boolean isBold() {
        return this.mAwtFont.isBold();
    }

    public boolean isItalic() {
        return this.mAwtFont.isItalic();
    }

    public double getEmScale() {
        return this.emScale;
    }
}

