/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.shape;

import com.idrsolutions.pdf.color.shading.ShadedPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.SwingShape;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.ShadingObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public final class SH {
    private SH() {
    }

    public static void execute(ParserOptions parser, String shadingObject, PdfObjectCache cache, GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current) {
        byte[] shadingData = (byte[])cache.get(5, shadingObject);
        if (shadingData == null) {
            shadingData = (byte[])cache.get(4, shadingObject);
        }
        PdfObject Shading = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new ShadingObject("1 0 R"), currentPdfFile.getObjectReader(), shadingData, 878474856);
        Shape shadeShape = gs.getClippingShape();
        if (shadeShape == null) {
            shadeShape = new Rectangle(Short.MIN_VALUE, Short.MIN_VALUE, 65536, 65536);
        }
        if (current.isHTMLorSVG() && cache.groupObj == null) {
            current.eliminateHiddenText(shadeShape, gs, 7, true);
        }
        try {
            PdfArrayIterator ColorSpace2 = Shading.getMixedArray(2087749783);
            GenericColorSpace newColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
            ShadedPaint shading = new ShadedPaint(Shading, newColorSpace, currentPdfFile, gs.CTM, new float[]{0.0f, 0.0f}, gs, parser);
            gs.setFillType(2);
            GenericColorSpace oldColorSpace = gs.nonstrokeColorSpace;
            gs.nonstrokeColorSpace = new DeviceRGBColorSpace();
            gs.nonstrokeColorSpace.setColor(shading);
            cache.put(1, newColorSpace.getID(), (Object)"x");
            current.drawShape(new SwingShape(shadeShape), gs, 70);
            gs.nonstrokeColorSpace = oldColorSpace;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }
}

