/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormAppearanceObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.xfa.APImageForXFA;
import org.jpedal.objects.raw.xfa.CheckBoxAP;
import org.jpedal.objects.raw.xfa.ComboAP;
import org.jpedal.objects.raw.xfa.MultiLineTextAP;
import org.jpedal.objects.raw.xfa.PushButtonAP;
import org.jpedal.objects.raw.xfa.RadioButtonAP;
import org.jpedal.objects.raw.xfa.SignatureFieldAP;
import org.jpedal.objects.raw.xfa.SingleLineTextAP;

public final class XFAFormStream {
    private XFAFormStream() {
    }

    public static BufferedImage decode(PdfObject formObj, PdfObjectReader currentPdfFile, PdfObject XObject2) {
        BufferedImage image = XFAFormStream.decodeApperanceObject((FormAppearanceObject)XObject2, 1.5f);
        APImageForXFA.addTextToXFAAPImage(formObj, currentPdfFile, image, 1.5f);
        APImageForXFA.completeImage((FormAppearanceObject)XObject2, image, 1.5f);
        return image;
    }

    public static BufferedImage decodeApperanceObject(FormAppearanceObject XObject2, float scaling) {
        int w = (int)(scaling * (float)XObject2.getWidth());
        int h = (int)(scaling * (float)XObject2.getHeight());
        if ((float)w < scaling) {
            w = (int)scaling;
        }
        if ((float)h < scaling) {
            h = (int)scaling;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = image.createGraphics();
        float[] BG = XObject2.getFloatArray(4631);
        if (BG != null) {
            g2.setColor(new Color((int)BG[0], (int)BG[1], (int)BG[2]));
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        int subtype = XObject2.getSubtype();
        switch (subtype) {
            case 8: 
            case 9: {
                switch (XObject2.getXfaCheckButtonShapeType()) {
                    case 108704142: {
                        RadioButtonAP.draw(image, XObject2);
                        break;
                    }
                    case -894674659: {
                        CheckBoxAP.draw(image, XObject2);
                    }
                }
                break;
            }
            case 7: {
                PushButtonAP.draw(XObject2, image);
                break;
            }
            case 3: 
            case 4: {
                SingleLineTextAP.draw(image, XObject2);
                break;
            }
            case 5: 
            case 6: {
                MultiLineTextAP.draw(image, XObject2);
                break;
            }
            case 2: {
                ComboAP.draw(image, XObject2);
                break;
            }
            case 11: {
                SignatureFieldAP.draw(image, XObject2);
            }
        }
        if (XObject2.isRollover()) {
            CheckBoxAP.drawRollover(image);
        }
        return image;
    }
}

