/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.FormAppearanceObject;

final class SignatureFieldAP {
    private static final Color acrobatColor = new Color(255, 255, 255);

    private SignatureFieldAP() {
    }

    static void draw(BufferedImage image, FormAppearanceObject XObject2) {
        int strokeType = XObject2.getBorderStroke();
        switch (strokeType) {
            case 0: {
                SignatureFieldAP.drawSignatureArrow(image, 0, 0);
                break;
            }
            case 6: {
                SignatureFieldAP.drawSignatureField(image);
            }
        }
    }

    private static void drawSignatureField(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        Color lightGrey = new Color(212, 208, 200);
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width - 4, height - 4));
        g2.setColor(lightGrey);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(acrobatColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 8, height - 8));
        g2.setColor(lightGrey);
        int[] x = new int[]{width - 4, width - 2, width - 2};
        int[] y = new int[]{4, 2, 4};
        Polygon p = new Polygon(x, y, 3);
        g2.fillPolygon(p);
        g2.setColor(lightGrey);
        x = new int[]{2, 4, 4};
        y = new int[]{height - 2, height - 2, height - 4};
        p = new Polygon(x, y, 3);
        g2.fillPolygon(p);
        SignatureFieldAP.drawSignatureArrow(image, 4, 4);
    }

    private static void drawSignatureArrow(BufferedImage image, int offsetX, int offsetY) {
        Graphics2D g2 = image.createGraphics();
        double width = image.getWidth();
        double height = image.getHeight();
        g2.setColor(new Color(243, 136, 111));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0 + width / 21.75;
        double x3 = x2 + x2 / 2.0;
        double y3 = 0.0 + height / 15.0;
        double y4 = y3 * 2.0;
        double[][] points = new double[][]{{0.0, 0.0}, {x2, 0.0}, {x3, y3}, {x2, y4}, {0.0, y4}};
        GeneralPath tick = new GeneralPath();
        tick.moveTo(points[0][0], points[0][1]);
        for (int k = 1; k < points.length; ++k) {
            tick.lineTo(points[k][0], points[k][1]);
        }
        tick.closePath();
        tick.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, offsetX, offsetY));
        g2.fill(tick);
    }
}

