/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.text;

import java.util.ArrayList;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.region.text.TextRegionHuffmanFlags;
import org.jpedal.jbig2.segment.tables.CodeTableSegment;

public class HuffManTables {
    public int[][] huffmanFSTable;
    public int[][] huffmanDSTable;
    public int[][] huffmanDTTable;
    public int[][] huffmanRDWTable;
    public int[][] huffmanRDHTable;
    public int[][] huffmanRDXTable;
    public int[][] huffmanRDYTable;

    public void create(TextRegionHuffmanFlags textRegionHuffmanFlags, boolean sbHuffman, ArrayList<Segment> codeTables) {
        if (sbHuffman) {
            int sbHuffFS = textRegionHuffmanFlags.getFlagValue("SB_HUFF_FS");
            this.huffmanFSTable = HuffManTables.getHuffmanFSTable(sbHuffFS, codeTables);
            int sbHuffDS = textRegionHuffmanFlags.getFlagValue("SB_HUFF_DS");
            this.huffmanDSTable = HuffManTables.getHuffmanDSTable(sbHuffDS, codeTables);
            int sbHuffDT = textRegionHuffmanFlags.getFlagValue("SB_HUFF_DT");
            this.huffmanDTTable = HuffManTables.getHuffmanDTTable(sbHuffDT, codeTables);
            int sbHuffRDW = textRegionHuffmanFlags.getFlagValue("SB_HUFF_RDW");
            this.huffmanRDWTable = HuffManTables.getHuffmanRDWTable(sbHuffRDW, codeTables);
            int sbHuffRDH = textRegionHuffmanFlags.getFlagValue("SB_HUFF_RDH");
            this.huffmanRDHTable = HuffManTables.getHuffmanRDHTable(sbHuffRDH, codeTables);
            int sbHuffRDX = textRegionHuffmanFlags.getFlagValue("SB_HUFF_RDX");
            this.huffmanRDXTable = HuffManTables.getHuffmanRDXTable(sbHuffRDX, codeTables);
            int sbHuffRDY = textRegionHuffmanFlags.getFlagValue("SB_HUFF_RDY");
            this.huffmanRDYTable = HuffManTables.getHuffmanRDYTable(sbHuffRDY, codeTables);
            int sbHuffRSize = textRegionHuffmanFlags.getFlagValue("SB_HUFF_RSIZE");
            if (sbHuffRSize == 1) {
                codeTables.remove(0);
            }
        }
    }

    private static int[][] getHuffmanFSTable(int sbHuffFS, ArrayList<Segment> codeTables) {
        switch (sbHuffFS) {
            case 0: {
                return HuffmanDecoder.huffmanTableF;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableG;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }

    private static int[][] getHuffmanDSTable(int sbHuffDS, ArrayList<Segment> codeTables) {
        switch (sbHuffDS) {
            case 0: {
                return HuffmanDecoder.huffmanTableH;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableI;
            }
            case 2: {
                return HuffmanDecoder.huffmanTableJ;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }

    private static int[][] getHuffmanDTTable(int sbHuffDT, ArrayList<Segment> codeTables) {
        switch (sbHuffDT) {
            case 0: {
                return HuffmanDecoder.huffmanTableK;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableL;
            }
            case 2: {
                return HuffmanDecoder.huffmanTableM;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }

    private static int[][] getHuffmanRDWTable(int sbHuffRDW, ArrayList<Segment> codeTables) {
        switch (sbHuffRDW) {
            case 0: {
                return HuffmanDecoder.huffmanTableN;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableO;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }

    private static int[][] getHuffmanRDHTable(int sbHuffRDH, ArrayList<Segment> codeTables) {
        switch (sbHuffRDH) {
            case 0: {
                return HuffmanDecoder.huffmanTableN;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableO;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }

    private static int[][] getHuffmanRDXTable(int sbHuffRDX, ArrayList<Segment> codeTables) {
        switch (sbHuffRDX) {
            case 0: {
                return HuffmanDecoder.huffmanTableN;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableO;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }

    private static int[][] getHuffmanRDYTable(int sbHuffRDY, ArrayList<Segment> codeTables) {
        switch (sbHuffRDY) {
            case 0: {
                return HuffmanDecoder.huffmanTableN;
            }
            case 1: {
                return HuffmanDecoder.huffmanTableO;
            }
            case 3: {
                int[][] t = ((CodeTableSegment)codeTables.get(0)).getHuffTable();
                codeTables.remove(0);
                return t;
            }
        }
        return null;
    }
}

